/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree.inventory;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.inventory.AbstractElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DimensionElement
extends AbstractElement {
    @Override
    public boolean areChildrenAllowed(SimpleObject simpleObject) {
        return true;
    }

    @Override
    public SimpleBrowseObject[] getChildrenOf(SimpleObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleObjects = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            List lMeasures;
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Dimension><Measures/><Hierarchies/></Dimension></Templates>");
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface dimension = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            List lHierarchies = (List)dimension.get("Hierarchies");
            if (lHierarchies != null && !lHierarchies.isEmpty()) {
                for (int i = 0; i < lHierarchies.size(); ++i) {
                    BrowseMetadataInterface object = (BrowseMetadataInterface)lHierarchies.get(i);
                    lSimpleObjects.add(new SimpleBrowseObjectImpl(object));
                }
            }
            if ((lMeasures = (List)dimension.get("Measures")) != null && !lMeasures.isEmpty()) {
                for (int i = 0; i < lMeasures.size(); ++i) {
                    BrowseMetadataInterface object = (BrowseMetadataInterface)lMeasures.get(i);
                    lSimpleObjects.add(new SimpleBrowseObjectImpl(object));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleObjects.toArray(new SimpleBrowseObject[lSimpleObjects.size()]);
    }

    @Override
    public SimpleBrowseObject[] getParentsOf(SimpleObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleParents = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Dimension><Cubes/></Dimension></Templates>");
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface dimension = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            List lCubes = (List)dimension.get("Cubes");
            if (lCubes != null && !lCubes.isEmpty()) {
                for (int i = 0; i < lCubes.size(); ++i) {
                    BrowseMetadataInterface cube = (BrowseMetadataInterface)lCubes.get(i);
                    lSimpleParents.add(new SimpleBrowseObjectImpl(cube));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleParents.toArray(new SimpleBrowseObject[lSimpleParents.size()]);
    }
}

