/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WsDecoratableIcon;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.DropTargetResult;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNodeFactory;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class UserFolderTreeNode
extends SimpleBrowseObjectTreeNode {
    private static final Icon m_userFolderIcon = new WsDecoratableIcon(new ImageIcon(UserFolderTreeNode.class.getResource("res/MyFolder.gif")));
    private IDataTreeNode m_delegateNode;

    private static SimpleBrowseObject getHomeFolder(UserFolderType folderType, UserContextInterface userContext) throws RemoteException, ServiceException {
        ServerInterface server = userContext.getAuthServer();
        FolderInterface myFolder = server.getHomeFolder(null, folderType, null);
        BrowseMetadataInterface browseObject = server.browseFetch(myFolder.getEntityKey(), null);
        return new SimpleBrowseObjectImpl(browseObject);
    }

    public UserFolderTreeNode(UserFolderType folderType, UserContextInterface userContext, ITreeNodeFactory nodeFactory) throws RemoteException, ServiceException {
        super(UserFolderTreeNode.getHomeFolder(folderType, userContext));
        this.m_delegateNode = (IDataTreeNode)nodeFactory.createNode(this.m_simpleBrowseObject);
    }

    @Override
    public Icon getIcon() {
        return m_userFolderIcon;
    }

    @Override
    public boolean isValidDragSource() {
        return false;
    }

    @Override
    public boolean isValidDropTarget() {
        return this.m_delegateNode.isValidDropTarget();
    }

    @Override
    public boolean isValidDropTarget(Object[] draggedObjects) {
        return this.m_delegateNode.isValidDropTarget(draggedObjects);
    }

    @Override
    public DropTargetResult getIsValidDropTargetResult(Object[] draggedObjects) {
        return this.m_delegateNode.getIsValidDropTargetResult(draggedObjects);
    }

    @Override
    public void drop(Object[] aDroppedObjects) {
        this.m_delegateNode.drop(aDroppedObjects);
    }

    @Override
    public boolean isRenameAllowed() {
        return this.m_delegateNode.isRenameAllowed();
    }

    @Override
    public boolean isValidName(String sNewName) {
        return this.m_delegateNode.isValidName(sNewName);
    }

    @Override
    public void rename(String sNewName) {
        this.m_delegateNode.rename(sNewName);
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.m_delegateNode.isDeleteAllowed();
    }

    @Override
    public boolean delete() {
        return this.m_delegateNode.delete();
    }
}

