/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import com.sas.workspace.models.tree.UserFolderTreeNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FoldersTreeModel
extends AbstractTreeModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(FoldersTreeModel.class);
    protected static final Filter m_browseRootFilter = new Filter();
    protected static final Filter m_browseFolderFilter;
    private ISimpleObjectHierarchyModel m_hierarchyModel;

    public FoldersTreeModel(UserContextInterface userContext) {
        super(userContext, null);
        SimpleBrowseObject rootObj = this.getFoldersRoot();
        if (rootObj != null) {
            cFoldersRootTreeNode foldersRoot = new cFoldersRootTreeNode(rootObj);
            foldersRoot.setUserObject("Folders");
            foldersRoot.setTreeModel(this);
            this.setRoot(foldersRoot);
        }
    }

    public void setAdditionalHierarchyModel(ISimpleObjectHierarchyModel hierarchyModel) {
        this.m_hierarchyModel = hierarchyModel;
    }

    @Override
    public boolean isValidParent(ITreeNode nodeParent, ITreeNode nodeChild) {
        if (nodeParent instanceof IDataTreeNode && nodeChild instanceof IDataTreeNode) {
            String sNodeParentID = ((IDataTreeNode)nodeParent).getID();
            if (sNodeParentID == null) {
                return false;
            }
            SimpleBrowseObject childObject = (SimpleBrowseObject)((IDataTreeNode)nodeChild).getData();
            List lRealParentIDs = this.getParentIDs(childObject);
            for (String sRealParentID : lRealParentIDs) {
                if (!sNodeParentID.equals(sRealParentID)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addChildren(ITreeNode parentNode) {
        ITreeNode childNode;
        ArrayList lChildren;
        block12: {
            lChildren = new ArrayList();
            try {
                BrowseMetadataInterface browseFolder;
                if (parentNode == this.getRoot()) {
                    try {
                        this.addChild(new UserFolderTreeNode(UserFolderType.MYFOLDER, this.getUserContext(), this.getNodeFactory()), parentNode);
                    }
                    catch (Exception ex) {
                        Workspace.getDefaultLogger().debug("Unable to create \"My Folder\" for user.  Reason: " + ex.getMessage());
                    }
                    if (parentNode instanceof cFoldersRootTreeNode) {
                        SimpleBrowseObject rootFolder = ((cFoldersRootTreeNode)parentNode).getSimpleBrowseObject();
                        browseFolder = this.m_server.browseFolder(rootFolder.getISEntityKey(), (FilterInterface)m_browseRootFilter);
                        lChildren.addAll((List)browseFolder.get("SoftwareTrees"));
                    }
                    break block12;
                }
                if (parentNode.isFolder() && parentNode instanceof SimpleBrowseObjectTreeNode) {
                    SimpleBrowseObject folder = ((SimpleBrowseObjectTreeNode)parentNode).getSimpleBrowseObject();
                    browseFolder = this.m_server.browseFolder(folder.getISEntityKey(), (FilterInterface)m_browseFolderFilter);
                    lChildren.addAll(browseFolder.getSubfolders());
                    lChildren.addAll(browseFolder.getMembers());
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        if (!lChildren.isEmpty()) {
            for (BrowseMetadataInterface browseChild : lChildren) {
                SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseChild);
                if (!this.isValidObject(simpleObj)) continue;
                childNode = this.createNode(simpleObj);
                this.addChild(childNode, parentNode);
            }
        }
        if (parentNode instanceof IDataTreeNode && this.m_hierarchyModel != null) {
            SimpleObject simpleObj = (SimpleObject)((IDataTreeNode)parentNode).getData();
            SimpleBrowseObject[] aChildren = this.m_hierarchyModel.getChildrenOf(simpleObj);
            for (int i = 0; i < aChildren.length; ++i) {
                if (!this.isValidObject(aChildren[i])) continue;
                childNode = this.createNode(aChildren[i]);
                this.addChild(childNode, parentNode);
            }
        }
    }

    @Override
    public void addChild(IDataTreeNode nodeNew) {
        List lParentNodes = this.findParentNodes((SimpleBrowseObject)nodeNew.getData());
        for (ITreeNode nodeParent : lParentNodes) {
            if (!nodeParent.isPopulated()) continue;
            this.addChild(nodeNew, nodeParent);
        }
    }

    @Override
    public ITreeNode createNode(Object userObject) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)((Object)super.createNode(userObject));
        if (!node.getAllowsChildren() && userObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            node.setAllowsChildren(this.m_hierarchyModel.areChildrenAllowed((SimpleObject)userObject));
        }
        return (ITreeNode)((Object)node);
    }

    @Override
    public List findParentNodes(SimpleBrowseObject object) {
        ArrayList lParentNodes = new ArrayList();
        List lParentIDs = this.getParentIDs(object);
        for (String sParentID : lParentIDs) {
            lParentNodes.addAll(this.findNodes(sParentID));
        }
        return lParentNodes;
    }

    private List getParentIDs(SimpleBrowseObject object) {
        ArrayList<Object> lParentIDs = new ArrayList<Object>();
        BrowseMetadataInterface browseObject = object.getBrowseObject();
        List lBrowseParents = browseObject.getParents();
        if (lBrowseParents.isEmpty() && browseObject.isAFolder()) {
            List lSoftwareComponents = (List)browseObject.get("SoftwareComponents");
            if (lSoftwareComponents != null) {
                String sRootID = ((cFoldersRootTreeNode)this.getRoot()).getID();
                for (BrowseMetadataInterface softComp : lSoftwareComponents) {
                    if (!sRootID.equals(softComp.get("Id"))) continue;
                    lParentIDs.add(sRootID);
                    break;
                }
            }
        } else {
            for (BrowseMetadataInterface browseParent : lBrowseParents) {
                lParentIDs.add(browseParent.get("Id"));
            }
        }
        if (this.m_hierarchyModel != null) {
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(object);
            for (int i = 0; i < aParents.length; ++i) {
                lParentIDs.add(aParents[i].getID());
            }
        }
        return lParentIDs;
    }

    public void addParentNodes(SimpleObject simpleObj) {
        SimpleBrowseObject simpleBrowseObj = this.getSimpleBrowseObject(simpleObj.getID(), simpleObj.getMetadataType());
        if (simpleBrowseObj == null) {
            return;
        }
        List lParentNodes = this.findParentNodes(simpleBrowseObj);
        if (lParentNodes.isEmpty()) {
            List lParents = simpleBrowseObj.getBrowseObject().getParents();
            if (this.m_hierarchyModel != null) {
                SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(simpleObj);
                for (int i = 0; i < aParents.length; ++i) {
                    lParents.add(aParents[i].getBrowseObject());
                }
            }
            for (BrowseMetadataInterface browseParent : lParents) {
                SimpleBrowseObjectImpl simpleParent = new SimpleBrowseObjectImpl(browseParent);
                this.addParentNodes(simpleParent);
            }
            lParentNodes = this.findParentNodes(simpleBrowseObj);
        }
        for (ITreeNode parentNode : lParentNodes) {
            parentNode.expand();
            ArrayList<? extends TreeNode> lChildren = Collections.list(parentNode.children());
            ITreeNode[] aChildren = lChildren.toArray(new ITreeNode[lChildren.size()]);
            this.fireDecorateIcons(aChildren);
        }
    }

    @Override
    protected SimpleBrowseObject getSimpleBrowseObject(String sFQID, String sType) {
        try {
            Filter filter = new Filter("Id", 0, sFQID);
            filter.setType(sType);
            filter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"><ParentTree/><SoftwareComponents/><Trees/></Root></Templates>");
            filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
            List lBrowseObjects = this.m_server.browseSearch((FilterInterface)filter);
            if (!lBrowseObjects.isEmpty()) {
                return new SimpleBrowseObjectImpl((BrowseMetadataInterface)lBrowseObjects.get(0));
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return null;
    }

    @Override
    protected boolean doesNodeAllowChildren(IDataTreeNode node) {
        Object dataObject = node.getData();
        if (dataObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            return this.m_hierarchyModel.areChildrenAllowed((SimpleObject)dataObject);
        }
        return super.doesNodeAllowChildren(node);
    }

    private SimpleBrowseObject getFoldersRoot() {
        try {
            RootFolderInterface rootFolder = this.m_server.getRootFolder();
            BrowseMetadataInterface browseBIPService = this.m_server.browseFolder(rootFolder.getEntityKey(), (FilterInterface)m_browseFilter);
            return new SimpleBrowseObjectImpl(browseBIPService);
        }
        catch (ServiceException ex) {
            Filter filter = new Filter();
            filter.setType("SoftwareComponent");
            FilterComponent fc = new FilterComponent("ClassIdentifier", 0, "E5F27790-2149-11D6-8828-AA0004006D06");
            fc.addComponent(new FilterComponent("Name", 0, "BIP Service"));
            fc.setAggregation(0);
            filter.setFilterComponent(fc);
            try {
                if (((MetadataServerInterface)this.m_server).getCountNoSecurity(filter, null) > 0) {
                    MessageUtil.displayMessage(bundle.getString("FoldersTreeModel.RootFolderError.txt"), 0);
                }
                MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return null;
    }

    static {
        m_browseRootFilter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"><SoftwareTrees /></Root></Templates>");
        m_browseRootFilter.setOMRFlags(-2147483628);
        m_browseFolderFilter = new Filter();
        m_browseFolderFilter.setOMRTemplate("<Templates><Template TemplateName=\"Tree\"><Tree Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"><SubTrees><Tree TemplateName=\"SubTree\"/></SubTrees><Members/></Tree><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"/></Template><Template TemplateName=\"SubTree\"><Tree Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"/></Template></Templates>");
        m_browseFolderFilter.setOMRFlags(-2147483628);
    }

    private class cFoldersRootTreeNode
    extends SimpleBrowseObjectTreeNode {
        public cFoldersRootTreeNode(SimpleBrowseObject browseObject) {
            super(browseObject);
            this.setAllowsChildren(true);
            this.setEditable(false);
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean isValidName(String sNewName) {
            throw new UnsupportedOperationException("This node cannot be renamed.");
        }

        @Override
        public void rename(String sNewName) {
            throw new UnsupportedOperationException("This node cannot be renamed.");
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException("This node cannot be deleted.");
        }

        @Override
        public boolean isFolder() {
            return true;
        }

        @Override
        public void update() {
            this.m_simpleBrowseObject = FoldersTreeModel.this.getFoldersRoot();
        }
    }
}

