/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.workspace.models.tree.DropTargetResult;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class AbstractTreeNode
extends DefaultMutableTreeNode
implements ITreeNode {
    protected boolean m_bEditable = true;
    protected boolean m_bSorted = true;
    protected boolean m_bPopulated = false;
    protected boolean m_bExpanded = false;
    protected boolean m_bDisposed = false;
    protected ITreeModel m_model;

    public AbstractTreeNode(Object userObject) {
        this(userObject, true);
    }

    public AbstractTreeNode(Object userObject, boolean bAllowsChildren) {
        super(userObject, bAllowsChildren);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
    }

    @Override
    public boolean isValidDragSource() {
        return true;
    }

    @Override
    public boolean isValidDropTarget() {
        return false;
    }

    @Override
    public boolean isValidDropTarget(Object[] aDraggedObjects) {
        return false;
    }

    @Override
    public DropTargetResult getIsValidDropTargetResult(Object[] aDraggedObjects) {
        return this.isValidDropTarget(aDraggedObjects) ? DropTargetResult.VALID : DropTargetResult.INVALID;
    }

    @Override
    public void drop(Object[] aDroppedObjects) {
        throw new UnsupportedOperationException("This node does not support drop.");
    }

    @Override
    public boolean isSorted() {
        return this.m_bSorted;
    }

    @Override
    public void setSorted(boolean bSorted) {
        this.m_bSorted = bSorted;
    }

    @Override
    public boolean isPopulated() {
        return this.m_bPopulated;
    }

    @Override
    public void setPopulated(boolean bPopulated) {
        this.m_bPopulated = bPopulated;
    }

    @Override
    public boolean isExpanded() {
        return this.m_bExpanded;
    }

    @Override
    public void setExpanded(boolean bExpanded) {
        this.m_bExpanded = bExpanded;
    }

    @Override
    public void expand() {
        if (!this.isPopulated() && this.m_model != null) {
            this.m_model.addChildren(this);
            this.setPopulated(true);
        }
    }

    @Override
    public void setTreeModel(ITreeModel model) {
        this.m_model = model;
    }

    @Override
    public void dispose() {
        this.m_model = null;
        this.m_bDisposed = true;
    }

    @Override
    public Object clone() {
        AbstractTreeNode nodeClone = (AbstractTreeNode)super.clone();
        if (this.children != null) {
            nodeClone.children = (Vector)this.children.clone();
        }
        return nodeClone;
    }

    @Override
    public boolean equals(ITreeNode node) {
        String sName = this.getName();
        if (sName != null) {
            return sName.equals(node.getName());
        }
        return super.equals(node);
    }

    public int hashcode() {
        return super.hashCode();
    }
}

