/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsMessagesPropertyTab;
import java.rmi.RemoteException;
import java.util.List;

public class GeneratedTransformationUtilities {
    private static WAdminResource bundle = WAdminResource.getBundle(GeneratedTransformationUtilities.class);
    private static final String PROCESSTREEPATHNAME = "UITreeCategory";
    private static final String TRANSFORMATIONTYPE = "TransformationStep2";
    private static final String TEMPLATES = "<TEMPLATES><Prototype><Properties/><Extensions/></Prototype><Property><StoredConfiguration/></Property><StoredConfiguration><StoredText/></StoredConfiguration></TEMPLATES>";
    private static final String XMLSELECT = "<XMLSELECT Search=\"@MetadataType='TransformationStep2'\"/>";

    private GeneratedTransformationUtilities() {
    }

    public static List loadGeneratedTransformations(CMetadata repository, MdObjectStore store) throws MdException, RemoteException {
        String sOptions = "<TEMPLATES><Prototype><Properties/><Extensions/></Prototype><Property><StoredConfiguration/></Property><StoredConfiguration><StoredText/></StoredConfiguration></TEMPLATES><XMLSELECT Search=\"@MetadataType='TransformationStep2'\"/>";
        MdFactory factory = store.getFactory();
        return factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getFQID(), "Prototype", 24972, sOptions);
    }

    public static boolean isTransformLoaded(String strPrototypeXML) throws MdException, RemoteException {
        boolean bLoaded = false;
        String classSearch = Workspace.getMdFactory().getOMIUtil().cleanStringForXML("<Property Name=\"Class\" PropertyName=\"Class\" DefaultValue=\"");
        int classIndex = strPrototypeXML.indexOf(classSearch);
        if (classIndex > -1) {
            String guid = strPrototypeXML.substring(classIndex + classSearch.length(), strPrototypeXML.indexOf(Workspace.getMdFactory().getOMIUtil().cleanStringForXML("\""), classIndex + classSearch.length()));
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "Generated Transform Utilities Store");
            List transforms = GeneratedTransformationUtilities.loadGeneratedTransformations(Workspace.getWorkspace().getDefaultRepository(), store);
            for (int j = 0; j < transforms.size(); ++j) {
                Prototype proto = (Prototype)transforms.get(j);
                AssociationList pSets = proto.getProperties(true);
                for (int k = 0; k < pSets.size(); ++k) {
                    TextStore tStore;
                    Property prop = (Property)pSets.get(k);
                    if (!prop.getPropertyRole().equals("GetXML") || (tStore = (TextStore)prop.getStoredConfiguration()).getStoredText().indexOf(guid) <= -1) continue;
                    WsMessagesPropertyTab.getInstance().addMessage(bundle.formatString("WsMetadataCopyUtil.TransformationExists.Error.txt", proto.getName()), 1);
                    store.dispose();
                    return true;
                }
            }
            store.dispose();
        }
        return bLoaded;
    }

    public static boolean isTransformLoaded(String strPrototypeXML, MdFactory factory) throws MdException, RemoteException {
        boolean bLoaded = false;
        String classSearch = factory.getOMIUtil().cleanStringForXML("<Property Name=\"Class\" PropertyName=\"Class\" DefaultValue=\"");
        int classIndex = strPrototypeXML.indexOf(classSearch);
        if (classIndex > -1) {
            String guid = strPrototypeXML.substring(classIndex + classSearch.length(), strPrototypeXML.indexOf(factory.getOMIUtil().cleanStringForXML("\""), classIndex + classSearch.length()));
            MdObjectStore store = factory.createObjectStore(null, "Generated Transform Utilities Store");
            CMetadata repos = factory.getOMIUtil().getFoundationRepository();
            List transforms = GeneratedTransformationUtilities.loadGeneratedTransformations(repos, store);
            for (int j = 0; j < transforms.size(); ++j) {
                Prototype proto = (Prototype)transforms.get(j);
                AssociationList pSets = proto.getProperties(true);
                for (int k = 0; k < pSets.size(); ++k) {
                    TextStore tStore;
                    Property prop = (Property)pSets.get(k);
                    if (!prop.getPropertyRole().equals("GetXML") || (tStore = (TextStore)prop.getStoredConfiguration()).getStoredText().indexOf(guid) <= -1) continue;
                    store.dispose();
                    return true;
                }
            }
            store.dispose();
        }
        return bLoaded;
    }

    public static void populateGeneratedTransformation(Prototype mdoTransformation) throws MdException, RemoteException {
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdoTransformation, null, null, TEMPLATES, 12);
    }

    public static boolean isGeneratedTransformation(Root mdoTest) {
        try {
            if (mdoTest.getCMetadataType().equals("Prototype")) {
                Prototype mdoPrototype = (Prototype)mdoTest;
                return mdoPrototype.getMetadataType().equals(TRANSFORMATIONTYPE);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return false;
    }

    public static String getProcessTreePath(Root mdoTransformation) throws MdException, RemoteException {
        if (mdoTransformation == null) {
            return null;
        }
        Extension mdoPathExtension = GeneratedTransformationUtilities.getProcessTreePathExtension(mdoTransformation);
        return mdoPathExtension == null ? "" : mdoPathExtension.getValue();
    }

    public static void setProcessTreePath(Root mdoTransformation, String sPath) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)mdoTransformation.getObjectStore();
        Extension mdoPathExtension = GeneratedTransformationUtilities.getProcessTreePathExtension(mdoTransformation);
        if (sPath == null || sPath.length() == 0) {
            if (mdoPathExtension != null) {
                store.removeObjectFromStore((CMetadata)mdoPathExtension, null);
            }
        } else if (mdoPathExtension == null) {
            mdoPathExtension = (Extension)Workspace.getMdFactory().createComplexMetadataObject(store, PROCESSTREEPATHNAME, "Extension", mdoTransformation.getRepositoryID());
            mdoPathExtension.setExtensionType("VARCHAR");
            mdoPathExtension.setValue(sPath);
            mdoTransformation.getExtensions().add((Object)mdoPathExtension);
        } else if (!mdoPathExtension.getValue().equals(sPath)) {
            mdoPathExtension.setValue(sPath);
        }
    }

    private static Extension getProcessTreePathExtension(Root mdoTransformation) throws MdException, RemoteException {
        AssociationList extensionList = mdoTransformation.getExtensions();
        for (int k = 0; k < extensionList.size(); ++k) {
            Extension extension = (Extension)extensionList.get(k);
            if (!extension.getName().equals(PROCESSTREEPATHNAME)) continue;
            return extension;
        }
        return null;
    }

    public static boolean isTreePathExtension(Root mdoTestee) {
        try {
            return mdoTestee.getCMetadataType().equals("Extension") && mdoTestee.getName().equals(PROCESSTREEPATHNAME);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }
}

