/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.swing.visuals.util.Util;
import com.sas.workspace.EnableHelpUtil;
import com.sas.workspace.imsmc.ApplicationResource;
import com.sas.workspace.imsmc.visuals.GridBagPanel;
import com.sas.workspace.imsmc.visuals.WindowUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextLayout;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseDialog
extends JDialog {
    private static final long serialVersionUID = -1498682743136887948L;
    protected GridBagPanel m_contentPanel = null;
    protected JPanel m_dialogPanel = null;
    protected Component m_firstFocus = null;
    protected GridBagPanel m_buttonPanel = null;
    protected DialogButton[] m_buttons;
    protected int m_buttonAlignment;
    protected int m_returnValue = 2;
    protected int m_buttonDefault = 1;
    protected BaseKeyHandler m_keyHandler = null;
    protected DialogCloser m_dialogCloser = null;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CUSTOM1 = 3;
    public static final int CUSTOM2 = 4;
    public static final int APPLY = 5;
    public static final int HELP = 6;
    public static final int BUTTON_COUNT = 6;
    public static final int ALIGN_BOTTOM_RIGHT = 1;
    public static final int ALIGN_BOTTOM_CENTER = 2;
    public static final int ALIGN_RIGHT_TOP = 3;
    private static ApplicationResource bundle = new ApplicationResource(BaseDialog.class);
    private static final Logger LOGGER = LogManager.getLogger(BaseDialog.class);

    public BaseDialog() {
        this.initBaseDialog();
    }

    public BaseDialog(Frame parentFrame, boolean bModal) {
        this(parentFrame, " ", bModal);
    }

    public BaseDialog(Frame parentFrame, String title, boolean bModal) {
        super(parentFrame, title, bModal);
        this.initBaseDialog();
    }

    public BaseDialog(Dialog parentFrame, boolean bModal) {
        super(parentFrame, " ", bModal);
        this.initBaseDialog();
    }

    public BaseDialog(Dialog parentFrame, String title, boolean bModal) {
        super(parentFrame, title, bModal);
        this.initBaseDialog();
    }

    private void initBaseDialog() {
        this.setBackground(SystemColor.control);
        this.m_buttonAlignment = 1;
        this.m_buttons = new DialogButton[7];
        this.m_buttons[1] = new DialogButton(bundle.getString("Standard.ButtonLabel.Ok.txt"), true, new AbstractAction(){
            private static final long serialVersionUID = 730584530358756247L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDialog.this.onOK();
            }
        });
        this.m_buttons[2] = new DialogButton(bundle.getString("Standard.ButtonLabel.Cancel.txt"), true, new AbstractAction(){
            private static final long serialVersionUID = -3464925861852276735L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDialog.this.onCancel();
            }
        });
        this.m_buttons[3] = new DialogButton("", false, new AbstractAction(){
            private static final long serialVersionUID = 2149213026624709017L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDialog.this.onCustomOne();
            }
        });
        this.m_buttons[4] = new DialogButton("", false, new AbstractAction(){
            private static final long serialVersionUID = -1330125770154917538L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDialog.this.onCustomTwo();
            }
        });
        this.m_buttons[5] = new DialogButton(bundle.getString("Common.Apply.txt"), false, new AbstractAction(){
            private static final long serialVersionUID = -9221849824707864675L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDialog.this.onApply();
            }
        });
        this.m_buttons[6] = new DialogButton(bundle.getString("Common.Help.txt"), false, null);
        this.m_buttons[1].setText(bundle.getString("Standard.ButtonLabel.Ok.txt"));
        this.m_buttons[2].setText(bundle.getString("Standard.ButtonLabel.Cancel.txt"));
        this.m_buttons[5].setText(bundle.getString("Common.Apply.txt"));
        this.m_buttons[6].setText(bundle.getString("Standard.ButtonLabel.Help.txt"));
        KeyListener arrowKeyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int i;
                int nextButton;
                int i2;
                int currButton;
                if (e.getKeyCode() == 39 || e.getKeyCode() == 40) {
                    currButton = 0;
                    for (i2 = 0; i2 <= 6; ++i2) {
                        if (BaseDialog.this.m_buttons[i2] != e.getSource()) continue;
                        currButton = i2;
                    }
                    nextButton = -1;
                    for (i = currButton + 1; i <= 6 && nextButton == -1; ++i) {
                        if (BaseDialog.this.m_buttons[i] == null || !BaseDialog.this.m_buttons[i].getVisible() || !BaseDialog.this.m_buttons[i].isEnabled()) continue;
                        nextButton = i;
                    }
                    for (i = 0; i <= currButton && nextButton == -1; ++i) {
                        if (BaseDialog.this.m_buttons[i] == null || !BaseDialog.this.m_buttons[i].getVisible() || !BaseDialog.this.m_buttons[i].isEnabled()) continue;
                        nextButton = i;
                    }
                    BaseDialog.this.m_buttons[nextButton].requestFocus();
                }
                if (e.getKeyCode() == 37 || e.getKeyCode() == 38) {
                    currButton = 0;
                    for (i2 = 0; i2 <= 6; ++i2) {
                        if (BaseDialog.this.m_buttons[i2] != e.getSource()) continue;
                        currButton = i2;
                    }
                    nextButton = -1;
                    for (i = currButton - 1; i >= 0 && nextButton == -1; --i) {
                        if (BaseDialog.this.m_buttons[i] == null || !BaseDialog.this.m_buttons[i].getVisible() || !BaseDialog.this.m_buttons[i].isEnabled()) continue;
                        nextButton = i;
                    }
                    for (i = 6; i >= currButton && nextButton == -1; --i) {
                        if (BaseDialog.this.m_buttons[i] == null || !BaseDialog.this.m_buttons[i].getVisible() || !BaseDialog.this.m_buttons[i].isEnabled()) continue;
                        nextButton = i;
                    }
                    BaseDialog.this.m_buttons[nextButton].requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this.m_buttons[1].addKeyListener(arrowKeyListener);
        this.m_buttons[2].addKeyListener(arrowKeyListener);
        this.m_buttons[3].addKeyListener(arrowKeyListener);
        this.m_buttons[4].addKeyListener(arrowKeyListener);
        this.m_buttons[5].addKeyListener(arrowKeyListener);
        this.m_buttons[6].addKeyListener(arrowKeyListener);
    }

    public void setDialogPanel(JPanel panel) {
        if (panel != null) {
            this.m_dialogPanel = panel;
        }
    }

    @Override
    public void show() {
        this.buildDialog();
        this.m_keyHandler = new BaseKeyHandler();
        this.addKeyListener(this.m_keyHandler);
        this.addBaseKeyListeners(this, this.m_keyHandler);
        this.m_dialogCloser = new DialogCloser();
        this.addWindowListener(this.m_dialogCloser);
        if (this.m_buttons[this.m_buttonDefault] != null && this.m_buttons[this.m_buttonDefault].getVisible()) {
            this.getRootPane().setDefaultButton(this.m_buttons[this.m_buttonDefault]);
        }
        if (this.m_firstFocus != null) {
            this.m_firstFocus.requestFocus();
        } else if (this.m_dialogPanel != null) {
            this.m_dialogPanel.requestFocus();
        }
        super.show();
    }

    public void buildDialog() {
        if (!this.isDialogBuilt() && this.m_dialogPanel != null) {
            Container content = this.getContentPane();
            content.setBackground(SystemColor.control);
            this.setResizable(true);
            this.m_contentPanel = new GridBagPanel();
            this.m_contentPanel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
            this.m_contentPanel.addComponent(0, 0, this.m_dialogPanel, 1, 1, 1.0, 1.0, 18, 1);
            content.add(this.m_contentPanel);
            this.m_buttonPanel = new GridBagPanel();
            this.m_buttonPanel.setBorder(BorderFactory.createEmptyBorder(11, 0, 0, 0));
            this.adjustButtonPanel(true);
            this.pack();
            this.centerOnParent();
        }
    }

    public boolean isDialogBuilt() {
        return this.m_contentPanel != null && this.m_buttonPanel != null && this.m_dialogPanel != null;
    }

    private void adjustButtonPanel(boolean layoutChanged) {
        if (this.m_buttonPanel != null) {
            int i;
            Dimension buttonSize = new Dimension(0, 0);
            for (i = 0; i <= 6; ++i) {
                if (this.m_buttons[i] == null || !this.m_buttons[i].isVisible()) continue;
                this.m_buttons[i].setPreferredSize(null);
                Dimension size = this.m_buttons[i].getPreferredSize();
                buttonSize.width = Math.max(buttonSize.width, size.width);
                buttonSize.height = Math.max(buttonSize.height, size.height);
            }
            for (i = 0; i <= 6; ++i) {
                if (this.m_buttons[i] == null || !this.m_buttons[i].isVisible()) continue;
                this.m_buttons[i].setPreferredSize(buttonSize);
                this.m_buttons[i].setMinimumSize(buttonSize);
            }
            if (layoutChanged) {
                this.m_buttonPanel.removeAll();
                for (i = 0; i <= 6; ++i) {
                    if (this.m_buttons[i] == null || !this.m_buttons[i].getVisible()) continue;
                    if (this.m_buttonAlignment == 3) {
                        this.m_buttonPanel.addComponent(0, i, this.m_buttons[i], 1, 1, 0.0, 0.0, 10, 0, 0, 0, 0, 6);
                        continue;
                    }
                    this.m_buttonPanel.addComponent(i, 0, this.m_buttons[i], 1, 1, 0.0, 0.0, 10, 0, 0, 6, 0, 0);
                }
                if (this.isDialogBuilt()) {
                    switch (this.m_buttonAlignment) {
                        case 1: {
                            this.m_contentPanel.addComponent(0, 1, this.m_buttonPanel, 1, 1, 0.0, 0.0, 13, 0, 2, 0, 0, 0);
                            break;
                        }
                        case 2: {
                            this.m_contentPanel.addComponent(0, 1, this.m_buttonPanel, 1, 1, 0.0, 0.0, 10, 0, 0, 0, 0, 0);
                            break;
                        }
                        case 3: {
                            this.m_contentPanel.addComponent(1, 0, this.m_buttonPanel, 1, 1, 0.0, 0.0, 11, 0, 0, 2, 0, 0);
                        }
                    }
                }
            }
        }
    }

    public void setMinimumSize(int width, int height) {
        this.buildDialog();
        if (this.isDialogBuilt()) {
            Dimension size = this.getSize();
            size.width = Math.max(width, size.width);
            size.height = Math.max(height, size.height);
            this.setSize(size);
            this.centerOnParent();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retValue = super.getPreferredSize();
        if (this.getGraphics() instanceof Graphics2D) {
            Graphics2D graphics = (Graphics2D)this.getGraphics();
            if (this.getTitle() != null && this.getTitle().length() > 0) {
                TextLayout layout = new TextLayout(this.getTitle(), this.getFont(), graphics.getFontRenderContext());
                retValue.width = Math.max((int)layout.getAdvance() + 75, retValue.width);
            } else {
                retValue.width = Math.max(75, retValue.width);
            }
        }
        return retValue;
    }

    protected void onOK() {
        this.m_returnValue = 1;
        this.dispose();
    }

    protected void onCancel() {
        this.m_returnValue = 2;
        this.dispose();
    }

    protected void onApply() {
    }

    protected void onCustomOne() {
    }

    protected void onCustomTwo() {
    }

    public boolean wasOkHit() {
        return this.m_returnValue == 1;
    }

    public boolean wasCancelHit() {
        return this.m_returnValue == 2;
    }

    public void centerOnParent() {
        if (this.getParent() != null) {
            WindowUtil.centerOverWindow(this, this.getParent());
        } else {
            LOGGER.debug("dialog with no parent being centered!");
            WindowUtil.center(this);
        }
    }

    public void moveToNotOverlap(Component comp) {
        this.buildDialog();
        if (this.isDialogBuilt()) {
            Point compLoc = comp.getLocationOnScreen();
            Dimension compSize = comp.getSize();
            Dimension findSize = this.getSize();
            Point newLoc = new Point(compLoc.x + compSize.width + 3, compLoc.y);
            if ((double)(newLoc.x + findSize.width) > GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getMaxX()) {
                newLoc.x = compLoc.x - findSize.width - 3;
            }
            newLoc.x = Math.max(newLoc.x, 0);
            newLoc.y = Math.max(newLoc.y, 0);
            newLoc.x = Math.min(newLoc.x, (int)GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getMaxX() - findSize.width);
            newLoc.y = Math.min(newLoc.y, (int)GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getMaxY() - findSize.height);
            this.setLocation(newLoc);
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.getRootPane().getAccessibleContext().setAccessibleName(title);
        this.getContentPane().getAccessibleContext().setAccessibleName(title);
    }

    public void setButtonText(int buttonIndex, String text) {
        if (0 < buttonIndex && buttonIndex <= 6) {
            this.m_buttons[buttonIndex].setText(Util.getLabelWithoutMnemonic((String)text));
            int index = Util.getDisplayedMnemonicIndex((String)text);
            if (index > -1) {
                int mnemonic = Util.getDisplayedMnemonic((String)text);
                this.m_buttons[buttonIndex].setMnemonic(mnemonic);
                this.m_buttons[buttonIndex].setDisplayedMnemonicIndex(index);
            }
            this.adjustButtonPanel(false);
        }
    }

    public void setButtonShown(int buttonIndex, boolean visible) {
        if (0 < buttonIndex && buttonIndex <= 6) {
            this.m_buttons[buttonIndex].setVisible(visible);
            this.adjustButtonPanel(true);
        }
    }

    public void setButtonEnabled(int buttonIndex, boolean enable) {
        if (0 < buttonIndex && buttonIndex <= 6) {
            this.m_buttons[buttonIndex].setEnabled(enable);
        }
    }

    public void setButtonAlignment(int alignment) {
        if (alignment != this.m_buttonAlignment) {
            this.m_buttonAlignment = alignment;
            this.adjustButtonPanel(true);
        }
    }

    public void setButtonDefault(int buttonIndex) {
        if (buttonIndex != this.m_buttonDefault) {
            this.m_buttonDefault = buttonIndex;
            this.adjustButtonPanel(false);
        }
    }

    public void setHelpID(String docProduct, String id) {
        if (docProduct != null) {
            this.setButtonShown(6, true);
            EnableHelpUtil.enableHelpKey(this.getContentPane(), docProduct, id, null);
            EnableHelpUtil.enableHelpOnClick(this.m_buttons[6], docProduct, id, null);
        } else {
            this.setButtonShown(6, false);
        }
    }

    public void setFirstFocus(Component comp) {
        this.m_firstFocus = comp;
    }

    public Component getFirstFocus() {
        return this.m_firstFocus;
    }

    public void addShortKeyAccelerators() {
        this.buildDialog();
        if (this.m_contentPanel != null) {
            this.m_contentPanel.getInputMap(1).put(KeyStroke.getKeyStroke(this.m_buttons[1].getMnemonic(), 0), "onOK");
            this.m_contentPanel.getActionMap().put("onOK", this.m_buttons[1].getAction());
            this.m_contentPanel.getInputMap(1).put(KeyStroke.getKeyStroke(this.m_buttons[2].getMnemonic(), 0), "onCancel");
            this.m_contentPanel.getActionMap().put("onCancel", this.m_buttons[2].getAction());
            this.m_contentPanel.getInputMap(1).put(KeyStroke.getKeyStroke(this.m_buttons[3].getMnemonic(), 0), "onCustom1");
            this.m_contentPanel.getActionMap().put("onCustom1", this.m_buttons[3].getAction());
            this.m_contentPanel.getInputMap(1).put(KeyStroke.getKeyStroke(this.m_buttons[4].getMnemonic(), 0), "onCustom2");
            this.m_contentPanel.getActionMap().put("onCustom2", this.m_buttons[4].getAction());
            this.m_contentPanel.getInputMap(1).put(KeyStroke.getKeyStroke(this.m_buttons[5].getMnemonic(), 0), "onApply");
            this.m_contentPanel.getActionMap().put("onHelp", this.m_buttons[5].getAction());
        }
    }

    @Override
    public void dispose() {
        this.m_dialogPanel = null;
        this.m_firstFocus = null;
        this.m_buttonPanel = null;
        for (int i = 0; i <= 6; ++i) {
            this.m_buttons[i] = null;
        }
        this.removeBaseKeyListeners(this, this.m_keyHandler);
        this.removeKeyListener(this.m_keyHandler);
        this.removeWindowListener(this.m_dialogCloser);
        this.m_dialogCloser = null;
        this.m_keyHandler = null;
        super.dispose();
    }

    private void addBaseKeyListeners(Container container, BaseKeyHandler keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            if (components[index] instanceof JComboBox) continue;
            if (components[index] instanceof Container) {
                this.addBaseKeyListeners((Container)components[index], keyHandler);
            }
            if (!components[index].isFocusable()) continue;
            components[index].addKeyListener(keyHandler);
        }
    }

    private void removeBaseKeyListeners(Container container, BaseKeyHandler keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            if (components[index] instanceof Container) {
                this.removeBaseKeyListeners((Container)components[index], keyHandler);
            }
            if (!components[index].isFocusable()) continue;
            components[index].removeKeyListener(keyHandler);
        }
    }

    class BaseKeyHandler
    extends KeyAdapter {
        BaseKeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (event.getKeyChar() == '\u001b') {
                BaseDialog.this.dispose();
            }
        }
    }

    class DialogCloser
    extends WindowAdapter {
        DialogCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            BaseDialog.this.dispose();
        }

        public void actionPerformed(ActionEvent event) {
            BaseDialog.this.dispose();
        }
    }

    public class DialogButton
    extends JButton {
        private static final long serialVersionUID = -3967607976373898835L;
        private boolean m_buttonVisible;

        public DialogButton(String text, boolean visible, AbstractAction action) {
            super(Util.getLabelWithoutMnemonic((String)text));
            int index = Util.getDisplayedMnemonicIndex((String)text);
            if (index > -1) {
                int mnemonic = Util.getDisplayedMnemonic((String)text);
                this.setMnemonic(mnemonic);
                this.setDisplayedMnemonicIndex(index);
            }
            this.m_buttonVisible = visible;
            if (action != null) {
                this.setAction(action);
                this.setText(Util.getLabelWithoutMnemonic((String)text));
            }
        }

        public boolean getVisible() {
            return this.m_buttonVisible;
        }

        @Override
        public void setVisible(boolean flag) {
            this.m_buttonVisible = flag;
        }
    }
}

