/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.model;

import com.sas.workspace.imsmc.ApplicationResource;
import com.sas.workspace.imsmc.model.PropertyChangeHandler;
import java.io.Serializable;
import java.util.Vector;

public class MessageHandler
extends PropertyChangeHandler
implements Serializable {
    private static final long serialVersionUID = -399531434908132589L;
    protected static ApplicationResource bundle = new ApplicationResource(MessageHandler.class);
    protected Vector m_errorMessageList = new Vector();
    protected Throwable m_associatedThrowable = null;
    protected Vector m_warningMessageList = new Vector();

    public boolean hasMessages() {
        return this.m_warningMessageList.size() > 0;
    }

    public boolean hasThrowable() {
        return this.m_associatedThrowable != null;
    }

    public Throwable getThrowable() {
        return this.m_associatedThrowable;
    }

    public synchronized String[] getMessages() {
        Object[] returnArray = new String[this.m_errorMessageList.size() + this.m_warningMessageList.size()];
        this.m_errorMessageList.copyInto(returnArray);
        Object[] tempArray = new String[this.m_warningMessageList.size()];
        this.m_warningMessageList.copyInto(tempArray);
        System.arraycopy(tempArray, 0, returnArray, this.m_errorMessageList.size(), this.m_warningMessageList.size());
        return returnArray;
    }

    public synchronized String getOneBigMessage() {
        String[] array = this.getMessages();
        String returnString = "";
        for (int index = 0; index < array.length; ++index) {
            if (returnString.length() > 0) {
                returnString = returnString + "\n";
            }
            returnString = returnString + array[index];
        }
        return returnString;
    }

    public synchronized void removeAllMessages() {
        this.m_errorMessageList.removeAllElements();
        this.m_warningMessageList.removeAllElements();
    }

    public synchronized void addInternalError(String message) {
        this.m_associatedThrowable = null;
        this.addError(bundle.messageString("Message.InternalError.txt") + message);
    }

    public synchronized void addInternalError(Throwable t) {
        this.m_associatedThrowable = t;
        String error = t.getLocalizedMessage();
        if (error == null) {
            error = t.toString();
        }
        String intError = bundle.getString("MessageHandler.intErrorString.txt");
        this.addError(intError + error);
        t.printStackTrace();
    }

    public synchronized void addInternalError(Exception e) {
        this.m_associatedThrowable = e;
        String error = e.getLocalizedMessage();
        if (error == null) {
            error = e.toString();
        }
        String intError = bundle.getString("MessageHandler.intErrorString.txt");
        this.addError(intError + error);
        e.printStackTrace();
    }

    public synchronized void addInternalError(Exception e, String message) {
        this.m_associatedThrowable = e;
        String error = e.getLocalizedMessage();
        if (error == null) {
            error = e.toString();
        }
        String intError = bundle.getString("MessageHandler.intErrorString.txt");
        this.addError(intError + error + " " + message);
        e.printStackTrace();
    }

    public void addInternalError(ApplicationResource bundle, String key) {
        this.m_associatedThrowable = null;
        String message = bundle.getString(key);
        this.addInternalError(message);
    }

    public synchronized void addError(Throwable e) {
        int cMessages;
        this.m_associatedThrowable = e;
        String message = e.getLocalizedMessage();
        if (message == null) {
            message = e.toString();
        }
        if ((cMessages = this.m_errorMessageList.size()) == 0 || !message.equals(this.m_errorMessageList.elementAt(cMessages - 1))) {
            this.m_errorMessageList.addElement(message);
        }
    }

    public synchronized void addError(Throwable e, String message) {
        int cMessages;
        this.m_associatedThrowable = e;
        if ((message = message + " " + e.getLocalizedMessage()) == null) {
            message = e.toString();
        }
        if ((cMessages = this.m_errorMessageList.size()) == 0 || !message.equals(this.m_errorMessageList.elementAt(cMessages - 1))) {
            this.m_errorMessageList.addElement(message);
        }
    }

    public synchronized void addError(String message) {
        this.m_associatedThrowable = null;
        if (message == null) {
            return;
        }
        int cMessages = this.m_errorMessageList.size();
        if (cMessages == 0 || !message.equals(this.m_errorMessageList.elementAt(cMessages - 1))) {
            this.m_errorMessageList.addElement(message);
        }
    }

    public void addError(ApplicationResource bundle, String key) {
        this.m_associatedThrowable = null;
        String message = bundle.getString(key);
        this.addError(message);
    }

    public void addError(Exception e, ApplicationResource bundle, String key) {
        this.m_associatedThrowable = e;
        String message = bundle.getString(key);
        this.addError(e, message);
    }

    public static void addStaticError(String message) {
        System.err.println(message);
    }

    public static void addStaticError(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            message = e.toString();
        }
        MessageHandler.addStaticError(message);
        e.printStackTrace();
    }

    public static void addStaticError(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            message = t.toString();
        }
        MessageHandler.addStaticError(message);
        t.printStackTrace();
    }

    public synchronized void addWarning(String message) {
        this.m_associatedThrowable = null;
        this.m_warningMessageList.addElement(message);
    }

    public void addWarning(ApplicationResource bundle, String key) {
        this.m_associatedThrowable = null;
        String message = bundle.getString(key);
        this.addWarning(message);
    }

    public synchronized boolean failureHasOccurred() {
        return this.m_errorMessageList.size() != 0;
    }
}

