/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.connection;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidInfoType;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionName;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionValue;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.services.ServiceException;
import com.sas.services.connection.HostPortPair;
import com.sas.services.connection.HostPortSet;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServices;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.services.information.IdentityInfo;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataConnectionEvent;
import com.sas.services.information.MetadataConnectionListener;
import com.sas.services.information.OMIServer;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.ServerInterface;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.security.login.LoginPropertyConstants;
import com.sas.services.security.login.OMILoginModule;
import com.sas.services.session.LockingException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.user.UserUnknownException;
import com.sas.services.util.Encryption;
import com.sas.services.util.NewUserWrapper;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.connection.ConnectionChangeListener;
import com.sas.workspace.connection.ConnectionException;
import com.sas.workspace.visuals.LoginCallbackHandler;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.omg.CORBA.Object;

public class ConnectionManager {
    private static WAdminResource bundle = WAdminResource.getBundle(ConnectionManager.class);
    private static final String SERVICE_DEPLOYMENT_FILENAME = "sas_foundation_services.xml";
    private static MdFactory m_factory;
    private UserContextInterface m_userContext;
    private SessionContextInterface m_sessionContext;
    private InformationServiceInterface m_informationService;
    private UserServiceInterface m_userService;
    private String m_username;
    private String m_securityPackage;
    private String m_servicePrincipalName;
    private String m_securityPackageList;
    private OMIServer m_metadataServer;
    private MdOMRConnection m_connection;
    private IOMI m_iomi;
    private IServer m_iServer;
    private MetadataConnectionListener m_metadataConnectionListener;
    private URL m_deploymentURL = null;
    private List<ConnectionChangeListener> m_connectionChangeListeners = new ArrayList<ConnectionChangeListener>();
    private LoginCallbackHandler m_loginCallbackHandler = new LoginCallbackHandler();
    private String m_host;
    private String m_port;
    private String m_user;
    private String m_domain;
    private boolean m_internalAccount = false;
    private boolean m_noredirect = false;
    private String m_tenant;
    private static final long TIMEOUT_INTERVAL = 60000L;
    private static final java.lang.Object SYNCH_OBJECT;
    private static final Map<java.lang.Object, SessionContextInterface> SESSION_CONTEXT_LOCKS;
    private static final String[] m_administratorClassifications;
    private boolean m_connectionToPausedServerAllowed = true;

    public MdFactory getFactory() {
        return m_factory;
    }

    public InformationServiceInterface getInformationService() {
        return this.m_informationService;
    }

    public IOMI getIOMI() {
        return this.m_iomi;
    }

    public IServer getIServer() {
        return this.m_iServer;
    }

    public String getUsername() {
        return this.m_username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentityInterface getIdentity(String domain) throws RemoteException {
        UserContextInterface userContextInterface = this.m_userContext;
        synchronized (userContextInterface) {
            List identities = this.m_userContext.getIdentities();
            for (UserIdentityInterface identity : identities) {
                if (!identity.getDomain().equals(domain)) continue;
                return identity;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getLogin(String domain) throws RemoteException {
        UserContextInterface userContextInterface = this.m_userContext;
        synchronized (userContextInterface) {
            List identities = this.m_userContext.getIdentities();
            for (UserIdentityInterface identity : identities) {
                if (!identity.getDomain().equals(domain)) continue;
                return new PasswordAuthentication(identity.getPrincipal().toString(), identity.getCredential().toString().toCharArray());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getAuthenticatedLogin() throws RemoteException {
        if (this.m_userContext == null) {
            return null;
        }
        UserContextInterface userContextInterface = this.m_userContext;
        synchronized (userContextInterface) {
            List identities = this.m_userContext.getIdentities();
            for (UserIdentityInterface identity : identities) {
                if (!identity.isPrimary()) continue;
                return new PasswordAuthentication(identity.getPrincipal().toString(), identity.getCredential().toString().toCharArray());
            }
            return null;
        }
    }

    public String getHost() {
        return this.m_host;
    }

    public String getPort() {
        return this.m_port;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPassword() {
        String password = null;
        try {
            PasswordAuthentication pw = this.getAuthenticatedLogin();
            try {
                if (pw != null && pw.getPassword() != null) {
                    password = String.valueOf(pw.getPassword());
                    String encodedPW = SasPasswordString.encode((String)password);
                    return encodedPW;
                }
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {}
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
        }
        return password;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public UserServiceInterface getUserService() {
        return this.m_userService;
    }

    public SessionContextInterface getSessionContext() {
        return this.m_sessionContext;
    }

    public UserContextInterface getUserContext() {
        return this.m_userContext;
    }

    public static MdFactory getMetadataFactory() {
        return m_factory;
    }

    public OMIServer getMetadataServer() {
        return this.m_metadataServer;
    }

    public boolean isConnectionToPausedServerAllowed() {
        return this.m_connectionToPausedServerAllowed;
    }

    public void setConnectionToPausedServerAllowed(boolean value) {
        this.m_connectionToPausedServerAllowed = value;
    }

    public void setSecurityPackage(String securityPackage) {
        this.m_securityPackage = securityPackage;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.m_servicePrincipalName = servicePrincipalName;
    }

    public void setSecurityPackageList(String securityPackageList) {
        this.m_securityPackageList = securityPackageList;
    }

    public void setDeploymentURL(URL url) {
        this.m_deploymentURL = url;
    }

    public void setLoginCallbackHostName(String hostname) {
        this.m_loginCallbackHandler.setHostName(hostname);
    }

    public boolean isNoredirect() {
        return this.m_noredirect;
    }

    public void setNoredirect(boolean noredirect) {
        this.m_noredirect = noredirect;
    }

    public String getTenant() {
        return this.m_tenant;
    }

    public void setTenant(String tenant) {
        if (tenant != null && tenant.length() == 0) {
            tenant = null;
        }
        this.m_tenant = tenant;
    }

    public boolean isInternalAccount() {
        return this.m_internalAccount;
    }

    public void setInternalAccount(boolean value) {
        this.m_internalAccount = value;
    }

    public boolean isValidInternalAccount() throws ServiceException {
        try {
            if (this.m_userContext == null || this.m_metadataServer == null) {
                return false;
            }
            String internalDomain = this.m_metadataServer.getInternalDomain();
            if (internalDomain != null && internalDomain.length() > 0) {
                String resolvedId = this.m_userContext.getResolvedUserId();
                int index = resolvedId.lastIndexOf(64);
                String domain = resolvedId.substring(index + 1);
                return domain.equalsIgnoreCase(internalDomain);
            }
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
        }
        return false;
    }

    public boolean isAdministrator() throws RemoteException, ServiceException {
        IdentityInfo info = this.m_metadataServer.getIdentityInfo();
        List classifications = info.getUserClass();
        for (int i = 0; i < m_administratorClassifications.length; ++i) {
            if (!classifications.contains(m_administratorClassifications[i])) continue;
            return true;
        }
        return false;
    }

    public void startFoundationServices() throws ServiceException, RemoteException {
        URL url = this.m_deploymentURL != null ? this.m_deploymentURL : this.getClass().getResource("res/sas_foundation_services.xml");
        if (url == null) {
            throw new ServiceException(bundle.getString("ConnectionManager.NoXML.txt") + " " + url);
        }
        MetadataSourceInterface[] localServiceDeployment = new MetadataSourceInterface[]{new URLMetadataSource(url)};
        PlatformServices.setServicesConfiguration((PlatformServicesConfiguration)new PlatformServicesConfiguration(localServiceDeployment, null));
        CorePlatformServices.setEnvironment((Environment)new Environment());
        CorePlatformServices.startServices();
        CorePlatformServices.getInformationService().setIsolated();
        CorePlatformServices.getInformationService().setOption(3, (java.lang.Object)new Boolean(false));
        CorePlatformServices.getUserService().setGroupLoginEnabled(true);
    }

    public void validateFoundationServices() throws ServiceException {
        AuthenticationServiceInterface authenticationSvc = CorePlatformServices.getAuthenticationService();
        if (authenticationSvc == null) {
            throw new ServiceException(bundle.getString("ConnectionManager.NoAuthSvc.txt"));
        }
        UserServiceInterface userSvc = CorePlatformServices.getUserService();
        if (userSvc == null) {
            throw new ServiceException(bundle.getString("ConnectionManager.NoUserSvc.txt"));
        }
        SessionServiceInterface sessionSvc = CorePlatformServices.getSessionService();
        if (sessionSvc == null) {
            throw new ServiceException(bundle.getString("ConnectionManager.NoSessionSvc.txt"));
        }
        InformationServiceInterface informationSvc = CorePlatformServices.getInformationService();
        if (informationSvc == null) {
            throw new ServiceException(bundle.getString("ConnectionManager.NoInfoSvc.txt"));
        }
    }

    public void terminateFoundationServices() throws ServiceException {
        CorePlatformServices.terminateServices();
    }

    public void connectToOMRServer(String host, String port, String domain, String user, String password) throws ServiceException, RemoteException, InterruptedException, Exception {
        this.connectToOMRServer(host, port, domain, user, password, false);
    }

    public void connectToOMRServer(String host, String port, String domain, String user, String password, boolean test) throws ServiceException, RemoteException, InterruptedException, Exception {
        this.m_userService = CorePlatformServices.getUserService();
        this.m_informationService = CorePlatformServices.getInformationService();
        if (this.m_userService == null || this.m_informationService == null) {
            throw new ConnectionException(bundle.getString("ConnectionManager.NoServices.txt"));
        }
        if (domain == null || domain.trim().length() == 0) {
            domain = !this.isInternalAccount() ? "DefaultAuth" : "InternalAuth";
        }
        HashMap<String, String> optionsMap = new HashMap<String, String>(5);
        optionsMap.put("host", host);
        optionsMap.put("port", port);
        optionsMap.put("domain", domain);
        optionsMap.put("holdopenconnection", LoginPropertyConstants.PROPERTYVALUE_TRUE);
        optionsMap.put("debug", Boolean.toString(Workspace.isDebug()));
        if (this.m_noredirect) {
            optionsMap.put("noredirect", Boolean.toString(true));
        }
        if (this.m_tenant != null) {
            optionsMap.put("tenant", this.m_tenant);
        }
        if (user == null) {
            optionsMap.put("idpropagation", "sspi");
            if (this.m_securityPackage.equals("Negotiate")) {
                if (!this.m_securityPackageList.equals("Kerberos,NTLM")) {
                    optionsMap.put("sspisecuritypackagelist", this.m_securityPackageList);
                }
            } else if (!this.m_securityPackage.equals("Negotiate")) {
                optionsMap.put("sspisecuritypackagelist", this.m_securityPackage);
            }
            if (this.m_servicePrincipalName.length() > 0) {
                optionsMap.put("sspispn", this.m_servicePrincipalName);
            }
        }
        AppConfigurationEntry[] appConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry(OMILoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, optionsMap)};
        PlatformServices.setJAASAppConfigurationEntry((AppConfigurationEntry[])appConfigurationEntries);
        this.m_host = host;
        this.m_port = port;
        this.m_user = user;
        this.m_domain = domain;
        try {
            NewUserWrapper wrapper = user == null ? NewUserWrapper.createWrapper(null, (String)Workspace.getWorkspace().getApplicationNameForLogging()) : NewUserWrapper.createWrapper((String)user, (String)Encryption.decrypt((String)password), (String)domain, null, (String)Workspace.getWorkspace().getApplicationNameForLogging());
            this.m_userContext = wrapper.invoke(CorePlatformServices.getUserService(), 60000L);
        }
        catch (UserInitializationException ex) {
            this.handleUserInitializationException(ex);
        }
        ServerInterface server = this.m_userContext.getAuthServer();
        if (!(server instanceof OMIServer)) {
            throw new ConnectionException(bundle.getString("ConnectionManager.UnexpectedServer.txt"));
        }
        this.m_metadataServer = (OMIServer)server;
        if (this.m_metadataServer != null) {
            String foundationResourceId;
            OMIServerRepository foundationRepository = (OMIServerRepository)this.m_metadataServer.getFoundationRepository();
            if (foundationRepository != null && !this.m_metadataServer.isAuthorized("", foundationResourceId = "REPOSID:" + foundationRepository.getDefaultRepositoryId().substring(9, 17), "ReadMetadata")) {
                String userId = this.m_userContext.getResolvedUserId();
                this.disconnectFromOMRServer(false);
                throw new ConnectionException(bundle.formatString("ConnectionManager.UnauthorizedUser.txt", userId, host));
            }
            this.m_metadataConnectionListener = new ConnectionListener();
            this.m_metadataServer.addMetadataConnectionListener(this.m_metadataConnectionListener);
        }
        this.m_sessionContext = CorePlatformServices.getSessionService().newSessionContext(this.m_userContext);
        if (Workspace.getWorkspace().getApplicationName() != null && !Workspace.getWorkspace().getApplicationName().isEmpty() && Workspace.getWorkspace().getApplicationName().indexOf("SAS Data Integration") >= 0) {
            this.m_sessionContext.setAttribute("com.sas.services.connection.platform.factoryReqStandard", (java.lang.Object)"TRUE");
        }
        this.updateFactory();
        this.updateUser();
        for (ConnectionChangeListener listener : this.m_connectionChangeListeners) {
            listener.connectionOpened(this);
        }
        if (!test) {
            if (Workspace.getWorkspace().getMetadataServerStatus() == Workspace.SERVERSTATUS_PAUSED && !this.isConnectionToPausedServerAllowed()) {
                this.disconnectFromOMRServer();
                throw new ConnectionException(bundle.formatString("ConnectionManager.PausedMetadataServer.txt", host));
            }
            if (Workspace.getWorkspace().getMetadataServerStatus() == Workspace.SERVERSTATUS_PAUSED && !this.isAdministrator()) {
                String userid = this.m_userContext.getResolvedUserId();
                this.disconnectFromOMRServer();
                throw new ConnectionException(bundle.formatString("ConnectionManager.NonAdminUserAndPausedServer.txt", host, userid));
            }
        }
        Workspace.getDefaultLogger().debug("Finishing connectToOMRServer");
    }

    protected void handleUserInitializationException(UserInitializationException ex) throws Exception {
        Exception[] exceptions = ex.getExceptions();
        for (int index = 0; index < exceptions.length; ++index) {
            if (exceptions[index] instanceof UserUnknownException) continue;
            throw exceptions[index];
        }
        if (exceptions.length > 0 && exceptions[0] instanceof UserUnknownException) {
            this.m_userContext = ex.getUser();
        }
    }

    public void disconnectFromOMRServer() throws RemoteException {
        this.disconnectFromOMRServer(true);
    }

    public void disconnectFromOMRServer(boolean notifyListeners) throws RemoteException {
        if (notifyListeners) {
            for (ConnectionChangeListener listener : this.m_connectionChangeListeners) {
                listener.connectionClosing(this);
            }
        }
        if (this.m_userContext != null) {
            this.m_userContext.destroy();
            this.m_userContext = null;
        }
        if (this.m_sessionContext != null) {
            try {
                this.m_sessionContext.destroy();
            }
            catch (LockingException ex) {
                Workspace.getDefaultLogger().warn((java.lang.Object)"", ex);
            }
            catch (IllegalStateException ex) {
                Workspace.getDefaultLogger().error((java.lang.Object)"", ex);
            }
            this.m_sessionContext = null;
        }
        this.m_internalAccount = false;
    }

    public void clearCredentialsCache() throws RemoteException {
        this.clearCredentialsCache(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCredentialsCache(boolean removePrimary) throws RemoteException {
        UserContextInterface userContextInterface = this.m_userContext;
        synchronized (userContextInterface) {
            List identities = this.m_userContext.getIdentities();
            for (UserIdentityInterface identity : identities) {
                if (!removePrimary && identity.isPrimary()) continue;
                this.m_userContext.removeIdentity(identity);
            }
        }
    }

    public void updateFactory() throws MdException, RemoteException {
        m_factory = this.m_metadataServer.getMdFactory();
        m_factory.setRemoveDependentObjects(true);
        this.m_connection = m_factory.getConnection();
        this.m_iomi = this.m_connection.getCMRHandle();
        this.m_iServer = this.m_connection.MakeIServerConnection(this.m_iomi);
    }

    public void updateUser() throws RemoteException, ServiceException {
        if (this.m_userContext == null) {
            return;
        }
        WsAppServer.setUserContext(this.m_userContext);
        this.m_userContext.setChallengeCallbackHandler((RemoteCallbackHandler)this.m_loginCallbackHandler);
        this.m_username = this.m_userContext.getResolvedUserId();
    }

    public void updateProfile() {
        WorkspaceFile workspaceFile = Workspace.getWorkspace().getWorkspaceFile();
        boolean update = false;
        boolean allowLocalPasswords = this.allowLocalPasswords();
        workspaceFile.setPropertyBoolean("AllowLocalPasswords", allowLocalPasswords);
        if (!allowLocalPasswords) {
            update = true;
            workspaceFile.setPropertyString("userid", "");
            workspaceFile.setPropertyString("password", "");
        }
        if (this.updateHostPortProperties(workspaceFile)) {
            update = true;
        }
        if (update) {
            workspaceFile.saveExisting();
        }
    }

    public void updateProfileHostPortProperties() {
        WorkspaceFile workspaceFile = Workspace.getWorkspace().getWorkspaceFile();
        if (workspaceFile != null && this.updateHostPortProperties(workspaceFile)) {
            workspaceFile.saveExisting();
        }
    }

    private boolean updateHostPortProperties(WorkspaceFile workspaceFile) {
        String allowClusterUpdate = workspaceFile.getPropertyString("AllowClusterUpdate");
        if (allowClusterUpdate != null && allowClusterUpdate.length() > 0 && !Boolean.parseBoolean(allowClusterUpdate)) {
            return false;
        }
        try {
            HostPortSet metadataCluster = this.m_metadataServer.getClusterConnections();
            if (metadataCluster == null) {
                return false;
            }
            HostPortSet profileCluster = HostPortSet.newInstance((String)workspaceFile.getPropertyString("host"), (String)workspaceFile.getPropertyString("port"));
            if (metadataCluster.size() == 1 && profileCluster.size() == 1) {
                return false;
            }
            if ("localhost".equalsIgnoreCase(profileCluster.getHosts())) {
                return false;
            }
            if (metadataCluster.equals((java.lang.Object)profileCluster)) {
                return false;
            }
            if (metadataCluster.contains((java.lang.Object)new HostPortPair(this.m_metadataServer.getHost(), this.m_metadataServer.getPort())) || metadataCluster.intersects(profileCluster)) {
                workspaceFile.setPropertyString("host", metadataCluster.getHosts());
                workspaceFile.setPropertyString("port", metadataCluster.getPorts());
                return true;
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)e.getLocalizedMessage(), e);
        }
        return false;
    }

    public void addConnectionChangeListener(ConnectionChangeListener listener) {
        this.m_connectionChangeListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionContext(SessionContextInterface sessionContext) {
        java.lang.Object object = SYNCH_OBJECT;
        synchronized (object) {
            block8: {
                try {
                    if (this.m_userContext != null) {
                        this.m_userContext.destroy();
                        this.m_userContext = null;
                    }
                    if (this.m_sessionContext != null) {
                        this.m_sessionContext.destroy();
                        this.m_sessionContext = null;
                    }
                    this.m_sessionContext = sessionContext;
                    this.m_userContext = this.m_sessionContext.getUserContext();
                    this.m_metadataServer = (OMIServer)this.m_sessionContext.getUserContext().getAuthServer();
                    this.updateFactory();
                    this.updateUser();
                }
                catch (Exception e) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"", e);
                    if (!Workspace.isDebug()) break block8;
                    e.printStackTrace();
                }
            }
            for (ConnectionChangeListener listener : this.m_connectionChangeListeners) {
                listener.connectionOpened(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeSessionContext(SessionContextInterface sessionContext, java.lang.Object sessionContextLock) {
        this.m_sessionContext = null;
        try {
            ConnectionManager.releaseSessionContext(sessionContext, sessionContextLock);
        }
        catch (ClassCastException classCastException) {
            Map<java.lang.Object, SessionContextInterface> map = SESSION_CONTEXT_LOCKS;
            synchronized (map) {
                SESSION_CONTEXT_LOCKS.remove(sessionContextLock);
            }
        }
        finally {
            Map<java.lang.Object, SessionContextInterface> map = SESSION_CONTEXT_LOCKS;
            synchronized (map) {
                SESSION_CONTEXT_LOCKS.remove(sessionContextLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final java.lang.Object lockSessionContext(SessionContextInterface sessionContext, String applicationName) throws ServiceException, IllegalStateException {
        java.lang.Object sessionContextLock = null;
        if (sessionContext != null) {
            try {
                sessionContextLock = sessionContext.lock(applicationName);
                Map<java.lang.Object, SessionContextInterface> map = SESSION_CONTEXT_LOCKS;
                synchronized (map) {
                    SESSION_CONTEXT_LOCKS.put(sessionContextLock, sessionContext);
                }
            }
            catch (RemoteException e) {
                throw new ServiceException((Throwable)e, bundle.formatString("ConnectionManager.lockSessionContext.ex.fmt.txt", applicationName));
            }
        }
        return sessionContextLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void releaseSessionContext(SessionContextInterface sessionContext, java.lang.Object sessionContextLock) {
        if (sessionContext != null) {
            SessionContextInterface sessionContextInterface = sessionContext;
            synchronized (sessionContextInterface) {
                block34: {
                    try {
                        if (sessionContextLock == null) break block34;
                        boolean isContextDestroyed = false;
                        Exception ex = null;
                        try {
                            sessionContext.unlock(sessionContextLock);
                        }
                        catch (IllegalArgumentException e) {
                            ex = e;
                        }
                        catch (RemoteException e) {
                            ex = e;
                        }
                        catch (IllegalStateException e) {
                            isContextDestroyed = true;
                        }
                        finally {
                            if (ex != null) {
                                Workspace.getDefaultLogger().error(ex.getLocalizedMessage());
                            }
                            Map<java.lang.Object, SessionContextInterface> e = SESSION_CONTEXT_LOCKS;
                            synchronized (e) {
                                SESSION_CONTEXT_LOCKS.remove(sessionContextLock);
                            }
                            if (!isContextDestroyed) {
                                sessionContext.destroy();
                            }
                        }
                    }
                    catch (LockingException isContextDestroyed) {
                    }
                    catch (IllegalStateException isContextDestroyed) {
                    }
                    catch (RemoteException e) {
                        Workspace.getDefaultLogger().error(e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    public boolean allowLocalPasswords() {
        return this.allowLocalPasswords(Workspace.getWorkspace().getCMRHandle());
    }

    public boolean allowLocalPasswords(IOMI serverInterface) {
        ISecurity_1_1 iSecurity = ISecurity_1_1Helper.narrow((Object)serverInterface);
        VariableArray2dOfStringHolder returnInfo = new VariableArray2dOfStringHolder();
        String[][] sOptions = new String[][]{{"sassec_local_pw_save", ""}};
        try {
            iSecurity.GetInfo("EnterprisePolicies", "", sOptions, returnInfo);
            return returnInfo.value[0][1].equals("1");
        }
        catch (InvalidCredHandle ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
        }
        catch (InvalidInfoType ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
        }
        catch (InvalidOptionName ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
        }
        catch (InvalidOptionValue ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
        }
        catch (GenericError ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
        }
        return false;
    }

    static {
        SYNCH_OBJECT = new java.lang.Object();
        SESSION_CONTEXT_LOCKS = new HashMap<java.lang.Object, SessionContextInterface>(5);
        m_administratorClassifications = new String[]{"Unrestricted", "Administrator", "IdentityAdmin"};
    }

    class ConnectionListener
    implements MetadataConnectionListener {
        ConnectionListener() {
        }

        public void connectionNotification(MetadataConnectionEvent event) throws RemoteException {
            try {
                MdOMRConnection connection;
                if (m_factory != null && (connection = m_factory.getConnection()) != null) {
                    ConnectionManager.this.m_iomi = connection.getCMRHandle();
                    ConnectionManager.this.m_iServer = connection.MakeIServerConnection(ConnectionManager.this.m_iomi);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            catch (MdException ex) {
                Workspace.getDefaultLogger().error((java.lang.Object)ex.getLocalizedMessage(), ex);
            }
        }
    }
}

