/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.visuals.util.XMLMenuBar;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsWindowsDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class WsWindowMenuManager
implements MenuListener {
    private static WAdminResource bundle = WAdminResource.getBundle(WsWindowMenuManager.class);
    protected static final String SEPARATOR_NAME = "RemoveMe";
    private JMenu m_mnuWindow;

    public WsWindowMenuManager() {
        XMLMenuBar menuBar = WorkspaceMenuSupport.getWorkspaceMenuSupport().getMenuBar();
        ArrayList alMenus = menuBar.getMenusById("window");
        if (alMenus != null && alMenus.size() > 0) {
            this.m_mnuWindow = (JMenu)alMenus.get(0);
            this.m_mnuWindow.addMenuListener(this);
        }
    }

    public WsWindowMenuManager(JMenu mnuWindow) {
        this.m_mnuWindow = mnuWindow;
        this.m_mnuWindow.addMenuListener(this);
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        JMenu menu = (JMenu)e.getSource();
        JInternalFrame[] aFrames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
        if (aFrames.length > 0) {
            JSeparator sep = new JSeparator();
            sep.setName(SEPARATOR_NAME);
            menu.add(sep);
        }
        int nFrames = Math.min(aFrames.length, 9);
        for (int iFrame = 0; iFrame < nFrames; ++iFrame) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new cWindowAction(iFrame + 1, aFrames[iFrame]));
            item.setSelected(aFrames[iFrame].isSelected());
            menu.add(item);
        }
        if (aFrames.length > 9) {
            JSeparator sep = new JSeparator();
            sep.setName(SEPARATOR_NAME);
            menu.add(sep);
            menu.add(new JMenuItem(new cMoreWindowsAction()));
        }
        boolean bAtLeastOne = aFrames.length > 0;
        WorkspaceMenuSupport wms = Workspace.getWorkspace().getMenuObject();
        if (wms != null) {
            wms.setItemsState("cascade", bAtLeastOne);
            wms.setItemsState("tileh", bAtLeastOne);
            wms.setItemsState("tilev", bAtLeastOne);
            wms.setItemsState("closeall", bAtLeastOne);
        } else {
            this.setActionEnabled("Common:Collapse", bAtLeastOne);
            this.setActionEnabled("Common:Arrange", bAtLeastOne);
            this.setActionEnabled("Common:CloseAll", bAtLeastOne);
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        JMenu menu = (JMenu)e.getSource();
        Component[] aItems = menu.getMenuComponents();
        for (int iItem = 0; iItem < aItems.length; ++iItem) {
            String sName;
            if (aItems[iItem] instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)aItems[iItem];
                Action action = item.getAction();
                if (action instanceof cWindowAction) {
                    menu.remove(item);
                    continue;
                }
                if (!(action instanceof cMoreWindowsAction)) continue;
                menu.remove(item);
                continue;
            }
            if (!(aItems[iItem] instanceof JSeparator) || (sName = aItems[iItem].getName()) == null || !sName.equals(SEPARATOR_NAME)) continue;
            menu.remove(aItems[iItem]);
        }
    }

    private void setActionEnabled(String sActionKey, boolean bEnabled) {
        WsAbstractAction act = WsAbstractApplicationActionsManager.getInstance().getAction(sActionKey);
        if (act != null) {
            act.setEnabled(bEnabled);
        }
    }

    protected class cWindowAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected JInternalFrame m_frm;

        public cWindowAction(int iFrame, JInternalFrame frm) {
            this.m_frm = frm;
            String sName = Integer.toString(iFrame) + " " + this.m_frm.getTitle();
            Integer mnem = new Integer(iFrame + 48);
            Icon icon = this.m_frm.getFrameIcon();
            this.putValue("Name", sName);
            this.putValue("MnemonicKey", mnem);
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Workspace.getWorkspace().getDesktopWindowHandle().activateFrame(this.m_frm);
        }
    }

    protected class cMoreWindowsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public cMoreWindowsAction() {
            String sName = bundle.getString("WindowMenuManager.MoreWindows.txt");
            Integer mnem = new Integer(bundle.getString("WindowMenuManager.MoreWindows.mnem").charAt(0));
            ImageIcon icon = bundle.getImageIcon("Common.EmptyIcon.image");
            this.putValue("Name", sName);
            this.putValue("MnemonicKey", mnem);
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsWindowsDialog dlg = new WsWindowsDialog();
            dlg.setVisible(true);
        }
    }
}

