/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginLoader;
import com.sas.workspace.CustomDesktop;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractOMAView;
import com.sas.workspace.WsBaseView;
import com.sas.workspace.WsNewView;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsView;
import com.sas.workspace.plugins.MetadataVisualsPluginInterface;
import java.awt.Cursor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class WsViewFactory {
    private WsViewFactory() {
    }

    private static WsBaseView findExistingView(String sID, String sClass, Object userData) {
        JInternalFrame[] frames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
        for (int iFrame = 0; iFrame < frames.length; ++iFrame) {
            WAInternalFrame frame;
            WsBaseView view;
            if (!(frames[iFrame] instanceof WAInternalFrame) || (view = (frame = (WAInternalFrame)frames[iFrame]).getView()) == null || !view.getClass().getName().equals(sClass) || !view.getID().equals(sID)) continue;
            if (view instanceof WsView) {
                WsView view2 = (WsView)((Object)view);
                Object viewUserData = view2.getUserData();
                if (viewUserData == null && userData == null) {
                    return view;
                }
                if (viewUserData == null || userData == null || !viewUserData.equals(userData)) continue;
                return view;
            }
            return view;
        }
        return null;
    }

    public static boolean anyViewsExist() {
        return Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames().length != 0;
    }

    public static WsOMAView findExistingView(CMetadata oMetadata, Class clsView) throws RemoteException {
        return WsViewFactory.findExistingView(oMetadata, clsView.getName());
    }

    public static WsOMAView findExistingView(CMetadata oMetadata, String sViewClass) {
        try {
            return (WsOMAView)WsViewFactory.findExistingView(oMetadata.getFQID(), sViewClass, null);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public static List findExistingViews(CMetadata oMetadata, String sViewClass) throws RemoteException {
        ArrayList<WsOMAView> lViews = new ArrayList<WsOMAView>(1);
        WsOMAView view = WsViewFactory.findExistingView(oMetadata, sViewClass);
        if (view != null) {
            lViews.add(view);
        }
        return lViews;
    }

    protected static WsOMAView findExistingView(CMetadata oMetadata, String sPrefix, String sPostfix) throws RemoteException {
        String sType = oMetadata.getCMetadataType();
        WsOMAView view = WsViewFactory.findExistingView(oMetadata, sPrefix + sType + sPostfix);
        if (view == null) {
            view = WsViewFactory.findExistingView(oMetadata, sPrefix + "Root" + sPostfix);
        }
        return view;
    }

    public static void showExistingView(WsOMAView view) {
        Workspace.getWorkspace().getDesktopWindowHandle().activateFrame(view.getFrame());
    }

    protected static WsOMAView createWorkspaceView(String sViewClass, ClassLoader loader) {
        try {
            Class<?> clsView = Class.forName(sViewClass, true, loader);
            WsOMAView view = (WsOMAView)clsView.newInstance();
            return view;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            return null;
        }
    }

    public static WsOMAView createPropertyView(CMetadata oMetadata, String sPrefix, String sPostfix) {
        return WsViewFactory.createPropertyView(oMetadata, sPrefix, sPostfix, ClassLoader.getSystemClassLoader());
    }

    public static WsOMAView createPropertyView(CMetadata oMetadata, String sPrefix, String sPostfix, ClassLoader loader) {
        String sType;
        try {
            sType = oMetadata.getCMetadataType();
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"WsViewFactory.createPropertyView", ex);
            sType = "Root";
        }
        WsOMAView view = WsViewFactory.createWorkspaceView(sPrefix + sType + sPostfix, loader);
        if (view == null && (view = WsViewFactory.createWorkspaceView(sPrefix + "Root" + sPostfix, loader)) == null) {
            return null;
        }
        WsViewFactory.attachViewToFrame(oMetadata, (WorkspaceOMAView)view, WsViewFactory.createPropertyFrame(oMetadata));
        return view;
    }

    public static WsOMAView createPropertyView(CMetadata oMetadata, String sViewClass, ClassLoader loader) {
        WsOMAView view = WsViewFactory.createWorkspaceView(sViewClass, loader);
        if (view != null) {
            WsViewFactory.attachViewToFrame(oMetadata, (WorkspaceOMAView)view, WsViewFactory.createPropertyFrame(oMetadata));
        }
        return view;
    }

    protected static void createPropertyViewFrame(CMetadata oMetadata, WsOMAView view) {
        WsViewFactory.attachViewToFrame(oMetadata, (WorkspaceOMAView)view, WsViewFactory.createPropertyFrame(oMetadata));
    }

    protected static WAPropertyFrame createPropertyFrame(CMetadata oMetadata) {
        return new WAPropertyFrame(oMetadata, "");
    }

    public static void attachViewToFrame(CMetadata oMetadata, WorkspaceOMAView view, WAPropertyFrame frame) {
        Workspace work = Workspace.getWorkspace();
        view.setMetadata((Root)oMetadata);
        WAPropertyTabGroup tabs = view.createView();
        if (tabs != null) {
            frame.addTabGroup(tabs);
            WsViewFactory.addPluginPropertyTabsToFrame(frame, oMetadata);
            view.setFrame(frame);
            CustomDesktop desktop = work.getDesktopWindowHandle();
            desktop.addCascaded(frame);
            frame.show();
        } else {
            Workspace.getDefaultLogger().debug("Properties not yet implemented for this object type.");
        }
    }

    public static void addPluginPropertyTabsToFrame(WAPropertyFrame frame, CMetadata oMetadata) {
        PluginLoader pluginLoader = Workspace.getWorkspace().getPluginLoader();
        if (pluginLoader == null) {
            return;
        }
        ArrayList alPlugins = pluginLoader.getPlugins("com.sas.workspace.plugins.MetadataVisualsPluginInterface", true);
        int nPlugins = alPlugins.size();
        for (int iPlugin = 0; iPlugin < nPlugins; ++iPlugin) {
            MetadataVisualsPluginInterface plugTabs = (MetadataVisualsPluginInterface)alPlugins.get(iPlugin);
            ArrayList alTabs = plugTabs.getPropertyTabs(oMetadata);
            if (alTabs == null) continue;
            int nTabs = alTabs.size();
            for (int iTab = 0; iTab < nTabs; ++iTab) {
                WAPropertyTab tab = (WAPropertyTab)alTabs.get(iTab);
                frame.addTab(tab.getTitle(), tab.getIcon(), tab, tab.getToolTipText());
            }
        }
    }

    public static WsOMAView showPropertyView(CMetadata oMetadata, String sPrefix, String sPostfix) {
        return WsViewFactory.showPropertyView(oMetadata, sPrefix, sPostfix, ClassLoader.getSystemClassLoader());
    }

    public static WsOMAView showPropertyView(CMetadata oMetadata, String sViewClass, ClassLoader loader) {
        WsOMAView view = null;
        try {
            view = WsViewFactory.findExistingView(oMetadata, sViewClass);
            if (view != null) {
                WsViewFactory.showExistingView(view);
                oMetadata.getObjectStore().dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            } else {
                Class<?> clsView = Class.forName(sViewClass, true, loader);
                view = (WsOMAView)clsView.newInstance();
                if (view != null) {
                    WsViewFactory.attachViewToFrame(oMetadata, (WorkspaceOMAView)view, WsViewFactory.createPropertyFrame(oMetadata));
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsOMAView showPropertyView(CMetadata oMetadata, String sPrefix, String sPostfix, ClassLoader loader) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        WsOMAView view = null;
        try {
            view = WsViewFactory.findExistingView(oMetadata, sPrefix, sPostfix);
            if (view != null) {
                WsViewFactory.showExistingView(view);
                oMetadata.getObjectStore().dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            } else {
                view = WsViewFactory.createPropertyView(oMetadata, sPrefix, sPostfix, loader);
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
        return view;
    }

    public static WsOMAView showPropertyView(CMetadata oMetadata, Package pkg) {
        return WsViewFactory.showPropertyView(oMetadata, pkg, ClassLoader.getSystemClassLoader());
    }

    public static WsOMAView showPropertyView(String sName, String sType, String sFQID, Package pkg) {
        return WsViewFactory.showPropertyView(sName, sType, sFQID, pkg, ClassLoader.getSystemClassLoader());
    }

    public static WsOMAView showPropertyView(CMetadata oMetadata, Package pkg, ClassLoader ldr) {
        try {
            return WsViewFactory.showPropertyView(oMetadata.getName(), oMetadata.getCMetadataType(), oMetadata.getFQID(), pkg, ldr);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"WsViewFactory showPropertyView", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsOMAView showPropertyView(String sName, String sType, String sFQID, Package pkg, ClassLoader ldr) {
        try {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            StringBuffer sbViewClass = new StringBuffer(100);
            sbViewClass.append(pkg.getName());
            sbViewClass.append('.');
            sbViewClass.append(sType);
            sbViewClass.append("View");
            Class clsView = WsViewFactory.loadClass(sbViewClass.toString(), ldr);
            if (clsView == null) {
                sbViewClass.setLength(0);
                sbViewClass.append(pkg.getName());
                sbViewClass.append('.');
                sbViewClass.append("RootView");
                clsView = WsViewFactory.loadClass(sbViewClass.toString(), ldr);
                if (clsView == null) {
                    WsOMAView wsOMAView = null;
                    return wsOMAView;
                }
            }
            WsOMAView wsOMAView = WsViewFactory.showView(sName, sType, sFQID, clsView);
            return wsOMAView;
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }

    private static Class loadClass(String sClass, ClassLoader ldr) {
        try {
            return Class.forName(sClass, true, ldr);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static WsOMAView showView(CMetadata oMetadata, Class clsView) {
        return WsViewFactory.showView(oMetadata, clsView, null);
    }

    public static WsOMAView showView(CMetadata oMetadata, Class clsView, Object userData) {
        return WsViewFactory.showView(oMetadata, clsView, userData, null);
    }

    public static WsOMAView showView(CMetadata oMetadata, Class clsView, Object userData, MdStore storeParent) {
        try {
            return WsViewFactory.showView(oMetadata.getName(), oMetadata.getCMetadataType(), oMetadata.getFQID(), clsView, userData, storeParent);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"WsViewFactory showView", ex);
            return null;
        }
    }

    public static WsOMAView showView(String sName, String sType, String sFQID, Class clsView) {
        return WsViewFactory.showView(sName, sType, sFQID, clsView, null);
    }

    public static WsOMAView showView(String sName, String sType, String sFQID, Class clsView, Object userData) {
        return WsViewFactory.showView(sName, sType, sFQID, clsView, userData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WsOMAView showView(String sName, String sType, String sFQID, Class clsView, Object userData, MdStore storeParent) {
        StringBuffer sbName = new StringBuffer(100);
        sbName.append(clsView.getName());
        sbName.append('-');
        sbName.append(sFQID);
        try {
            WsOMAView wsOMAView;
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(storeParent, sbName.toString());
            try {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                Root oData = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, sName, sType, sFQID);
                WsOMAView view = WsViewFactory.findExistingView((CMetadata)oData, clsView);
                if (view != null) {
                    WsViewFactory.showExistingView(view);
                    WsOMAView wsOMAView2 = view;
                    return wsOMAView2;
                }
                view = (WsOMAView)clsView.newInstance();
                if (view instanceof WsAbstractOMAView) {
                    WAPropertyFrame frame = WsViewFactory.createPropertyFrame((CMetadata)oData);
                    view.setMetadata(oData);
                    ((WsAbstractOMAView)view).setUserData(userData);
                    view.setFrame(frame);
                    Workspace.getWorkspace().getDesktopWindowHandle().addCascaded(frame);
                    frame.show();
                } else {
                    WsViewFactory.attachViewToFrame((CMetadata)oData, (WorkspaceOMAView)view, WsViewFactory.createPropertyFrame((CMetadata)oData));
                }
                store = null;
                WsOMAView wsOMAView3 = view;
                return wsOMAView3;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                wsOMAView = null;
                return wsOMAView;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                wsOMAView = null;
                return wsOMAView;
            }
            finally {
                if (store != null) {
                    store.dispose();
                    Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
                }
                Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public static WsOMAView findExistingView(Root oMetadata, Class clsView, Object userData) throws RemoteException {
        return (WsOMAView)WsViewFactory.findExistingView(oMetadata.getFQID(), clsView.getName(), userData);
    }

    public static WsView showView(Class clsView) {
        return WsViewFactory.showView(clsView, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsView showView(Class clsView, Object userData) {
        try {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            WsView view = WsViewFactory.findExistingView(clsView, userData);
            if (view != null) {
                WsViewFactory.showExistingView(view);
                WsView wsView = view;
                return wsView;
            }
            WAStandardInternalFrame frame = new WAStandardInternalFrame("");
            view = (WsView)clsView.newInstance();
            view.setUserData(userData);
            view.setFrame(frame);
            Workspace.getWorkspace().getDesktopWindowHandle().addCascaded(frame);
            frame.show();
            WsView wsView = view;
            return wsView;
        }
        catch (IllegalAccessException e) {
            Workspace.getDefaultLogger().error(e);
            WsView wsView = null;
            return wsView;
        }
        catch (InstantiationException e) {
            Workspace.getDefaultLogger().error(e);
            WsView wsView = null;
            return wsView;
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }

    private static void showExistingView(WsView view) {
        Workspace.getWorkspace().getDesktopWindowHandle().activateFrame(view.getFrame());
    }

    public static WsView findExistingView(Class clsView, Object userData) {
        return (WsView)((Object)WsViewFactory.findExistingView(clsView.getName(), clsView.getName(), userData));
    }

    public static WsNewView showNewView(String sID, String sType, String sName, Class clsView) {
        WsNewView view = (WsNewView)WsViewFactory.findExistingView(sID, clsView.getName(), null);
        if (view != null) {
            Workspace.getWorkspace().getDesktopWindowHandle().activateFrame(view.getFrame());
            return view;
        }
        try {
            Method method = clsView.getMethod("createInstance", String.class, String.class, String.class);
            view = (WsNewView)method.invoke(null, sID, sType, sName);
            Workspace.getWorkspace().getDesktopWindowHandle().addCascaded(view.getFrame());
            SwingUtilities.invokeLater(new ShowViewRunnable(view));
            return view;
        }
        catch (NoSuchMethodException ex) {
            throw new UnsupportedOperationException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new UnsupportedOperationException(ex);
        }
        catch (SecurityException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    private static class ShowViewRunnable
    implements Runnable {
        private WsNewView m_view;

        public ShowViewRunnable(WsNewView view) {
            this.m_view = view;
        }

        @Override
        public void run() {
            this.m_view.show();
        }
    }
}

