/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsTreeUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WsTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsTree.class);
    private static final String s_sUIClassID = "WsTreeUI";
    protected boolean m_bActive;
    protected boolean m_bPopupMenuEnabled;
    protected boolean m_bDefaultActionEnabled;
    protected WsPopupMenuRequestListener m_lsnrPopupMenuRequest;
    private boolean m_bIconsVisible;
    private boolean m_bExpandControlsVisible;
    private boolean m_bExpandActionEnabled;
    private boolean m_bDraggingEnabled;
    private boolean m_bDrawLines;
    protected WsTreeNode m_nodeActive;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actRename;
    protected AbstractAction m_actDefault;
    private AbstractAction m_actUserDefault;
    protected AbstractAction m_actShowPopupMenu;

    public WsTree() {
        this.initialize();
    }

    public WsTree(DefaultTreeModel mdl) {
        super(mdl);
        this.initialize();
    }

    @Override
    public String getUIClassID() {
        if (UIManager.get(s_sUIClassID) == null) {
            UIManager.put(s_sUIClassID, WsTreeUI.class.getName());
        }
        return s_sUIClassID;
    }

    protected void initialize() {
        this.createActions();
        this.createListeners();
        this.getActionMap().put(this.m_actDelete, this.m_actDelete);
        this.getActionMap().put(this.m_actRename, this.m_actRename);
        this.getActionMap().put(this.m_actDefault, this.m_actDefault);
        this.getActionMap().put(this.m_actShowPopupMenu, this.m_actShowPopupMenu);
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 0), this.m_actRename);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.m_actDefault);
        this.getInputMap().put(KeyStroke.getKeyStroke(121, 1), this.m_actShowPopupMenu);
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.setPopupMenuEnabled(true);
        this.setDefaultActionEnabled(true);
        this.setIconsVisible(true);
        this.setExpandControlsVisible(true);
        this.setExpandActionEnabled(true);
        this.setDrawLines(true);
        this.getSelectionModel().setSelectionMode(4);
        this.setSelectionPath(new TreePath(this.getModel().getRoot()));
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateActions();
    }

    public void setActiveNode(WsTreeNode nodeActive) {
        if (this.m_nodeActive != null) {
            this.m_nodeActive.updateWorkspaceUIComponents(false);
        }
        this.m_nodeActive = nodeActive;
        if (this.m_nodeActive != null) {
            this.m_nodeActive.updateWorkspaceUIComponents(this.m_bActive);
        }
    }

    public WsTreeNode getActiveNode() {
        return this.m_nodeActive;
    }

    public void setPopupMenuEnabled(boolean bEnabled) {
        this.m_bPopupMenuEnabled = bEnabled;
    }

    public boolean isPopupMenuEnabled() {
        return this.m_bPopupMenuEnabled;
    }

    public void setUserDefaultAction(AbstractAction actDefault) {
        this.m_actUserDefault = actDefault;
    }

    public AbstractAction getUserDefaultAction() {
        return this.m_actUserDefault;
    }

    public void setIconsVisible(boolean bIconsVisible) {
        this.m_bIconsVisible = bIconsVisible;
        this.invalidate();
        this.repaint();
    }

    public boolean areIconsVisible() {
        return this.m_bIconsVisible;
    }

    public void setExpandControlsVisible(boolean bExpandControlsVisible) {
        this.m_bExpandControlsVisible = bExpandControlsVisible;
        this.invalidate();
        this.repaint();
    }

    public boolean areExpandControlsVisible() {
        return this.m_bExpandControlsVisible;
    }

    public void setExpandActionEnabled(boolean bEnabled) {
        this.m_bExpandActionEnabled = bEnabled;
    }

    public boolean isExpandActionEnabled() {
        return this.m_bExpandActionEnabled;
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getPopupMenuRequestListener() {
        return this.m_lsnrPopupMenuRequest;
    }

    public void setDefaultActionEnabled(boolean bEnabled) {
        this.m_bDefaultActionEnabled = bEnabled;
    }

    public boolean isDefaultActionEnabled() {
        return this.m_bDefaultActionEnabled;
    }

    public void setDraggingEnabled(boolean bEnabled) {
        this.m_bDraggingEnabled = bEnabled;
    }

    public boolean isDraggingEnabled() {
        return this.m_bDraggingEnabled;
    }

    public void setDrawLines(boolean bDraw) {
        this.m_bDrawLines = bDraw;
    }

    public boolean isDrawLines() {
        return this.m_bDrawLines;
    }

    public void expand() {
        this.expand((TreeNode)this.getModel().getRoot());
    }

    public void expand(TreeNode node) {
        if (node.isLeaf()) {
            return;
        }
        Object[] aNodes = ((DefaultTreeModel)this.getModel()).getPathToRoot(node);
        this.expandPath(new TreePath(aNodes));
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            this.expand(node.getChildAt(iChild));
        }
    }

    public void setSelectedNode(WsTreeNode nodeSelected) {
        if (nodeSelected == null) {
            this.clearSelection();
        } else {
            this.setSelectionPath(new TreePath(nodeSelected.getPath()));
        }
    }

    public WsTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            return (WsTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    public void setSelectedNodes(WsTreeNode[] aSelectedNodes) {
        TreePath[] aSelectedPaths = new TreePath[aSelectedNodes.length];
        for (int iPath = 0; iPath < aSelectedPaths.length; ++iPath) {
            aSelectedPaths[iPath] = new TreePath(aSelectedNodes[iPath].getPath());
        }
        this.setSelectionPaths(aSelectedPaths);
    }

    public WsTreeNode[] getSelectedNodes() {
        TreePath[] aPaths = this.getSelectionPaths();
        if (aPaths == null) {
            return new WsTreeNode[0];
        }
        WsTreeNode[] aNodes = new WsTreeNode[aPaths.length];
        for (int iPath = 0; iPath < aPaths.length; ++iPath) {
            aNodes[iPath] = (WsTreeNode)aPaths[iPath].getLastPathComponent();
        }
        return aNodes;
    }

    public void showPopupMenu(MouseEvent e) {
        if (this.m_bPopupMenuEnabled && this.m_lsnrPopupMenuRequest != null) {
            this.m_lsnrPopupMenuRequest.popupMenuRequested(e);
        }
    }

    protected void addPopupMenuItems(JPopupMenu mnuPopup) {
        if (this.isEditable()) {
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.addSeparator();
            }
            mnuPopup.add(this.m_actRename);
            mnuPopup.add(this.m_actDelete);
        }
    }

    protected void createListeners() {
        this.setPopupMenuRequestListener(this.createDefaultPopupMenuRequestListener());
    }

    protected WsPopupMenuRequestListener createDefaultPopupMenuRequestListener() {
        return new cDefaultPopupMenuRequestListener();
    }

    public void updateActions() {
        boolean bDelete = true;
        WsTreeNode[] aNodes = this.getSelectedNodes();
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            if (aNodes[iNode].isDeleteable()) continue;
            bDelete = false;
            break;
        }
        boolean bRename = aNodes.length == 1 && aNodes[0].isRenameable();
        this.m_actDelete.setEnabled(this.isEditable() && bDelete);
        this.m_actRename.setEnabled(this.isEditable() && bRename);
    }

    protected void createActions() {
        this.m_actDelete = this.createDeleteAction();
        this.m_actRename = this.createRenameAction();
        this.m_actDefault = this.createDefaultAction();
        this.m_actShowPopupMenu = this.createShowPopupMenuAction();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_bActive = bActive;
        if (this.m_nodeActive != null) {
            this.m_nodeActive.updateWorkspaceUIComponents(bActive);
        }
        this.m_actDelete.setActive(bActive);
        this.m_actRename.setActive(bActive);
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createRenameAction() {
        return new cRenameAction();
    }

    protected AbstractAction createDefaultAction() {
        return new cDefaultAction();
    }

    protected AbstractAction createShowPopupMenuAction() {
        return new cShowPopupMenuAction();
    }

    protected class cDefaultPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cDefaultPopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            WsTreeNode nodeActive = WsTree.this.getActiveNode();
            if (nodeActive != null) {
                nodeActive.addPopupMenuItems(mnuPopup);
            }
            WsTree.this.addPopupMenuItems(mnuPopup);
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cDeleteAction() {
            super(bundle, "Tree.PopupMenu.Delete", true);
            this.setMenuSupportId("delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cRenameAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cRenameAction() {
            super(bundle, "Tree.PopupMenu.Rename");
            this.setMenuSupportId("rename");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cDefaultAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected cDefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTreeNode[] aNodes = WsTree.this.getSelectedNodes();
            if (aNodes.length == 1) {
                if (WsTree.this.isExpandActionEnabled()) {
                    TreePath path = WsTree.this.getSelectionPath();
                    if (WsTree.this.isExpanded(path)) {
                        WsTree.this.collapsePath(WsTree.this.getSelectionPath());
                    } else {
                        WsTree.this.expandPath(WsTree.this.getSelectionPath());
                    }
                }
                if (aNodes[0].isLeaf()) {
                    if (WsTree.this.m_actUserDefault != null) {
                        if (WsTree.this.m_actUserDefault.isEnabled()) {
                            WsTree.this.m_actUserDefault.actionPerformed(e);
                        }
                    } else if (WsTree.this.isDefaultActionEnabled()) {
                        aNodes[0].doDefaultAction();
                    }
                }
            }
        }
    }

    protected class cShowPopupMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Point pt = WsTree.this.getPathBounds(WsTree.this.getLeadSelectionPath()).getLocation();
            MouseEvent me = new MouseEvent((Component)e.getSource(), 501, 0L, 0, pt.x, pt.y, 1, true);
            WsTree.this.showPopupMenu(me);
        }
    }
}

