/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsButtonsLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class WsTipOfDayDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    public static final String ShowProperty = "TipOfDayDialog.show";
    protected static final String TipProperty = "TipOfDayDialog.tip";
    private static WsTipOfDayDialog s_dlgTipOfDay;
    protected JButton m_btnNextTip;
    private static WAdminResource m_bundle;
    private static WAdminResource s_bundleTips;

    public static void setTipsBundle(WAdminResource bundleTips) {
        s_bundleTips = bundleTips;
    }

    public static void showTipOfDayDialog(boolean bIgnoreSetting) {
        if (s_dlgTipOfDay != null) {
            s_dlgTipOfDay.showNextTip();
        } else {
            WorkspaceFile AppDefs;
            if (!bIgnoreSetting && !(AppDefs = Workspace.getWorkspace().getAppDefaultsFile()).getPropertyBoolean(ShowProperty, true)) {
                return;
            }
            s_dlgTipOfDay = new WsTipOfDayDialog();
            s_dlgTipOfDay.doShow(bIgnoreSetting);
        }
    }

    private WsTipOfDayDialog() {
        super((Frame)Workspace.getWorkspace(), m_bundle.getString("WsTipOfDayDialog.Title.txt"));
        this.setResizable(true);
    }

    public WsTipOfDayDialog(JFrame frmOwner, WAdminResource bundleTips) {
        super((Frame)Workspace.getWorkspace(), m_bundle.getString("WsTipOfDayDialog.Title.txt"));
        s_bundleTips = bundleTips;
        this.setResizable(true);
    }

    public void doShow(boolean bIgnoreSetting) {
        WorkspaceFile AppDefs;
        if (!bIgnoreSetting && !(AppDefs = Workspace.getWorkspace().getAppDefaultsFile()).getPropertyBoolean(ShowProperty, true)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.show();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WsTipOfDayDialog.this.show();
                }
            });
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_btnNextTip = new JButton(m_bundle.getString("WsTipOfDayDialog.NextTip.txt"));
        this.m_btnNextTip.setMnemonic(m_bundle.getString("WsTipOfDayDialog.NextTip.mnem").charAt(0));
        this.m_btnNextTip.addActionListener(this);
        this.setMainPanel(new cMainPanel());
    }

    @Override
    protected void updateButtonsPanel() {
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new WsButtonsLayout());
        this.m_pnlButtons.add(this.m_btnNextTip);
        this.m_pnlButtons.add(this.m_btnOk);
        ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnOk);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_btnNextTip) {
            this.showNextTip();
        } else {
            super.actionPerformed(e);
        }
    }

    public void showNextTip() {
        try {
            this.m_pnlMain.doDataExchange(false);
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        s_dlgTipOfDay = null;
    }

    static {
        m_bundle = WAdminResource.getBundle(WsTipOfDayDialog.class);
    }

    protected class cMainPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        protected JLabel m_lblImage;
        protected JCheckBox m_ckbDisable;
        protected WATextArea m_txtTip;
        protected JLabel m_lblTitle;

        public cMainPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        protected void initialize() {
            this.m_lblImage = new JLabel(s_bundleTips.getImageIcon("TipOfDayDialog.image"));
            this.m_lblTitle = new JLabel();
            this.m_ckbDisable = new JCheckBox(m_bundle.getString("WsTipOfDayDialog.DisableTips.txt"));
            this.m_txtTip = new WATextArea(10, 40);
            this.m_ckbDisable.setMnemonic(m_bundle.getString("WsTipOfDayDialog.DisableTips.mnem").charAt(0));
            this.m_txtTip.setBehavior(1);
            this.m_txtTip.setLineWrap(true);
            this.m_txtTip.setWrapStyleWord(true);
            this.m_txtTip.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            Font fntLabel = this.m_lblTitle.getFont();
            Font fntTitle = fntLabel.deriveFont(0, (float)((double)fntLabel.getSize() * 1.5));
            this.m_lblTitle.setFont(fntTitle);
        }

        @Override
        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_lblImage, new GridBagConstraints(1, 1, 1, 2, 0.5, 1.0, 11, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.m_lblTitle, new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 11, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.m_txtTip, new GridBagConstraints(2, 2, 1, 1, 0.5, 1.0, 11, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.m_ckbDisable, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }

        @Override
        public boolean validateData() {
            return true;
        }

        @Override
        public boolean doDataExchange(boolean bExchangeToModel) throws MdException, RemoteException {
            WorkspaceFile AppDefs = Workspace.getWorkspace().getAppDefaultsFile();
            if (bExchangeToModel) {
                AppDefs.setPropertyBoolean(WsTipOfDayDialog.ShowProperty, !this.m_ckbDisable.isSelected());
            } else {
                int iTip = AppDefs.getPropertyInt(WsTipOfDayDialog.TipProperty, 1);
                String sTip = s_bundleTips.getRawString("TipOfDayDialog.Tip" + iTip + ".txt");
                if (sTip == null) {
                    iTip = 1;
                    sTip = s_bundleTips.getString("TipOfDayDialog.Tip" + iTip + ".txt");
                }
                String sTitle = s_bundleTips.getString("TipOfDayDialog.Title" + iTip + ".txt");
                AppDefs.setPropertyInt(WsTipOfDayDialog.TipProperty, iTip + 1);
                this.m_txtTip.setText(sTip);
                this.m_lblTitle.setText(sTitle);
            }
            return true;
        }
    }
}

