/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableRowModelListener;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.workspace.DNDObject;
import com.sas.workspace.WsDefaultObjectListModel;
import com.sas.workspace.WsDefaultObjectsSelectionModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsObjectListModel;
import com.sas.workspace.WsObjectListModelEvent;
import com.sas.workspace.WsObjectListModelListener;
import com.sas.workspace.WsObjectSelectionEvent;
import com.sas.workspace.WsObjectSelectionListener;
import com.sas.workspace.WsObjectsSelectionModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.table.JTableHeader;
import javax.swing.undo.UndoManager;

public class WsTableMappingsPanel
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected static final int FEATHER_LENGTH = 6;
    protected static final int FEATHER_HEIGHT = 3;
    protected static final int ARROWSHAFT_LENGTH = 5;
    protected static final int ARROWHEAD_HEIGHT = 7;
    protected static final int ARROWHEAD_LENGTH = 4;
    protected WsTable m_tblSource;
    protected WsTable m_tblTarget;
    protected UndoManager m_mgrUndo;
    protected Color m_clrLines;
    protected Color m_clrSelectedLines;
    protected int m_cxFeather = 6;
    protected int m_cyFeather = 3;
    protected int m_cxArrowShaft = 5;
    protected int m_cxArrowHead = 4;
    protected int m_cyArrowHead = 7;
    protected boolean m_bAutoSelect;
    protected boolean m_bDraggingFromSourceTableEnabled;
    protected boolean m_bDraggingFromTargetTableEnabled;
    protected WsPopupMenuRequestListener m_lsnrPopupMenuRequest;
    protected boolean m_bDragging;
    protected boolean m_bEraseRubberbandLines;
    protected boolean m_bNeedToLayoutMappings;
    protected boolean m_bIgnoreSelectionEvents;
    protected WsObjectListModel m_mdlMappings;
    protected WsObjectListModel m_mdlLines;
    protected WsObjectsSelectionModel m_mdlSelection;
    protected WsObjectListModelListener m_lsnrMappingsModel;
    protected WsObjectListModelListener m_lsnrLinesModel;
    protected WsObjectSelectionListener m_lsnrMappingSelection;
    protected ListSelectionListener m_lsnrTableSelection;
    protected AdjustmentListener m_lsnrScrollAdjustment;
    protected TableModelListener m_lsnrTableModel;
    protected cTableRowModelListener m_lsnrTableRowModel;
    protected MouseListener m_lsnrPanelMouse;
    protected DropTargetListener m_lsnrPanelDropTarget;
    protected DragGestureListener m_lsnrDragGesture;
    protected DragSourceListener m_lsnrDragSource;
    protected DropTargetListener m_lsnrDropTarget;
    private FocusListener m_lsnrPanelFocus;
    protected WsTable m_tblDragSource;
    protected WsTable m_tblDragTarget;
    protected boolean m_bDragFromSourceToTarget;

    public WsTableMappingsPanel() {
        this(null, null);
    }

    public WsTableMappingsPanel(WsTable tblSource, WsTable tblTarget) {
        this.initialize();
        this.setSourceTable(tblSource);
        this.setTargetTable(tblTarget);
    }

    protected void initialize() {
        Color clr;
        this.setBackground(UIManager.getColor("control"));
        this.m_clrLines = UIManager.getColor("controlText");
        this.m_clrSelectedLines = UIManager.getColor("textHighlight");
        float[] hsbLines = Color.RGBtoHSB(this.m_clrLines.getRed(), this.m_clrLines.getGreen(), this.m_clrLines.getBlue(), null);
        float[] hsbSelectedLines = Color.RGBtoHSB(this.m_clrSelectedLines.getRed(), this.m_clrSelectedLines.getGreen(), this.m_clrSelectedLines.getBlue(), null);
        while ((double)Math.abs(hsbLines[2] - hsbSelectedLines[2]) < 0.6 && !(clr = this.m_clrSelectedLines.brighter()).equals(this.m_clrSelectedLines)) {
            this.m_clrSelectedLines = clr;
            Color.RGBtoHSB(this.m_clrSelectedLines.getRed(), this.m_clrSelectedLines.getGreen(), this.m_clrSelectedLines.getBlue(), hsbSelectedLines);
        }
        this.setPreferredSize(new Dimension(100, 200));
        this.setFocusable(true);
        this.m_bAutoSelect = true;
        this.setDraggingFromSourceTableEnabled(true);
        this.setDraggingFromTargetTableEnabled(true);
        this.createListeners();
        this.installListeners();
        this.createModels();
        new DropTarget(this, 2, this.m_lsnrPanelDropTarget, false);
    }

    protected void createModels() {
        this.setLinesModel(this.createLinesModel());
        this.setMappingsModel(this.createMappingsModel());
        this.setSelectionModel(this.createSelectionModel());
    }

    protected void setLinesModel(WsObjectListModel mdlLines) {
        this.m_mdlLines = mdlLines;
        this.m_mdlLines.addObjectListModelListener(this.m_lsnrLinesModel);
    }

    protected void installTableListeners(WsTable tbl) {
        tbl.getModel().addTableModelListener(this.m_lsnrTableModel);
        tbl.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)tbl.getRowModel();
        mdlRows.addRowModelListener(this.m_lsnrTableRowModel);
        mdlRows.addRowModelListener(this.m_lsnrTableRowModel);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)tbl), 2, this.m_lsnrDragGesture);
        this.createTableDropTarget(tbl);
        tbl.setMouseBlockSelectionEnabled(false);
        JScrollPane scr = tbl.getScrollPane();
        if (scr != null) {
            scr.getVerticalScrollBar().addAdjustmentListener(this.m_lsnrScrollAdjustment);
        }
    }

    protected void uninstallTableListeners(TableView tbl) {
        JScrollPane scr = tbl.getScrollPane();
        if (scr != null) {
            scr.getVerticalScrollBar().removeAdjustmentListener(this.m_lsnrScrollAdjustment);
        }
        tbl.getModel().removeTableModelListener(this.m_lsnrTableModel);
        tbl.getSelectionModel().removeListSelectionListener(this.m_lsnrTableSelection);
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)tbl.getRowModel();
        mdlRows.removeRowModelListener(this.m_lsnrTableRowModel);
        mdlRows.removeRowModelListener(this.m_lsnrTableRowModel);
    }

    public void setSourceTable(WsTable tblSource) {
        if (this.m_tblSource != null) {
            this.uninstallTableListeners(this.m_tblSource);
        }
        this.m_tblSource = tblSource;
        if (this.m_tblSource != null) {
            this.installTableListeners(this.m_tblSource);
        }
    }

    public TableView getSourceTable() {
        return this.m_tblSource;
    }

    public void setTargetTable(WsTable tblTarget) {
        if (this.m_tblTarget != null) {
            this.uninstallTableListeners(this.m_tblTarget);
        }
        this.m_tblTarget = tblTarget;
        if (this.m_tblTarget != null) {
            this.installTableListeners(this.m_tblTarget);
        }
    }

    public TableView getTargetTable() {
        return this.m_tblTarget;
    }

    public void setLinesColor(Color clrLines) {
        if (clrLines != this.m_clrLines) {
            this.m_clrLines = clrLines;
            this.repaint();
        }
    }

    public Color getLinesColor() {
        return this.m_clrLines;
    }

    public void setSelectedLinesColor(Color clrSelectedLines) {
        if (clrSelectedLines != this.m_clrSelectedLines) {
            this.m_clrSelectedLines = clrSelectedLines;
            this.repaint();
        }
    }

    public Color getSelectedLinesColor() {
        return this.m_clrSelectedLines;
    }

    public void setArrowHeadHeight(int cyArrowHead) {
        if (cyArrowHead != this.m_cyArrowHead) {
            this.m_cyArrowHead = cyArrowHead;
            this.layoutMappings();
            this.repaint();
        }
    }

    public int getArrowHeadHeight() {
        return this.m_cyArrowHead;
    }

    public void setArrowHeadLength(int cxArrowHead) {
        if (cxArrowHead != this.m_cxArrowHead) {
            this.m_cyArrowHead = cxArrowHead;
            this.layoutMappings();
            this.repaint();
        }
    }

    public int getArrowHeadLength() {
        return this.m_cyArrowHead;
    }

    public void setArrowShaftLength(int cxArrowShaft) {
        if (cxArrowShaft != this.m_cxArrowShaft) {
            this.m_cxArrowShaft = cxArrowShaft;
            this.layoutMappings();
            this.repaint();
        }
    }

    public int getArrowShaftLength() {
        return this.m_cxArrowShaft;
    }

    public void setFeatherHeight(int cyFeather) {
        if (cyFeather != this.m_cyFeather) {
            this.m_cyFeather = cyFeather;
            this.layoutMappings();
            this.repaint();
        }
    }

    public int getFeatherHeight() {
        return this.m_cyFeather;
    }

    public void setFeatherLength(int cxFeather) {
        if (cxFeather != this.m_cxFeather) {
            this.m_cyFeather = cxFeather;
            this.layoutMappings();
            this.repaint();
        }
    }

    public int getFeatherLength() {
        return this.m_cyFeather;
    }

    public boolean isAutoSelectEnabled() {
        return this.m_bAutoSelect;
    }

    public void setAutoSelectEnabled(boolean bAutoSelect) {
        this.m_bAutoSelect = bAutoSelect;
    }

    public boolean isDragging() {
        return this.m_bDragging;
    }

    public WsObjectListModel getMappingsModel() {
        return this.m_mdlMappings;
    }

    public void setMappingsModel(WsObjectListModel mdlMappings) {
        if (this.m_mdlMappings != null) {
            this.m_mdlMappings.removeObjectListModelListener(this.m_lsnrMappingsModel);
        }
        this.m_mdlMappings = mdlMappings;
        if (this.m_mdlMappings != null) {
            this.m_mdlMappings.addObjectListModelListener(this.m_lsnrMappingsModel);
            this.layoutMappings();
        }
        this.repaint();
    }

    public WsObjectsSelectionModel getSelectionModel() {
        return this.m_mdlSelection;
    }

    public void setSelectionModel(WsObjectsSelectionModel mdlSelection) {
        if (this.m_mdlSelection != null) {
            this.m_mdlSelection.removeObjectSelectionListener(this.m_lsnrMappingSelection);
        }
        this.m_mdlSelection = mdlSelection;
        this.repaint();
        if (this.m_mdlSelection != null) {
            this.m_mdlSelection.addObjectSelectionListener(this.m_lsnrMappingSelection);
        }
    }

    public void setDraggingFromTargetTableEnabled(boolean bDraggingFromTargetTableEnabled) {
        this.m_bDraggingFromTargetTableEnabled = bDraggingFromTargetTableEnabled;
    }

    public boolean isDraggingFromTargetTableEnabled() {
        return this.m_bDraggingFromTargetTableEnabled;
    }

    public void setDraggingFromSourceTableEnabled(boolean bDraggingFromSourceTableEnabled) {
        this.m_bDraggingFromSourceTableEnabled = bDraggingFromSourceTableEnabled;
    }

    public boolean isDraggingFromSourceTableEnabled() {
        return this.m_bDraggingFromSourceTableEnabled;
    }

    public void addMapping(int iSource, int iTarget) {
        this.addMapping(new WsMapping(iSource, iTarget));
    }

    public void addMapping(int iSource, int iTarget, Object oData) {
        this.addMapping(new WsMapping(iSource, iTarget, oData));
    }

    public void addMapping(WsMapping mapping) {
        this.m_mdlMappings.add(mapping);
    }

    public void addMappings(List lMappings) {
        int nMappings = lMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            this.m_mdlMappings.add(lMappings.get(iMapping));
        }
    }

    public boolean mappingExists(int iSource, int iTarget) {
        return this.mappingExists(new WsMapping(iSource, iTarget));
    }

    public boolean mappingExists(WsMapping testee) {
        return this.getRealMapping(testee) != null;
    }

    public WsMapping getRealMapping(int iSource, int iTarget) {
        return this.getRealMapping(new WsMapping(iSource, iTarget));
    }

    public WsMapping getRealMapping(WsMapping testee) {
        int nMappings = this.m_mdlMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping tester = (WsMapping)this.m_mdlMappings.get(iMapping);
            if (!tester.equals(testee)) continue;
            return tester;
        }
        return null;
    }

    public int getMappingsCount() {
        if (this.m_mdlMappings == null) {
            return 0;
        }
        return this.m_mdlMappings.size();
    }

    public List getMappings() {
        if (this.m_mdlMappings == null) {
            return new ArrayList();
        }
        int nMappings = this.m_mdlMappings.size();
        ArrayList<Object> lMappings = new ArrayList<Object>(nMappings);
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            lMappings.add(this.m_mdlMappings.get(iMapping));
        }
        return lMappings;
    }

    public void removeAllMappingsForRow(boolean bSource, int iRow) {
        int nMappings = this.m_mdlMappings.size();
        for (int iMapping = nMappings - 1; iMapping >= 0; --iMapping) {
            WsMapping mapping = (WsMapping)this.m_mdlMappings.get(iMapping);
            if (mapping.getValue(bSource) != iRow) continue;
            this.m_mdlMappings.remove(iMapping);
        }
    }

    public void removeMapping(int iSource, int iTarget) {
        this.removeMapping(new WsMapping(iSource, iTarget));
    }

    public void removeMapping(WsMapping mapping) {
        this.m_mdlMappings.remove(this.getRealMapping(mapping));
    }

    public void removeMappings(List lMappings) {
        int nMappings = lMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            this.m_mdlMappings.remove(this.getRealMapping((WsMapping)lMappings.get(iMapping)));
        }
    }

    public void removeAllMappings() {
        this.m_mdlMappings.removeAll();
        this.m_mdlSelection.deselectAllObjects();
    }

    public List findMappingsForRow(int iRow, boolean bSource) {
        ArrayList<WsMapping> lMappings = new ArrayList<WsMapping>();
        int nMappings = this.m_mdlMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)this.m_mdlMappings.get(iMapping);
            if (mapping.getValue(bSource) != iRow) continue;
            lMappings.add(mapping);
        }
        return lMappings;
    }

    public boolean isMappingSelected(int iSource, int iTarget) {
        return this.isMappingSelected(new WsMapping(iSource, iTarget));
    }

    public boolean isMappingSelected(WsMapping mapping) {
        if (this.m_mdlSelection == null) {
            return false;
        }
        WsMapping real = this.getRealMapping(mapping);
        if (real == null) {
            return false;
        }
        return this.m_mdlSelection.isObjectSelected(real);
    }

    public void selectMapping(int iSource, int iTarget) {
        this.selectMapping(new WsMapping(iSource, iTarget));
    }

    public void selectMapping(WsMapping mapping) {
        WsMapping real = this.getRealMapping(mapping);
        if (real != null) {
            this.m_mdlSelection.selectObject(real);
        }
    }

    public void selectAllMappings() {
        this.deselectAllMappings();
        int nMappings = this.m_mdlMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)this.m_mdlMappings.get(iMapping);
            if (!mapping.isVisible()) continue;
            this.m_mdlSelection.selectObject(mapping);
        }
    }

    public List getSelectedMappings() {
        if (this.m_mdlSelection == null) {
            return new ArrayList();
        }
        return this.m_mdlSelection.getSelectedObjects();
    }

    public void deselectMapping(int iSource, int iTarget) {
        this.deselectMapping(new WsMapping(iSource, iTarget));
    }

    public void deselectMapping(WsMapping mapping) {
        if (this.m_mdlSelection == null) {
            return;
        }
        WsMapping real = this.getRealMapping(mapping);
        if (real != null) {
            this.m_mdlSelection.deselectObject(real);
        }
    }

    public void deselectAllMappings() {
        if (this.m_mdlSelection == null) {
            return;
        }
        this.m_mdlSelection.deselectAllObjects();
    }

    public void autoSelectFromMappings() {
        if (!this.isAutoSelectEnabled()) {
            return;
        }
        if (this.m_bIgnoreSelectionEvents) {
            return;
        }
        this.m_bIgnoreSelectionEvents = true;
        this.m_tblSource.clearSelection();
        this.m_tblTarget.clearSelection();
        ArrayList lMappings = this.m_mdlSelection.getSelectedObjects();
        int nMappings = lMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)lMappings.get(iMapping);
            int iSourceRow = this.m_tblSource.convertRowIndexToView(mapping.getSource());
            int iTargetRow = this.m_tblTarget.convertRowIndexToView(mapping.getTarget());
            this.m_tblSource.addRowToSelection(iSourceRow);
            this.m_tblTarget.addRowToSelection(iTargetRow);
        }
        this.m_bIgnoreSelectionEvents = false;
    }

    public void autoSelectFromTable(boolean bSource) {
        WsTable tblTarget;
        WsTable tblSource;
        if (!this.m_bAutoSelect) {
            return;
        }
        if (this.m_bIgnoreSelectionEvents) {
            return;
        }
        this.m_bIgnoreSelectionEvents = true;
        if (bSource) {
            tblSource = this.m_tblSource;
            tblTarget = this.m_tblTarget;
        } else {
            tblSource = this.m_tblTarget;
            tblTarget = this.m_tblSource;
        }
        this.m_mdlSelection.deselectAllObjects();
        int[] aSelectedRows = tblSource.getSelectedRowsFromSelectedCells();
        int nSelectedRows = aSelectedRows.length;
        for (int iSelectedRow = 0; iSelectedRow < nSelectedRows; ++iSelectedRow) {
            List lMappings = this.findMappingsForRow(tblSource.convertRowIndexToModel(aSelectedRows[iSelectedRow]), bSource);
            int nMappings = lMappings.size();
            for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
                WsMapping mapping = (WsMapping)lMappings.get(iMapping);
                int iEventTargetRow = tblTarget.convertRowIndexToView(mapping.getValue(!bSource));
                if (!tblTarget.isCellSelectedInRow(iEventTargetRow)) continue;
                this.m_mdlSelection.selectObject(mapping);
            }
        }
        this.m_bIgnoreSelectionEvents = false;
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getPopupMenuRequestListener() {
        return this.m_lsnrPopupMenuRequest;
    }

    protected void firePopupMenuRequestEvent(MouseEvent e) {
        if (this.m_lsnrPopupMenuRequest != null) {
            this.m_lsnrPopupMenuRequest.popupMenuRequested(e);
        }
    }

    protected void selectMappings(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        cMappingLine line = this.hitTestLines(e.getPoint());
        if (this.m_mdlSelection.getSelectionMode() == 0) {
            if (line == null) {
                this.m_mdlSelection.deselectAllObjects();
            } else if (!this.m_mdlSelection.isObjectSelected(line.getMapping())) {
                this.m_mdlSelection.selectObject(line.getMapping());
            }
        } else if ((e.getModifiers() & 2) != 0) {
            if (line != null) {
                if (!this.m_mdlSelection.isObjectSelected(line.getMapping())) {
                    this.m_mdlSelection.selectObject(line.getMapping());
                } else {
                    this.m_mdlSelection.deselectObject(line.getMapping());
                }
            }
        } else if (line != null) {
            if (!this.m_mdlSelection.isObjectSelected(line.getMapping()) || this.m_mdlSelection.getSelectedObjects().size() != 1) {
                this.m_mdlSelection.deselectAllObjects();
                this.m_mdlSelection.selectObject(line.getMapping());
            }
        } else {
            this.m_mdlSelection.deselectAllObjects();
        }
    }

    protected cMappingLine hitTestLines(Point pt) {
        int nLines = this.m_mdlLines.size();
        for (int iLine = 0; iLine < nLines; ++iLine) {
            cMappingLine line = (cMappingLine)this.m_mdlLines.get(iLine);
            if (!line.hitTest(pt)) continue;
            return line;
        }
        return null;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.m_bNeedToLayoutMappings = true;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.m_bNeedToLayoutMappings = true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.m_bNeedToLayoutMappings = true;
    }

    protected void layoutMappings() {
        if (this.m_tblSource == null || this.m_tblTarget == null) {
            return;
        }
        int[] ysSource = this.calculateYMinMax(this.m_tblSource);
        int[] ysTarget = this.calculateYMinMax(this.m_tblTarget);
        int nLines = this.m_mdlLines.size();
        for (int iLine = 0; iLine < nLines; ++iLine) {
            cMappingLine line = (cMappingLine)this.m_mdlLines.get(iLine);
            line.layout(ysSource[0], ysSource[1], ysTarget[0], ysTarget[1]);
        }
        this.m_bNeedToLayoutMappings = false;
    }

    protected void layoutMapping(cMappingLine line) {
        int[] ysSource = this.calculateYMinMax(this.m_tblSource);
        int[] ysTarget = this.calculateYMinMax(this.m_tblTarget);
        line.layout(ysSource[0], ysSource[1], ysTarget[0], ysTarget[1]);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.m_bEraseRubberbandLines = false;
        if (this.isFocusOwner()) {
            g.setColor(this.m_clrSelectedLines);
            BasicGraphicsUtils.drawDashedRect(g, 1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
        g.setColor(this.m_clrLines);
        if (this.m_bNeedToLayoutMappings) {
            this.layoutMappings();
            this.m_bNeedToLayoutMappings = false;
        }
        g.setColor(this.m_clrLines);
        int nLines = this.m_mdlLines.size();
        for (int iLine = 0; iLine < nLines; ++iLine) {
            cMappingLine mappingInfo = (cMappingLine)this.m_mdlLines.get(iLine);
            if (this.m_mdlSelection.isObjectSelected(mappingInfo.getMapping())) continue;
            mappingInfo.paint(g);
        }
        if (this.m_mdlSelection != null) {
            g.setColor(this.m_clrSelectedLines);
            ArrayList lSelectedMappings = this.m_mdlSelection.getSelectedObjects();
            int nSelectedMappings = lSelectedMappings.size();
            for (int iSelectedMapping = 0; iSelectedMapping < nSelectedMappings; ++iSelectedMapping) {
                WsMapping mapping = (WsMapping)lSelectedMappings.get(iSelectedMapping);
                int iMapping = this.m_mdlMappings.indexOf(mapping);
                if (iMapping == -1) continue;
                ((cMappingLine)this.m_mdlLines.get(iMapping)).paint(g);
            }
        }
    }

    protected int[] calculateYMinMax(WsTable tbl) {
        int[] ys = new int[2];
        JScrollPane scr = tbl.getScrollPane();
        JTableHeader hdr = tbl.getTableHeader();
        ys[0] = hdr != null ? hdr.getHeight() : this.m_cyArrowHead / 2;
        if (scr != null) {
            JScrollBar sbr = scr.getHorizontalScrollBar();
            int off = sbr.isVisible() ? sbr.getHeight() : this.m_cyArrowHead / 2;
            ys[1] = scr.getHeight() - scr.getInsets().bottom - off - 1;
        } else {
            ys[1] = tbl.getHeight() - this.m_cyArrowHead / 2;
        }
        return ys;
    }

    protected int calculateRowY(WsTable tbl, int iRow, int yMin, int yMax) {
        int iViewRow = tbl.convertRowIndexToView(iRow);
        Rectangle rect = tbl.getCellRect(iViewRow, 0, false);
        Point pt = new Point(0, rect.y);
        SwingUtilities.convertPointToScreen(pt, (Component)((Object)tbl));
        SwingUtilities.convertPointFromScreen(pt, this);
        int y = pt.y + rect.height / 2;
        return Math.min(Math.max(y, yMin), yMax);
    }

    protected WsObjectListModel createMappingsModel() {
        return new WsDefaultObjectListModel();
    }

    protected WsObjectListModel createLinesModel() {
        return new WsDefaultObjectListModel();
    }

    protected WsObjectsSelectionModel createSelectionModel() {
        WsDefaultObjectsSelectionModel mdlSelection = new WsDefaultObjectsSelectionModel();
        mdlSelection.setSelectionMode(1);
        return mdlSelection;
    }

    protected cMappingLine createMappingLine(WsMapping mapping) {
        return new cMappingLine(mapping);
    }

    protected void createListeners() {
        this.m_lsnrTableModel = this.createTableModelListener();
        this.m_lsnrTableRowModel = this.createTableRowModelListener();
        this.m_lsnrMappingsModel = this.createMappingsModelListener();
        this.m_lsnrLinesModel = this.createLinesModelListener();
        this.m_lsnrTableSelection = this.createTableSelectionListener();
        this.m_lsnrMappingSelection = this.createMappingSelectionListener();
        this.m_lsnrScrollAdjustment = this.createScrollAdjustmentListener();
        this.m_lsnrPanelMouse = this.createPanelMouseListener();
        this.m_lsnrPanelDropTarget = this.createPanelDropTargetListener();
        this.m_lsnrDragGesture = this.createTableDragGestureListener();
        this.m_lsnrDragSource = this.createTableDragSourceListener();
        this.m_lsnrDropTarget = this.createTableDropTargetListener();
        this.m_lsnrPanelFocus = this.createPanelFocusListener();
    }

    protected void installListeners() {
        this.addMouseListener(this.m_lsnrPanelMouse);
        this.addFocusListener(this.m_lsnrPanelFocus);
    }

    protected AdjustmentListener createScrollAdjustmentListener() {
        return new cScrollAdjustmentListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected cTableRowModelListener createTableRowModelListener() {
        return new cTableRowModelListener();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsObjectListModelListener createMappingsModelListener() {
        return new WsMappingsModelListener();
    }

    protected WsObjectListModelListener createLinesModelListener() {
        return new cLinesModelListener();
    }

    protected WsObjectSelectionListener createMappingSelectionListener() {
        return new WsMappingSelectionListener();
    }

    protected MouseListener createPanelMouseListener() {
        return new cPanelMouseListener();
    }

    protected DropTargetListener createPanelDropTargetListener() {
        return new cPanelDropTargetListener();
    }

    protected DragGestureListener createTableDragGestureListener() {
        return new cTableDragGestureListener();
    }

    protected DragSourceListener createTableDragSourceListener() {
        return new cTableDragSourceListener();
    }

    protected DropTargetListener createTableDropTargetListener() {
        return new cTableDropTargetListener();
    }

    protected FocusListener createPanelFocusListener() {
        return new PanelFocusListener();
    }

    protected void createTableDropTarget(WsTable tbl) {
        new DropTarget((Component)((Object)tbl), 2, this.m_lsnrDropTarget, false);
        new DropTarget((Component)tbl.getRowHeader(), 2, this.m_lsnrDropTarget, false);
    }

    protected Runnable createMappingsCreatorRunnable(List lMappings) {
        return new cMappingsCreatorRunnable(lMappings);
    }

    protected void onCreateMappings(List lMappings) {
        this.m_bDragging = false;
        this.addMappings(lMappings);
    }

    protected class cTableRowModelListener
    implements TableRowModelListener,
    WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        public void rowMoved(TableRowModelEvent e) {
            WsTableMappingsPanel.this.layoutMappings();
            WsTableMappingsPanel.this.repaint();
        }

        public void rowMarginChanged(ChangeEvent e) {
            WsTableMappingsPanel.this.layoutMappings();
            WsTableMappingsPanel.this.repaint();
        }

        public void rowSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void rowDragged(TableRowModelEvent e) {
        }

        @Override
        public void rowsHidden(WsTableRowModelEvent e) {
            boolean bSource = e.getSource() == WsTableMappingsPanel.this.m_tblSource.getRowModel();
            this.setMappingsVisible(e.getRows(), bSource, false);
        }

        @Override
        public void rowsShown(WsTableRowModelEvent e) {
            boolean bSource = e.getSource() == WsTableMappingsPanel.this.m_tblSource.getRowModel();
            this.setMappingsVisible(e.getRows(), bSource, true);
        }

        @Override
        public void rowsRemapped(ChangeEvent e) {
            WsTableMappingsPanel.this.layoutMappings();
            WsTableMappingsPanel.this.repaint();
        }

        protected void setMappingsVisible(int[] aRows, boolean bSource, boolean bVisible) {
            int nRows = aRows.length;
            for (int iRow = nRows - 1; iRow >= 0; --iRow) {
                List lMappings = WsTableMappingsPanel.this.findMappingsForRow(aRows[iRow], bSource);
                int nMappings = lMappings.size();
                for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
                    WsMapping map = (WsMapping)lMappings.get(iMapping);
                    map.setVisible(bVisible);
                    if (bVisible || !WsTableMappingsPanel.this.isMappingSelected(map)) continue;
                    WsTableMappingsPanel.this.deselectMapping(map);
                }
            }
            WsTableMappingsPanel.this.m_bNeedToLayoutMappings = true;
            WsTableMappingsPanel.this.repaint();
        }
    }

    protected class cMappingLine {
        protected WsMapping m_mapping;
        protected boolean m_bVisible;
        protected int[] m_xsFeather = new int[5];
        protected int[] m_ysFeather = new int[5];
        protected int[] m_xsArrow = new int[3];
        protected int[] m_ysArrow = new int[3];
        protected int[] m_ysShaft = new int[2];
        protected int[] m_xsShaft = new int[2];
        protected int[] m_xsConnector = new int[2];
        protected int[] m_ysConnector = new int[2];
        protected Polygon m_pgnHitTest = new Polygon();

        public cMappingLine(WsMapping mapping) {
            this.m_mapping = mapping;
            this.m_bVisible = true;
        }

        public WsMapping getMapping() {
            return this.m_mapping;
        }

        public void layout(int ySourceMin, int ySourceMax, int yTargetMin, int yTargetMax) {
            if (!this.m_mapping.isVisible()) {
                return;
            }
            int ySource = WsTableMappingsPanel.this.calculateRowY(WsTableMappingsPanel.this.m_tblSource, this.m_mapping.getSource(), ySourceMin, ySourceMax);
            int yTarget = WsTableMappingsPanel.this.calculateRowY(WsTableMappingsPanel.this.m_tblTarget, this.m_mapping.getTarget(), yTargetMin, yTargetMax);
            int xPanelTarget = WsTableMappingsPanel.this.getWidth() - 1;
            int cxArrowOff = WsTableMappingsPanel.this.m_cxArrowHead - 1;
            int cxShaftOff = WsTableMappingsPanel.this.m_cxArrowShaft - 1;
            int cxFeatherOff = WsTableMappingsPanel.this.m_cxFeather - 1;
            int cyFeatherOff = WsTableMappingsPanel.this.m_cyFeather / 2;
            int[] xs = this.m_xsFeather;
            int[] ys = this.m_ysFeather;
            xs[0] = 0;
            ys[0] = ySource - cyFeatherOff;
            xs[1] = cxFeatherOff - cyFeatherOff;
            ys[1] = ySource - cyFeatherOff;
            xs[2] = cxFeatherOff;
            ys[2] = ySource;
            xs[3] = cxFeatherOff - cyFeatherOff;
            ys[3] = ySource + cyFeatherOff;
            xs[4] = 0;
            ys[4] = ySource + cyFeatherOff;
            xs = this.m_xsArrow;
            ys = this.m_ysArrow;
            xs[0] = xPanelTarget;
            ys[0] = yTarget;
            xs[1] = xPanelTarget - cxArrowOff;
            ys[1] = yTarget - cxArrowOff;
            xs[2] = xPanelTarget - cxArrowOff;
            ys[2] = yTarget + cxArrowOff;
            xs = this.m_xsShaft;
            ys = this.m_ysShaft;
            xs[0] = xPanelTarget - WsTableMappingsPanel.this.m_cxArrowHead;
            ys[0] = yTarget;
            xs[1] = xPanelTarget - WsTableMappingsPanel.this.m_cxArrowHead - cxShaftOff;
            ys[1] = yTarget;
            xs = this.m_xsConnector;
            ys = this.m_ysConnector;
            xs[0] = this.m_xsFeather[2];
            ys[0] = this.m_ysFeather[2];
            xs[1] = this.m_xsShaft[1];
            ys[1] = this.m_ysShaft[1];
            xs = new int[8];
            ys = new int[8];
            xs[0] = this.m_xsFeather[0];
            ys[0] = this.m_ysFeather[0];
            xs[1] = this.m_xsFeather[2];
            ys[1] = this.m_ysFeather[1];
            xs[2] = this.m_xsShaft[1];
            ys[2] = this.m_ysArrow[1];
            xs[3] = this.m_xsArrow[0];
            ys[3] = this.m_ysArrow[1];
            xs[4] = this.m_xsArrow[0];
            ys[4] = this.m_ysArrow[2];
            xs[5] = this.m_xsShaft[1];
            ys[5] = this.m_ysArrow[2];
            xs[6] = this.m_xsFeather[2];
            ys[6] = this.m_ysFeather[3];
            xs[7] = this.m_xsFeather[4];
            ys[7] = this.m_ysFeather[4];
            this.m_pgnHitTest = new Polygon(xs, ys, 8);
        }

        public void paint(Graphics g) {
            if (!this.m_mapping.isVisible()) {
                return;
            }
            g.drawPolygon(this.m_xsFeather, this.m_ysFeather, 5);
            g.fillPolygon(this.m_xsFeather, this.m_ysFeather, 5);
            g.drawPolygon(this.m_xsArrow, this.m_ysArrow, 3);
            g.fillPolygon(this.m_xsArrow, this.m_ysArrow, 3);
            g.drawLine(this.m_xsShaft[0], this.m_ysShaft[0], this.m_xsShaft[1], this.m_ysShaft[1]);
            g.drawLine(this.m_xsConnector[0], this.m_ysConnector[0], this.m_xsConnector[1], this.m_ysConnector[1]);
        }

        public boolean hitTest(Point pt) {
            if (!this.m_mapping.isVisible()) {
                return false;
            }
            return this.m_pgnHitTest.contains(pt);
        }
    }

    protected class cScrollAdjustmentListener
    implements AdjustmentListener {
        protected cScrollAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            WsTableMappingsPanel.this.m_bNeedToLayoutMappings = true;
            WsTableMappingsPanel.this.repaint();
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int eType = e.getType();
            if (eType == -1 || eType == 1) {
                boolean bSource = e.getSource() == WsTableMappingsPanel.this.m_tblSource.getModel();
                int iFirstRow = e.getFirstRow();
                int iLastRow = e.getLastRow();
                int nRows = iLastRow - iFirstRow + 1;
                int nMappings = WsTableMappingsPanel.this.m_mdlMappings.size();
                for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
                    WsMapping map = (WsMapping)WsTableMappingsPanel.this.m_mdlMappings.get(iMapping);
                    int iRow = map.getValue(bSource);
                    if (eType == -1) {
                        if (iRow <= iLastRow) continue;
                        map.setValue(bSource, iRow - nRows);
                        continue;
                    }
                    if (iRow < iFirstRow) continue;
                    map.setValue(bSource, iRow + nRows);
                }
                WsTableMappingsPanel.this.m_bNeedToLayoutMappings = true;
                WsTableMappingsPanel.this.repaint();
            }
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WsTableMappingsPanel.this.autoSelectFromTable(e.getSource() == WsTableMappingsPanel.this.m_tblSource.getSelectionModel());
        }
    }

    protected class WsMappingsModelListener
    implements WsObjectListModelListener {
        protected WsMappingsModelListener() {
        }

        @Override
        public void objectAdded(WsObjectListModelEvent e) {
            cMappingLine line = WsTableMappingsPanel.this.createMappingLine((WsMapping)e.getObject());
            WsTableMappingsPanel.this.m_mdlLines.add(line);
        }

        @Override
        public void objectRemoved(WsObjectListModelEvent e) {
            WsMapping mapping = (WsMapping)e.getObject();
            if (WsTableMappingsPanel.this.m_mdlSelection.isObjectSelected(mapping)) {
                WsTableMappingsPanel.this.m_mdlSelection.deselectObject(mapping);
            }
            int nLines = WsTableMappingsPanel.this.m_mdlLines.size();
            for (int iLine = 0; iLine < nLines; ++iLine) {
                cMappingLine line = (cMappingLine)WsTableMappingsPanel.this.m_mdlLines.get(iLine);
                if (line.getMapping() != mapping) continue;
                WsTableMappingsPanel.this.m_mdlLines.remove(iLine);
                break;
            }
        }
    }

    protected class cLinesModelListener
    implements WsObjectListModelListener {
        protected cLinesModelListener() {
        }

        @Override
        public void objectAdded(WsObjectListModelEvent e) {
            WsTableMappingsPanel.this.layoutMapping((cMappingLine)e.getObject());
            WsTableMappingsPanel.this.repaint();
        }

        @Override
        public void objectRemoved(WsObjectListModelEvent e) {
            WsTableMappingsPanel.this.repaint();
        }
    }

    protected class WsMappingSelectionListener
    implements WsObjectSelectionListener {
        protected WsMappingSelectionListener() {
        }

        @Override
        public void objectChangedSelection(WsObjectSelectionEvent e) {
            WsTableMappingsPanel.this.repaint();
            WsTableMappingsPanel.this.autoSelectFromMappings();
        }
    }

    protected class cPanelMouseListener
    extends MouseAdapter {
        protected cPanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            WsTableMappingsPanel.this.requestFocusInWindow();
            WsTableMappingsPanel.this.selectMappings(e);
            if (e.isPopupTrigger()) {
                this.triggerPopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.triggerPopupMenu(e);
            }
        }

        public void triggerPopupMenu(MouseEvent e) {
            cMappingLine line = WsTableMappingsPanel.this.hitTestLines(e.getPoint());
            if (line != null && !WsTableMappingsPanel.this.m_mdlSelection.isObjectSelected(line.getMapping())) {
                WsTableMappingsPanel.this.m_mdlSelection.deselectAllObjects();
                WsTableMappingsPanel.this.m_mdlSelection.selectObject(line.getMapping());
            }
            WsTableMappingsPanel.this.firePopupMenuRequestEvent(e);
        }
    }

    protected class cPanelDropTargetListener
    implements DropTargetListener {
        protected Point[] m_aptStart;
        protected Point m_ptCurrent;

        protected cPanelDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            int[] ys = WsTableMappingsPanel.this.calculateYMinMax(WsTableMappingsPanel.this.m_tblDragSource);
            int[] aRows = WsTableMappingsPanel.this.m_tblDragSource.getSelectedRowsFromSelectedCells();
            WsTableMappingsPanel.this.m_tblDragSource.convertRowIndexesToModel(aRows);
            this.m_aptStart = new Point[aRows.length];
            int nRows = aRows.length;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int xStart = WsTableMappingsPanel.this.m_bDragFromSourceToTarget ? 0 : WsTableMappingsPanel.this.getWidth() - 1;
                int yStart = WsTableMappingsPanel.this.calculateRowY(WsTableMappingsPanel.this.m_tblDragSource, aRows[iRow], ys[0], ys[1]);
                this.m_aptStart[iRow] = new Point(xStart, yStart);
            }
            this.updateRubberbandLines(false, true, e.getLocation());
            e.acceptDrag(e.getSourceActions());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.updateRubberbandLines(true, false, null);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            this.updateRubberbandLines(true, true, e.getLocation());
            e.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            this.updateRubberbandLines(true, false, null);
            e.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateRubberbandLines(boolean bErase, boolean bDraw, Point ptNewCurrent) {
            if (!bDraw && !WsTableMappingsPanel.this.m_bEraseRubberbandLines) {
                return;
            }
            Graphics g = WsTableMappingsPanel.this.getGraphics();
            try {
                int iRow;
                g.setXORMode(WsTableMappingsPanel.this.getBackground());
                int nRows = this.m_aptStart.length;
                if (bErase && WsTableMappingsPanel.this.m_bEraseRubberbandLines) {
                    for (iRow = nRows - 1; iRow >= 0; --iRow) {
                        g.drawLine(this.m_aptStart[iRow].x, this.m_aptStart[iRow].y, this.m_ptCurrent.x, this.m_ptCurrent.y);
                    }
                }
                if (bDraw) {
                    this.m_ptCurrent = ptNewCurrent;
                    for (iRow = 0; iRow < nRows; ++iRow) {
                        g.drawLine(this.m_aptStart[iRow].x, this.m_aptStart[iRow].y, this.m_ptCurrent.x, this.m_ptCurrent.y);
                    }
                    WsTableMappingsPanel.this.m_bEraseRubberbandLines = true;
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    protected class cTableDragGestureListener
    implements DragGestureListener {
        protected cTableDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            WsTableMappingsPanel.this.m_tblDragSource = (WsTable)((Object)e.getComponent());
            if (WsTableMappingsPanel.this.m_tblDragSource.getSelectedRowsFromSelectedCells().length <= 0) {
                return;
            }
            if (WsTableMappingsPanel.this.m_tblDragSource.isEditing()) {
                return;
            }
            if (WsTableMappingsPanel.this.m_tblDragSource == WsTableMappingsPanel.this.m_tblSource) {
                if (!WsTableMappingsPanel.this.m_bDraggingFromSourceTableEnabled) {
                    return;
                }
                WsTableMappingsPanel.this.m_tblDragTarget = WsTableMappingsPanel.this.m_tblTarget;
                WsTableMappingsPanel.this.m_bDragFromSourceToTarget = true;
            } else {
                if (!WsTableMappingsPanel.this.m_bDraggingFromTargetTableEnabled) {
                    return;
                }
                WsTableMappingsPanel.this.m_tblDragTarget = WsTableMappingsPanel.this.m_tblSource;
                WsTableMappingsPanel.this.m_bDragFromSourceToTarget = false;
            }
            WsTableMappingsPanel.this.getDropTarget().setActive(true);
            WsTableMappingsPanel.this.m_tblDragTarget.getDropTarget().setActive(true);
            WsTableMappingsPanel.this.m_tblDragTarget.getRowHeader().getDropTarget().setActive(true);
            WsTableMappingsPanel.this.m_bDragging = true;
            e.getDragSource().startDrag(e, null, new DNDObject(), WsTableMappingsPanel.this.m_lsnrDragSource);
        }
    }

    protected class cTableDragSourceListener
    implements DragSourceListener {
        protected cTableDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            WsTableMappingsPanel.this.getDropTarget().setActive(false);
            WsTableMappingsPanel.this.m_tblDragTarget.getDropTarget().setActive(false);
            WsTableMappingsPanel.this.m_tblDragTarget.getRowHeader().getDropTarget().setActive(false);
            WsTableMappingsPanel.this.m_bDragging = false;
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    protected class cTableDropTargetListener
    implements DropTargetListener {
        protected int[] m_aSourceRows;
        protected int m_iTargetRow;
        protected List m_lMappings;
        protected boolean m_bFirstDragOver;

        protected cTableDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            this.m_aSourceRows = WsTableMappingsPanel.this.m_tblDragSource.getSelectedRowsFromSelectedCells();
            WsTableMappingsPanel.this.m_tblDragSource.convertRowIndexesToModel(this.m_aSourceRows);
            this.m_lMappings = new ArrayList(this.m_aSourceRows.length);
            this.m_iTargetRow = WsTableMappingsPanel.this.m_tblDragTarget.convertRowIndexToModel(WsTableMappingsPanel.this.m_tblDragTarget.rowAtPoint(e.getLocation()));
            this.createDragMappings();
            if (this.m_lMappings.size() == 0) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getSourceActions());
            }
            this.m_bFirstDragOver = true;
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.removeDragMappings();
            this.m_iTargetRow = -1;
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            WsUIUtilities.autoscrollForDragEvent(e);
            int iTargetRow = WsTableMappingsPanel.this.m_tblDragTarget.convertRowIndexToModel(WsTableMappingsPanel.this.m_tblDragTarget.rowAtPoint(e.getLocation()));
            if (iTargetRow != this.m_iTargetRow) {
                this.removeDragMappings();
                this.m_iTargetRow = iTargetRow;
                this.createDragMappings();
            }
            if (this.m_lMappings.size() == 0 && !this.m_bFirstDragOver) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getSourceActions());
                this.m_bFirstDragOver = false;
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            int iTargetRow = WsTableMappingsPanel.this.m_tblDragTarget.convertRowIndexToModel(WsTableMappingsPanel.this.m_tblDragTarget.rowAtPoint(e.getLocation()));
            if (iTargetRow != this.m_iTargetRow) {
                this.removeDragMappings();
                this.m_iTargetRow = iTargetRow;
                this.createDragMappings();
            }
            if (this.m_lMappings.size() == 0) {
                e.rejectDrop();
            } else {
                e.acceptDrop(e.getSourceActions());
                e.dropComplete(true);
                ArrayList<WsMapping> lMappings = new ArrayList<WsMapping>(this.m_lMappings.size());
                for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
                    WsMapping mapping = (WsMapping)this.m_lMappings.get(iMapping);
                    lMappings.add(new WsMapping(mapping.getSource(), mapping.getTarget()));
                }
                this.removeDragMappings();
                this.m_lMappings = null;
                SwingUtilities.invokeLater(WsTableMappingsPanel.this.createMappingsCreatorRunnable(lMappings));
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        protected void createDragMappings() {
            if (this.m_iTargetRow == -1) {
                return;
            }
            int nSourceRows = this.m_aSourceRows.length;
            for (int iSourceRow = 0; iSourceRow < nSourceRows; ++iSourceRow) {
                WsMapping mapping = WsTableMappingsPanel.this.m_bDragFromSourceToTarget ? new WsMapping(this.m_aSourceRows[iSourceRow], this.m_iTargetRow, true) : new WsMapping(this.m_iTargetRow, this.m_aSourceRows[iSourceRow], true);
                if (WsTableMappingsPanel.this.mappingExists(mapping)) continue;
                this.m_lMappings.add(mapping);
            }
            if (this.m_lMappings.size() > 0) {
                WsTableMappingsPanel.this.addMappings(this.m_lMappings);
            }
        }

        protected void removeDragMappings() {
            WsTableMappingsPanel.this.removeMappings(this.m_lMappings);
            this.m_lMappings.clear();
        }
    }

    private class PanelFocusListener
    implements FocusListener {
        private PanelFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent ev) {
            WsTableMappingsPanel.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent ev) {
            WsTableMappingsPanel.this.repaint();
        }
    }

    protected class cMappingsCreatorRunnable
    implements Runnable {
        protected List m_lMappings;

        public cMappingsCreatorRunnable(List lMappings) {
            this.m_lMappings = lMappings;
        }

        @Override
        public void run() {
            WsTableMappingsPanel.this.onCreateMappings(this.m_lMappings);
        }
    }
}

