/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import java.text.DecimalFormat;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WsIntegerTableColumn
extends WsAbstractTableColumn {
    private static WAdminResource bundle = WAdminResource.getBundle(WsIntegerTableColumn.class);
    protected int m_iDefault;
    protected int m_iMinimum = 0;
    protected int m_iMaximum = Integer.MAX_VALUE;
    private Integer m_iMissing;
    private boolean m_bAllowNegative;
    private DecimalFormat m_fmt;

    public WsIntegerTableColumn() {
        this(0);
    }

    public WsIntegerTableColumn(int iModelIndex) {
        this(iModelIndex, 75);
    }

    public WsIntegerTableColumn(int iModelIndex, int cxWidth) {
        this(iModelIndex, "", cxWidth);
    }

    public WsIntegerTableColumn(int iModelIndex, String sName, int cxWidth) {
        this(iModelIndex, sName, cxWidth, 0);
    }

    public WsIntegerTableColumn(int iModelIndex, String sName, int cxWidth, int iDefault) {
        this(iModelIndex, sName, cxWidth, iDefault, 0, Integer.MAX_VALUE);
    }

    public WsIntegerTableColumn(int iModelIndex, String sName, int cxWidth, int iDefault, int iMinimum, int iMaximum) {
        super(iModelIndex, sName, cxWidth);
        this.m_iDefault = iDefault;
        this.m_iMinimum = iMinimum;
        this.m_iMaximum = iMaximum;
        this.setColumnClass(Integer.class);
    }

    @Override
    public Object createDefaultValue() {
        return new Integer(this.m_iDefault);
    }

    @Override
    public TableCellEditor createCellEditor() {
        WAIntTextField txtNumber = new WAIntTextField(this.m_bAllowNegative);
        WsDefaultCellEditor edt = new WsDefaultCellEditor(txtNumber);
        edt.setMissingValue(this.m_iMissing);
        return edt;
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        WsDefaultTableCellRenderer rdr = new WsDefaultTableCellRenderer();
        rdr.setHorizontalAlignment(4);
        rdr.setMissingValue(this.m_iMissing);
        rdr.setFormat(this.m_fmt);
        return rdr;
    }

    @Override
    public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
        int iValue = (Integer)oValue;
        if (oValue.equals(this.m_iMissing)) {
            return true;
        }
        if (iValue < this.m_iMinimum) {
            String sMessage = bundle.formatString("WsIntegerTableColumn.TooSmallError.fmt", this.getName(), new Integer(this.m_iMinimum));
            MessageUtil.displayMessage(sMessage, 0);
            return false;
        }
        if (iValue > this.m_iMaximum) {
            String sMessage = bundle.formatString("WsIntegerTableColumn.TooLargeError.fmt", this.getName(), new Integer(this.m_iMaximum));
            MessageUtil.displayMessage(sMessage, 0);
            return false;
        }
        return true;
    }

    public void setDefaultValue(int iDefault) {
        this.m_iDefault = iDefault;
    }

    public int getDefaultValue() {
        return this.m_iDefault;
    }

    public void setMaximumValue(int iMaximum) {
        this.m_iMaximum = iMaximum;
    }

    public int getMaximumValue() {
        return this.m_iMaximum;
    }

    public void setMinimumValue(int iMinimum) {
        this.m_iMinimum = iMinimum;
    }

    public int getMinimumValue() {
        return this.m_iMinimum;
    }

    public void setMissingValue(Integer iMissing) {
        this.m_iMissing = iMissing;
    }

    public Integer getMissingValue() {
        return this.m_iMissing;
    }

    public void setAllowNegative(boolean bAllowNegative) {
        this.m_bAllowNegative = bAllowNegative;
    }

    public boolean isAllowNegative() {
        return this.m_bAllowNegative;
    }

    public void setFormat(DecimalFormat fmt) {
        this.m_fmt = fmt;
    }

    public DecimalFormat getFormat() {
        return this.m_fmt;
    }
}

