/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextField;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsForwardInputMap;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class WsDialogTableCellEditor
extends WsDefaultCellEditor {
    private static final long serialVersionUID = 1L;
    protected JTable m_tbl;
    protected int m_iRow;
    protected int m_iColumn;
    protected JPanel m_pnl;
    protected JButton m_btn = WsUIUtilities.createBrowseButton();
    protected WATextField m_txt;
    protected WsDialogTableCellEditorInterface m_dlg;
    protected boolean m_bStopEditingOnDialogClose;
    protected boolean m_bTextEditable = true;

    public WsDialogTableCellEditor() {
        this.m_btn.addActionListener(new cShowDialogAction());
        cBackTabAction actBackTab = new cBackTabAction();
        this.m_btn.getActionMap().put(actBackTab, actBackTab);
        this.m_btn.getInputMap().put(KeyStroke.getKeyStroke(9, 1), actBackTab);
        this.m_txt = new WATextField();
        this.initialize(this.m_txt, (WsDefaultCellEditor.cEditorDelegate)new cDelegate((JTextField)this.m_txt));
        cTabAction actTab = new cTabAction();
        this.m_txt.getActionMap().put(actTab, actTab);
        this.m_txt.getInputMap().put(KeyStroke.getKeyStroke(9, 0), actTab);
        this.m_pnl = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public void requestFocus() {
                if (WsDialogTableCellEditor.this.m_bTextEditable) {
                    WsDialogTableCellEditor.this.m_txt.requestFocus();
                } else {
                    WsDialogTableCellEditor.this.m_btn.requestFocus();
                }
            }
        };
        this.m_pnl.add((Component)this.m_txt, "Center");
        this.m_pnl.add((Component)this.m_btn, "East");
        WsForwardInputMap.install(this.m_pnl, this.m_txt);
        this.m_cmpEditor = this.m_pnl;
    }

    @Override
    public JComponent getComponent() {
        return this.m_txt;
    }

    public void setDialog(WsDialogTableCellEditorInterface dlg) {
        this.m_dlg = dlg;
    }

    public WsDialogTableCellEditorInterface getDialog() {
        return this.m_dlg;
    }

    public void setMaxCharacters(int nMaxCharacters) {
        this.m_txt.setMaxCharacters(nMaxCharacters);
    }

    public int getMaxCharacters() {
        return this.m_txt.getMaxCharacters();
    }

    public void setStopEditingOnDialogClose(boolean bStopEditingOnDialogClose) {
        this.m_bStopEditingOnDialogClose = bStopEditingOnDialogClose;
    }

    public boolean isStopEditingOnDialogClose() {
        return this.m_bStopEditingOnDialogClose;
    }

    public void setTextEditable(boolean bEditable) {
        this.m_bTextEditable = bEditable;
        this.m_txt.setEditable(bEditable);
    }

    public boolean isTextEditable() {
        return this.m_bTextEditable;
    }

    protected class cShowDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected cShowDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String sValue;
            if (WsDialogTableCellEditor.this.m_dlg != null && (sValue = WsDialogTableCellEditor.this.m_dlg.showDialog(WsDialogTableCellEditor.this.m_tbl, WsDialogTableCellEditor.this.m_iRow, WsDialogTableCellEditor.this.m_iColumn, WsDialogTableCellEditor.this.m_txt.getText())) != null) {
                WsDialogTableCellEditor.this.m_txt.setText(sValue);
            }
            if (WsDialogTableCellEditor.this.m_bStopEditingOnDialogClose) {
                WsDialogTableCellEditor.this.stopCellEditing();
            } else {
                WsDialogTableCellEditor.this.m_txt.requestFocus();
            }
        }
    }

    protected class cBackTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected cBackTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsDialogTableCellEditor.this.m_txt.requestFocus();
        }
    }

    protected class cDelegate
    extends WsDefaultCellEditor.cTextFieldDelegate {
        public cDelegate(JTextField txtEditor) {
            super(txtEditor);
        }

        @Override
        public void layout(JTable table, int iRow, int iColumn) {
            WsDialogTableCellEditor.this.m_tbl = table;
            WsDialogTableCellEditor.this.m_iRow = iRow;
            WsDialogTableCellEditor.this.m_iColumn = iColumn;
        }
    }

    protected class cTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected cTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsDialogTableCellEditor.this.m_btn.requestFocus();
        }
    }
}

