/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.models.DecoratableIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class WsDecoratableIcon
implements DecoratableIcon {
    private static final int MIN_HEIGHT = 16;
    private static final int MIN_WIDTH = 24;
    private Icon m_icon;
    private Icon m_nwDecoration;
    private Icon m_neDecoration;
    private Icon m_swDecoration;
    private Icon m_seDecoration;
    private int m_iIconHeight;
    private int m_iIconWidth;

    public WsDecoratableIcon() {
    }

    public WsDecoratableIcon(Icon icon) {
        this.setIcon(icon);
    }

    public void setIcon(Icon icon) {
        this.m_iIconHeight = Math.max(icon.getIconHeight(), 16);
        this.m_iIconWidth = Math.max(icon.getIconWidth(), 24);
        this.m_icon = icon;
    }

    @Override
    public void setNWDecoration(Icon nwDecoration) {
        this.validateDecoration(nwDecoration);
        this.m_nwDecoration = nwDecoration;
    }

    @Override
    public void setNEDecoration(Icon neDecoration) {
        this.validateDecoration(neDecoration);
        this.m_neDecoration = neDecoration;
    }

    @Override
    public void setSWDecoration(Icon swDecoration) {
        this.validateDecoration(swDecoration);
        this.m_swDecoration = swDecoration;
    }

    @Override
    public void setSEDecoration(Icon seDecoration) {
        this.validateDecoration(seDecoration);
        this.m_seDecoration = seDecoration;
    }

    private void validateDecoration(Icon decoration) {
        if (this.m_icon == null) {
            throw new IllegalStateException("Main icon must be set before adding decorations.");
        }
        if (decoration.getIconHeight() > this.m_iIconHeight / 2 || decoration.getIconWidth() > this.m_iIconWidth / 2) {
            throw new IllegalArgumentException("Decoration size must be less than or equal to half of the main icon's size in both dimensions.");
        }
    }

    @Override
    public boolean clearDecorations() {
        boolean bIconModified = false;
        if (this.m_nwDecoration != null) {
            this.m_nwDecoration = null;
            bIconModified = true;
        }
        if (this.m_neDecoration != null) {
            this.m_neDecoration = null;
            bIconModified = true;
        }
        if (this.m_swDecoration != null) {
            this.m_swDecoration = null;
            bIconModified = true;
        }
        if (this.m_seDecoration != null) {
            this.m_seDecoration = null;
            bIconModified = true;
        }
        return bIconModified;
    }

    @Override
    public int getIconHeight() {
        return this.m_iIconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.m_iIconWidth;
    }

    @Override
    public synchronized void paintIcon(Component cmp, Graphics g, int x, int y) {
        int iIconX = x;
        if (this.m_icon.getIconWidth() < this.m_iIconWidth) {
            iIconX += (this.m_iIconWidth - this.m_icon.getIconWidth()) / 2;
        }
        int iIconY = y;
        if (this.m_icon.getIconHeight() < this.m_iIconHeight) {
            iIconY += (this.m_iIconHeight - this.m_icon.getIconHeight()) / 2;
        }
        this.m_icon.paintIcon(cmp, g, iIconX, iIconY);
        if (this.m_nwDecoration != null) {
            this.m_nwDecoration.paintIcon(cmp, g, x, y);
        }
        if (this.m_neDecoration != null) {
            this.m_neDecoration.paintIcon(cmp, g, x + (this.m_iIconWidth - this.m_neDecoration.getIconWidth()), y);
        }
        if (this.m_swDecoration != null) {
            this.m_swDecoration.paintIcon(cmp, g, x, y + (this.m_iIconHeight - this.m_swDecoration.getIconHeight()));
        }
        if (this.m_seDecoration != null) {
            this.m_seDecoration.paintIcon(cmp, g, x + (this.m_iIconWidth - this.m_seDecoration.getIconWidth()), y + (this.m_iIconHeight - this.m_seDecoration.getIconHeight()));
        }
    }
}

