/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.nls.collator.SASCollatorFactory;
import java.util.Comparator;
import java.util.Date;

public class WsComparatorFactory {
    private WsComparatorFactory() {
    }

    public static Comparator createComparator(Class cls) {
        if (cls == String.class) {
            return WsComparatorFactory.createStringComparator();
        }
        if (cls == Integer.class) {
            return WsComparatorFactory.createIntegerComparator();
        }
        if (cls == Double.class) {
            return WsComparatorFactory.createDoubleComparator();
        }
        if (cls == Date.class) {
            return WsComparatorFactory.createDateComparator();
        }
        if (cls == Float.class) {
            return WsComparatorFactory.createFloatComparator();
        }
        if (cls == Long.class) {
            return WsComparatorFactory.createLongComparator();
        }
        if (cls == Short.class) {
            return WsComparatorFactory.createShortComparator();
        }
        if (cls == Byte.class) {
            return WsComparatorFactory.createByteComparator();
        }
        if (cls == Character.class) {
            return WsComparatorFactory.createCharacterComparator();
        }
        if (cls == Boolean.class) {
            return WsComparatorFactory.createBooleanComparator();
        }
        return WsComparatorFactory.createObjectComparator();
    }

    protected static Comparator createStringComparator() {
        return SASCollatorFactory.createCollator();
    }

    protected static Comparator createIntegerComparator() {
        return new cIntegerComparator();
    }

    protected static Comparator createDoubleComparator() {
        return new cDoubleComparator();
    }

    protected static Comparator createDateComparator() {
        return new cDateComparator();
    }

    protected static Comparator createFloatComparator() {
        return new cFloatComparator();
    }

    protected static Comparator createLongComparator() {
        return new cLongComparator();
    }

    protected static Comparator createShortComparator() {
        return new cShortComparator();
    }

    protected static Comparator createByteComparator() {
        return new cByteComparator();
    }

    protected static Comparator createCharacterComparator() {
        return new cCharacterComparator();
    }

    protected static Comparator createBooleanComparator() {
        return new cBooleanComparator();
    }

    protected static Comparator createObjectComparator() {
        return new cObjectComparator();
    }

    protected static class cIntegerComparator
    implements Comparator {
        protected cIntegerComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer i1 = (Integer)o1;
            Integer i2 = (Integer)o2;
            return i1.compareTo(i2);
        }
    }

    protected static class cDoubleComparator
    implements Comparator {
        protected cDoubleComparator() {
        }

        public int compare(Object o1, Object o2) {
            Double d1 = (Double)o1;
            Double d2 = (Double)o2;
            return d1.compareTo(d2);
        }
    }

    protected static class cDateComparator
    implements Comparator {
        protected cDateComparator() {
        }

        public int compare(Object o1, Object o2) {
            Date d1 = (Date)o1;
            Date d2 = (Date)o2;
            return d1.compareTo(d2);
        }
    }

    protected static class cFloatComparator
    implements Comparator {
        protected cFloatComparator() {
        }

        public int compare(Object o1, Object o2) {
            Float f1 = (Float)o1;
            Float f2 = (Float)o2;
            return f1.compareTo(f2);
        }
    }

    protected static class cLongComparator
    implements Comparator {
        protected cLongComparator() {
        }

        public int compare(Object o1, Object o2) {
            Long l1 = (Long)o1;
            Long l2 = (Long)o2;
            return l1.compareTo(l2);
        }
    }

    protected static class cShortComparator
    implements Comparator {
        protected cShortComparator() {
        }

        public int compare(Object o1, Object o2) {
            Short s1 = (Short)o1;
            Short s2 = (Short)o2;
            return s1.compareTo(s2);
        }
    }

    protected static class cByteComparator
    implements Comparator {
        protected cByteComparator() {
        }

        public int compare(Object o1, Object o2) {
            Byte b1 = (Byte)o1;
            Byte b2 = (Byte)o2;
            return b1.compareTo(b2);
        }
    }

    protected static class cCharacterComparator
    implements Comparator {
        protected cCharacterComparator() {
        }

        public int compare(Object o1, Object o2) {
            Character c1 = (Character)o1;
            Character c2 = (Character)o2;
            return c1.compareTo(c2);
        }
    }

    protected static class cBooleanComparator
    implements Comparator {
        protected cBooleanComparator() {
        }

        public int compare(Object o1, Object o2) {
            Boolean b1 = (Boolean)o1;
            Boolean b2 = (Boolean)o2;
            if (b1.equals(b2)) {
                return 0;
            }
            if (b1.booleanValue()) {
                return -1;
            }
            return 1;
        }
    }

    protected static class cObjectComparator
    implements Comparator {
        protected cObjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    protected static class cStringComparator
    implements Comparator {
        protected cStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareToIgnoreCase(s2);
        }
    }
}

