/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WsCheckBoxScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private cMouseListener m_cbListener = new cMouseListener();
    private JList m_list = null;
    private DefaultListModel m_model = new DefaultListModel();
    private int m_rowCount = 10;

    public WsCheckBoxScrollPane() {
        super(new JList(new DefaultListModel()), 20, 31);
    }

    public ListModel getModel() {
        return this.m_model;
    }

    public void setRowCount(int size) {
        this.m_rowCount = size;
    }

    public JList redisplay() {
        if (this.m_model != null) {
            this.m_list = new JList(this.m_model);
            try {
                int height = ((JCheckBox)this.m_model.firstElement()).getFont().getSize() + 4;
                this.m_list.setFixedCellHeight(height);
            }
            catch (NoSuchElementException ex) {
                this.m_list.setFixedCellHeight(-1);
            }
            cSelectAction actSelect = new cSelectAction();
            this.m_list.getActionMap().put(actSelect, actSelect);
            this.m_list.getInputMap().put(KeyStroke.getKeyStroke(32, 0), actSelect);
            this.m_list.setVisibleRowCount(this.m_rowCount);
            this.m_list.setCellRenderer(new cCellRenderer());
            this.m_list.addMouseListener(this.m_cbListener);
            this.m_list.setSelectedIndex(0);
            super.getViewport().setView(this.m_list);
            super.updateUI();
        } else {
            this.m_list.setVisibleRowCount(this.m_rowCount);
            this.m_list.setSelectedIndex(0);
            super.repaint();
        }
        return this.m_list;
    }

    public JCheckBox getCheckBox(int index) {
        if (this.m_model != null) {
            return (JCheckBox)this.m_model.getElementAt(index);
        }
        return (JCheckBox)this.getComponent(index);
    }

    public void addElement(JCheckBox newbox) {
        this.m_model.addElement(newbox);
    }

    public void addElement(int index, JCheckBox newbox) {
        this.m_model.add(index, newbox);
    }

    public boolean removeElement(JCheckBox box) {
        boolean rc = this.m_model.removeElement(box);
        return rc;
    }

    public JCheckBox removeElement(int index) {
        JCheckBox rcb = (JCheckBox)this.m_model.remove(index);
        return rcb;
    }

    public void removeAllElements() {
        this.m_model.removeAllElements();
    }

    public void setStatusAll(boolean value) {
        int nCheckBoxes = this.m_model.size();
        for (int i = 0; i < nCheckBoxes; ++i) {
            ((JCheckBox)this.m_model.getElementAt(i)).setSelected(value);
        }
        EventListener[] listeners = this.m_list.getListeners(ListSelectionListener.class);
        int count = listeners.length;
        ListSelectionEvent e = new ListSelectionEvent(this, 0, nCheckBoxes - 1, true);
        for (int i = 0; i < count; ++i) {
            ((ListSelectionListener)listeners[i]).valueChanged(e);
        }
        this.m_list.setSelectedIndex(0);
        this.repaint();
    }

    private class cMouseListener
    implements MouseListener {
        private cMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JCheckBox checkbox;
            int index = WsCheckBoxScrollPane.this.m_list.locationToIndex(e.getPoint());
            checkbox.setSelected(!(checkbox = (JCheckBox)WsCheckBoxScrollPane.this.m_model.getElementAt(index)).isSelected());
            WsCheckBoxScrollPane.this.m_model.setElementAt(checkbox, index);
        }
    }

    protected class cSelectAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected cSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox checkbox;
            int index = WsCheckBoxScrollPane.this.m_list.getSelectedIndex();
            checkbox.setSelected(!(checkbox = (JCheckBox)WsCheckBoxScrollPane.this.m_model.getElementAt(index)).isSelected());
            WsCheckBoxScrollPane.this.m_model.setElementAt(checkbox, index);
        }
    }

    private class cCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        private cCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkBox = (JCheckBox)value;
            this.setText(checkBox.getText());
            this.setSelected(checkBox.isSelected());
            if (cellHasFocus) {
                this.setForeground(SystemColor.textHighlightText);
                this.setBackground(SystemColor.textHighlight);
            } else {
                this.setForeground(SystemColor.windowText);
                this.setBackground(SystemColor.window);
            }
            return this;
        }
    }
}

