/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WsAbstractAction;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;

public abstract class WsAbstractToggleAction
extends WsAbstractAction {
    private List m_lButtons;
    private ItemListener m_lsnrSelect;
    private boolean m_bIgnoreUpdates;
    public static final String SELECTED = "Selected";

    public WsAbstractToggleAction() {
        this.initialize();
    }

    public WsAbstractToggleAction(WAdminResource bundle, String sResourceKey, int fFlags) {
        super(bundle, sResourceKey, fFlags & 0xFFFFFFFE);
        this.initialize();
    }

    private void initialize() {
        this.putValue(SELECTED, Boolean.FALSE);
        this.m_lButtons = new ArrayList();
        this.m_lsnrSelect = this.createSelectListener();
    }

    protected ItemListener createSelectListener() {
        return new SelectChangeListener();
    }

    public void addButton(AbstractButton btn) {
        btn.setSelected(this.isSelected());
        this.m_lButtons.add(btn);
        btn.addItemListener(this.m_lsnrSelect);
    }

    public void removeButton(AbstractButton btn) {
        this.m_lButtons.remove(btn);
        btn.removeItemListener(this.m_lsnrSelect);
    }

    public void setSelected(boolean bSelected) {
        boolean bOldSelected = this.isSelected();
        this.putValue(SELECTED, bSelected);
        if (bOldSelected != bSelected) {
            WorkspaceMenuSupport wms;
            String sMenuSupportId;
            if (this.m_bActive && (sMenuSupportId = this.getMenuSupportId()) != null && (wms = WorkspaceMenuSupport.getWorkspaceMenuSupport()) != null) {
                wms.setSelectedItemsState(sMenuSupportId, bSelected);
            }
            this.updateButtons();
        }
    }

    public boolean isSelected() {
        return (Boolean)this.getValue(SELECTED);
    }

    private void updateButtons() {
        if (this.m_bIgnoreUpdates) {
            return;
        }
        this.m_bIgnoreUpdates = true;
        try {
            for (int iButton = 0; iButton < this.m_lButtons.size(); ++iButton) {
                AbstractButton btn = (AbstractButton)this.m_lButtons.get(iButton);
                btn.setSelected(this.isSelected());
            }
        }
        finally {
            this.m_bIgnoreUpdates = false;
        }
    }

    @Override
    public void setActive(boolean bActive) {
        if (this.m_bActive != bActive) {
            super.setActive(bActive);
            String sMenuSupportId = this.getMenuSupportId();
            if (sMenuSupportId != null) {
                WorkspaceMenuSupport wms = WorkspaceMenuSupport.getWorkspaceMenuSupport();
                if (wms == null) {
                    return;
                }
                if (bActive) {
                    wms.addItemListener(sMenuSupportId, this.m_lsnrSelect);
                } else {
                    wms.removeItemListener(sMenuSupportId, this.m_lsnrSelect);
                }
                wms.setSelectedItemsState(sMenuSupportId, bActive && this.isSelected());
            }
        }
    }

    protected class SelectChangeListener
    implements ItemListener {
        protected SelectChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            AbstractButton btn = (AbstractButton)ev.getSource();
            WsAbstractToggleAction.this.setSelected(btn.isSelected());
        }
    }
}

