/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDecoratableIcon;
import com.sas.workspace.models.DecoratableIcon;
import com.sas.workspace.models.ISimpleObjectDecorator;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectDecorator;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class WsAbstractIconFactory {
    private static final WAdminResource bundle = WAdminResource.getBundle(WsAbstractIconFactory.class);
    public static final int SIZE_16 = 16;
    public static final int SIZE_24 = 24;
    public static final int SIZE_32 = 32;
    public static final int SIZE_48 = 48;
    public static final String OPEN_ACTION = "Common:Open";
    public static final String SAVE_ACTION = "Common:Save";
    public static final String SAVE_AS_ACTION = "Common:SaveAs";
    public static final String PRINT_ACTION = "Common:Print";
    public static final String UNDO_ACTION = "Common:Undo";
    public static final String REDO_ACTION = "Common:Redo";
    public static final String CUT_ACTION = "Common:Cut";
    public static final String COPY_ACTION = "Common:Copy";
    public static final String PASTE_ACTION = "Common:Paste";
    public static final String DELETE_ACTION = "Common:Delete";
    public static final String FIND_ACTION = "Common:Find";
    public static final String FIND_NEXT_ACTION = "Common:FindNext";
    public static final String FIND_PREVIOUS_ACTION = "Common:FindPrevious";
    public static final String PROPERTIES_ACTION = "Common:Properties";
    public static final String REFRESH_ACTION = "Common:Refresh";
    public static final String IMPORT_ACTION = "Common:Import";
    public static final String EXPORT_ACTION = "Common:Export";
    public static final String HELP_ACTION = "Common:Help";
    public static final String NEW_ACTION = "Common:New";
    public static final String NEW_COLUMN_ACTION = "Common:NewColumn";
    public static final String IMPORT_COLUMNS_ACTION = "Common:ImportColumns";
    public static final String ANALYZE_ACTION = "Common:Analyze";
    public static final String MOVE_UP_ACTION = "Common:MoveUp";
    public static final String MOVE_DOWN_ACTION = "Common:MoveDown";
    public static final String FIRST_ROW_ACTION = "Common:FirstRow";
    public static final String LAST_ROW_ACTION = "Common:LastRow";
    public static final String BROWSE_ACTION = "Common:Browse";
    public static final String EDIT_ACTION = "Common:Edit";
    public static final String SORT_ACTION = "Common:Sort";
    public static final String FILTER_ACTION = "Common:Filter";
    public static final String SUBSET_COLUMNS_ACTION = "Common:SubsetColumns";
    public static final String COLUMN_NAMES_ACTION = "Common:ColumnNames";
    public static final String COLUMN_DESCRIPTIONS_ACTION = "Common:ColumnDescriptions";
    public static final String COLUMN_METADATA_NAMES_ACTION = "Common:ColumnMetadataNames";
    public static final String FORMAT_ACTION = "Common:Format";
    public static final String COMMIT_CHANGES_ACTION = "Common:CommitChanges";
    public static final String DELETE_ROWS_ACTION = "Common:DeleteRows";
    public static final String OPTIONS_DROP_MENU_ACTION = "OptionsDropMenu";
    public static final String REPORT_VIEW_ACTION = "ReportView";
    public static final String DIAGRAM_VIEW_ACTION = "DiagramView";
    public static final String CODE_EDITOR_ACTION = "Common:CodeEditor";
    public static final String MOVE_TAB_UP_ACTION = "Common:MoveTabUp";
    public static final String MOVE_TAB_DOWN_ACTION = "Common:MoveTabDown";
    public static final String MOVE_TAB_LEFT_ACTION = "Common:MoveTabLeft";
    public static final String MOVE_TAB_RIGHT_ACTION = "Common:MoveTabRight";
    public static final String BOLD_ACTION = "Common:Bold";
    public static final String ITALIC_ACTION = "Common:Italic";
    public static final String UNDERLINE_ACTION = "Common:Underline";
    public static final String MINIMIZE_ACTION = "Common:Minimize";
    public static final String MAXIMIZE_ACTION = "Common:Maximize";
    public static final String RESTORE_ACTION = "Common:Restore";
    public static final String CLOSE_ACTION = "Common:Close";
    public static final String MINIMIZE_ROLLOVER_ACTION = "Common:MinimizeRollover";
    public static final String MAXIMIZE_ROLLOVER_ACTION = "Common:MaximizeRollover";
    public static final String RESTORE_ROLLOVER_ACTION = "Common:RestoreRollover";
    public static final String CLOSE_ROLLOVER_ACTION = "Common:CloseRollover";
    public static final String RUN_ACTION = "Common:Run";
    public static final String STOP_ACTION = "Common:Stop";
    public static final String PRIMARY_KEY_TYPE = "Type:PrimaryKey";
    public static final String UNIQUE_KEY_TYPE = "Type:UniqueKey";
    public static final String FOREIGN_KEY_TYPE = "Type:ForeignKey";
    public static final String INDEX_TYPE = "Type:Index";
    private static final String UNKNOWN_TYPE = "GenericSASObject.gif";
    private static WsAbstractIconFactory m_instance;
    protected ServerInterface m_server;
    private Map m_mapActionIcons = new HashMap();
    private Map m_mapPrivateTypeIcons = new HashMap();
    protected ISimpleObjectDecorator m_iconDecorator;

    public static WsAbstractIconFactory getInstance() {
        return m_instance;
    }

    public static void setInstance(WsAbstractIconFactory instance) {
        m_instance = instance;
    }

    protected WsAbstractIconFactory() {
        this.registerIconsForActions();
        this.registerIconsForPrivateTypes();
    }

    protected WsAbstractIconFactory(ServerInterface server) {
        this();
        this.setServer(server);
    }

    public void setServer(ServerInterface server) {
        this.m_server = server;
        this.m_iconDecorator = new SimpleObjectDecorator(server);
    }

    public Icon getIconForPublicType(String sPublicType) {
        return this.getIconForPublicType(sPublicType, 16);
    }

    public Icon getIconForPublicType(String sPublicType, int iSize) {
        Icon returnedIcon;
        block13: {
            returnedIcon = null;
            if (sPublicType != null && sPublicType.length() > 0) {
                if (this.m_server == null) {
                    throw new IllegalStateException("No server available.  You must call setServer on the icon factory to provide a server.");
                }
                try {
                    TypeDescriptorInterface typeInfo = this.m_server.getTypeDescriptor(sPublicType);
                    if (typeInfo == null) break block13;
                    try {
                        if (iSize == 16) {
                            returnedIcon = typeInfo.getIcon();
                        } else {
                            String sIconName = typeInfo.getIconName();
                            ImageIcon icon = Resources.getImageIcon((String)sIconName, (int)iSize);
                            if (icon != null) {
                                returnedIcon = icon;
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage(ex);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
            }
        }
        if (returnedIcon == null) {
            try {
                return Resources.getImageIcon((String)UNKNOWN_TYPE, (int)iSize);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return returnedIcon;
    }

    public Icon getIconForSimpleObject(SimpleObject simpleObject) {
        return this.getIconForSimpleObject(simpleObject, 16);
    }

    public Icon getIconForSimpleObject(SimpleObject simpleObject, int iSize) {
        if (simpleObject == null) {
            throw new IllegalArgumentException("Simple object must not be null.");
        }
        return this.getIconForPublicType(simpleObject.getPublicType(), iSize);
    }

    public DecoratableIcon getDecoratableIconForSimpleObject(SimpleObject simpleObject) {
        return this.getDecoratableIconForSimpleObject(simpleObject, 16);
    }

    public DecoratableIcon getDecoratableIconForSimpleObject(SimpleObject simpleObject, int iSize) {
        Icon icon = this.getIconForSimpleObject(simpleObject, iSize);
        if (icon != null) {
            return new WsDecoratableIcon(icon);
        }
        return null;
    }

    public DecoratableIcon getDecoratedIconForSimpleObject(SimpleObject simpleObject) {
        return this.getDecoratedIconForSimpleObject(simpleObject, 16);
    }

    public DecoratableIcon getDecoratedIconForSimpleObject(SimpleObject simpleObject, int iSize) {
        if (this.m_iconDecorator == null) {
            throw new IllegalStateException("No icon decorator available because a server has not been set.  You must call setServer on the icon factory to provide a server.");
        }
        return this.getDecoratedIconForSimpleObject(simpleObject, this.m_iconDecorator, iSize);
    }

    public DecoratableIcon getDecoratedIconForSimpleObject(SimpleObject simpleObject, ISimpleObjectDecorator iconDecorator) {
        return this.getDecoratedIconForSimpleObject(simpleObject, iconDecorator, 16);
    }

    public DecoratableIcon getDecoratedIconForSimpleObject(SimpleObject simpleObject, ISimpleObjectDecorator iconDecorator, int iSize) {
        if (iconDecorator == null) {
            throw new IllegalArgumentException("You must provide a valid icon decorator.");
        }
        DecoratableIcon icon = this.getDecoratableIconForSimpleObject(simpleObject, iSize);
        if (icon != null) {
            try {
                iconDecorator.decorateIcon(icon, simpleObject);
            }
            catch (ServiceException ex) {
                MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        return icon;
    }

    public ISimpleObjectDecorator getIconDecorator() {
        return this.m_iconDecorator;
    }

    public Icon getIconForAction(String sAction) {
        return (Icon)this.m_mapActionIcons.get(sAction);
    }

    protected void registerIconsForActions() {
        this.addIconForAction(OPEN_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Open.image"));
        this.addIconForAction(SAVE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Save.image"));
        this.addIconForAction(SAVE_AS_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.SaveAs.image"));
        this.addIconForAction(PRINT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Print.image"));
        this.addIconForAction(UNDO_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Undo.image"));
        this.addIconForAction(REDO_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Redo.image"));
        this.addIconForAction(CUT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Cut.image"));
        this.addIconForAction(COPY_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Copy.image"));
        this.addIconForAction(PASTE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Paste.image"));
        this.addIconForAction(DELETE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Delete.image"));
        this.addIconForAction(FIND_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Find.image"));
        this.addIconForAction(FIND_NEXT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.FindNext.image"));
        this.addIconForAction(FIND_PREVIOUS_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.FindPrevious.image"));
        this.addIconForAction(PROPERTIES_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Properties.image"));
        this.addIconForAction(REFRESH_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Refresh.image"));
        this.addIconForAction(IMPORT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Import.image"));
        this.addIconForAction(EXPORT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Export.image"));
        this.addIconForAction(HELP_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Help.image"));
        this.addIconForAction(NEW_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.New.image"));
        this.addIconForAction(NEW_COLUMN_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.NewColumn.image"));
        this.addIconForAction(IMPORT_COLUMNS_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.ImportColumns.image"));
        this.addIconForAction(ANALYZE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Analyze.image"));
        this.addIconForAction(MOVE_UP_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.MoveUp.image"));
        this.addIconForAction(MOVE_DOWN_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.MoveDown.image"));
        this.addIconForAction(FIRST_ROW_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.FirstRow.image"));
        this.addIconForAction(LAST_ROW_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.LastRow.image"));
        this.addIconForAction(BROWSE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Browse.image"));
        this.addIconForAction(EDIT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Edit.image"));
        this.addIconForAction(SORT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Sort.image"));
        this.addIconForAction(FILTER_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Filter.image"));
        this.addIconForAction(SUBSET_COLUMNS_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.SubsetColumns.image"));
        this.addIconForAction(COLUMN_NAMES_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.ColumnNames.image"));
        this.addIconForAction(COLUMN_DESCRIPTIONS_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.ColumnDescriptions.image"));
        this.addIconForAction(COLUMN_METADATA_NAMES_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.ColumnMetadataNames.image"));
        this.addIconForAction(FORMAT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Format.image"));
        this.addIconForAction(COMMIT_CHANGES_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.CommitChanges.image"));
        this.addIconForAction(DELETE_ROWS_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.DeleteRows.image"));
        this.addIconForAction(OPTIONS_DROP_MENU_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.OptionsDropMenu.image"));
        this.addIconForAction(REPORT_VIEW_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.ReportView.image"));
        this.addIconForAction(DIAGRAM_VIEW_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.DiagramView.image"));
        this.addIconForAction(CODE_EDITOR_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.CodeEditor.image"));
        this.addIconForAction(MOVE_TAB_UP_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.MoveTabUp.image"));
        this.addIconForAction(MOVE_TAB_DOWN_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.MoveTabDown.image"));
        this.addIconForAction(MOVE_TAB_LEFT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.MoveTabLeft.image"));
        this.addIconForAction(MOVE_TAB_RIGHT_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.MoveTabRight.image"));
        this.addIconForAction(BOLD_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Bold.image"));
        this.addIconForAction(ITALIC_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Italic.image"));
        this.addIconForAction(UNDERLINE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Underline.image"));
        this.addIconForAction(MINIMIZE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Minimize.image"));
        this.addIconForAction(MAXIMIZE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Maximize.image"));
        this.addIconForAction(RESTORE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Restore.image"));
        this.addIconForAction(CLOSE_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Close.image"));
        this.addIconForAction(MINIMIZE_ROLLOVER_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Minimize.image"));
        this.addIconForAction(MAXIMIZE_ROLLOVER_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Maximize.image"));
        this.addIconForAction(RESTORE_ROLLOVER_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Restore.image"));
        this.addIconForAction(CLOSE_ROLLOVER_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Close.image"));
        this.addIconForAction(RUN_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Run.image"));
        this.addIconForAction(STOP_ACTION, bundle.getIcon("WsAbstractIconFactory.Action.Stop.image"));
    }

    protected void addIconForAction(String sAction, Icon iconAction) {
        this.m_mapActionIcons.put(sAction, iconAction);
    }

    public Icon getIconForPrivateType(String sPrivateType) {
        return this.getIconForPrivateType(sPrivateType, 16);
    }

    public Icon getIconForPrivateType(String sPrivateType, int eSize) {
        return (Icon)this.m_mapPrivateTypeIcons.get(sPrivateType + eSize);
    }

    protected void registerIconsForPrivateTypes() {
        this.addIconForPrivateType(PRIMARY_KEY_TYPE, 16, bundle.getIcon("WsAbstractIconFactory.PrivateType.PrimaryKey.16.image"));
        this.addIconForPrivateType(UNIQUE_KEY_TYPE, 16, bundle.getIcon("WsAbstractIconFactory.PrivateType.UniqueKey.16.image"));
        this.addIconForPrivateType(FOREIGN_KEY_TYPE, 16, bundle.getIcon("WsAbstractIconFactory.PrivateType.ForeignKey.16.image"));
        this.addIconForPrivateType(INDEX_TYPE, 16, bundle.getIcon("WsAbstractIconFactory.PrivateType.Index.16.image"));
    }

    protected void addIconForPrivateType(String sPrivateType, int eSize, Icon iconPrivateType) {
        this.m_mapPrivateTypeIcons.put(sPrivateType + eSize, iconPrivateType);
    }
}

