/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ProjectEventListener2;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsDefaultTreeModel;
import com.sas.workspace.tree.WsTreeModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeNode;

public class WorkspaceTreeModel
extends WsDefaultTreeModel
implements WsTreeModel {
    private static final long serialVersionUID = 1L;
    protected WsTreeNode m_nodeRoot;
    protected boolean m_handleObjectsCreatedMetadataEvent = true;
    protected boolean m_bListenForChanges = true;
    protected cMetadataServerListener m_lsnrMetadata;
    private MdFactoryListener m_lsnrFactory;

    public WorkspaceTreeModel(WsTreeNode nodeRoot) {
        super(nodeRoot);
        this.m_nodeRoot = nodeRoot;
        nodeRoot.setTreeModel(this);
        this.installListeners();
    }

    public void dispose() {
        this.uninstallListeners();
    }

    @Override
    public void setRoot(TreeNode nodeRoot) {
        super.setRoot(nodeRoot);
        this.m_nodeRoot = (WsTreeNode)nodeRoot;
    }

    public void setListenForChanges(boolean bListenForChanges) {
        if (this.m_bListenForChanges != bListenForChanges) {
            this.m_bListenForChanges = bListenForChanges;
            if (this.m_bListenForChanges) {
                this.installListeners();
            } else {
                this.uninstallListeners();
            }
        }
    }

    public boolean isListenForChanges() {
        return this.m_bListenForChanges;
    }

    protected void installListeners() {
        try {
            this.m_lsnrMetadata = this.createMetadataListener();
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            ProjectUtil.addProjectEventListener(this.m_lsnrMetadata);
            this.m_lsnrFactory = this.createMetadataFactoryListener();
            factory.addMdFactoryListener(this.m_lsnrFactory);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected cMetadataServerListener createMetadataListener() {
        return new cMetadataServerListener();
    }

    private MdFactoryListener createMetadataFactoryListener() {
        return new MetadataFactoryListener();
    }

    protected void uninstallListeners() {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            ProjectUtil.removeProjectEventListener(this.m_lsnrMetadata);
            this.m_lsnrMetadata = null;
            factory.removeMdFactoryListener(this.m_lsnrFactory);
            this.m_lsnrFactory = null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreatedObjects(Map mapObjects) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WorkspaceTreeModel:updateCreatedObjects");
            try {
                List lObjects = this.createObjectsInStore(store, mapObjects);
                if (lObjects == null) {
                    return;
                }
                this.populateObjects(lObjects);
                for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                    CMetadata oObject = (CMetadata)lObjects.get(iObject);
                    if (oObject == null || !this.isValidNewObject(oObject)) continue;
                    this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
                }
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected boolean isValidNewObject(CMetadata mdoObject) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModifiedObjects(Map mapObjects) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WorkspaceTreeModel:updateModifiedObjects");
            try {
                List lObjects = this.createObjectsInStore(store, mapObjects);
                if (lObjects == null) {
                    return;
                }
                this.objectsModified(lObjects);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    private List createObjectsInStore(MdObjectStore store, Map mapObjects) throws RemoteException {
        Set setKeys = mapObjects.keySet();
        if (setKeys.size() == 0) {
            return null;
        }
        String[] saKeys = new String[setKeys.size()];
        setKeys.toArray(saKeys);
        ArrayList<CMetadata> lObjects = new ArrayList<CMetadata>(saKeys.length);
        for (int iKey = 0; iKey < saKeys.length; ++iKey) {
            lObjects.add(Workspace.getMdFactory().createComplexMetadataObject(store, (String)null, (String)mapObjects.get(saKeys[iKey]), saKeys[iKey]));
        }
        return lObjects;
    }

    protected void removeDeletedObjects(String[] saFQIDs) {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        for (int iFQID = 0; iFQID < saFQIDs.length; ++iFQID) {
            ArrayList lNodes = this.findNodes(nodeRoot, saFQIDs[iFQID]);
            for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
                this.removeChild((WsTreeNode)lNodes.get(iNode));
            }
        }
    }

    public void addChild(CMetadata oMetadata, WsTreeNode nodeParent) {
        try {
            CMetadata oSimple = Workspace.getMdFactory().createSimpleMetadataObject(oMetadata);
            if (oSimple instanceof Root) {
                ((Root)oSimple).setChangeState(((Root)oMetadata).getChangeState());
                ((Root)oSimple).setLockedBy(((Root)oMetadata).getLockedBy());
            }
            WsTreeNode nodeNew = nodeParent.createChild(oSimple);
            this.addChild(nodeNew, nodeParent);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void replaceChild(WsTreeNode nodeOld, WsTreeNode nodeNew) {
        if (nodeOld != null && nodeNew != null) {
            WsTreeNode nodeParent = (WsTreeNode)nodeOld.getParent();
            this.removeChild(nodeOld);
            this.addChild(nodeNew, nodeParent);
        }
    }

    public WsTreeNode getNodeRoot() {
        return this.m_nodeRoot;
    }

    public ArrayList findNodes(CMetadata oMetadata) {
        return this.findNodes((WsTreeNode)this.getRoot(), oMetadata);
    }

    public ArrayList findNodes(WsTreeNode nodeStart, CMetadata oMetadata) {
        try {
            String strFQIDToFind = oMetadata.getFQID();
            String strChangeState = ((Root)oMetadata).getChangeState();
            if (strChangeState != null && strChangeState.length() > 0) {
                int middleIndex = strChangeState.indexOf(":");
                strFQIDToFind = strChangeState.substring(middleIndex + 2, strChangeState.length());
            }
            return this.findNodes(nodeStart, strFQIDToFind);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return new ArrayList();
        }
    }

    public ArrayList findNodes(String sFQID) {
        return this.findNodes((WsTreeNode)this.getRoot(), sFQID);
    }

    public ArrayList findNodes(WsTreeNode nodeStart, String sFQID) {
        ArrayList<WsTreeNode> alNodes = new ArrayList<WsTreeNode>();
        Enumeration<TreeNode> enumNodes = nodeStart.breadthFirstEnumeration();
        while (enumNodes.hasMoreElements()) {
            WsTreeNode nodeCurrent = (WsTreeNode)enumNodes.nextElement();
            String sFQIDNode = nodeCurrent.getFQID();
            if (!sFQID.equals(sFQIDNode)) continue;
            alNodes.add(nodeCurrent);
        }
        return alNodes;
    }

    public ArrayList findNodesByChangeState(WsTreeNode nodeStart, String sFQID) throws RemoteException {
        ArrayList<WsTreeNode> alNodes = new ArrayList<WsTreeNode>();
        Enumeration<TreeNode> enumNodes = nodeStart.breadthFirstEnumeration();
        while (enumNodes.hasMoreElements()) {
            int middleIndex;
            String strFQIDToFind;
            WsDataTreeNode dataNode;
            String strChangeState;
            WsTreeNode nodeCurr = (WsTreeNode)enumNodes.nextElement();
            String sFQIDCurr = nodeCurr.getFQID();
            if (sFQIDCurr == null || (strChangeState = ((Root)(dataNode = (WsDataTreeNode)nodeCurr).getMetadata()).getChangeState()) == null || strChangeState.length() <= 0 || sFQID.compareToIgnoreCase(strFQIDToFind = strChangeState.substring((middleIndex = strChangeState.indexOf(":")) + 2, strChangeState.length())) != 0) continue;
            alNodes.add(nodeCurr);
        }
        return alNodes;
    }

    public WsTreeNode getNodebyNameAndFQID(String Name2, String FQID) throws RemoteException {
        if (FQID != null && FQID.length() > 0) {
            WsTreeNode rootnode = (WsTreeNode)this.getRoot();
            Enumeration<TreeNode> treeenum = rootnode.breadthFirstEnumeration();
            int index = 0;
            while (treeenum.hasMoreElements()) {
                WsTreeNode node = (WsTreeNode)treeenum.nextElement();
                ++index;
                CMetadata nodeObject = node.getMetadata();
                if (nodeObject == null) continue;
                String nodeObjectFQID = nodeObject.getFQID();
                String nodeObjectName = nodeObject.getName();
                if (nodeObjectFQID != null && nodeObjectName != null && nodeObjectFQID.equals(FQID) && nodeObjectName.equals(Name2)) {
                    return node;
                }
                if (node.hasExpanded() || FQID.indexOf(nodeObject.getRepositoryID()) <= -1) continue;
                try {
                    node.addChildren();
                    node.setHasExpanded(true);
                    treeenum = rootnode.breadthFirstEnumeration();
                    for (int i = 0; i < index - 1; ++i) {
                        treeenum.nextElement();
                    }
                }
                catch (Exception e) {
                    Workspace.getDefaultLogger().error((Object)"", e);
                }
            }
        }
        return null;
    }

    public WsTreeNode getFirstMetadataObjectNode(WsTreeNode nodeToStart) throws RemoteException {
        if (nodeToStart != null) {
            Enumeration<TreeNode> treeenum = nodeToStart.breadthFirstEnumeration();
            int index = 0;
            while (treeenum.hasMoreElements()) {
                WsTreeNode node = (WsTreeNode)treeenum.nextElement();
                ++index;
                CMetadata nodeObject = node.getMetadata();
                if (nodeObject == null) continue;
                String nodeObjectFQID = nodeObject.getFQID();
                if (nodeObjectFQID != null && nodeObjectFQID.indexOf("A0000001") == -1) {
                    return node;
                }
                if (node.hasExpanded()) continue;
                try {
                    node.addChildren();
                    node.setHasExpanded(true);
                    treeenum = nodeToStart.breadthFirstEnumeration();
                    for (int i = 0; i < index - 1; ++i) {
                        treeenum.nextElement();
                    }
                }
                catch (Exception e) {
                    Workspace.getDefaultLogger().error((Object)"", e);
                }
            }
        }
        return null;
    }

    public WsTreeNode getTreeNodebyRole(String strRole) throws RemoteException {
        WsTreeNode rootnode = (WsTreeNode)this.getRoot();
        Enumeration<TreeNode> treeenum = rootnode.breadthFirstEnumeration();
        MdObjectStore parentStore = null;
        int index = 0;
        try {
            parentStore = Workspace.getMdFactory().createObjectStore();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            return null;
        }
        while (treeenum.hasMoreElements()) {
            WsTreeNode node = (WsTreeNode)treeenum.nextElement();
            ++index;
            CMetadata nodeObject = node.getMetadata();
            if (nodeObject == null) continue;
            if (nodeObject.getCMetadataType().equals("Tree")) {
                Tree tree = null;
                try {
                    tree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(parentStore, null, nodeObject.getName(), nodeObject.getCMetadataType(), nodeObject.getId(), null);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)tree, null, null, "", 8);
                }
                catch (Exception e) {
                    try {
                        parentStore.dispose();
                    }
                    catch (Exception ex) {
                        Workspace.getDefaultLogger().error((Object)"", ex);
                    }
                    return null;
                }
                if (tree.getTreeType().equals(strRole)) {
                    try {
                        parentStore.dispose();
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", e);
                    }
                    return node;
                }
            }
            if (node.hasExpanded()) continue;
            node.addChildren();
            node.setHasExpanded(true);
            treeenum = rootnode.breadthFirstEnumeration();
            for (int i = 0; i < index - 1; ++i) {
                treeenum.nextElement();
            }
        }
        try {
            parentStore.dispose();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
        return null;
    }

    public WsTreeNode getFirstRepository() throws RemoteException {
        WsTreeNode rootnode = (WsTreeNode)this.getRoot();
        Enumeration<TreeNode> treeenum = rootnode.breadthFirstEnumeration();
        while (treeenum.hasMoreElements()) {
            String nodeObjectFQID;
            WsTreeNode node = (WsTreeNode)treeenum.nextElement();
            CMetadata nodeObject = node.getMetadata();
            if (nodeObject == null || (nodeObjectFQID = nodeObject.getFQID()).indexOf("A0000001") <= -1) continue;
            return node;
        }
        return null;
    }

    public void objectsCreated(MdEvent e, List lFQIDs) {
        try {
            ArrayList alObjects = this.getObjects(lFQIDs);
            this.populateObjects(alObjects);
            int nObjects = alObjects.size();
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                CMetadata oObject = (CMetadata)alObjects.get(iObject);
                if (oObject == null) continue;
                this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void objectsModified(MdEvent e, List lFQIDs) {
        try {
            this.objectsModified(this.getObjects(lFQIDs));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void objectsUndoCheckout(ArrayList alObjects) {
        this.populateUncheckedOutObjects(alObjects);
        this.handleObjectsModified(alObjects);
    }

    public void objectsClearProject(ArrayList alObjects) {
        if (!alObjects.isEmpty()) {
            this.populateClearedObjects(alObjects);
            this.handleObjectsCleared(alObjects);
        }
    }

    public void objectsCheckedIn(ArrayList alObjects) {
        this.populateUncheckedOutObjects(alObjects);
        this.handleObjectsCheckedIn(alObjects);
    }

    public void objectsDestroyed(Vector vObjects) {
        this.handleObjectsDestroyed(vObjects);
    }

    public void doObjectsCheckedOut(ArrayList alObjects) {
        this.objectsModified(alObjects);
    }

    public void doObjectsFetched(ArrayList alObjects) {
        this.objectsModified(alObjects);
    }

    public void objectsModified(List alObjects) {
        this.populateObjects(alObjects);
        this.handleObjectsModified(alObjects);
    }

    public void doObjectsCopied(ArrayList alObjects) {
        this.populateObjects(alObjects);
        this.handleObjectsModified(alObjects);
    }

    protected void handleObjectsCheckedIn(ArrayList alObjects) {
        this.handleObjectsModified(alObjects);
    }

    protected void handleObjectsDestroyed(Vector vObjects) {
        int length = vObjects.size();
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            String idDestroyed = (String)vObjects.elementAt(i);
            WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
            ArrayList alNodes = this.findNodes(nodeRoot, idDestroyed);
            int nNodes = alNodes.size();
            for (int iNode = 0; iNode < nNodes; ++iNode) {
                this.removeChild((WsTreeNode)alNodes.get(iNode));
            }
        }
    }

    protected void handleObjectsModified(List lObjects) {
        try {
            int nObjects = lObjects.size();
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                CMetadata oObject = (CMetadata)lObjects.get(iObject);
                if (oObject == null) continue;
                ArrayList alNodes = this.findNodes(oObject);
                String sType = oObject.getCMetadataType();
                boolean bPhysicalTable = sType.equals("PhysicalTable");
                boolean bNeedToCreate = true;
                int nNodes = alNodes.size();
                for (int iNode = 0; iNode < nNodes; ++iNode) {
                    WsTreeNode nodeObject = (WsTreeNode)alNodes.get(iNode);
                    WsTreeNode nodeParent = (WsTreeNode)nodeObject.getParent();
                    if (((Root)oObject).getChangeState() != null && ((Root)oObject).getChangeState().length() > 0) {
                        nodeObject.updateMetadata(oObject);
                        bNeedToCreate = false;
                        continue;
                    }
                    if (bPhysicalTable || !nodeParent.isValidParentFor(oObject)) {
                        this.removeChild(nodeObject);
                        continue;
                    }
                    nodeObject.updateMetadata(oObject);
                    bNeedToCreate = false;
                }
                if (!bNeedToCreate) continue;
                this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected void handleObjectsCleared(List lObjects) {
        try {
            int nObjects = lObjects.size();
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                CMetadata oObject = (CMetadata)lObjects.get(iObject);
                if (oObject == null || ((Root)oObject).getChangeState().indexOf("New") >= 0) continue;
                ArrayList alNodes = this.findNodes(oObject);
                String sType = oObject.getCMetadataType();
                boolean bPhysicalTable = sType.equals("PhysicalTable");
                boolean bNeedToCreate = true;
                int nNodes = alNodes.size();
                for (int iNode = 0; iNode < nNodes; ++iNode) {
                    WsTreeNode nodeObject = (WsTreeNode)alNodes.get(iNode);
                    WsTreeNode nodeParent = (WsTreeNode)nodeObject.getParent();
                    if (((Root)oObject).getChangeState() != null && ((Root)oObject).getChangeState().length() > 0) {
                        nodeObject.updateMetadata(oObject);
                        bNeedToCreate = false;
                        continue;
                    }
                    if (bPhysicalTable || !nodeParent.isValidParentFor(oObject)) {
                        this.removeChild(nodeObject);
                        continue;
                    }
                    nodeObject.updateMetadata(oObject);
                    bNeedToCreate = false;
                }
                if (!bNeedToCreate) continue;
                this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void objectDeleted(MdEvent e, String sFQID) {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        ArrayList alNodes = this.findNodes(nodeRoot, sFQID);
        int nNodes = alNodes.size();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            this.removeChild((WsTreeNode)alNodes.get(iNode));
        }
    }

    protected ArrayList getObjects(List lFQIDs) throws RemoteException {
        int nObjects = lFQIDs.size();
        ArrayList<CMetadata> alObjects = new ArrayList<CMetadata>(nObjects);
        for (int iObject = 0; iObject < nObjects; ++iObject) {
            CMetadata oObject = Workspace.getMdFactory().getObject((String)lFQIDs.get(iObject));
            alObjects.add(oObject);
        }
        return alObjects;
    }

    protected void populateObjects(List lObjects) {
        try {
            StringBuffer sbXML = new StringBuffer();
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                CMetadata oObject = (CMetadata)lObjects.get(iObject);
                if (oObject == null) continue;
                sbXML.append("<");
                sbXML.append(oObject.getCMetadataType());
                sbXML.append(" Id=\"");
                sbXML.append(oObject.getFQID());
                sbXML.append("\" Name=\"\" LockedBy = \"\" ChangeState=\"\">");
                sbXML.append("</");
                sbXML.append(oObject.getCMetadataType());
                sbXML.append(">");
            }
            CMetadata oObject = (CMetadata)lObjects.get(0);
            Workspace.getMdFactory().getOMIUtil().getMetadataObjects(oObject.getObjectStore(), sbXML.toString(), "", 256);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Accessing");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected void populateUncheckedOutObjects(ArrayList alObjects) {
    }

    protected void populateClearedObjects(ArrayList alObjects) {
    }

    public void setHandleObjectsCreatedMetadataEvent(boolean fFlag) {
        this.m_handleObjectsCreatedMetadataEvent = fFlag;
    }

    protected void createNodesFor(WsTreeNode node, CMetadata oMetadata) throws RemoteException {
        if (!node.hasExpanded()) {
            return;
        }
        if (node.isValidParentFor(oMetadata)) {
            CMetadata oSimple = Workspace.getMdFactory().createSimpleMetadataObject(oMetadata);
            if (oMetadata instanceof Tree) {
                oSimple.setClientSideOnlyObject((Object)((Tree)oMetadata).getTreeType());
            }
            ((Root)oSimple).setChangeState(((Root)oMetadata).getChangeState());
            ((Root)oSimple).setLockedBy(((Root)oMetadata).getLockedBy());
            WsTreeNode nodeChild = node.createChild(oSimple);
            node.addChild(nodeChild);
            return;
        }
        if (node.isValidAncestorFor(oMetadata)) {
            int nChildren = node.getChildCount();
            for (int iChild = 0; iChild < nChildren; ++iChild) {
                WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
                this.createNodesFor(nodeChild, oMetadata);
            }
        }
    }

    protected class cMetadataServerListener
    implements MdObjectFactoryListener,
    MdStoreListener,
    ProjectEventListener2 {
        protected cMetadataServerListener() {
        }

        public void MdObjectsAdded(MdEvent e, List alObjects) {
        }

        public void MdObjectsRemoved(MdEvent e, List alObjects) {
        }

        public void MdObjectsModified(MdEvent e, List lFQIDs) {
            WorkspaceTreeModel.this.objectsModified(e, lFQIDs);
        }

        public void MdObjectsCreated(MdEvent e, List lFQIDs) {
            WorkspaceTreeModel.this.objectsCreated(e, lFQIDs);
        }

        public void MdObjectCreated(MdEvent e, String sFQID) {
        }

        public void MdObjectDeleted(MdEvent e, String sFQID) {
            WorkspaceTreeModel.this.objectDeleted(e, sFQID);
        }

        @Override
        public void objectsCheckedOut(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.doObjectsCheckedOut(objectArray);
        }

        @Override
        public void objectsCheckedIn(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.objectsCheckedIn(objectArray);
        }

        @Override
        public void objectsDestroyed(ChangeEvent e, Vector objects) {
            WorkspaceTreeModel.this.objectsDestroyed(objects);
        }

        @Override
        public void objectsFetched(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.doObjectsFetched(objectArray);
        }

        @Override
        public void objectsCopied(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.doObjectsCopied(objectArray);
        }

        @Override
        public void objectsLocked(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.objectsModified(objectArray);
        }

        @Override
        public void objectsUnLocked(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.objectsUndoCheckout(objectArray);
        }

        @Override
        public void objectsUndoCheckout(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.objectsUndoCheckout(objectArray);
        }

        @Override
        public void objectsClearProject(ChangeEvent e, Vector objects) {
            ArrayList objectArray = new ArrayList(objects);
            WorkspaceTreeModel.this.objectsClearProject(objectArray);
        }

        @Override
        public void objectsNewAdded(ChangeEvent e, ArrayList objects) {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    }

    private class MetadataFactoryListener
    implements MdFactoryListener {
        private MetadataFactoryListener() {
        }

        public void MdObjectsCreated(MdFactoryEvent ev) {
            WorkspaceTreeModel.this.addCreatedObjects(ev.getObjectMap());
        }

        public void MdObjectsModified(MdFactoryEvent ev) {
            WorkspaceTreeModel.this.updateModifiedObjects(ev.getObjectMap());
        }

        public void MdObjectsDeleted(MdFactoryEvent ev) {
            WorkspaceTreeModel.this.removeDeletedObjects(ev.getObjectIDs());
        }
    }
}

