/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.plugins.PluginLoader;
import com.sas.visuals.Resources;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WorkspaceTreeUI;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractOperation;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.plugins.TreeNodeInterface;
import com.sas.workspace.plugins.WorkspaceTreeContextMenuPluginInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WorkspaceTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WorkspaceTree.class);
    public static final String ACTIVE_NODE_PROPERTY = "activeNode";
    private static final String s_uiClassID = "WorkspaceTreeUI";
    protected JScrollPane m_treeScrollPane;
    protected Workspace m_workspace = Workspace.getWorkspace();
    protected DragSource m_dragSource;
    protected boolean m_bPopupMenusEnabled = true;
    protected boolean m_bAddingMemberNodes = true;
    protected boolean m_bShowCheckout = false;
    protected boolean m_bDraggingEnabled = false;
    protected boolean m_bToolTipsEnabled = false;
    private boolean m_bDefaultActionEnabled = true;
    protected List m_vRepositories;
    private Action m_actUserDefault;
    protected boolean m_bDragging;
    private boolean m_bDraggingOver;
    protected boolean m_bActive;
    protected WsTreeNode m_nodeActive;
    protected WsTreeNode[] m_aNodes;
    protected DropTarget m_dropTarget;
    protected WsAbstractAction m_actCopy;
    protected WsAbstractAction m_actPaste;
    protected WsAbstractAction m_actPasteSpecial;
    protected WsAbstractAction m_actExport;
    protected WsAbstractAction m_actImport;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actRename;
    protected WsAbstractAction m_actRefresh;
    protected WsAbstractAction m_actPopup;
    protected WsAbstractAction m_actDefault;
    protected String m_sPad = "";

    public static Icon getOpenedFolderIcon() {
        return Resources.getImageIcon((String)bundle.getString("Common.OpenedTree.image"), (int)16);
    }

    public static Icon getClosedFolderIcon() {
        return Resources.getImageIcon((String)bundle.getString("Common.ClosedTree.image"), (int)16);
    }

    public static Icon getDefaultLeafIcon() {
        return bundle.getImageIcon("Common.DefaultLeaf.image");
    }

    @Override
    public String getUIClassID() {
        if (UIManager.get(s_uiClassID) == null) {
            UIManager.put(s_uiClassID, WorkspaceTreeUI.class.getName());
        }
        return s_uiClassID;
    }

    public WorkspaceTree() {
        this.createListeners();
        this.createActions();
        this.createKeyActionMappings();
        cTreeCellRenderer tcr = new cTreeCellRenderer();
        this.setCellRenderer(tcr);
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.m_treeScrollPane = new JScrollPane(this);
        this.setEditable(true);
        cCellEditor tce = new cCellEditor(this, tcr);
        this.setCellEditor(tce);
        tce.addCellEditorListener(new cCellEditorListener());
        this.setInvokesStopCellEditing(true);
    }

    protected void createListeners() {
        this.addMouseListener(this.createMouseListener());
        this.addTreeSelectionListener(this.createSelectionListener());
        this.addTreeExpansionListener(this.createTreeExpansionListener());
        this.addKeyListener(this.createKeyListener());
        this.m_dragSource = new DragSource();
        this.m_dragSource.createDefaultDragGestureRecognizer(this, 3, this.createDragGestureListener());
        this.m_dropTarget = new DropTarget(this, this.createDropTargetListener());
        this.m_dropTarget.setDefaultActions(3);
    }

    protected MouseListener createMouseListener() {
        return new cMouseListener();
    }

    protected TreeSelectionListener createSelectionListener() {
        return new cSelectListener();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new cExpansionListener();
    }

    protected KeyListener createKeyListener() {
        return new cKeyListener();
    }

    protected DragGestureListener createDragGestureListener() {
        return new cDragGestureListener();
    }

    protected DragSourceListener createDragSourceListener() {
        return new cDragSourceListener();
    }

    protected DropTargetListener createDropTargetListener() {
        return new cDropTargetListener();
    }

    protected void createActions() {
        this.m_actCopy = this.createCopyAction();
        this.m_actPaste = this.createPasteAction();
        this.m_actPasteSpecial = this.createPasteSpecialAction();
        this.m_actExport = this.createExportAction();
        this.m_actImport = this.createImportAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actRename = this.createRenameAction();
        this.m_actRefresh = this.createRefreshAction();
        this.m_actPopup = this.createPopupAction();
        this.m_actDefault = this.createDefaultAction();
    }

    protected void createKeyActionMappings() {
        this.getInputMap().put(KeyStroke.getKeyStroke(121, 64, false), "popup");
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 128, false), "copy");
        this.getInputMap().put(KeyStroke.getKeyStroke(86, 128, false), "paste");
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 128, false), "copy");
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 64, false), "paste");
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 0, false), "rename");
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0, false), "delete");
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "default");
        this.getActionMap().put("popup", this.m_actPopup);
        this.getActionMap().put("copy", this.m_actCopy);
        this.getActionMap().put("paste", this.m_actPaste);
        this.getActionMap().put("pastespecial", this.m_actPasteSpecial);
        this.getActionMap().put("export", this.m_actExport);
        this.getActionMap().put("import", this.m_actImport);
        this.getActionMap().put("rename", this.m_actRename);
        this.getActionMap().put("delete", this.m_actDelete);
        this.getActionMap().put("default", this.m_actDefault);
    }

    protected WsAbstractAction createCopyAction() {
        return new cCopyAction();
    }

    protected WsAbstractAction createPasteAction() {
        return new cPasteAction();
    }

    protected WsAbstractAction createPasteSpecialAction() {
        return new cPasteSpecialAction();
    }

    protected WsAbstractAction createExportAction() {
        return new cExportAction();
    }

    protected WsAbstractAction createImportAction() {
        return new cImportAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createRenameAction() {
        return new cRenameAction();
    }

    protected WsAbstractAction createRefreshAction() {
        return new cRefreshAction();
    }

    protected WsAbstractAction createPopupAction() {
        return new cPopupAction();
    }

    protected WsAbstractAction createDefaultAction() {
        return new cDefaultAction();
    }

    public void initialize() {
        WorkspaceTreeModel model = this.createModel(this.createRootNode());
        WsTreeNode nodeRoot = (WsTreeNode)model.getRoot();
        nodeRoot.expand();
        nodeRoot.setIsExpanded(true);
        this.setModel(model);
        this.setSelectionPath(new TreePath(nodeRoot));
    }

    public void dispose() {
        TreeModel model = this.getModel();
        if (model instanceof WorkspaceTreeModel) {
            ((WorkspaceTreeModel)model).dispose();
        }
    }

    protected WorkspaceTreeModel createModel(WsTreeNode nodeRoot) {
        return new WorkspaceTreeModel(nodeRoot);
    }

    protected WsTreeNode createRootNode() {
        return new cRootNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            WorkspaceTreeModel model = (WorkspaceTreeModel)this.getModel();
            WsTreeNode nodeNewRoot = (WsTreeNode)model.getRoot();
            WsTreeNode nodeOldRoot = (WsTreeNode)nodeNewRoot.clone();
            model.removeAllChildren(nodeNewRoot);
            nodeNewRoot.setHasExpanded(false);
            this.refreshNode(nodeNewRoot, nodeOldRoot);
        }
        finally {
            Workspace.getWorkspace().setCursor(null);
        }
    }

    protected void refreshNode(WsTreeNode nodeNew, WsTreeNode nodeOld) {
        if (nodeOld.hasExpanded()) {
            nodeNew.expand();
            int nOldChildren = nodeOld.getChildCount();
            int nNewChildren = nodeNew.getChildCount();
            block0: for (int iOldChild = 0; iOldChild < nOldChildren; ++iOldChild) {
                WsTreeNode nodeOldChild = (WsTreeNode)nodeOld.getChildAt(iOldChild);
                for (int iNewChild = 0; iNewChild < nNewChildren; ++iNewChild) {
                    WsTreeNode nodeNewChild = (WsTreeNode)nodeNew.getChildAt(iNewChild);
                    if (!nodeOldChild.equals(nodeNewChild)) continue;
                    this.refreshNode(nodeNewChild, nodeOldChild);
                    continue block0;
                }
            }
        }
        if (nodeOld.isExpanded()) {
            this.expandPath(new TreePath(nodeNew.getPath()));
        }
    }

    public void dump() {
        this.dumpNode((WsTreeNode)this.getModel().getRoot());
    }

    protected void dumpNode(WsTreeNode node) {
        String sNode = node.getName();
        if (node.hasExpanded()) {
            sNode = sNode + ", hasExpanded";
        }
        if (node.isExpanded()) {
            sNode = sNode + ", isExpanded";
        }
        Workspace.getDefaultLogger().debug(this.m_sPad + sNode);
        int nChildren = node.getChildCount();
        this.m_sPad = this.m_sPad + "   ";
        for (int iChild = 0; iChild < nChildren; ++iChild) {
            this.dumpNode((WsTreeNode)node.getChildAt(iChild));
        }
        this.m_sPad = this.m_sPad.substring(3);
    }

    public static WsDataTreeNode createDataTreeNode(CMetadata oMetadata, String sClassPrefix, String sClassPostfix) {
        if (sClassPrefix == null) {
            sClassPrefix = "";
        }
        if (sClassPostfix == null) {
            sClassPostfix = "";
        }
        WsDataTreeNode node = null;
        Class[] aClasses = new Class[]{oMetadata.getClass()};
        Object[] aObjects = new Object[]{oMetadata};
        try {
            String sType = oMetadata.getCMetadataType();
            boolean fFound = false;
            ArrayList plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.workspace.plugins.TreeNodeInterface");
            for (int i = 0; i < plugins.size(); ++i) {
                TreeNodeInterface plugin = (TreeNodeInterface)plugins.get(i);
                String type = plugin.getCMetadataType();
                if (!sType.equals(type)) continue;
                fFound = true;
                node = plugin.getDataTreeNode(oMetadata);
            }
            if (!fFound) {
                Class<?> clsNode = Class.forName(sClassPrefix + sType + sClassPostfix);
                node = (WsDataTreeNode)Workspace.getMdFactory().getUtil().findValidConstructor(clsNode, aClasses).newInstance(aObjects);
            }
        }
        catch (Exception e) {
            try {
                Class<?> clsNode = Class.forName(sClassPrefix + "General" + sClassPostfix);
                node = (WsDataTreeNode)Workspace.getMdFactory().getUtil().findValidConstructor(clsNode, aClasses).newInstance(aObjects);
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error("Unable to create general tree node: " + sClassPrefix + "General" + sClassPostfix);
                node = new WsDataTreeNode(oMetadata);
            }
        }
        return node;
    }

    @Override
    public void removeAll() {
        this.m_treeScrollPane.removeAll();
        this.m_treeScrollPane = null;
    }

    public void enablePopupMenus(boolean bPopupMenusEnabled) {
        this.setPopupMenusEnabled(bPopupMenusEnabled);
    }

    public void setPopupMenusEnabled(boolean bPopupMenusEnabled) {
        this.m_bPopupMenusEnabled = bPopupMenusEnabled;
    }

    public boolean isPopupMenusEnabled() {
        return this.m_bPopupMenusEnabled;
    }

    public void setDefaultActionEnabled(boolean bEnabled) {
        this.m_bDefaultActionEnabled = bEnabled;
    }

    public boolean isDefaultActionEnabled() {
        return this.m_bDefaultActionEnabled;
    }

    public void setUserDefaultAction(Action actDefault) {
        this.m_actUserDefault = actDefault;
    }

    public Action getUserDefaultAction() {
        return this.m_actUserDefault;
    }

    public void setAddingMemberNodes(boolean bAddingMemberNodes) {
        this.m_bAddingMemberNodes = bAddingMemberNodes;
    }

    public boolean isAddingMemberNodes() {
        return this.m_bAddingMemberNodes;
    }

    public void setShowCheckout(boolean bShowCheckout) {
        this.m_bShowCheckout = bShowCheckout;
    }

    public boolean isShowingCheckout() {
        return this.m_bShowCheckout;
    }

    public void enableDragging(boolean bEnabled) {
        this.setDraggingEnabled(bEnabled);
    }

    public void setDraggingEnabled(boolean bEnabled) {
        this.m_bDraggingEnabled = bEnabled;
    }

    public boolean isDraggingEnabled() {
        return this.m_bDraggingEnabled;
    }

    public void enableDropping(boolean bEnabled) {
        this.setDroppingEnabled(bEnabled);
    }

    public void setDroppingEnabled(boolean bEnabled) {
        this.m_dropTarget.setActive(bEnabled);
    }

    public boolean isDroppingEnabled() {
        return this.m_dropTarget.isActive();
    }

    public void enableToolTips(boolean bEnabled) {
        this.setToolTipsEnabled(bEnabled);
    }

    public void setToolTipsEnabled(boolean bEnabled) {
        if (this.m_bToolTipsEnabled != bEnabled) {
            this.m_bToolTipsEnabled = bEnabled;
            if (bEnabled) {
                ToolTipManager.sharedInstance().registerComponent(this);
            } else {
                ToolTipManager.sharedInstance().unregisterComponent(this);
            }
        }
    }

    public boolean isToolTipsEnabled() {
        return this.m_bToolTipsEnabled;
    }

    public void setListenForChanges(boolean bListenForChanges) {
        ((WorkspaceTreeModel)this.getModel()).setListenForChanges(bListenForChanges);
    }

    public boolean isListenForChanges() {
        return ((WorkspaceTreeModel)this.getModel()).isListenForChanges();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_bActive = bActive;
        if (this.m_nodeActive != null) {
            this.m_nodeActive.updateWorkspaceUIComponents(bActive);
        }
        this.m_actCopy.setActive(bActive);
        this.m_actPaste.setActive(bActive);
        this.m_actPasteSpecial.setActive(bActive);
        this.m_actExport.setActive(bActive);
        this.m_actImport.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actRename.setActive(bActive);
        this.m_actRefresh.setActive(bActive);
    }

    protected void updateActions() {
        boolean bAllDeleteable = true;
        boolean bRenameable = false;
        WsTreeNode[] aNodes = this.getSelectedNodes();
        int nNodes = aNodes.length;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            if (aNodes[iNode].isDeleteable()) continue;
            bAllDeleteable = false;
        }
        if (nNodes == 0) {
            bAllDeleteable = false;
        }
        if (nNodes == 1) {
            this.setActiveNode(aNodes[0]);
            bRenameable = aNodes[0].isRenameable();
        } else {
            this.setActiveNode(null);
        }
        this.m_actCopy.setEnabled(false);
        this.m_actPaste.setEnabled(false);
        this.m_actPasteSpecial.setEnabled(false);
        this.m_actExport.setEnabled(false);
        this.m_actImport.setEnabled(false);
        this.m_actRename.setEnabled(bRenameable && this.isEditable());
        this.m_actDelete.setEnabled(bAllDeleteable && this.isEditable());
    }

    protected void setActiveNode(WsTreeNode nodeActive) {
        if (this.m_nodeActive != nodeActive) {
            if (this.m_nodeActive != null && this.m_bActive) {
                this.m_nodeActive.updateWorkspaceUIComponents(false);
            }
            WsTreeNode nodeOldActive = this.m_nodeActive;
            this.m_nodeActive = nodeActive;
            if (this.m_nodeActive != null && this.m_bActive) {
                this.m_nodeActive.updateWorkspaceUIComponents(true);
            }
            this.firePropertyChange(ACTIVE_NODE_PROPERTY, nodeOldActive, nodeActive);
        }
    }

    protected WsTreeNode getActiveNode() {
        return this.m_nodeActive;
    }

    public ArrayList getAncestorTrees(Tree oTreeObject) {
        return new ArrayList();
    }

    public JScrollPane getTreeScrollPane() {
        return this.m_treeScrollPane;
    }

    public void setSelectedData(Root mdo) throws MdException, RemoteException {
        WsDataTreeNode node = ((WorkspaceTreeModel)this.getModel()).find(mdo);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    public void addSelectedData(Root mdo) throws MdException, RemoteException {
        WsDataTreeNode node = ((WorkspaceTreeModel)this.getModel()).find(mdo);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.addSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    public Root getSelectedData() throws MdException, RemoteException {
        WsTreeNode[] aNodes = this.getSelectedNodes();
        if (aNodes.length == 1 && aNodes[0] instanceof WsDataTreeNode) {
            return (Root)((WsDataTreeNode)aNodes[0]).getMetadata();
        }
        return null;
    }

    public WsTreeNode getSelectedNode() {
        return (WsTreeNode)this.getLastSelectedPathComponent();
    }

    public WsTreeNode[] getSelectedNodes() {
        TreePath[] aSelectedPaths = super.getSelectionPaths();
        int nSelectedPaths = aSelectedPaths == null ? 0 : aSelectedPaths.length;
        WsTreeNode[] aSelectedNodes = new WsTreeNode[nSelectedPaths];
        for (int iSelectedPath = 0; iSelectedPath < nSelectedPaths; ++iSelectedPath) {
            aSelectedNodes[iSelectedPath] = (WsTreeNode)aSelectedPaths[iSelectedPath].getLastPathComponent();
        }
        return aSelectedNodes;
    }

    public List getVectorOfRepositories() {
        if (this.m_vRepositories == null) {
            this.m_vRepositories = Workspace.getWorkspace().getSelectedRepositories();
        }
        return this.m_vRepositories;
    }

    public void setVectorOfRepositories(Vector vRepositories) {
        this.m_vRepositories = vRepositories;
    }

    public void showPopupMenu(MouseEvent e) {
        JPopupMenu menuPopup;
        if (!this.m_bPopupMenusEnabled) {
            return;
        }
        WsTreeNode[] aSelectedNodes = this.getSelectedNodes();
        if (aSelectedNodes.length == 1) {
            menuPopup = aSelectedNodes[0].getPopupMenu(bundle);
            if (aSelectedNodes[0] instanceof WsDataTreeNode) {
                ((WsDataTreeNode)aSelectedNodes[0]).addPluginMenuItems(menuPopup);
            }
        } else {
            menuPopup = new JPopupMenu();
        }
        this.addPluginMenuItems(menuPopup, aSelectedNodes);
        this.addPopupMenuItems(menuPopup, aSelectedNodes);
        WsUIUtilities.preparePopupMenuForCleanUp(menuPopup);
        if (menuPopup.getComponentCount() != 0) {
            menuPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void addPopupMenuItems(JPopupMenu menuPopup, WsTreeNode[] aNodes) {
        if (this.isEditable() && aNodes.length >= 1) {
            if (menuPopup.getComponentCount() != 0) {
                menuPopup.add(new JSeparator());
            }
            menuPopup.add(new JMenuItem(this.m_actCopy));
            menuPopup.add(new JMenuItem(this.m_actPaste));
            menuPopup.add(new JMenuItem(this.m_actPasteSpecial));
            menuPopup.add(new JMenuItem(this.m_actRename));
            menuPopup.add(new JMenuItem(this.m_actDelete));
            menuPopup.add(new JSeparator());
            menuPopup.add(new JMenuItem(this.m_actExport));
            menuPopup.add(new JMenuItem(this.m_actImport));
        }
        if (menuPopup.getComponentCount() != 0) {
            menuPopup.add(new JSeparator());
        }
        menuPopup.add(new JMenuItem(this.m_actRefresh));
    }

    protected void addPluginMenuItems(JPopupMenu menuPopup, WsTreeNode[] aNodes) {
        PluginLoader pluginLoader = Workspace.getWorkspace().getPluginLoader();
        if (pluginLoader == null) {
            return;
        }
        boolean bAddSeparator = menuPopup.getComponentCount() > 0;
        ArrayList alPlugins = pluginLoader.getPlugins("com.sas.workspace.plugins.WorkspaceTreeContextMenuPluginInterface", true);
        int nPlugins = alPlugins.size();
        for (int iPlugin = 0; iPlugin < nPlugins; ++iPlugin) {
            WorkspaceTreeContextMenuPluginInterface plugin = (WorkspaceTreeContextMenuPluginInterface)alPlugins.get(iPlugin);
            JMenuItem[] aMenuItems = plugin.getMenuItems(aNodes);
            if (aMenuItems == null) continue;
            int nMenuItems = aMenuItems.length;
            for (int iMenuItem = 0; iMenuItem < nMenuItems; ++iMenuItem) {
                if (bAddSeparator) {
                    menuPopup.addSeparator();
                    bAddSeparator = false;
                }
                if (aMenuItems[iMenuItem].getIcon() == null) {
                    aMenuItems[iMenuItem].setIcon(bundle.getImageIcon("Common.EmptyIcon.image"));
                }
                menuPopup.add(aMenuItems[iMenuItem]);
            }
        }
    }

    public void onRename() {
        this.startEditingAtPath(this.getSelectionPath());
    }

    public void onCopy() {
    }

    public void onPaste() {
    }

    public void onPasteSpecial() {
    }

    public void onExport() {
    }

    public void onImport() {
    }

    public void onDelete() {
        String sNames;
        WsTreeNode[] aNodes = this.getSelectedNodes();
        if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoDelete.Text.fmt")) {
            return;
        }
        if (!this.areNodesReallyDeleteable(aNodes)) {
            return;
        }
        if (aNodes.length == 1) {
            sNames = aNodes[0].getName();
        } else if (aNodes.length == 2) {
            sNames = bundle.formatString("Common.TwoNames.fmt", aNodes[0].getName(), aNodes[1].getName());
        } else {
            int iNode;
            sNames = "";
            int nNodes = Math.min(aNodes.length, 20);
            for (iNode = 0; iNode < nNodes - 1; ++iNode) {
                sNames = bundle.formatString("Common.ConcatenateNames.fmt", sNames, aNodes[iNode].getName());
            }
            sNames = nNodes < aNodes.length ? bundle.formatString("Common.AndOthers.fmt", sNames) : bundle.formatString("Common.LastName.fmt", sNames, aNodes[iNode].getName());
        }
        int eAnswer = MessageUtil.displayMessage(bundle.formatString("Common.ConfirmDelete.Text.txt", sNames), bundle.getString("Common.ConfirmDelete.Title.txt"), 1, 0);
        if (eAnswer == 0) {
            OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), bundle.getString("WorkspaceTree.DeleteProgressIndicator.MessagePrototype.txt"), bundle.getString("WorkspaceTree.DeleteProgressIndicator.Title.txt"));
            request.setDelayBeforeProgressCancelDialog(200);
            request.executeWithCancel(this.createDeleteOperation(aNodes, request));
            Workspace.getDefaultLogger().debug("Finished waiting on delete");
        }
    }

    protected OpRequestUICancellableRunnable createDeleteOperation(WsTreeNode[] aNodes, OpRequestUI opUI) {
        return new DeleteOperation(aNodes, opUI);
    }

    protected boolean isAnyObjectInUse(WsTreeNode[] aNodes, String sMessageKey) {
        int nNodes = aNodes.length;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            if (aNodes[iNode] == null || !WsLockManager.getInstance().isLocked(aNodes[iNode].getFQID())) continue;
            String message = bundle.formatString(sMessageKey, aNodes[iNode].getName());
            MessageUtil.displayMessage(message, 2);
            return true;
        }
        return false;
    }

    public boolean areNodesReallyDeleteable(WsTreeNode[] aNodes) {
        int nNodes = aNodes.length;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            if (aNodes[iNode].isReallyDeleteable()) continue;
            return false;
        }
        return true;
    }

    public void onRefresh() {
        this.refresh();
    }

    public boolean isObjectEditable(CMetadata object) {
        return true;
    }

    public boolean isDraggingOver() {
        return this.m_bDraggingOver;
    }

    protected class cTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Icon m_iconCheckedOut;
        protected Icon m_iconEmptyFiller;
        protected Icon m_iconFetched;
        protected Icon m_iconOpen;
        protected Icon m_iconClosed;
        protected Icon m_iconLeaf;
        protected Icon[] m_aIcons = new Icon[2];

        public cTreeCellRenderer() {
            this.m_iconCheckedOut = bundle.getImageIcon("Common.CheckedOutCheck.image");
            this.m_iconEmptyFiller = bundle.getImageIcon("Common.EmptyIcon.image");
            this.m_iconFetched = bundle.getImageIcon("Common.Fetched.image");
            this.m_iconOpen = Resources.getImageIcon((String)bundle.getString("Common.OpenedTree.image"), (int)16);
            this.m_iconClosed = Resources.getImageIcon((String)bundle.getString("Common.ClosedTree.image"), (int)16);
            this.m_iconLeaf = bundle.getImageIcon("Common.DefaultLeaf.image");
        }

        protected Icon createCompoundIcon(Icon icon1, Icon icon2) {
            this.m_aIcons[0] = icon1;
            this.m_aIcons[1] = icon2;
            WsCompoundIcon iconCompound = new WsCompoundIcon(this.m_aIcons);
            iconCompound.setIconGap(-8);
            iconCompound.setReverseOrder(true);
            return iconCompound;
        }

        protected Icon getNodeIcon(WsTreeNode node) {
            Icon icon = node.getIcon(node.isExpanded());
            if (icon == null) {
                icon = node.isLeaf() ? this.m_iconLeaf : (node.isExpanded() ? this.m_iconOpen : this.m_iconClosed);
            }
            if (WorkspaceTree.this.m_bShowCheckout) {
                CMetadata oData = node.getMetadata();
                icon = WAdminResource.getCMTypeIcon(oData, icon, true);
            }
            return icon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean bHasFocus) {
            String sToolTip;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, bHasFocus);
            if (!(value instanceof WsTreeNode)) {
                return this;
            }
            WsTreeNode node = (WsTreeNode)value;
            Icon icon = this.getNodeIcon(node);
            if (icon != null) {
                this.setIcon(icon);
            }
            if ((sToolTip = node.getToolTip()) != null) {
                this.setToolTipText(sToolTip);
            }
            return this;
        }
    }

    protected class cCellEditor
    extends DefaultTreeCellEditor {
        private WATextField m_txtEditor;

        public cCellEditor(JTree atree, DefaultTreeCellRenderer arenderer) {
            super(atree, arenderer);
        }

        @Override
        protected void determineOffset(JTree atree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (this.renderer instanceof cTreeCellRenderer && value instanceof WsTreeNode) {
                this.editingIcon = ((cTreeCellRenderer)this.renderer).getNodeIcon((WsTreeNode)value);
                this.offset = this.renderer.getIconTextGap() + this.editingIcon.getIconWidth();
            } else {
                super.determineOffset(atree, value, isSelected, expanded, leaf, row);
            }
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (WorkspaceTree.this.m_bDragging) {
                return false;
            }
            if (!WorkspaceTree.this.isEditable()) {
                return false;
            }
            if (!WorkspaceTree.this.m_actRename.isEnabled()) {
                return false;
            }
            return super.isCellEditable(e);
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            this.m_txtEditor = new WATextField();
            this.m_txtEditor.setMaxCharacters(60);
            this.m_txtEditor.setBorder(UIManager.getBorder("Tree.editorBorder"));
            DefaultCellEditor editor = new DefaultCellEditor(this.m_txtEditor){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean stopCellEditing() {
                    TreePath path = WorkspaceTree.this.getEditingPath();
                    WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                    if (!node.isValidName(cCellEditor.this.m_txtEditor.getText())) {
                        return false;
                    }
                    return super.stopCellEditing();
                }
            };
            editor.setClickCountToStart(1);
            return editor;
        }
    }

    protected class cCellEditorListener
    implements CellEditorListener {
        protected cCellEditorListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
        }
    }

    public class cMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        protected void handlePopupTriggers(MouseEvent e) {
            TreePath path;
            if (!(e.isShiftDown() || e.isControlDown() || WorkspaceTree.this.isPathSelected(path = WorkspaceTree.this.getPathForLocation(e.getX(), e.getY())))) {
                WorkspaceTree.this.setSelectionPath(path);
            }
            WorkspaceTree.this.showPopupMenu(e);
        }
    }

    public class cSelectListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            WorkspaceTree.this.updateActions();
        }
    }

    public class cExpansionListener
    implements TreeExpansionListener {
        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            WsTreeNode nodeCurrent = (WsTreeNode)e.getPath().getLastPathComponent();
            nodeCurrent.setIsExpanded(true);
            if (nodeCurrent.hasExpanded()) {
                return;
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            try {
                nodeCurrent.expand();
            }
            finally {
                Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            WsTreeNode nodeCurrent = (WsTreeNode)e.getPath().getLastPathComponent();
            nodeCurrent.setIsExpanded(false);
        }
    }

    public class cKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
        }
    }

    protected class cDragGestureListener
    implements DragGestureListener {
        protected cDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            if (!WorkspaceTree.this.m_bDraggingEnabled) {
                return;
            }
            if (WorkspaceTree.this.isEditing()) {
                return;
            }
            WsTreeNode[] aSelectedNodes = WorkspaceTree.this.getSelectedNodes();
            if (aSelectedNodes.length != 0) {
                DNDObject oDrag = new DNDObject();
                int nSelectedNodes = aSelectedNodes.length;
                for (int iSelectedNode = 0; iSelectedNode < nSelectedNodes; ++iSelectedNode) {
                    if (!aSelectedNodes[iSelectedNode].isDragSource()) {
                        return;
                    }
                    CMetadata oMetadata = aSelectedNodes[iSelectedNode].getMetadata();
                    if (oMetadata == null) continue;
                    oDrag.add(oMetadata);
                }
                WorkspaceTree.this.m_dragSource.startDrag(event, null, oDrag, WorkspaceTree.this.createDragSourceListener());
                WorkspaceTree.this.m_bDragging = true;
            }
        }
    }

    protected class cDragSourceListener
    implements DragSourceListener {
        protected cDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            WorkspaceTree.this.m_bDragging = false;
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    protected class cDropTargetListener
    implements DropTargetListener {
        protected boolean m_bFirstDragOver;
        protected TreePath[] m_aOriginalSelectedPaths;

        protected cDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            WorkspaceTree.this.m_bDraggingOver = true;
            if (!WorkspaceTree.this.isEditable()) {
                e.rejectDrag();
                return;
            }
            this.m_aOriginalSelectedPaths = WorkspaceTree.this.getSelectionPaths();
            Point pt = e.getLocation();
            TreePath path = WorkspaceTree.this.getPathForLocation(pt.x, pt.y);
            if (!WorkspaceTree.this.isPathSelected(path)) {
                WorkspaceTree.this.setSelectionPath(path);
            }
            if (path == null) {
                e.rejectDrag();
            } else {
                WsTreeNode node = WorkspaceTree.this.getSelectedNode();
                if (node.isDropTarget(e)) {
                    e.acceptDrag(e.getSourceActions());
                } else {
                    e.rejectDrag();
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            WorkspaceTree.this.m_bDraggingOver = false;
            WorkspaceTree.this.setSelectionPaths(this.m_aOriginalSelectedPaths);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (!WorkspaceTree.this.isEditable()) {
                e.rejectDrag();
                return;
            }
            WsUIUtilities.autoscrollForDragEvent(e);
            Point pt = e.getLocation();
            TreePath path = WorkspaceTree.this.getPathForLocation(pt.x, pt.y);
            if (!WorkspaceTree.this.isPathSelected(path)) {
                WorkspaceTree.this.setSelectionPath(path);
            }
            if (path == null) {
                e.rejectDrag();
            } else {
                WsTreeNode node = WorkspaceTree.this.getSelectedNode();
                if (node.isDropTarget(e)) {
                    e.acceptDrag(e.getSourceActions());
                } else {
                    e.rejectDrag();
                }
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (!WorkspaceTree.this.isEditable()) {
                e.rejectDrop();
                WorkspaceTree.this.m_bDraggingOver = false;
                return;
            }
            Point pt = e.getLocation();
            TreePath path = WorkspaceTree.this.getPathForLocation(pt.x, pt.y);
            if (!WorkspaceTree.this.isPathSelected(path)) {
                WorkspaceTree.this.setSelectionPath(path);
            }
            if (path == null) {
                e.rejectDrop();
            } else {
                WsTreeNode node = WorkspaceTree.this.getSelectedNode();
                if (node.isDropTarget(e)) {
                    e.acceptDrop(e.getSourceActions());
                    node.drop(e);
                    e.dropComplete(true);
                } else {
                    e.rejectDrop();
                }
            }
            WorkspaceTree.this.m_bDraggingOver = false;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    protected class cCopyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCopyAction() {
            super(bundle, "Tree.PopupMenu.Copy", true);
            this.setMenuSupportId("copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onCopy();
        }
    }

    protected class cPasteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPasteAction() {
            super(bundle, "Tree.PopupMenu.Paste", true);
            this.setMenuSupportId("paste");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onPaste();
        }
    }

    protected class cPasteSpecialAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPasteSpecialAction() {
            super(bundle, "Tree.PopupMenu.PasteSpecial", false);
            this.setMenuSupportId("pastespecial");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onPasteSpecial();
        }
    }

    protected class cExportAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cExportAction() {
            super(bundle, "Tree.PopupMenu.Export", true);
            this.setMenuSupportId("export");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onExport();
        }
    }

    protected class cImportAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cImportAction() {
            super(bundle, "Tree.PopupMenu.Import", true);
            this.setMenuSupportId("import");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onImport();
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cDeleteAction() {
            super(bundle, "Tree.PopupMenu.Delete", true);
            this.setMenuSupportId("delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onDelete();
        }
    }

    protected class cRenameAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cRenameAction() {
            super(bundle, "Tree.PopupMenu.Rename");
            this.setMenuSupportId("rename");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onRename();
        }
    }

    protected class cRefreshAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cRefreshAction() {
            super(bundle, "Tree.PopupMenu.Refresh", true);
            this.setMenuSupportId("refresh");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTree.this.onRefresh();
        }
    }

    protected class cPopupAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        protected cPopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point pt = WorkspaceTree.this.getPathBounds(WorkspaceTree.this.getLeadSelectionPath()).getLocation();
            MouseEvent me = new MouseEvent(WorkspaceTree.this, 501, 0L, 0, pt.x, pt.y, 1, true);
            WorkspaceTree.this.showPopupMenu(me);
        }
    }

    protected class cDefaultAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        protected cDefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTreeNode[] aNodes = WorkspaceTree.this.getSelectedNodes();
            if (aNodes.length == 1) {
                if (aNodes[0].isExpanded()) {
                    WorkspaceTree.this.collapsePath(new TreePath(aNodes[0].getPath()));
                } else {
                    WorkspaceTree.this.expandPath(new TreePath(aNodes[0].getPath()));
                }
                if (aNodes[0].isLeaf()) {
                    if (WorkspaceTree.this.m_actUserDefault != null) {
                        if (WorkspaceTree.this.m_actUserDefault.isEnabled()) {
                            WorkspaceTree.this.m_actUserDefault.actionPerformed(e);
                        }
                    } else if (WorkspaceTree.this.isDefaultActionEnabled()) {
                        aNodes[0].doDefaultAction();
                    }
                }
            }
        }
    }

    protected class cRootNode
    extends WsTreeNode {
        private static final long serialVersionUID = 1L;

        public cRootNode() {
            super(bundle.getString("Common.Repositories.txt"));
            this.setDragSource(false);
        }

        @Override
        public void addChildren() {
            List vRepositories = WorkspaceTree.this.getVectorOfRepositories();
            int nRepositories = vRepositories.size();
            for (int iRepository = 0; iRepository < nRepositories; ++iRepository) {
                CMetadata oRepository = (CMetadata)vRepositories.get(iRepository);
                if (!this.isRepositoryIncluded(oRepository)) continue;
                this.addChild(this.createChild(oRepository));
            }
        }

        protected boolean isRepositoryIncluded(CMetadata oMetadata) {
            return true;
        }

        @Override
        public void addChild(WsTreeNode nodeChild) {
            this.getTreeModel().addChild(nodeChild, this);
            nodeChild.addChildren();
            nodeChild.setHasExpanded(true);
        }

        @Override
        public WsTreeNode createChild(CMetadata oMetadata) {
            return new cRepositoryNode(oMetadata);
        }

        @Override
        public boolean isValidAncestorFor(CMetadata oMetadata) {
            return true;
        }
    }

    private class DeleteOperation
    extends WsAbstractOperation {
        private OpRequestUI m_opUI;
        private WsTreeNode[] m_aDeleteNodes;

        public DeleteOperation(WsTreeNode[] aNodes, OpRequestUI opUI) {
            super(opUI);
            this.m_aDeleteNodes = aNodes;
            this.m_opUI = opUI;
        }

        @Override
        public void run() {
            Integer nNodes = new Integer(this.m_aDeleteNodes.length);
            for (int iNode = 0; iNode < this.m_aDeleteNodes.length && !this.isOperationCancelled(); ++iNode) {
                this.m_opUI.setMessage(bundle.formatString("WorkspaceTree.DeleteProgressIndicator.Message.fmt.txt", new Integer(iNode + 1), nNodes));
                this.m_aDeleteNodes[iNode].delete();
            }
        }
    }

    protected class cRepositoryNode
    extends WsDataTreeNode {
        private static final long serialVersionUID = 1L;

        public cRepositoryNode(CMetadata oRepository) {
            super(oRepository);
            this.setDragSource(false);
        }

        @Override
        public boolean isValidAncestorFor(CMetadata oMetadata) {
            try {
                return this.getFQID().substring(9).equals(oMetadata.getRepositoryID());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
                return false;
            }
        }
    }
}

