/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.AppServerPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class WorkspaceFile {
    private static WAdminResource bundle = WAdminResource.getBundle(WorkspaceFile.class);
    protected boolean m_bWorkspaceFileOpen = false;
    protected String m_strFileName;
    protected Properties m_properties;
    protected Vector propChangeListeners = new Vector();
    public static final String USERID = "userid";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String APPHOST = "apphost";
    public static final String APPPORT = "appport";
    public static final String APPUSERID = "appuserid";
    public static final String APPPASSWORD = "apppassword";
    public static final String AUTHENTICATIONDOMAIN = "authenticationdomain";
    public static final String SINGLESIGNON = "SingleSignOn";
    public static final String SECURITYPACKAGE = "SecurityPackage";
    public static final String SERVICEPRINCIPALNAME = "ServicePrincipalName";
    public static final String SECURITYPACKAGELIST = "SecurityPackageList";
    public static final String ALLOWLOCALPASSWORDS = "AllowLocalPasswords";
    public static final String INTERNALACCOUNT = "InternalAccount";
    public static final String NOREDIRECT = "Noredirect";
    public static final String ALLOWCLUSTERUPDATE = "AllowClusterUpdate";
    public static final String TENANT = "Tenant";

    public WorkspaceFile() {
        this.m_properties = new Properties();
    }

    public WorkspaceFile(String filepath) {
        this.m_properties = new Properties();
        this.m_strFileName = filepath;
        this.openExisting(this.m_strFileName);
    }

    public void setPropertyString(String strKeyName, String strValue) {
        WorkspaceFile wsf;
        String defaultServerID = AppServerPanel.DefaultServerId;
        if (strKeyName.equals(defaultServerID) && this != (wsf = Workspace.getWorkspace().getWorkspaceFile())) {
            wsf.setPropertyString(defaultServerID, strValue);
            wsf.saveExisting();
            return;
        }
        this.m_properties.setProperty(strKeyName, strValue);
        this.notifyPropertyChange(strKeyName, null, strValue);
    }

    public boolean isOpen() {
        return this.m_bWorkspaceFileOpen;
    }

    public String getPropertyString(String strKeyName) {
        WorkspaceFile wsf;
        String defaultServerID = AppServerPanel.DefaultServerId;
        if (strKeyName.equals(defaultServerID) && this != (wsf = Workspace.getWorkspace().getWorkspaceFile())) {
            return wsf.getPropertyString(defaultServerID);
        }
        try {
            String strValue = this.m_properties.getProperty(strKeyName);
            if (strValue == null) {
                return "";
            }
            return strValue;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            return "";
        }
    }

    public String getPropertyString(String sKey, String sDefault) {
        WorkspaceFile wsf;
        String defaultServerID = AppServerPanel.DefaultServerId;
        if (sKey.equals(defaultServerID) && this != (wsf = Workspace.getWorkspace().getWorkspaceFile())) {
            return wsf.getPropertyString(defaultServerID);
        }
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue == null) {
            this.setPropertyString(sKey, sDefault);
            sValue = sDefault;
        }
        return sValue;
    }

    public int getPropertyInt(String sKey, int iDefault) {
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue != null && sValue.length() != 0) {
            return Integer.parseInt(sValue);
        }
        this.setPropertyInt(sKey, iDefault);
        return iDefault;
    }

    public void setPropertyInt(String sKey, int iValue) {
        this.m_properties.setProperty(sKey, Integer.toString(iValue));
        this.notifyPropertyChange(sKey, null, new Integer(iValue));
    }

    public boolean getPropertyBoolean(String sKey, boolean bDefault) {
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue != null && sValue.length() != 0) {
            return Boolean.valueOf(sValue);
        }
        this.setPropertyBoolean(sKey, bDefault);
        return bDefault;
    }

    public void setPropertyBoolean(String sKey, boolean bValue) {
        this.m_properties.setProperty(sKey, new Boolean(bValue).toString());
        this.notifyPropertyChange(sKey, null, new Boolean(bValue));
    }

    public void removeProperty(String sKey) {
        this.m_properties.remove(sKey);
    }

    public void closeExisting() {
        if (this.m_bWorkspaceFileOpen) {
            this.m_properties.clear();
            this.m_bWorkspaceFileOpen = false;
            this.m_strFileName = null;
        }
    }

    public boolean saveExisting() {
        boolean fSuccess = false;
        if (this.m_bWorkspaceFileOpen) {
            fSuccess = true;
            try {
                FileOutputStream output = new FileOutputStream(this.m_strFileName);
                String strHeader = "Properties file updated on: " + new Date() + "  !!!!! DO NOT EDIT !!!!!!!";
                this.m_properties.store(output, strHeader);
                output.close();
            }
            catch (FileNotFoundException ex) {
                Workspace.getDefaultLogger().error("Workspace file " + this.m_strFileName + " not found.");
                return false;
            }
            catch (IOException ex) {
                Workspace.getDefaultLogger().error("Workspace file " + this.m_strFileName + " IO Exception.");
                return false;
            }
        }
        return fSuccess;
    }

    public boolean openExisting(String strFileName) {
        boolean fOK = true;
        if (this.m_bWorkspaceFileOpen) {
            this.m_properties.clear();
        }
        this.m_strFileName = strFileName;
        fOK = this.readSource(this.m_strFileName);
        if (fOK) {
            this.m_bWorkspaceFileOpen = true;
        }
        return fOK;
    }

    public String getFileName() {
        return this.m_strFileName;
    }

    public void setFileName(String file) {
        this.m_strFileName = file;
    }

    protected boolean readSource(String strFile) {
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(strFile);
            }
            catch (FileNotFoundException e) {
                File f = new File(strFile);
                try {
                    f.createNewFile();
                }
                catch (Exception e2) {
                    Workspace.getDefaultLogger().error((Object)"", e2);
                    System.out.println("Could not create file");
                    return false;
                }
                input = new FileInputStream(strFile);
            }
            catch (SecurityException e) {
                Workspace.getDefaultLogger().error("problems reading the main file");
                return false;
            }
            this.m_properties.load(input);
            input.close();
        }
        catch (Exception e) {
            String newMessage = new String(bundle.getString("Message.WorkspaceHandler.LoadError") + "\n" + e);
            System.out.println(newMessage);
            Workspace.getDefaultLogger().error((Object)"", e);
            return false;
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.propChangeListeners.contains(l)) {
            this.propChangeListeners.addElement(l);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propChangeListeners.contains(l)) {
            this.propChangeListeners.removeElement(l);
        }
    }

    public void notifyPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener client : this.propChangeListeners) {
            client.propertyChange(evt);
        }
    }
}

