/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WizardTabInfo;
import java.util.ArrayList;

public class WATransitionWizardModel
implements WAWizardModel {
    protected ArrayList m_aoPanels = new ArrayList();
    protected cWizardPanelInfo m_CurrPanel = null;
    protected cPanelStack m_PanelPath = new cPanelStack();

    @Override
    public WizardTabInfo getCurrent() {
        if (this.m_CurrPanel != null) {
            return this.m_CurrPanel.getInfo();
        }
        return null;
    }

    @Override
    public WizardTabInfo next() {
        String sNext = this.m_CurrPanel.getTransitionToPanel();
        if (sNext == null) {
            return null;
        }
        cWizardPanelInfo panel = this.findPanel(sNext);
        if (panel == null) {
            return null;
        }
        this.m_PanelPath.push(this.m_CurrPanel);
        this.m_CurrPanel = panel;
        return panel.getInfo();
    }

    @Override
    public WizardTabInfo prev() {
        cWizardPanelInfo panel = this.m_PanelPath.pop();
        if (panel == null) {
            return null;
        }
        this.m_CurrPanel = panel;
        return panel.getInfo();
    }

    @Override
    public boolean hasPrev() {
        return !this.m_PanelPath.isEmpty();
    }

    @Override
    public boolean hasNext() {
        return this.m_CurrPanel.hasTransitions();
    }

    @Override
    public boolean canBeFinish() {
        return !this.hasNext() || this.m_CurrPanel.getInfo().canFinish();
    }

    @Override
    public void addPanel(WizardTabInfo oInfo) {
        cWizardPanelInfo Panel = new cWizardPanelInfo(oInfo);
        this.m_aoPanels.add(Panel);
        if (this.m_CurrPanel == null) {
            this.m_CurrPanel = Panel;
        }
    }

    @Override
    public WizardTabInfo[] getVisitedPanels() {
        if (this.m_CurrPanel == null) {
            return new WizardTabInfo[0];
        }
        ArrayList aoPanels = this.m_PanelPath.getStack();
        int nPanels = aoPanels.size();
        WizardTabInfo[] panels = new WizardTabInfo[nPanels + 1];
        for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
            panels[iPanel] = ((cWizardPanelInfo)aoPanels.get(iPanel)).getInfo();
        }
        panels[iPanel] = this.m_CurrPanel.getInfo();
        return panels;
    }

    public void addTransitions(String[][] aTransitions) {
        int nTransitions = aTransitions.length;
        for (int iTransition = 0; iTransition < nTransitions; ++iTransition) {
            cWizardPanelInfo Panel = this.findPanel(aTransitions[iTransition][0]);
            if (Panel == null) continue;
            Panel.addTransition(new cTransition(aTransitions[iTransition][1], aTransitions[iTransition][2]));
        }
    }

    public void addTransition(String sFromTab, String sTransition, String sToTab) {
        cWizardPanelInfo Panel = this.findPanel(sFromTab);
        if (Panel != null) {
            Panel.addTransition(new cTransition(sTransition, sToTab));
        }
    }

    public void removeTransitions(String[][] aTransitions) {
        int nTransitions = aTransitions.length;
        for (int iTransition = 0; iTransition < nTransitions; ++iTransition) {
            cWizardPanelInfo Panel = this.findPanel(aTransitions[iTransition][0]);
            if (Panel == null) continue;
            Panel.removeTransition(aTransitions[iTransition][1]);
        }
    }

    public void removeTransition(String sFromTab, String sTransition) {
        cWizardPanelInfo Panel = this.findPanel(sFromTab);
        if (Panel != null) {
            Panel.removeTransition(sTransition);
        }
    }

    protected cWizardPanelInfo findPanel(String sPanel) {
        int nPanels = this.m_aoPanels.size();
        for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
            cWizardPanelInfo Panel = (cWizardPanelInfo)this.m_aoPanels.get(iPanel);
            if (!Panel.getInfo().getTabName().equals(sPanel)) continue;
            return Panel;
        }
        return null;
    }

    public boolean isTransitionAlreadyAdded(String sTransition) {
        cWizardPanelInfo Panel = this.findPanel(sTransition);
        return Panel != null;
    }

    protected class cWizardPanelInfo {
        protected WizardTabInfo m_Info;
        protected ArrayList m_aTransitions;

        public cWizardPanelInfo(WizardTabInfo info) {
            this.m_Info = info;
            this.m_aTransitions = new ArrayList();
        }

        public WizardTabInfo getInfo() {
            return this.m_Info;
        }

        public boolean hasTransitions() {
            return this.m_aTransitions.size() != 0;
        }

        public void addTransition(cTransition oTransition) {
            this.m_aTransitions.add(oTransition);
        }

        public void removeTransition(String sTransitionState) {
            cTransition Transition = this.findTransition(sTransitionState);
            if (Transition == null) {
                return;
            }
            this.m_aTransitions.remove(Transition);
        }

        public String getTransitionToPanel() {
            cTransition Transition = this.findTransition(this.m_Info.getTab().getConditionState());
            if (Transition == null) {
                return null;
            }
            return Transition.getDest();
        }

        public cTransition findTransition(String sTransitionState) {
            int nTransitions = this.m_aTransitions.size();
            for (int iTransition = 0; iTransition < nTransitions; ++iTransition) {
                cTransition Transition = (cTransition)this.m_aTransitions.get(iTransition);
                if (!Transition.getState().equalsIgnoreCase(sTransitionState)) continue;
                return Transition;
            }
            return null;
        }
    }

    protected class cPanelStack {
        protected ArrayList m_Stack = new ArrayList();

        protected cPanelStack() {
        }

        public void push(cWizardPanelInfo oPanel) {
            this.m_Stack.add(oPanel);
        }

        public cWizardPanelInfo pop() {
            int iLastPanel = this.m_Stack.size() - 1;
            if (iLastPanel == -1) {
                return null;
            }
            cWizardPanelInfo info = (cWizardPanelInfo)this.m_Stack.get(iLastPanel);
            this.m_Stack.remove(iLastPanel);
            return info;
        }

        public boolean isEmpty() {
            return this.m_Stack.size() == 0;
        }

        public ArrayList getStack() {
            return this.m_Stack;
        }
    }

    protected class cTransition {
        String m_sState;
        String m_sDest;

        cTransition(String sState, String sDest) {
            this.m_sState = sState;
            this.m_sDest = sDest;
        }

        public String getState() {
            return this.m_sState;
        }

        public String getDest() {
            return this.m_sDest;
        }
    }
}

