/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextComponent;
import com.sas.workspace.WsBasicCaret;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsTextComponentAdapter;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import javax.swing.FocusManager;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;

public class WATextArea
extends JTextArea
implements WATextComponent {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_BEHAVIOR = 0;
    public static final int LABEL_BEHAVIOR = 1;
    public static final int NEVEREDITABLE_BEHAVIOR = 2;
    protected boolean m_bAutosize = false;
    protected boolean m_bFocusable = true;
    protected WsTextComponentAdapter m_adapter;
    protected DragSource m_dragSource;

    public WATextArea() {
        this.initialize();
    }

    public WATextArea(String text) {
        super(text);
        this.initialize();
    }

    public WATextArea(int rows, int columns) {
        super(rows, columns);
        this.initialize();
    }

    public WATextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.initialize();
    }

    protected void initialize() {
        Font fnt = this.getFont();
        this.setFont(new Font("Dialog", fnt.getStyle(), fnt.getSize()));
        this.m_adapter = new WsTextComponentAdapter(this);
        this.setUI(new cBasicTextAreaUI());
    }

    public WsTextComponentAdapter getAdapter() {
        return this.m_adapter;
    }

    public void setMaxCharacters(int maxCharacters) {
        Document doc = this.getDocument();
        if (doc instanceof WsLimitedPlainDocument) {
            ((WsLimitedPlainDocument)doc).setMaxCharacters(maxCharacters);
        }
    }

    public int getMaxCharacters() {
        Document doc = this.getDocument();
        if (doc instanceof WsLimitedPlainDocument) {
            return ((WsLimitedPlainDocument)doc).getMaxCharacters();
        }
        return Integer.MAX_VALUE;
    }

    public void setAutosize(boolean bAutosize) {
        if (bAutosize && this.isEditable()) {
            throw new UnsupportedOperationException();
        }
        if (this.m_bAutosize == bAutosize) {
            return;
        }
        this.m_bAutosize = bAutosize;
        if (this.m_bAutosize) {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            if (this.getColumns() <= 0) {
                super.setColumns(40);
            }
            this.calculateRows();
        }
    }

    public boolean isAutosize() {
        return this.m_bAutosize;
    }

    public void setBehavior(int eBehavior) {
        this.m_adapter.setBehavior(eBehavior);
    }

    public int getBehavior() {
        return this.m_adapter.getBehavior();
    }

    @Override
    public void setFocusable(boolean bFocusable) {
        this.m_bFocusable = bFocusable;
        if (!bFocusable && this.hasFocus()) {
            FocusManager.getCurrentManager().focusNextComponent(this);
        }
    }

    @Override
    public boolean isFocusable() {
        return this.m_bFocusable;
    }

    @Override
    public String getPropertyPrefix() {
        return ((cBasicTextAreaUI)this.getUI()).getPropertyPrefix();
    }

    @Override
    public void setBorder(Border border) {
        if (!this.isEditable() && border == null) {
            this.setFocusable(false);
        }
        super.setBorder(border);
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this.isAutosize() && bEditable) {
            throw new UnsupportedOperationException();
        }
        super.setEditable(bEditable);
    }

    @Override
    public void setText(String sText) {
        super.setText(sText);
        if (this.isAutosize()) {
            this.calculateRows();
        }
    }

    @Override
    public void setColumns(int nColumns) {
        super.setColumns(nColumns);
        if (this.isAutosize()) {
            this.calculateRows();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.isAutosize()) {
            this.calculateRows();
        }
    }

    @Override
    public void setRows(int nRows) {
        if (this.isAutosize()) {
            throw new UnsupportedOperationException();
        }
        super.setRows(nRows);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        if (this.isAutosize()) {
            this.setBounds(this.getX(), this.getY(), width, height);
        } else {
            super.setSize(width, height);
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.isAutosize() && width > 0) {
            super.setColumns(width / this.getColumnWidth());
            Insets insets = this.getInsets();
            this.calculateRows(width - insets.left - insets.right);
            super.setBounds(x, y, width, this.getRows() * this.getRowHeight() + insets.top + insets.bottom);
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins;
        Dimension dim = super.getPreferredSize();
        if (this.getColumns() != 0) {
            ins = this.getInsets();
            dim.width += ins.left + ins.right;
        }
        if (this.getRows() != 0) {
            ins = this.getInsets();
            dim.height += ins.top + ins.bottom;
        }
        return dim;
    }

    protected void calculateRows() {
        Insets insets = this.getInsets();
        this.calculateRows(this.getColumns() * this.getColumnWidth() - insets.left - insets.right);
    }

    protected void calculateRows(int cxText) {
        int iBreak;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        Document doc = this.getDocument();
        int nRows = 0;
        int iEnd = doc.getEndPosition().getOffset();
        for (int iStart = doc.getStartPosition().getOffset(); iStart < iEnd; iStart += iBreak) {
            ++nRows;
            Segment segText = new Segment();
            try {
                doc.getText(iStart, iEnd - iStart, segText);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            iBreak = Math.max(Utilities.getBreakLocation(segText, metrics, 0, cxText, null, iStart), 1);
            int iReturn = segText.toString().substring(0, iBreak).indexOf(10);
            if (iReturn < 0) continue;
            iBreak = iReturn + 1;
        }
        super.setRows(nRows);
    }

    @Override
    protected Document createDefaultModel() {
        return new WsLimitedPlainDocument();
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return this.isFocusable() && super.isRequestFocusEnabled();
    }

    public boolean isAutoSelect() {
        Caret caret = this.getCaret();
        if (caret instanceof WsBasicCaret) {
            return ((WsBasicCaret)caret).isAutoSelect();
        }
        return false;
    }

    public void setAutoSelect(boolean bAutoSelect) {
        Caret caret = this.getCaret();
        if (caret instanceof WsBasicCaret) {
            ((WsBasicCaret)caret).setAutoSelect(bAutoSelect);
        }
    }

    public void initDragSource() {
        this.m_dragSource = new DragSource();
        this.m_dragSource.createDefaultDragGestureRecognizer(this, 2, (DragGestureListener)((Object)this.getParent()));
    }

    public void clearSelection() {
        this.setSelectionStart(this.getSelectionEnd());
    }

    protected static class cBasicTextAreaUI
    extends BasicTextAreaUI {
        protected cBasicTextAreaUI() {
        }

        @Override
        protected Caret createCaret() {
            return new WsBasicCaret();
        }

        @Override
        public String getPropertyPrefix() {
            return super.getPropertyPrefix();
        }
    }
}

