/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class WATableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static Border m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    WATableModel model = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        int toolTipColumn;
        if (value == null) {
            this.setText("");
        } else if (value instanceof Integer) {
            this.setText(((Integer)value).toString());
            this.setHorizontalAlignment(4);
        } else if (value instanceof String) {
            this.setText((String)value);
        } else {
            this.setText(value.toString());
        }
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(m_noFocusBorder);
        }
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        if (table instanceof WATable && (toolTipColumn = ((WATable)table).getToolTipColumn()) > -1) {
            WATableModel waTableModel = (WATableModel)table.getModel();
            try {
                Object oToolTip = waTableModel.getValueAt(row, toolTipColumn);
                if (oToolTip != null) {
                    this.setToolTipText(oToolTip.toString());
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return this;
    }
}

