/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoManager;

public class WAStandardDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int MIN_WIDTH = 150;
    private static final int MIN_HEIGHT = 150;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected static final String DATA_CHANGED_PROPERTY = "DataChanged";
    public static final String EDITABLE_PROPERTY = "Editable";
    public static final String DataChangedPromptProperty = "PromptAboutDataChanged";
    private static final WAdminResource bundle = WAdminResource.getBundle(WAStandardDialog.class);
    private static boolean s_bDoNotShowMessageCheckBoxVisible = true;
    protected int m_eReturnValue;
    protected boolean m_bDataChanged;
    protected boolean m_bEditable = true;
    private boolean m_bShownPreviously;
    private boolean m_bOKButtonVisible;
    private boolean m_bCancelButtonVisible;
    private boolean m_bCloseButtonVisible;
    private boolean m_bApplyButtonVisible;
    private boolean m_bHelpButtonVisible;
    private String m_sRealTitle;
    private String m_sSettingsName;
    private UndoManager m_mgrUndo;
    private Action m_actOK;
    private Action m_actClose;
    private Action m_actCancel;
    private Action m_actApply;
    private Action m_actHelp;
    protected JPanel m_pnlButtons;
    protected JButton m_btnOk;
    protected JButton m_btnCancel;
    protected JButton m_btnClose;
    protected JButton m_btnApply;
    protected JButton m_btnHelp;
    protected WAPanel m_pnlMain;
    protected cKeyHandler m_KeyHandler;
    protected PropertyChangeListener m_lsnrDataChanged;
    protected PropertyChangeListener m_lsnrPanelDataChanged;
    protected ChangeListener m_lsnrUndoManager;
    protected String m_sHelpTopic;
    protected String m_sHelpProduct;
    protected String docsetVersion;
    private InputMap m_mapInput;
    private ActionMap m_mapAction;

    public static void setDoNotShowMessageCheckBoxVisible(boolean bVisible) {
        s_bDoNotShowMessageCheckBoxVisible = bVisible;
    }

    public static boolean isDoNotShowMessageCheckBoxVisible() {
        return s_bDoNotShowMessageCheckBoxVisible;
    }

    public static void setUserPreferenceToShowTheDiscardChangesMessage(boolean bShow) {
    }

    public static boolean isUserPreferenceToShowTheDiscardChangesMessage() {
        return true;
    }

    public WAStandardDialog(Dialog dlgOwner) {
        this(dlgOwner, "", false, (WAPanel)null);
    }

    public WAStandardDialog(Dialog dlgOwner, boolean bModal) {
        this(dlgOwner, "", bModal, (WAPanel)null);
    }

    public WAStandardDialog(Dialog dlgOwner, String sTitle) {
        this(dlgOwner, sTitle, false, (WAPanel)null);
    }

    public WAStandardDialog(Dialog dlgOwner, String sTitle, boolean bModal) {
        this(dlgOwner, sTitle, bModal, (WAPanel)null);
    }

    public WAStandardDialog(Dialog dlgOwner, String sTitle, boolean bModal, WAPanel pnlMain) {
        super(dlgOwner, sTitle, bModal);
        this.setTitle(sTitle);
        this.setResizable(false);
        this.setOKButtonVisible(true);
        this.setCancelButtonVisible(true);
        this.setCloseButtonVisible(false);
        this.setApplyButtonVisible(!bModal);
        this.setHelpButtonVisible(true);
        this.m_KeyHandler = this.createKeyListener();
        this.m_lsnrDataChanged = new cDataChangedListener();
        this.m_lsnrPanelDataChanged = new cPanelDataChangedListener();
        this.m_lsnrUndoManager = new UndoManagerListener();
        this.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrDataChanged);
        if (pnlMain != null) {
            this.setMainPanel(pnlMain);
        }
        Workspace.debugFocusOnDialog(this);
    }

    public WAStandardDialog(Frame frmOwner) {
        this(frmOwner, "", false, (WAPanel)null);
    }

    public WAStandardDialog(Frame frmOwner, boolean bModal) {
        this(frmOwner, "", bModal, (WAPanel)null);
    }

    public WAStandardDialog(Frame frmOwner, String sTitle) {
        this(frmOwner, sTitle, false, (WAPanel)null);
    }

    public WAStandardDialog(Frame frmOwner, String sTitle, boolean bModal) {
        this(frmOwner, sTitle, bModal, (WAPanel)null);
    }

    public WAStandardDialog(Frame frmOwner, String sTitle, boolean bModal, WAPanel pnlMain) {
        super(frmOwner, sTitle, bModal);
        this.setTitle(sTitle);
        this.setResizable(false);
        this.setOKButtonVisible(true);
        this.setCancelButtonVisible(true);
        this.setCloseButtonVisible(false);
        this.setApplyButtonVisible(!bModal);
        this.setHelpButtonVisible(true);
        this.m_KeyHandler = this.createKeyListener();
        this.m_lsnrDataChanged = new cDataChangedListener();
        this.m_lsnrPanelDataChanged = new cPanelDataChangedListener();
        this.m_lsnrUndoManager = new UndoManagerListener();
        this.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrDataChanged);
        if (pnlMain != null) {
            this.setMainPanel(pnlMain);
        }
        Workspace.debugFocusOnDialog(this);
    }

    @Override
    public void setModal(boolean bModal) {
        super.setModal(bModal);
        this.setApplyButtonVisible(this.isEditable() && !bModal);
        if (this.m_pnlButtons != null) {
            this.updateButtonsPanel();
        }
    }

    public int getReturnValue() {
        return this.m_eReturnValue;
    }

    public void setMainPanel(WAPanel pnlMain) {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.setDefaultAction(null);
            this.m_pnlMain.removePropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.removeKeyListeners(this.m_pnlMain, this.m_KeyHandler);
            this.getContentPane().remove(this.m_pnlMain);
            this.restoreMainPanelBorder();
        }
        this.m_pnlMain = pnlMain;
        if (this.m_pnlMain != null) {
            this.getContentPane().add((Component)this.m_pnlMain, "Center");
            this.addKeyListeners(this.m_pnlMain, this.m_KeyHandler);
            this.m_pnlMain.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.m_pnlMain.setEditable(this.m_bEditable);
            this.m_pnlMain.setDefaultAction(this.m_actOK);
            this.createMainPanelBorder();
        }
    }

    public WAPanel getMainPanel() {
        return this.m_pnlMain;
    }

    public void setEditable(boolean bEditable) {
        if (this.m_bEditable != bEditable) {
            boolean bOld = this.m_bEditable;
            this.m_bEditable = bEditable;
            this.firePropertyChange(EDITABLE_PROPERTY, new Boolean(bOld), new Boolean(bEditable));
            this.refreshTitle();
            this.setOKButtonVisible(bEditable);
            this.setApplyButtonVisible(bEditable && !this.isModal());
            if (this.m_pnlMain != null) {
                this.m_pnlMain.setEditable(bEditable);
            }
            if (this.m_pnlButtons != null) {
                this.updateButtonsPanel();
            }
        }
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void setTitle(String sTitle) {
        this.m_sRealTitle = sTitle;
        this.refreshTitle();
    }

    private void refreshTitle() {
        String sReadOnly = !this.isEditable() ? " " + bundle.getString("Common.ReadOnlyIndicator.txt") : "";
        super.setTitle(this.m_sRealTitle + sReadOnly);
    }

    public ClassLoader getHelpClassLoader() {
        return this.m_pnlMain != null ? this.m_pnlMain.getHelpClassLoader() : null;
    }

    public void setHelpTopic(String sHelpTopic) {
        this.m_sHelpTopic = sHelpTopic;
    }

    public String getHelpTopic() {
        String sHelpTopic = null;
        if (this.m_pnlMain != null) {
            sHelpTopic = this.m_pnlMain.getHelpTopic();
        }
        if (sHelpTopic == null) {
            sHelpTopic = this.m_sHelpTopic;
        }
        return sHelpTopic;
    }

    public void setHelpProduct(String sHelpProduct) {
        this.m_sHelpProduct = sHelpProduct;
    }

    public String getHelpProduct() {
        String sHelpProduct = null;
        if (this.m_pnlMain != null) {
            sHelpProduct = this.m_pnlMain.getHelpProduct();
        }
        if (sHelpProduct == null) {
            sHelpProduct = this.m_sHelpProduct;
        }
        return sHelpProduct;
    }

    public String getDocsetVersion() {
        return this.docsetVersion;
    }

    public void setDocsetVersion(String docsetVersion) {
        this.docsetVersion = docsetVersion;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    public boolean hasDataChanged() {
        return this.m_bDataChanged;
    }

    public boolean isOKButtonVisible() {
        return this.m_bOKButtonVisible;
    }

    public void setOKButtonVisible(boolean visible) {
        this.m_bOKButtonVisible = visible;
    }

    public boolean isCancelButtonVisible() {
        return this.m_bCancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean visible) {
        this.m_bCancelButtonVisible = visible;
    }

    public boolean isCloseButtonVisible() {
        return this.m_bCloseButtonVisible;
    }

    public void setCloseButtonVisible(boolean visible) {
        this.m_bCloseButtonVisible = visible;
    }

    public boolean isApplyButtonVisible() {
        return this.m_bApplyButtonVisible;
    }

    public void setApplyButtonVisible(boolean visible) {
        this.m_bApplyButtonVisible = visible;
    }

    public boolean isHelpButtonVisible() {
        return this.m_bHelpButtonVisible;
    }

    public void setHelpButtonVisible(boolean visible) {
        this.m_bHelpButtonVisible = visible;
    }

    public void setUndoManager(UndoManager mgrUndo) {
        if (this.m_mgrUndo instanceof WsUndoManager) {
            ((WsUndoManager)this.m_mgrUndo).removeChangeListener(this.m_lsnrUndoManager);
        }
        this.m_mgrUndo = mgrUndo;
        if (this.m_mgrUndo instanceof WsUndoManager) {
            ((WsUndoManager)this.m_mgrUndo).addChangeListener(this.m_lsnrUndoManager);
        }
    }

    public UndoManager getUndoManager() {
        return this.m_mgrUndo;
    }

    public Component getDefaultFocusComponent() {
        Component cmp = null;
        if (this.m_pnlMain != null) {
            cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_pnlMain);
        }
        if (cmp == null) {
            cmp = ((WARootPane)this.getRootPane()).getRealDefaultButton();
        }
        if (cmp == null && this.m_pnlButtons != null) {
            cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_pnlButtons);
        }
        return cmp != null ? cmp : this;
    }

    @Override
    public void show() {
        if (!this.m_bShownPreviously) {
            this.initialize();
            this.layoutWidgets();
            this.pack();
            if (this.m_sSettingsName != null) {
                Dimension dimScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
                int cx = appDefaults.getPropertyInt(this.m_sSettingsName + ".cx", -1);
                int cy = appDefaults.getPropertyInt(this.m_sSettingsName + ".cy", -1);
                if (cx != -1 && cy != -1) {
                    cx = Math.min(Math.max(cx, 150), dimScreenSize.width - 100);
                    cy = Math.min(Math.max(cy, 150), dimScreenSize.height - 100);
                    this.setSize(cx, cy);
                }
            }
            this.center();
            this.onShow();
            this.m_bShownPreviously = true;
        }
        this.getDefaultFocusComponent().requestFocus();
        super.show();
    }

    public final void setSettingsName(String name) {
        this.m_sSettingsName = name;
    }

    public final String getSettingsName() {
        return this.m_sSettingsName;
    }

    protected void createMainPanelBorder() {
        Border brdrOuter = BorderFactory.createEmptyBorder(7, 7, 7, 7);
        Border brdrInner = this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
    }

    protected void restoreMainPanelBorder() {
        CompoundBorder brdrCompound = (CompoundBorder)this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(brdrCompound.getInsideBorder());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnOk) {
            if (this.onOK()) {
                this.dispose();
            }
        } else if (src == this.m_btnCancel) {
            if (this.onCancel()) {
                this.dispose();
            }
        } else if (src == this.m_btnApply) {
            this.onApply();
        } else if (src == this.m_btnHelp) {
            this.onHelp();
        }
    }

    protected void onShow() {
        this.doDataExchange(false);
    }

    protected boolean onOK() {
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        if (this.validateData() && this.doDataExchange(true)) {
            this.m_eReturnValue = 1;
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentOK();
            }
            return true;
        }
        return false;
    }

    protected boolean onCancel() {
        if (!this.isEditable()) {
            this.m_eReturnValue = 2;
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentCancel();
            }
            return true;
        }
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        if (WAStandardDialog.isUserPreferenceToShowTheDiscardChangesMessage() && this.hasDataChanged() && !this.showDiscardChangesMessage()) {
            return false;
        }
        this.m_eReturnValue = 2;
        if (this.m_pnlMain != null) {
            this.m_pnlMain.onParentCancel();
        }
        return true;
    }

    private boolean showDiscardChangesMessage() {
        int eAnswer;
        String sTitle = bundle.getString("WAStandardDialog.DiscardChanges.Title.txt");
        String sMessage = bundle.getString("WAStandardDialog.DiscardChanges.Message.txt");
        if (WAStandardDialog.isDoNotShowMessageCheckBoxVisible()) {
            JCheckBox ckbDoNotShow = WsUIUtilities.createCheckBox(bundle, "WAStandardDialog.DiscardChanges.DoNotShow.CheckBox", 1);
            Object[] oaMessage = new Object[]{sMessage, " ", ckbDoNotShow};
            eAnswer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), oaMessage, sTitle, 0, 2);
            WAStandardDialog.setUserPreferenceToShowTheDiscardChangesMessage(!ckbDoNotShow.isSelected());
        } else {
            eAnswer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), sMessage, sTitle, 0, 2);
        }
        return eAnswer == 0;
    }

    private boolean onClose() {
        return this.onCancel();
    }

    protected boolean onApply() {
        if (this.validateData()) {
            this.doDataExchange(true);
            this.setDataChanged(false);
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentApply();
            }
            return true;
        }
        return false;
    }

    protected void onHelp() {
        Workspace.getWorkspace().showHelp(this.getHelpProduct(), this.getHelpTopic(), this, this.getHelpClassLoader(), this.getDocsetVersion());
    }

    protected boolean validateData() {
        if (this.m_pnlMain != null) {
            return this.m_pnlMain.validateData();
        }
        return true;
    }

    protected boolean doDataExchange(boolean bSaveToModel) {
        if (this.m_pnlMain != null) {
            try {
                if (!bSaveToModel) {
                    this.m_pnlMain.populateStore();
                    this.m_pnlMain.moveDataToView();
                } else {
                    this.m_pnlMain.moveDataToStore();
                }
                return true;
            }
            catch (MdException e) {
                if (!e.getMessage().equalsIgnoreCase("Undisplayable")) {
                    MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
                }
                return false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
                return false;
            }
        }
        return true;
    }

    @Override
    protected JRootPane createRootPane() {
        return new WARootPane();
    }

    protected void initialize() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (WAStandardDialog.this.onCancel()) {
                    WAStandardDialog.this.dispose();
                }
            }
        });
        this.m_actOK = this.createOKAction();
        this.m_actCancel = this.createCancelAction();
        this.m_actClose = this.createCloseAction();
        this.m_actApply = this.createApplyAction();
        this.m_actHelp = this.createHelpAction();
        this.m_pnlButtons = new JPanel();
        this.m_btnOk = new JButton(this.m_actOK);
        this.m_btnCancel = new JButton(this.m_actCancel);
        this.m_btnClose = new JButton(this.m_actClose);
        this.m_btnApply = new JButton(this.m_actApply);
        this.m_btnHelp = new JButton(this.m_actHelp);
        this.m_btnOk.setName("OK");
        this.m_btnCancel.setName("Cancel");
        this.m_btnApply.setName("Apply");
        this.m_btnHelp.setName("Help");
        this.updateInputMap();
        this.updateActionMap();
        if (this.m_pnlMain != null) {
            this.m_pnlMain.setDefaultAction(this.m_actOK);
        }
        this.m_actApply.setEnabled(false);
    }

    private void updateInputMap() {
        this.m_mapInput = this.getLayeredPane().getInputMap(1);
        this.m_mapInput.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.m_mapInput.put(KeyStroke.getKeyStroke(112, 1), "help");
        this.m_mapInput.put(KeyStroke.getKeyStroke(112, 0), "help");
        this.m_mapInput.put(KeyStroke.getKeyStroke(90, 2), "undo");
        this.m_mapInput.put(KeyStroke.getKeyStroke(89, 2), "redo");
    }

    private void updateActionMap() {
        this.m_mapAction = this.getLayeredPane().getActionMap();
        this.m_mapAction.put("cancel", this.m_actCancel);
        this.m_mapAction.put("help", this.m_actHelp);
        this.m_mapAction.put("undo", new UndoAction());
        this.m_mapAction.put("redo", new RedoAction());
    }

    private void cleanupInputMap() {
        if (this.m_mapInput != null) {
            this.m_mapInput.remove(KeyStroke.getKeyStroke(27, 0));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(112, 1));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(112, 0));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(90, 2));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(89, 2));
        }
    }

    private void cleanupActionMap() {
        if (this.m_mapAction != null) {
            this.m_mapAction.remove("cancel");
            this.m_mapAction.remove("help");
            this.m_mapAction.remove("undo");
            this.m_mapAction.remove("redo");
        }
    }

    protected void layoutWidgets() {
        this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(3, 7, 7, 7));
        Container paneContents = this.getContentPane();
        if (this.m_pnlMain != null) {
            paneContents.add((Component)this.m_pnlMain, "Center");
        }
        this.updateButtonsPanel();
        paneContents.add((Component)this.m_pnlButtons, "South");
        if (this.m_pnlMain != null) {
            this.m_pnlMain.setNextFocusableComponentOnLastFocusableComponent(this.m_pnlButtons.getComponent(0));
        }
    }

    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new WsButtonsLayout());
        if (this.isOKButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnOk);
        }
        if (this.isCancelButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnCancel);
        }
        if (this.isCloseButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnClose);
        }
        if (this.isApplyButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnApply);
        }
        if (this.isHelpButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnHelp);
        }
        if (this.isOKButtonVisible()) {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnOk);
        } else if (this.isCloseButtonVisible()) {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnClose);
        } else {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnCancel);
        }
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    @Override
    public void dispose() {
        if (this.m_sSettingsName != null) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            appDefaults.setPropertyInt(this.m_sSettingsName + ".cx", Math.max(this.getWidth(), 150));
            appDefaults.setPropertyInt(this.m_sSettingsName + ".cy", Math.max(this.getHeight(), 150));
        }
        this.setUndoManager(null);
        if (this.m_pnlMain != null) {
            try {
                this.m_pnlMain.saveSettingsAndCleanUp();
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error((Object)"Exception during main panel clean up", ex);
            }
            this.m_pnlMain = null;
        }
        super.dispose();
        SwingUtilities.replaceUIInputMap(this.getRootPane(), 2, null);
        this.cleanupInputMap();
        this.cleanupActionMap();
    }

    protected void center() {
        Dimension szDialog = this.getSize();
        Dimension szParent = this.getParent().getSize();
        Point ptParent = this.getParent().getLocation();
        int x = ptParent.x + (szParent.width - szDialog.width) / 2;
        int y = ptParent.y + (szParent.height - szDialog.height) / 2;
        Rectangle rVirtualScreen = WsUIUtilities.getVirtualScreenExtent();
        x = Math.max(rVirtualScreen.x, Math.min(x, rVirtualScreen.width - szDialog.width));
        y = Math.max(rVirtualScreen.y, Math.min(y, rVirtualScreen.height - szDialog.height));
        this.setLocation(x, y);
    }

    public static Rectangle getVirtualScreenExtent() {
        return WsUIUtilities.getVirtualScreenExtent();
    }

    protected cKeyHandler createKeyListener() {
        return new cKeyHandler();
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] aComps = container.getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            aComps[iComp].addKeyListener(keyHandler);
            if (!(aComps[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)aComps[iComp], keyHandler);
        }
    }

    protected void removeKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] aComps = container.getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            aComps[iComp].removeKeyListener(keyHandler);
            if (!(aComps[iComp] instanceof Container)) continue;
            this.removeKeyListeners((Container)aComps[iComp], keyHandler);
        }
    }

    protected Action createOKAction() {
        return new OKAction();
    }

    protected Action createCancelAction() {
        return new CancelAction();
    }

    protected Action createCloseAction() {
        return new CloseAction();
    }

    protected Action createApplyAction() {
        return new ApplyAction();
    }

    protected Action createHelpAction() {
        return new HelpAction();
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }

    protected class cDataChangedListener
    implements PropertyChangeListener {
        protected cDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean bEnable = (Boolean)e.getNewValue();
            if (WAStandardDialog.this.m_actApply != null) {
                WAStandardDialog.this.m_actApply.setEnabled(bEnable);
            }
        }
    }

    protected class cPanelDataChangedListener
    implements PropertyChangeListener {
        protected cPanelDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (WAStandardDialog.this.m_mgrUndo instanceof WsUndoManager) {
                return;
            }
            WAStandardDialog.this.setDataChanged((Boolean)e.getNewValue());
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            WAStandardDialog.this.setDataChanged(WAStandardDialog.this.getUndoManager().canUndo());
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (WAStandardDialog.this.m_mgrUndo == null) {
                return;
            }
            if (WAStandardDialog.this.m_mgrUndo.canUndo()) {
                WAStandardDialog.this.m_mgrUndo.undo();
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (WAStandardDialog.this.m_mgrUndo == null) {
                return;
            }
            if (WAStandardDialog.this.m_mgrUndo.canRedo()) {
                WAStandardDialog.this.m_mgrUndo.redo();
            }
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OKAction() {
            this.putValue("Name", bundle.getString("Common.OK.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() != WAStandardDialog.this.m_btnOk) {
                if (WAStandardDialog.this.onOK()) {
                    WAStandardDialog.this.dispose();
                }
            } else {
                WAStandardDialog.this.actionPerformed(ev);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            this.putValue("Name", bundle.getString("Common.Cancel.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() != WAStandardDialog.this.m_btnCancel) {
                if (WAStandardDialog.this.onCancel()) {
                    WAStandardDialog.this.dispose();
                }
            } else {
                WAStandardDialog.this.actionPerformed(ev);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAction() {
            this.putValue("Name", bundle.getString("Common.Close.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (WAStandardDialog.this.onClose()) {
                WAStandardDialog.this.dispose();
            }
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ApplyAction() {
            this.putValue("Name", bundle.getString("Common.Apply.txt"));
            this.putValue("MnemonicKey", new Integer(bundle.getString("Common.Apply.mnem").charAt(0)));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WAStandardDialog.this.actionPerformed(ev);
        }
    }

    private class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpAction() {
            this.putValue("Name", bundle.getString("Common.Help.txt"));
            this.putValue("MnemonicKey", new Integer(bundle.getString("Common.Help.mnem").charAt(0)));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() != WAStandardDialog.this.m_btnHelp) {
                WAStandardDialog.this.onHelp();
            } else {
                WAStandardDialog.this.actionPerformed(ev);
            }
        }
    }
}

