/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.CArrowRepeatButton;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;

public class WASpinBox
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    protected WAIntTextField m_data;
    protected CArrowRepeatButton m_inc;
    protected CArrowRepeatButton m_dec;
    protected int m_nMin;
    protected int m_nMax;
    protected int m_nInitial;
    protected int m_nDelta;
    protected int m_nPeriod;
    protected int m_nCurrVal;

    public WASpinBox(int min, int max, int initial, int delta, int period) {
        this.m_inc = new CArrowRepeatButton(1, period);
        this.m_dec = new CArrowRepeatButton(5, period);
        this.m_data = new WAIntTextField();
        this.m_data.setValue(initial);
        this.m_data.addFocusListener(this);
        this.m_dec.addActionListener(this);
        this.m_inc.addActionListener(this);
        this.m_nMin = min;
        this.m_nMax = max;
        this.m_nDelta = delta;
        this.m_nInitial = initial;
        this.m_nCurrVal = initial;
        this.m_nPeriod = period;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_data, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_inc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 13, 1, new Insets(0, 0, 0, 0), 10, 0));
        this.add((Component)this.m_dec, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 13, 1, new Insets(0, 0, 0, 0), 10, 0));
    }

    public synchronized void setValue(int value) {
        this.m_nCurrVal = value;
        this.m_data.setText("" + this.m_nCurrVal);
    }

    public synchronized int getValue() {
        this.checkBounds();
        return this.m_nCurrVal;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent ev) {
        int origValue;
        int currValue;
        boolean increment = ev.getSource() == this.m_inc;
        try {
            origValue = currValue = Integer.parseInt(this.m_data.getText());
        }
        catch (NumberFormatException ex) {
            Workspace.getLogger("com.sas.workspace.components").error("Not a number!");
            return;
        }
        if (increment && currValue + this.m_nDelta <= this.m_nMax) {
            currValue += this.m_nDelta;
        } else if (!increment && currValue - this.m_nDelta >= this.m_nMin) {
            currValue -= this.m_nDelta;
        }
        currValue = Math.max(Math.min(this.m_nMax, currValue), this.m_nMin);
        if (origValue != currValue) {
            this.setValue(currValue);
        }
    }

    public WATextField getTextField() {
        return this.m_data;
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        this.m_data.setEnabled(bEnabled);
        this.m_inc.setEnabled(bEnabled);
        this.m_dec.setEnabled(bEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.m_data.isEnabled();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.checkBounds();
    }

    protected void checkBounds() {
        int nEditValue;
        try {
            nEditValue = Integer.parseInt(this.m_data.getText());
        }
        catch (NumberFormatException ex) {
            nEditValue = this.m_nInitial;
        }
        int nLegalValue = Math.min(this.m_nMax, Math.max(this.m_nMin, nEditValue));
        this.setValue(nLegalValue);
    }

    @Override
    public void setToolTipText(String sText) {
        super.setToolTipText(sText);
        this.m_data.setToolTipText(sText);
        this.m_inc.setToolTipText(sText);
        this.m_dec.setToolTipText(sText);
    }

    @Override
    public void requestFocus() {
        this.m_data.requestFocus();
    }
}

