/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WARowTable;
import com.sas.workspace.WATable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WARowTableUI
extends BasicTableUI {
    boolean pColSelectionF = false;
    boolean dragFlag = false;
    int lastEffectiveMouseY = 0;
    int dragHit = -1;
    int dragIdx = -1;
    int viewCol = 0;
    WATable parentTable = null;

    public WARowTableUI(WATable wat) {
        this.parentTable = wat;
    }

    public boolean getColFlag() {
        return this.pColSelectionF;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandlerRow();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point minLocation = clip.getLocation();
        Point maxLocation = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(minLocation);
        int rMax = this.table.rowAtPoint(maxLocation);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(minLocation);
        int cMax = this.table.columnAtPoint(maxLocation);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = maxCell.x + maxCell.width;
            int y = minCell.y;
            for (int row = rMin; row <= rMax; ++row) {
                g.drawLine(0, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = maxCell.y + maxCell.height;
            int x = minCell.x;
            for (int column = cMin; column <= cMax; ++column) {
                g.drawLine((x += cm.getColumn(column).getWidth()) - 1, 0, x - 1, tableHeight - 1);
            }
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle cellRect = this.table.getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, row, column);
                }
                cellRect.x += columnWidth;
            }
        }
        int[] dragRows = ((WARowTable)this.table).getDragRows();
        if (dragRows != null && dragRows.length > 0) {
            this.paintDraggedRowArea(g, cMin, cMax, ((WARowTable)this.table).getDragDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void paintDraggedRowArea(Graphics g, int cMin, int cMax, int distance) {
        int[] dragRows = ((WARowTable)this.table).getDragRows();
        Rectangle minCell = this.table.getCellRect(dragRows[0], cMin, true);
        Rectangle maxCell = this.table.getCellRect(dragRows[dragRows.length - 1], cMax, true);
        Rectangle vacatedRowRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedRowRect.x, vacatedRowRect.y, vacatedRowRect.width, vacatedRowRect.height);
        vacatedRowRect.y += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedRowRect.x, vacatedRowRect.y, vacatedRowRect.width, vacatedRowRect.height);
        if (this.table.getShowHorizontalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedRowRect.x;
            int y1 = vacatedRowRect.y;
            int x2 = x1 + vacatedRowRect.width - 1;
            int y2 = y1 + vacatedRowRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int i = 0; i < dragRows.length; ++i) {
            int row = dragRows[i];
            for (int col = cMin; col <= cMax; ++col) {
                Rectangle r = this.table.getCellRect(row, col, false);
                r.y += distance;
                this.paintCell(g, r, row, col);
                if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) continue;
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, col, true);
                rcr.y += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                if (this.table.getShowHorizontalLines()) {
                    g.drawLine(x1, y2, x2, y2);
                }
                if (!this.table.getShowVerticalLines()) continue;
                g.drawLine(x2, y1, x2, y2);
            }
        }
    }

    public class MouseInputHandlerRow
    extends BasicTableUI.MouseInputHandler {
        public MouseInputHandlerRow() {
            super(WARowTableUI.this);
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            WARowTableUI.this.dragFlag = true;
            ((WARowTable)WARowTableUI.this.table).setDragRows(((WARowTable)WARowTableUI.this.table).getTDragRows());
            int mouseY = me.getY();
            int deltaY = mouseY - WARowTableUI.this.lastEffectiveMouseY;
            if (deltaY > -5 && deltaY < 5) {
                return;
            }
            this.move(me, deltaY);
            WARowTableUI.this.lastEffectiveMouseY = mouseY;
            WARowTableUI.this.parentTable.rowMouseDrag(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            WARowTableUI.this.pColSelectionF = WARowTableUI.this.parentTable.getColumnSelectionAllowed();
            TableCellEditor ce = WARowTableUI.this.parentTable.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            WARowTableUI.this.dragFlag = false;
            ((WARowTable)WARowTableUI.this.table).setDragDistance(0);
            WARowTableUI.this.viewCol = WARowTableUI.this.parentTable.getSelectedColumn();
            WARowTableUI.this.parentTable.setColumnSelectionInterval(0, WARowTableUI.this.parentTable.getColumnCount() - 1);
            Point p = me.getPoint();
            int row = WARowTableUI.this.table.rowAtPoint(p);
            boolean f = WARowTableUI.this.table.isRowSelected(row);
            if (WARowTableUI.this.table.getSelectedRowCount() <= 1 || !f) {
                super.mousePressed(me);
            } else if (me.isControlDown() || me.isShiftDown()) {
                super.mousePressed(me);
            }
            WARowTableUI.this.dragHit = row;
            int[] rows = WARowTableUI.this.table.getSelectedRows();
            Arrays.sort(rows);
            ((WARowTable)WARowTableUI.this.table).setTDragRows(rows);
            int[] tdragRows = ((WARowTable)WARowTableUI.this.table).getTDragRows();
            for (int i = 0; i < tdragRows.length; ++i) {
                if (tdragRows[i] != WARowTableUI.this.dragHit) continue;
                WARowTableUI.this.dragIdx = i;
            }
            WARowTableUI.this.lastEffectiveMouseY = me.getY();
        }

        private void setValueIsAdjusting(boolean flag) {
            WARowTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            WARowTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (WARowTableUI.this.table.getSelectedRowCount() <= 1 || me.isControlDown() || me.isShiftDown() || me.isPopupTrigger()) {
                super.mouseReleased(me);
            } else if (!WARowTableUI.this.dragFlag) {
                Point p = me.getPoint();
                int row = WARowTableUI.this.table.rowAtPoint(p);
                int column = WARowTableUI.this.table.columnAtPoint(p);
                if (column == -1 || row == -1) {
                    return;
                }
                WARowTableUI.this.table.requestFocus();
                TableCellEditor editor = WARowTableUI.this.table.getCellEditor();
                if (editor == null || editor.shouldSelectCell(me)) {
                    this.setValueIsAdjusting(true);
                    WARowTableUI.this.table.changeSelection(row, column, me.isControlDown(), me.isShiftDown());
                }
            }
            ((WARowTable)WARowTableUI.this.table).setDragRows(null);
            WARowTableUI.this.dragHit = -1;
            WARowTableUI.this.dragIdx = -1;
            ((WARowTable)WARowTableUI.this.table).setDragDistance(0);
            WARowTableUI.this.lastEffectiveMouseY = 0;
        }

        private void move(MouseEvent e, int delta) {
            int draggedDistance = ((WARowTable)WARowTableUI.this.table).getDragDistance() + delta;
            int lastRow = WARowTableUI.this.parentTable.getRowCount() - 1;
            int[] dragRows = ((WARowTable)WARowTableUI.this.table).getDragRows();
            if (draggedDistance < 0 && dragRows[0] != 0) {
                int boundRow = dragRows[0];
                int height = WARowTableUI.this.table.getRowHeight(dragRows[0] - 1);
                if (-draggedDistance > height / 2) {
                    int length = dragRows.length;
                    int j = 0;
                    int swapDistance = Math.abs(draggedDistance / height);
                    if (swapDistance == 0) {
                        ++swapDistance;
                    }
                    if (boundRow - swapDistance < 0) {
                        swapDistance = boundRow;
                    }
                    for (int i = 0; i < length; ++i) {
                        for (int k = 0; k < swapDistance; ++k) {
                            j = dragRows[i];
                            WARowTableUI.this.parentTable.moveRow(j, j - 1);
                            int n = i;
                            dragRows[n] = dragRows[n] - 1;
                        }
                    }
                    WARowTableUI.this.parentTable.changeSelection(dragRows[0], -1, false, false);
                    for (int k = 1; k < length; ++k) {
                        WARowTableUI.this.parentTable.changeSelection(dragRows[k], -1, false, true);
                    }
                    draggedDistance = height * swapDistance + draggedDistance;
                }
            } else if (draggedDistance > 0 && dragRows[dragRows.length - 1] < lastRow) {
                int boundRow = dragRows[dragRows.length - 1];
                int height = WARowTableUI.this.table.getRowHeight(dragRows[0] + 1);
                if (draggedDistance > height / 2) {
                    int j = 0;
                    int swapDistance = Math.abs(draggedDistance / height);
                    if (swapDistance == 0) {
                        ++swapDistance;
                    }
                    if (boundRow + swapDistance > lastRow) {
                        swapDistance = lastRow - boundRow;
                    }
                    for (int i = dragRows.length - 1; i >= 0; --i) {
                        for (int k = 0; k < swapDistance; ++k) {
                            j = dragRows[i];
                            WARowTableUI.this.parentTable.moveRow(j, j + 1);
                            int n = i;
                            dragRows[n] = dragRows[n] + 1;
                        }
                    }
                    WARowTableUI.this.parentTable.changeSelection(dragRows[0], -1, false, false);
                    for (int k = 1; k < dragRows.length; ++k) {
                        WARowTableUI.this.parentTable.changeSelection(dragRows[k], -1, false, true);
                    }
                    draggedDistance = -(height * swapDistance - draggedDistance);
                }
            }
            ((WARowTable)WARowTableUI.this.table).setDragDistance(draggedDistance);
            ((WARowTable)WARowTableUI.this.table).setDragRows(dragRows);
        }
    }
}

