/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAKeyAdapter;
import com.sas.workspace.WARowCellRenderer;
import com.sas.workspace.WARowTableUI;
import com.sas.workspace.WATable;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WARowTable
extends JTable
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WARowTable.class);
    int dragDistance = 0;
    int dragRow = -1;
    int stopDragRow = -1;
    int currentRow = -1;
    int[] dragRows = null;
    int[] tdragRows = null;
    WATable parentTable = null;
    WARowTableUI myUI = null;
    boolean colSelection = false;
    WAKeyAdapter waka = null;

    public WARowTable(TableModel tm, TableColumnModel tcm, WATable parent) {
        super(tm, tcm);
        this.myUI = new WARowTableUI(parent);
        this.setUI(this.myUI);
        this.setForeground(Color.white);
        this.setBackground(Color.white);
        this.setCellSelectionEnabled(true);
        this.parentTable = parent;
        this.waka = new WAKeyAdapter(this);
        this.addKeyListener(this.waka);
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void setColumnSelectionFlag(boolean f) {
        this.colSelection = f;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public void setupRenderer() {
        TableColumn t = this.getColumnModel().getColumn(0);
        t.setHeaderValue(bundle.getString("WARowTable.NumberSign.txt"));
        t.setCellRenderer(new WARowCellRenderer(this.parentTable.getRenumber()));
    }

    public void setParentTable(WATable t) {
        this.parentTable = t;
        this.colSelection = this.parentTable.getColumnSelectionAllowed();
    }

    public WATable getParentTable() {
        return this.parentTable;
    }

    public int[] getDragRows() {
        return this.dragRows;
    }

    public int[] getTDragRows() {
        return this.tdragRows;
    }

    public void setDragRows(int[] iArray) {
        this.dragRows = iArray;
    }

    public void setTDragRows(int[] iArray) {
        this.tdragRows = iArray;
    }

    public void setDragDistance(int i) {
        this.dragDistance = i;
        this.repaint();
        this.parentTable.repaint();
    }

    public int getDragDistance() {
        return this.dragDistance;
    }

    public boolean getColumnSelectionFlag() {
        return this.colSelection;
    }
}

