/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsLimitedPlainDocument;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class WADecimalTextField
extends WATextField {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WADecimalTextField.class);
    private int m_columnWidth = 0;

    public WADecimalTextField() {
        this(false);
    }

    public WADecimalTextField(boolean allowNegative) {
        this.setHorizontalAlignment(4);
        ((DecimalDocument)this.getDocument()).setAllowNegatives(allowNegative);
        this.setMaxDecimalDigits(Integer.MAX_VALUE);
    }

    @Override
    protected Document createDefaultModel() {
        return new DecimalDocument();
    }

    public boolean getAllowNegatives() {
        return ((DecimalDocument)this.getDocument()).getAllowNegatives();
    }

    public void setAllowNegatives(boolean allowNegative) {
        ((DecimalDocument)this.getDocument()).setAllowNegatives(allowNegative);
    }

    public void setMaxDecimalDigits(int maxDecimalDigits) {
        ((DecimalDocument)this.getDocument()).setMaxDecimalDigits(maxDecimalDigits);
    }

    public int getMaxDecimalDigits() {
        return ((DecimalDocument)this.getDocument()).getMaxDecimalDigits();
    }

    public double getValue() throws IllegalDecimalException {
        double iValue = -1.0;
        try {
            DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance();
            df.setGroupingUsed(false);
            df.setMaximumFractionDigits(Integer.MAX_VALUE);
            iValue = df.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            Workspace.getLogger("com.sas.workspace.components").warn("Error in WADecimalTextField");
            String message = ((DecimalDocument)this.getDocument()).getAllowNegatives() ? bundle.formatString("WADecimalTextField.IllegalDecimalException.Negative.fmt", this.getText()) : bundle.formatString("WADecimalTextField.IllegalDecimalException.NoNegative.fmt", this.getText());
            throw new IllegalDecimalException(message);
        }
        return iValue;
    }

    public void setValue(double value) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance();
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(Integer.MAX_VALUE);
        this.setText(df.format(value));
    }

    @Override
    public int getColumnWidth() {
        if (this.m_columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.m_columnWidth = metrics.charWidth('0');
        }
        return this.m_columnWidth;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.m_columnWidth = 0;
    }

    protected static class DecimalDocument
    extends WsLimitedPlainDocument {
        private static final long serialVersionUID = 1L;
        private static final char SEPARATOR = new DecimalFormatSymbols().getDecimalSeparator();
        private static final char NEGATIVE_SIGN = new DecimalFormatSymbols().getMinusSign();
        private int m_maxDecimalDigits;
        private boolean m_bAllowNegatives;

        protected DecimalDocument() {
        }

        public void setMaxDecimalDigits(int decimalDigits) {
            this.m_maxDecimalDigits = decimalDigits;
        }

        public int getMaxDecimalDigits() {
            return this.m_maxDecimalDigits;
        }

        public void setAllowNegatives(boolean allowNegative) {
            this.m_bAllowNegatives = allowNegative;
        }

        public boolean getAllowNegatives() {
            return this.m_bAllowNegatives;
        }

        @Override
        public void insertString(int iText, String sText, AttributeSet a) throws BadLocationException {
            if (sText == null || sText.length() == 0) {
                return;
            }
            String sError = null;
            char[] caSource = sText.toCharArray();
            for (int iSource = 0; iSource < caSource.length; ++iSource) {
                char c = caSource[iSource];
                if (!this.getAllowNegatives() && c == NEGATIVE_SIGN) {
                    sError = bundle.getString("Common.NegativeNumbersNotAllowedErrorMessage.txt");
                    break;
                }
                if (Character.isDigit(c) || c == SEPARATOR || c == NEGATIVE_SIGN) continue;
                sError = bundle.getString("Common.DecimalCharactersOnlyErrorMessage.txt");
                break;
            }
            if (sError == null) {
                int iNegative;
                String sFullText = this.getText(0, iText) + sText + this.getText(iText, this.getLength() - iText);
                int iDecimal = sFullText.indexOf(SEPARATOR);
                if (iDecimal != -1) {
                    if (sFullText.indexOf(SEPARATOR, iDecimal + 1) > 0) {
                        sError = bundle.formatString("Common.DecimalSeparatorErrorMessage.txt", String.valueOf(SEPARATOR));
                    } else if (sFullText.length() - iDecimal - 1 > this.m_maxDecimalDigits) {
                        sError = bundle.formatString("Common.DecimalDigitMaxLimitErrorMessage.txt", Integer.toString(this.m_maxDecimalDigits));
                    }
                }
                if ((iNegative = sFullText.indexOf(NEGATIVE_SIGN)) != -1 && sError == null) {
                    if (sFullText.indexOf(NEGATIVE_SIGN, iNegative + 1) > 0) {
                        sError = bundle.formatString("Common.NegativeSymbolErrorMessage.txt", String.valueOf(NEGATIVE_SIGN));
                    } else if (iNegative != 0) {
                        sError = bundle.getString("Common.InsertNegativeSignErrorMessage.txt");
                    }
                }
            }
            if (sError != null && s_msgDisplayer != null) {
                s_msgDisplayer.displayMessage(sError);
                this.m_bMessage = true;
                return;
            }
            if (this.m_bMessage) {
                s_msgDisplayer.displayMessage("");
                this.m_bMessage = false;
            }
            super.insertString(iText, sText, a);
        }
    }

    public class IllegalDecimalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalDecimalException(String message) {
            super(message);
        }
    }
}

