/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.connection.HostPortSet;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.security.ExpiredPasswordLoginServiceException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.connection.ConnectionException;
import com.sas.workspace.imsmc.visuals.InternalLoginPasswordChangeDialog;
import com.sas.workspace.imsmc.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import org.omg.CORBA.StringHolder;

public class WAConnectWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WAConnectWizard.class);
    protected Frame m_parentFrame;
    protected Workspace m_workspace;
    protected WorkspaceFile m_workspaceFile;
    protected WorkspaceFile m_appDefaultsFile;
    protected String m_strFilename;
    protected boolean m_bEdit;
    protected boolean m_bTempConnection;
    protected boolean m_bFinish;
    protected boolean m_bRepositoryRequired;
    private boolean m_bAddRepositoryEnabled = true;
    private boolean m_showProjectPanel = false;
    private boolean m_bOpenOnStartup = false;
    private boolean m_bAllowLocalPasswords = true;
    private static String DEFAULT_SPN = "";
    protected String m_holdStrUser;

    public WAConnectWizard(Frame frame) {
        this(frame, false);
    }

    public WAConnectWizard(Frame frame, boolean bEdit) {
        this(frame, bEdit, false);
    }

    public WAConnectWizard(Frame frame, boolean bEdit, boolean bRepositoryRequired) {
        this(frame, bEdit, bRepositoryRequired, true);
    }

    public WAConnectWizard(Frame frame, boolean bEdit, boolean bRepositoryRequired, boolean bAddRepositoryEnabled) {
        this(frame, bEdit, bRepositoryRequired, bAddRepositoryEnabled, true);
    }

    public WAConnectWizard(Frame frame, boolean bEdit, boolean bRepositoryRequired, boolean bAddRepositoryEnabled, boolean showProjectPanel) {
        this(frame, bEdit, bRepositoryRequired, bAddRepositoryEnabled, showProjectPanel, false);
    }

    public WAConnectWizard(Frame frame, boolean bEdit, boolean bRepositoryRequired, boolean bAddRepositoryEnabled, boolean showProjectPanel, boolean bOpenOnStartup) {
        super(frame, null, true, null, false);
        this.setHelpProduct("newworkspace");
        this.m_parentFrame = JOptionPane.getFrameForComponent(this);
        this.m_bEdit = bEdit;
        this.m_bRepositoryRequired = bRepositoryRequired;
        this.m_bAddRepositoryEnabled = bAddRepositoryEnabled;
        this.m_showProjectPanel = showProjectPanel;
        this.m_bOpenOnStartup = bOpenOnStartup;
        this._initialize();
    }

    public WAConnectWizard(Dialog dlgOwner) {
        this(dlgOwner, false);
    }

    public WAConnectWizard(Dialog dlgOwner, boolean bEdit) {
        this(dlgOwner, bEdit, false);
    }

    public WAConnectWizard(Dialog dlgOwner, boolean bEdit, boolean bRepositoryRequired) {
        this(dlgOwner, bEdit, bRepositoryRequired, true);
    }

    public WAConnectWizard(Dialog dlgOwner, boolean bEdit, boolean bRepositoryRequired, boolean bAddRepositoryEnabled) {
        this(dlgOwner, bEdit, bRepositoryRequired, bAddRepositoryEnabled, true);
    }

    public WAConnectWizard(Dialog dlgOwner, boolean bEdit, boolean bRepositoryRequired, boolean bAddRepositoryEnabled, boolean showProjectPanel) {
        this(dlgOwner, bEdit, bRepositoryRequired, bAddRepositoryEnabled, showProjectPanel, false);
    }

    public WAConnectWizard(Dialog dlgOwner, boolean bEdit, boolean bRepositoryRequired, boolean bAddRepositoryEnabled, boolean showProjectPanel, boolean bOpenOnStartup) {
        super(dlgOwner, null, true, null, false);
        this.setHelpProduct("newworkspace");
        this.m_parentFrame = JOptionPane.getFrameForComponent(this);
        this.m_bEdit = bEdit;
        this.m_bRepositoryRequired = bRepositoryRequired;
        this.m_bAddRepositoryEnabled = bAddRepositoryEnabled;
        this.m_showProjectPanel = showProjectPanel;
        this.m_bOpenOnStartup = bOpenOnStartup;
        this._initialize();
    }

    protected void _initialize() {
        this.m_workspace = Workspace.getWorkspace();
        this.m_workspaceFile = this.m_workspace.getWorkspaceFile();
        this.m_appDefaultsFile = this.m_workspace.getAppDefaultsFile();
        this.m_bTempConnection = false;
        this.m_bFinish = false;
        if (!this.m_bEdit) {
            this.setTitle(bundle.getString("ConnectWizard.NewTitle.txt"));
        } else {
            this.setTitle(bundle.formatString("ConnectWizard.EditTitle.fmt", this.m_workspaceFile.getPropertyString("Name")));
        }
        if (!this.m_bEdit) {
            this.addTab(bundle.getString("ConnectWizard.WelcomeTab.Title.txt"), "Tab1", new WelcomeTab(), "ConnectWizard.WelcomeTab.image", bundle.getImageIcon("ConnectWizard.WelcomeTab.image"), false);
        }
        this.addTab(bundle.getString("ConnectWizard.WorkspaceTab.Title.txt"), "Tab2", new WorkspaceTab(), "ConnectWizard.WorkspaceTab.image", bundle.getImageIcon("ConnectWizard.WorkspaceTab.image"), false);
        this.addTab(bundle.getString("ConnectWizard.ConnectServerTab.Title.txt"), "Tab3", new ConnectServerTab(), "ConnectWizard.ConnectServerTab.image", bundle.getImageIcon("ConnectWizard.ConnectServerTab.image"), !this.m_bRepositoryRequired);
        if (this.m_showProjectPanel) {
            this.addTab(bundle.getString("ConnectWizard.RepositoriesTab.Title.txt"), "Tab4", new RepositoriesTab(), "ConnectWizard.RepositoriesTab.image", bundle.getImageIcon("ConnectWizard.RepositoriesTab.image"), true);
        }
        this.addTab(bundle.getString("ConnectWizard.FinishTab.Title.txt"), "Tab5", new FinishTab(), "ConnectWizard.FinishTab.image", bundle.getImageIcon("ConnectWizard.FinishTab.image"), true);
    }

    @Override
    protected boolean onFinish() {
        this.m_bFinish = true;
        boolean brc = super.onFinish();
        if (brc) {
            if (this.m_bTempConnection) {
                if (this.m_workspace.isFoundationServicesConnection()) {
                    try {
                        this.m_workspace.getConnectionManager().disconnectFromOMRServer(false);
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException(e);
                    }
                } else {
                    this.m_workspace.closeOMRConnection();
                }
            }
            this.m_appDefaultsFile.setPropertyString("LastWorkspace", this.m_workspaceFile.getFileName());
            this.m_workspaceFile.saveExisting();
            this.m_appDefaultsFile.saveExisting();
        }
        this.doDisposeOfStore();
        return brc;
    }

    @Override
    protected boolean onCancel() {
        if (this.m_bTempConnection) {
            if (this.m_workspace.isFoundationServicesConnection()) {
                try {
                    this.m_workspace.getConnectionManager().disconnectFromOMRServer(false);
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException(e);
                }
            } else {
                this.m_workspace.closeOMRConnection();
            }
        }
        return super.onCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Vector getMyProjectRepositories(String strUserID, List repositories) {
        Vector<String> strIds = new Vector<String>();
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            try {
                String strIdentityType = this.m_workspace.getMyIdentityType();
                if (strIdentityType == null) {
                    Vector<String> vector = strIds;
                    return vector;
                }
                String strIdentityID = this.m_workspace.getMyIdentityID();
                String strTemplate = "<Templates><" + strIdentityType + "><Extensions search=\"@Name='ProjectRepository'\"/></" + strIdentityType + "><Extension Name=\"\" Value=\"\"/></Templates>";
                Identity identity = (Identity)Workspace.getMdFactory().createComplexMetadataObject(store, "name", strIdentityType, strIdentityID);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, strIdentityType, strIdentityID, null, null, strTemplate, 8460);
                int j = 0;
                while (j < identity.getExtensions().size()) {
                    strIds.add(((Extension)identity.getExtensions().elementAt(j)).getValue());
                    ++j;
                }
                return strIds;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
                return strIds;
            }
            finally {
                if (store != null) {
                    store.dispose();
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        return strIds;
    }

    public boolean isProjectPanelEnabled() {
        return this.m_showProjectPanel;
    }

    class WelcomeTab
    extends WsDescriptionWizardTab {
        private static final long serialVersionUID = 1L;
        WATextArea m_taText;

        public WelcomeTab() {
            this.setHelpTopic("workwiz_1");
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        public void initialize() {
            this.setDescription(bundle.getString("ConnectWizard.WelcomeTab.Description.txt"));
            this.m_taText = new WATextArea(bundle.getString("ConnectWizard.WelcomeTab.taText.txt"));
            this.m_taText.setColumns(30);
            this.m_taText.setBehavior(1);
            this.m_taText.setAutosize(true);
            this.setWizardPageType(0);
        }

        @Override
        public void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_taText, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                // empty if block
            }
            return true;
        }

        @Override
        public boolean validateData() {
            return true;
        }
    }

    class WorkspaceTab
    extends WsDescriptionWizardTab {
        private static final long serialVersionUID = 1L;
        JLabel m_lblWorkspaceName;
        WATextField m_tfWorkspaceName;
        JCheckBox m_cbReload;
        String m_strWorkspaceName;
        String m_strWorkspaceFilename;
        String m_strOriginalWorkspaceName;

        public WorkspaceTab() {
            this.setHelpTopic("workwiz_2");
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        public void initialize() {
            this.setDescription(bundle.getString("ConnectWizard.WorkspaceTab.Description.txt"));
            this.m_lblWorkspaceName = new JLabel(bundle.getString("ConnectWizard.WorkspaceTab.lblWorkspaceName.txt"));
            this.m_tfWorkspaceName = new WATextField();
            this.m_cbReload = new JCheckBox(bundle.getString("ConnectWizard.WorkspaceTab.cbReload.txt"));
            this.m_lblWorkspaceName.setLabelFor(this.m_tfWorkspaceName);
            this.m_lblWorkspaceName.setDisplayedMnemonic(bundle.getString("ConnectWizard.WorkspaceTab.lblWorkspaceName.mnem").charAt(0));
            this.m_cbReload.setMnemonic(bundle.getString("ConnectWizard.WorkspaceTab.cbReload.mnem").charAt(0));
        }

        @Override
        public void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_lblWorkspaceName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this.m_tfWorkspaceName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.m_cbReload, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)new WAPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                if (WAConnectWizard.this.m_bEdit) {
                    this.m_strOriginalWorkspaceName = WAConnectWizard.this.m_workspaceFile.getPropertyString("Name");
                    this.m_tfWorkspaceName.setText(this.m_strOriginalWorkspaceName);
                    this.m_cbReload.setVisible(false);
                } else {
                    this.m_tfWorkspaceName.setText(bundle.getString("ConnectWizard.WorkspaceTab.DefaultWorkspaceName.txt"));
                }
                this.m_tfWorkspaceName.requestFocus();
                this.m_tfWorkspaceName.selectAll();
            } else {
                if (WAConnectWizard.this.m_bEdit && this.m_strWorkspaceName.compareTo(this.m_strOriginalWorkspaceName) != 0) {
                    boolean brc;
                    File oldWorkspaceFile = new File(WAConnectWizard.this.m_workspaceFile.getFileName());
                    File newWorkspaceFile = new File(this.m_strWorkspaceFilename);
                    if (oldWorkspaceFile.exists() && !(brc = oldWorkspaceFile.renameTo(newWorkspaceFile))) {
                        MessageUtil.displayMessage(bundle.getString("ConnectWizard.WorkspaceTab.RenameError.txt"), 0);
                    }
                    WAConnectWizard.this.m_workspaceFile.setFileName(this.m_strWorkspaceFilename);
                } else {
                    WAConnectWizard.this.m_workspaceFile.openExisting(this.m_strWorkspaceFilename);
                }
                WAConnectWizard.this.m_workspaceFile.setPropertyString("Name", this.m_tfWorkspaceName.getText().trim());
                WAConnectWizard.this.m_appDefaultsFile.setPropertyBoolean("ReloadLastWorkspace", this.m_cbReload.isSelected());
            }
            return true;
        }

        @Override
        public boolean validateData() {
            String strErrMsg = null;
            this.m_strWorkspaceName = this.m_tfWorkspaceName.getText().trim();
            this.m_strWorkspaceFilename = WAConnectWizard.this.m_appDefaultsFile.getPropertyString("WorkspacePath") + System.getProperty("file.separator") + this.m_strWorkspaceName + ".swa";
            if (this.m_strWorkspaceName.length() == 0) {
                strErrMsg = bundle.getString("ConnectWizard.WorkspaceTab.EmptyError.txt");
            } else if (this.m_strWorkspaceName.indexOf("\\") != -1 || this.m_strWorkspaceName.indexOf("/") != -1 || this.m_strWorkspaceName.indexOf(":") != -1 || this.m_strWorkspaceName.indexOf("*") != -1 || this.m_strWorkspaceName.indexOf("?") != -1 || this.m_strWorkspaceName.indexOf("\"") != -1 || this.m_strWorkspaceName.indexOf("<") != -1 || this.m_strWorkspaceName.indexOf(">") != -1 || this.m_strWorkspaceName.indexOf("|") != -1) {
                strErrMsg = bundle.getString("ConnectWizard.WorkspaceTab.InvalidCharError.txt");
            } else {
                File file = new File(this.m_strWorkspaceFilename);
                if (file.exists()) {
                    if (!file.canWrite()) {
                        strErrMsg = bundle.getString("ConnectWizard.WorkspaceTab.ReadOnlyError.txt");
                    } else if (!WAConnectWizard.this.m_bEdit) {
                        int iChoice = MessageUtil.displayMessage(bundle.getString("ConnectWizard.WorkspaceTab.EditMsg.txt"), bundle.getString("ConnectWizard.WorkspaceTab.EditMsgTitle.txt"), 3, 0);
                        if (iChoice != 0) {
                            return false;
                        }
                    } else if (WAConnectWizard.this.m_bEdit && this.m_strWorkspaceName.compareToIgnoreCase(this.m_strOriginalWorkspaceName) != 0) {
                        strErrMsg = bundle.getString("ConnectWizard.WorkspaceTab.EditError.txt");
                    }
                } else {
                    try {
                        file.createNewFile();
                        file.delete();
                    }
                    catch (IOException e) {
                        strErrMsg = bundle.getString("ConnectWizard.WorkspaceTab.InvalidError.txt") + "  " + e.getLocalizedMessage() + ".";
                    }
                }
            }
            if (strErrMsg != null) {
                this.m_tfWorkspaceName.requestFocus();
                this.m_tfWorkspaceName.selectAll();
                MessageUtil.displayMessage(strErrMsg, 0);
                return false;
            }
            WAConnectWizard.this.m_strFilename = this.m_strWorkspaceFilename;
            return true;
        }

        @Override
        public String createFinishString() {
            String strFinish = bundle.getString("ConnectWizard.WorkspaceTab.strName.txt");
            strFinish = strFinish + "\n   ";
            strFinish = strFinish + this.m_strWorkspaceName;
            strFinish = strFinish + "\n\n";
            strFinish = this.m_cbReload.isSelected() || WAConnectWizard.this.m_bOpenOnStartup ? strFinish + bundle.getString("ConnectWizard.WorkspaceTab.strReloadYes.txt") : strFinish + bundle.getString("ConnectWizard.WorkspaceTab.strReloadNo.txt");
            strFinish = strFinish + "\n\n";
            return strFinish;
        }
    }

    class ConnectServerTab
    extends WsDescriptionWizardTab {
        private static final long serialVersionUID = 1L;
        JLabel m_lblHost;
        JLabel m_lblPort;
        JLabel m_lblUser;
        JLabel m_lblPass;
        WATextField m_tfHost;
        WATextField m_tfPort;
        WATextField m_tfUser;
        WAPasswordField m_pfPass;
        JCheckBox m_cbSaveLogin;
        String m_strHost;
        String m_strPort;
        String m_strUser;
        String m_strPass;
        boolean m_bSaveLogin;
        JLabel m_lblAuthDomain;
        WATextField m_tfAuthDomain;
        String m_strAuthDomain;
        JSeparator m_separator;
        JPanel m_singleSignOnPanel;
        JCheckBox m_singleSignOnCheckBox;
        SingleSignOnAction m_singleSignOnAction;
        JButton m_advancedButton;
        AdvancedAction m_advancedAction;
        private String m_securityPackage;
        private String m_servicePrincipalName;
        private String m_securityPackageList;

        public ConnectServerTab() {
            this.setHelpTopic("workwiz_3");
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        public void initialize() {
            this.setDescription(bundle.getString("ConnectWizard.ConnectServerTab.Description.txt"));
            this.m_lblHost = new JLabel(bundle.getString("ConnectWizard.ConnectServerTab.lblHost.txt"));
            this.m_lblPort = new JLabel(bundle.getString("ConnectWizard.ConnectServerTab.lblPort.txt"));
            this.m_lblUser = new JLabel(bundle.getString("ConnectWizard.ConnectServerTab.lblUser.txt"));
            this.m_lblPass = new JLabel(bundle.getString("ConnectWizard.ConnectServerTab.lblPass.txt"));
            this.m_lblAuthDomain = new JLabel(bundle.getString("ConnectWizard.ConnectServerTab.lblAuthenticationDomain.txt"));
            this.m_tfHost = new WATextField();
            this.m_tfPort = new WATextField();
            this.m_tfUser = new WATextField();
            this.m_pfPass = new WAPasswordField();
            this.m_tfAuthDomain = new WATextField();
            this.m_cbSaveLogin = new JCheckBox(bundle.getString("ConnectWizard.ConnectServerTab.cbSaveLogin.txt"));
            this.m_separator = new JSeparator();
            this.m_singleSignOnAction = new SingleSignOnAction();
            this.m_singleSignOnCheckBox = WsUIUtilities.createCheckBox(this.m_singleSignOnAction);
            this.m_advancedAction = new AdvancedAction();
            this.m_advancedButton = new JButton(this.m_advancedAction);
            this.m_singleSignOnPanel = new JPanel(new BorderLayout());
            this.m_singleSignOnPanel.add((Component)this.m_singleSignOnCheckBox, "West");
            this.m_singleSignOnPanel.add((Component)this.m_advancedButton, "East");
            this.m_lblHost.setLabelFor(this.m_tfHost);
            this.m_lblPort.setLabelFor(this.m_tfPort);
            this.m_lblUser.setLabelFor(this.m_tfUser);
            this.m_lblPass.setLabelFor(this.m_pfPass);
            this.m_lblAuthDomain.setLabelFor(this.m_tfAuthDomain);
            this.m_lblHost.setDisplayedMnemonic(bundle.getString("ConnectWizard.ConnectServerTab.lblHost.mnem").charAt(0));
            this.m_lblPort.setDisplayedMnemonic(bundle.getString("ConnectWizard.ConnectServerTab.lblPort.mnem").charAt(0));
            this.m_lblUser.setDisplayedMnemonic(bundle.getString("ConnectWizard.ConnectServerTab.lblUser.mnem").charAt(0));
            this.m_lblPass.setDisplayedMnemonic(bundle.getString("ConnectWizard.ConnectServerTab.lblPass.mnem").charAt(0));
            this.m_lblAuthDomain.setDisplayedMnemonic(bundle.getString("ConnectWizard.ConnectServerTab.lblAuthenticationDomain.mnem").charAt(0));
            this.m_cbSaveLogin.setMnemonic(bundle.getString("ConnectWizard.ConnectServerTab.cbSaveLogin.mnem").charAt(0));
            this.m_tfPort.setHorizontalAlignment(2);
        }

        @Override
        public void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_lblHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this.m_tfHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.m_lblPort, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.m_tfPort, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)this.m_lblUser, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.m_tfUser, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)this.m_lblPass, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.m_pfPass, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)this.m_lblAuthDomain, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.m_tfAuthDomain, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)this.m_cbSaveLogin, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.m_cbSaveLogin, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled()) {
                this.add((Component)this.m_separator, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
                this.add((Component)this.m_singleSignOnPanel, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            } else {
                this.add((Component)new JPanel(), new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            }
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                if (WAConnectWizard.this.m_bEdit) {
                    this.m_tfUser.setText(WAConnectWizard.this.m_workspaceFile.getPropertyString("userid"));
                    this.m_pfPass.setText(Workspace.getMdFactory().getUtil().decrypt(WAConnectWizard.this.m_workspaceFile.getPropertyString("password")));
                    this.m_tfHost.setText(WAConnectWizard.this.m_workspaceFile.getPropertyString("host"));
                    this.m_tfPort.setText(WAConnectWizard.this.m_workspaceFile.getPropertyString("port"));
                    this.m_tfAuthDomain.setText(WAConnectWizard.this.m_workspaceFile.getPropertyString("authenticationdomain", ""));
                    WAConnectWizard.this.m_bAllowLocalPasswords = WAConnectWizard.this.m_workspaceFile.getPropertyBoolean("AllowLocalPasswords", true);
                    if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled()) {
                        this.m_singleSignOnCheckBox.setSelected(WAConnectWizard.this.m_workspaceFile.getPropertyBoolean("SingleSignOn", false));
                        this.m_securityPackage = WAConnectWizard.this.m_workspaceFile.getPropertyString("SecurityPackage", "Negotiate");
                        this.m_servicePrincipalName = WAConnectWizard.this.m_workspaceFile.getPropertyString("ServicePrincipalName", DEFAULT_SPN);
                        this.m_securityPackageList = WAConnectWizard.this.m_workspaceFile.getPropertyString("SecurityPackageList", "Kerberos,NTLM");
                    }
                } else {
                    File file = new File(WAConnectWizard.this.m_strFilename);
                    if (file.exists()) {
                        WorkspaceFile tmpWorkspaceFile = new WorkspaceFile(WAConnectWizard.this.m_strFilename);
                        this.m_tfUser.setText(tmpWorkspaceFile.getPropertyString("userid"));
                        this.m_pfPass.setText(Workspace.getMdFactory().getUtil().decrypt(tmpWorkspaceFile.getPropertyString("password")));
                        this.m_tfHost.setText(tmpWorkspaceFile.getPropertyString("host"));
                        this.m_tfPort.setText(tmpWorkspaceFile.getPropertyString("port"));
                        this.m_tfAuthDomain.setText(WAConnectWizard.this.m_workspaceFile.getPropertyString("authenticationdomain", ""));
                        if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled()) {
                            this.m_singleSignOnCheckBox.setSelected(tmpWorkspaceFile.getPropertyBoolean("SingleSignOn", false));
                            this.m_securityPackage = WAConnectWizard.this.m_workspaceFile.getPropertyString("SecurityPackage", "Negotiate");
                            this.m_servicePrincipalName = WAConnectWizard.this.m_workspaceFile.getPropertyString("ServicePrincipalName", DEFAULT_SPN);
                            this.m_securityPackageList = WAConnectWizard.this.m_workspaceFile.getPropertyString("SecurityPackageList", "Kerberos,NTLM");
                        }
                    } else {
                        if (this.m_tfPort != null && this.m_tfPort.getText().length() <= 0) {
                            this.m_tfPort.setText(bundle.getString("ConnectWizard.ConnectServerTab.DefaultServerPort.notrans"));
                        }
                        this.m_tfAuthDomain.setText("");
                        if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled()) {
                            this.m_singleSignOnCheckBox.setSelected(false);
                            this.m_securityPackage = "Negotiate";
                            this.m_servicePrincipalName = DEFAULT_SPN;
                            this.m_securityPackageList = "Kerberos,NTLM";
                        }
                    }
                }
                this.m_cbSaveLogin.setEnabled(WAConnectWizard.this.m_bAllowLocalPasswords);
                if (!(this.m_tfUser.getText().length() <= 0 && this.m_pfPass.getPassword().length <= 0 || WAConnectWizard.this.m_workspace.isSingleSignOnEnabled() && this.m_singleSignOnCheckBox.isSelected() || !WAConnectWizard.this.m_bAllowLocalPasswords)) {
                    this.m_cbSaveLogin.setSelected(true);
                }
                if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled()) {
                    this.updateActions();
                    this.updateComponents();
                }
                WAConnectWizard.this.m_workspace.getConnectionManager().setNoredirect(WAConnectWizard.this.m_workspaceFile.getPropertyBoolean("Noredirect", false));
                WAConnectWizard.this.m_workspace.getConnectionManager().setTenant(WAConnectWizard.this.m_workspaceFile.getPropertyString("Tenant"));
            } else {
                WAConnectWizard.this.m_workspaceFile.setPropertyString("host", this.m_strHost);
                WAConnectWizard.this.m_workspaceFile.setPropertyString("port", this.m_strPort);
                WAConnectWizard.this.m_workspaceFile.setPropertyString("authenticationdomain", this.m_strAuthDomain);
                if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled() && this.m_singleSignOnCheckBox.isSelected()) {
                    WAConnectWizard.this.m_workspaceFile.setPropertyBoolean("SingleSignOn", this.m_singleSignOnCheckBox.isSelected());
                    if (!this.m_securityPackage.equals("Negotiate")) {
                        WAConnectWizard.this.m_workspaceFile.setPropertyString("SecurityPackage", this.m_securityPackage);
                    } else {
                        WAConnectWizard.this.m_workspaceFile.removeProperty("SecurityPackage");
                    }
                    if (!this.m_servicePrincipalName.equals(DEFAULT_SPN)) {
                        WAConnectWizard.this.m_workspaceFile.setPropertyString("ServicePrincipalName", this.m_servicePrincipalName);
                    } else {
                        WAConnectWizard.this.m_workspaceFile.removeProperty("ServicePrincipalName");
                    }
                    if (!this.m_securityPackageList.equals("Kerberos,NTLM")) {
                        WAConnectWizard.this.m_workspaceFile.setPropertyString("SecurityPackageList", this.m_securityPackageList);
                    } else {
                        WAConnectWizard.this.m_workspaceFile.removeProperty("SecurityPackageList");
                    }
                    WAConnectWizard.this.m_workspaceFile.setPropertyString("userid", "");
                    WAConnectWizard.this.m_workspaceFile.setPropertyString("password", "");
                } else if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled() && !this.m_singleSignOnCheckBox.isSelected()) {
                    WAConnectWizard.this.m_workspaceFile.setPropertyBoolean("SingleSignOn", false);
                }
                WAConnectWizard.this.m_workspaceFile.setPropertyBoolean("AllowLocalPasswords", WAConnectWizard.this.m_workspace.getConnectionManager().allowLocalPasswords());
                try {
                    WAConnectWizard.this.m_workspaceFile.setPropertyBoolean("InternalAccount", WAConnectWizard.this.m_workspace.getConnectionManager().isValidInternalAccount());
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage(e);
                }
                if (!WAConnectWizard.this.m_workspace.isSingleSignOnEnabled() || !this.m_singleSignOnCheckBox.isSelected()) {
                    if (this.m_cbSaveLogin.isSelected()) {
                        if (WAConnectWizard.this.m_workspace.getConnectionManager().allowLocalPasswords()) {
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("userid", this.m_strUser);
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("password", this.m_strPass);
                        } else {
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("userid", "");
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("password", "");
                        }
                    } else {
                        WAConnectWizard.this.m_workspaceFile.setPropertyString("userid", "");
                        WAConnectWizard.this.m_workspaceFile.setPropertyString("password", "");
                        WAConnectWizard.this.m_workspace.setUsername(this.m_strUser);
                        WAConnectWizard.this.m_workspace.setPassword(this.m_strPass);
                    }
                }
                try {
                    if (!WAConnectWizard.this.m_showProjectPanel) {
                        OMIServerRepository foundationRepository = (OMIServerRepository)WAConnectWizard.this.m_workspace.getConnectionManager().getMetadataServer().getFoundationRepository();
                        if (foundationRepository != null) {
                            String foundationRepositoryId = foundationRepository.getDefaultRepositoryId();
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("SelectedReps", foundationRepositoryId);
                            String appServerRepository = WAConnectWizard.this.m_workspaceFile.getPropertyString("AppServer.Default");
                            if (appServerRepository != null && appServerRepository.length() > 0 && (appServerRepository = "." + appServerRepository.substring(0, appServerRepository.indexOf("."))).indexOf(appServerRepository) == -1) {
                                WAConnectWizard.this.m_workspaceFile.setPropertyString("AppServer.Default", "");
                            }
                        } else {
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("SelectedReps", "");
                        }
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException(e);
                }
                catch (ServiceException e) {
                    Workspace.handleServiceException(e);
                }
            }
            return true;
        }

        @Override
        public boolean validateData() {
            String strErrMsg = null;
            this.m_strHost = this.m_tfHost.getText().trim();
            this.m_strPort = this.m_tfPort.getText().trim();
            WAConnectWizard.this.m_holdStrUser = this.m_strUser = this.m_tfUser.getText().trim();
            this.m_strPass = new String(this.m_pfPass.getPassword());
            this.m_strAuthDomain = this.m_tfAuthDomain.getText().trim();
            if (this.m_strHost.length() == 0) {
                this.m_tfHost.requestFocus();
                strErrMsg = bundle.getString("ConnectWizard.ConnectServerTab.tfHost.Error.txt");
            } else if (!(this.m_singleSignOnCheckBox.isSelected() || !this.m_cbSaveLogin.isSelected() && WAConnectWizard.this.m_bFinish)) {
                if (this.m_strUser.length() == 0) {
                    this.m_tfUser.requestFocus();
                    strErrMsg = bundle.getString("ConnectWizard.ConnectServerTab.tfUser.Error.txt");
                } else if (this.m_strPass.length() == 0 || this.m_strPass.toLowerCase().indexOf("{sas") == 0) {
                    this.m_pfPass.requestFocus();
                    strErrMsg = bundle.getString("ConnectWizard.ConnectServerTab.pfPass.Error.txt");
                }
            }
            if (!WAConnectWizard.this.m_workspace.isSingleSignOnEnabled() || !this.m_singleSignOnCheckBox.isSelected()) {
                try {
                    this.m_strPass = Workspace.getMdFactory().getUtil().encrypt(this.m_strPass);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
            }
            if (strErrMsg == null) {
                try {
                    HostPortSet.newInstance((String)this.m_strHost, (String)this.m_strPort);
                }
                catch (IllegalArgumentException e) {
                    this.m_tfPort.requestFocus();
                    strErrMsg = e.getLocalizedMessage();
                }
            }
            if (strErrMsg == null) {
                boolean brc;
                block32: {
                    if (WAConnectWizard.this.m_bTempConnection) {
                        WAConnectWizard.this.m_workspace.closeOMRConnection();
                    }
                    if (WAConnectWizard.this.m_workspace.isSingleSignOnEnabled() && this.m_singleSignOnCheckBox.isSelected()) {
                        this.m_strUser = null;
                        WAConnectWizard.this.m_workspace.getConnectionManager().setSecurityPackage(this.m_securityPackage);
                        WAConnectWizard.this.m_workspace.getConnectionManager().setServicePrincipalName(this.m_servicePrincipalName);
                        WAConnectWizard.this.m_workspace.getConnectionManager().setSecurityPackageList(this.m_securityPackageList);
                    }
                    brc = false;
                    if (WAConnectWizard.this.m_workspace.isFoundationServicesConnection()) {
                        try {
                            WAConnectWizard.this.m_workspace.getConnectionManager().connectToOMRServer(this.m_strHost, this.m_strPort, this.m_strAuthDomain, this.m_strUser, this.m_strPass, true);
                            brc = true;
                            if (this.m_cbSaveLogin.isSelected() && !WAConnectWizard.this.m_workspace.getConnectionManager().allowLocalPasswords()) {
                                MessageUtil.displayMessage(bundle.getString("ConnectWizard.ConnectServerTab.LocalPasswordsNotAllowed.txt"), 2);
                                WAConnectWizard.this.m_bAllowLocalPasswords = false;
                                this.m_cbSaveLogin.setSelected(false);
                                this.m_cbSaveLogin.setEnabled(false);
                            }
                        }
                        catch (ConnectionException ex) {
                            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
                            brc = false;
                        }
                        catch (RemoteException ex) {
                            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
                            brc = false;
                        }
                        catch (ExpiredPasswordLoginServiceException ex) {
                            if (Workspace.isUsingNewStartupReturnValues() && this.m_strUser.toUpperCase().contains("@SASPW")) {
                                String errorTitleString = "";
                                if (WAConnectWizard.this.m_parentFrame != null && WAConnectWizard.this.m_parentFrame.getTitle().length() > 0) {
                                    errorTitleString = WAConnectWizard.this.m_parentFrame.getTitle();
                                }
                                if (errorTitleString == null || errorTitleString.trim().length() < 1) {
                                    errorTitleString = bundle.getString("Common.Error.txt");
                                }
                                InternalLoginPasswordChangeDialog ilpcd = new InternalLoginPasswordChangeDialog(WindowUtil.getParentDialog(this), this.m_strUser, errorTitleString);
                                ilpcd.setUserService(WAConnectWizard.this.m_workspace.getConnectionManager().getUserService());
                                ilpcd.setPort(this.m_strPort);
                                ilpcd.setHost(this.m_strHost);
                                ilpcd.setSize(300, 300);
                                ilpcd.centerOnParent();
                                ilpcd.setVisible(true);
                                if (ilpcd.m_success) {
                                    JOptionPane.showMessageDialog(this, bundle.getString("IMS.IPPasswordResetSuccess.Message.txt"), bundle.getString("IMS.IPPasswordResetSuccess.Title.txt"), 1);
                                } else {
                                    JOptionPane.showMessageDialog(this, bundle.getString("IMS.IPPasswordResetFailure.Message.txt"), bundle.getString("IMS.IPPasswordResetFailure.Title.txt"), 1);
                                }
                                break block32;
                            }
                            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
                            brc = false;
                        }
                        catch (ServiceException ex) {
                            MessageUtil.displayServiceExceptionMessage(ex);
                            brc = false;
                        }
                        catch (InterruptedException ex) {
                            MessageUtil.displayMessage(bundle.getString("Workspace.ConnectError.txt"), 0);
                            brc = false;
                        }
                        catch (Exception ex) {
                            Workspace.getDefaultLogger().error((Object)"", ex);
                            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
                            brc = false;
                        }
                    } else {
                        brc = WAConnectWizard.this.m_workspace.makeOMRConnection(this.m_strHost, this.m_strPort, this.m_strUser, this.m_strPass, false);
                    }
                }
                WAConnectWizard.this.m_bTempConnection = brc;
                if (!brc) {
                    this.m_tfHost.requestFocus();
                    this.m_tfHost.selectAll();
                    return false;
                }
            }
            if (strErrMsg != null) {
                MessageUtil.displayMessage(strErrMsg, 0);
                return false;
            }
            return true;
        }

        @Override
        public String createFinishString() {
            String strFinish = bundle.getString("ConnectWizard.ConnectServerTab.strHost.txt");
            strFinish = strFinish + "\n   ";
            strFinish = strFinish + this.m_strHost;
            strFinish = strFinish + "\n";
            strFinish = strFinish + bundle.getString("ConnectWizard.ConnectServerTab.strPort.txt");
            strFinish = strFinish + "\n   ";
            strFinish = strFinish + this.m_strPort;
            if (!this.m_singleSignOnCheckBox.isSelected() && this.m_cbSaveLogin.isSelected()) {
                strFinish = strFinish + "\n";
                strFinish = strFinish + bundle.getString("ConnectWizard.ConnectServerTab.strUser.txt");
                strFinish = strFinish + "\n   ";
                strFinish = strFinish + this.m_strUser;
                strFinish = strFinish + "\n";
                strFinish = strFinish + bundle.getString("ConnectWizard.ConnectServerTab.strPass.txt");
                strFinish = strFinish + "\n   ";
                String strPassword = "";
                try {
                    int iNumChars = Workspace.getMdFactory().getUtil().decrypt(this.m_strPass).length();
                    for (int i = 0; i < iNumChars; ++i) {
                        strPassword = strPassword + "*";
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
                strFinish = strFinish + strPassword;
                if (this.m_strAuthDomain.length() > 0) {
                    strFinish = strFinish + "\n";
                    strFinish = strFinish + bundle.getString("ConnectWizard.ConnectServerTab.lblAuthenticationDomainLabelInWizardSummary.txt");
                    strFinish = strFinish + "\n   ";
                    strFinish = strFinish + this.m_strAuthDomain;
                }
            } else if (!this.m_singleSignOnCheckBox.isSelected() && !this.m_cbSaveLogin.isSelected()) {
                if (this.m_strAuthDomain.length() > 0) {
                    strFinish = strFinish + "\n";
                    strFinish = strFinish + bundle.getString("ConnectWizard.ConnectServerTab.lblAuthenticationDomainLabelInWizardSummary.txt");
                    strFinish = strFinish + "\n   ";
                    strFinish = strFinish + this.m_strAuthDomain;
                }
                strFinish = strFinish + "\n\n";
                strFinish = strFinish + bundle.getString("ConnectWizard.ConnectServerTab.strNoLogin.txt");
            } else if (this.m_singleSignOnCheckBox.isSelected()) {
                strFinish = strFinish + "\n\n";
                strFinish = strFinish + bundle.getString("ConnectWizard.ConnectServerTab.SingleSignonSelected.txt");
            }
            strFinish = strFinish + "\n\n";
            return strFinish;
        }

        protected void updateComponents() {
            if (!WAConnectWizard.this.m_workspace.isSingleSignOnEnabled()) {
                return;
            }
            this.m_tfUser.setEnabled(!this.m_singleSignOnCheckBox.isSelected());
            this.m_pfPass.setEnabled(!this.m_singleSignOnCheckBox.isSelected());
            this.m_tfAuthDomain.setEnabled(!this.m_singleSignOnCheckBox.isSelected());
            this.m_cbSaveLogin.setEnabled(!this.m_singleSignOnCheckBox.isSelected() && WAConnectWizard.this.m_bAllowLocalPasswords);
            this.m_advancedAction.setEnabled(this.m_singleSignOnCheckBox.isSelected());
        }

        protected void updateActions() {
            if (!WAConnectWizard.this.m_workspace.isSingleSignOnEnabled()) {
                return;
            }
            this.m_advancedAction.setEnabled(this.m_singleSignOnCheckBox.isSelected());
        }

        protected class SingleSignOnAction
        extends WsAbstractToggleAction {
            public SingleSignOnAction() {
                super(bundle, "ConnectWizard.ConnectServerTab.UseIntegratedWindowsAuthentication", 0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectServerTab.this.updateComponents();
                ConnectServerTab.this.updateActions();
            }
        }

        protected class AdvancedAction
        extends WsAbstractAction {
            public AdvancedAction() {
                super(bundle, "ConnectWizard.ConnectServerTab.Advanced", 0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthenticationSettingsPanel authPanel = new AuthenticationSettingsPanel();
                WAStandardDialog dialog = new WAStandardDialog(WAConnectWizard.this, bundle.getString("AdvancedAuthenticationSettingsPanel.Title.txt"), true);
                dialog.setMainPanel(authPanel);
                dialog.setResizable(true);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    // empty if block
                }
            }
        }

        protected class AuthenticationSettingsPanel
        extends WAPropertyTab {
            protected JComboBox m_packageComboBox;
            protected JTextField m_principalNameTextField;
            protected JTextField m_packageListTextField;
            protected ActionListener m_lsnrType;

            public AuthenticationSettingsPanel() {
                this.initialize();
                this.createListeners();
                this.setHelpProduct("newworkspace");
                this.setHelpTopic("workwiz_advanced");
            }

            protected void removeComboListener() {
                this.m_packageComboBox.removeActionListener(this.m_lsnrType);
            }

            protected void addComboListener() {
                this.m_packageComboBox.addActionListener(this.m_lsnrType);
            }

            @Override
            public void initialize() {
                this.m_packageComboBox = new JComboBox<String>(new String[]{"Negotiate", "Kerberos", "NTLM"});
                JLabel packageLabel = WsUIUtilities.createLabelAndToolTipForComponent(this.m_packageComboBox, bundle, "AdvancedAuthenticationSettingsPanel.SecurityPackage");
                this.m_principalNameTextField = new JTextField();
                JLabel principalLabel = WsUIUtilities.createLabelAndToolTipForComponent(this.m_principalNameTextField, bundle, "AdvancedAuthenticationSettingsPanel.ServicePrincipalName");
                this.m_packageListTextField = new JTextField("Kerberos,NTLM");
                JLabel packageListLabel = WsUIUtilities.createLabelAndToolTipForComponent(this.m_packageListTextField, bundle, "AdvancedAuthenticationSettingsPanel.SecurityPackageList");
                this.setLayout(new GridBagLayout());
                this.add((Component)packageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
                this.add((Component)this.m_packageComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
                this.add((Component)principalLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
                this.add((Component)this.m_principalNameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
                this.add((Component)packageListLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
                this.add((Component)this.m_packageListTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
                this.add((Component)new WAPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            }

            protected void createListeners() {
                this.m_lsnrType = this.createComboListener();
            }

            protected ActionListener createComboListener() {
                return new cComboListener();
            }

            @Override
            public void moveDataToStore() throws MdException, RemoteException {
                this.removeComboListener();
                ConnectServerTab.this.m_securityPackage = (String)this.m_packageComboBox.getSelectedItem();
                ConnectServerTab.this.m_servicePrincipalName = this.m_principalNameTextField.getText();
                ConnectServerTab.this.m_securityPackageList = this.m_packageListTextField.getText();
            }

            @Override
            public void moveDataToView() {
                this.addComboListener();
                this.m_packageComboBox.setSelectedItem(ConnectServerTab.this.m_securityPackage);
                this.m_principalNameTextField.setText(ConnectServerTab.this.m_servicePrincipalName);
                this.m_packageListTextField.setText(ConnectServerTab.this.m_securityPackageList);
            }

            protected class cComboListener
            implements ActionListener {
                protected cComboListener() {
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((String)AuthenticationSettingsPanel.this.m_packageComboBox.getSelectedItem()).equalsIgnoreCase("NTLM")) {
                        AuthenticationSettingsPanel.this.m_principalNameTextField.setEnabled(false);
                        AuthenticationSettingsPanel.this.m_packageListTextField.setEnabled(false);
                    } else if (((String)AuthenticationSettingsPanel.this.m_packageComboBox.getSelectedItem()).equalsIgnoreCase("Kerberos")) {
                        AuthenticationSettingsPanel.this.m_principalNameTextField.setEnabled(true);
                        AuthenticationSettingsPanel.this.m_packageListTextField.setEnabled(false);
                    } else {
                        AuthenticationSettingsPanel.this.m_principalNameTextField.setEnabled(true);
                        AuthenticationSettingsPanel.this.m_packageListTextField.setEnabled(true);
                    }
                }
            }
        }
    }

    class RepositoriesTab
    extends WsDescriptionWizardTab {
        private static final long serialVersionUID = 1L;
        JList m_lstRepositories;
        JScrollPane m_scrListPane;
        JButton m_btnSelectAll;
        JButton m_btnDeselectAll;
        JButton m_btnAddRepository;
        DefaultListModel m_repositoriesModel;
        Vector m_vecRepositoryIDs;
        String m_strDefaultRep;
        JCheckBox m_connectProjectCheckbox;
        WsAbstractToggleAction m_connectProjectAction;
        boolean m_serverPaused;

        public RepositoriesTab() {
            this.setHelpTopic("workwiz_4");
            this.initialize();
            this.layoutWidgets();
            this.m_serverPaused = false;
        }

        @Override
        public void initialize() {
            this.setDescription(bundle.getString("ConnectWizard.RepositoriesTab.Description.txt"));
            this.m_connectProjectAction = new ConnectProjectAction();
            this.m_connectProjectCheckbox = WsUIUtilities.createCheckBox(this.m_connectProjectAction);
            this.m_repositoriesModel = new DefaultListModel();
            this.m_lstRepositories = new JList(this.m_repositoriesModel);
            ConnectListBoxRenderer renderer = new ConnectListBoxRenderer();
            this.m_lstRepositories.setCellRenderer(renderer);
            this.m_scrListPane = new JScrollPane(this.m_lstRepositories);
            this.m_btnAddRepository = new JButton(bundle.getString("ConnectWizard.RepositoriesTab.btnAddRepository.txt"));
            this.m_lstRepositories.setSelectionMode(0);
            this.m_btnAddRepository.setMnemonic(bundle.getString("ConnectWizard.RepositoriesTab.btnAddRepository.mnem").charAt(0));
            if (WAConnectWizard.this.m_bAddRepositoryEnabled) {
                this.m_btnAddRepository.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        try {
                            String strPreStatus = "<state>";
                            String strPostStatus = "</state>";
                            StringHolder returnInfo = new StringHolder("");
                            Workspace.getWorkspace().getIServer().Status("<state/>", returnInfo, "");
                            int iPreStatus = returnInfo.value.indexOf(strPreStatus);
                            int IPostStatus = returnInfo.value.indexOf(strPostStatus);
                            if (returnInfo.value.substring(iPreStatus + strPreStatus.length(), IPostStatus).compareTo("1") == 0) {
                                MessageUtil.displayMessage(bundle.getString("ConnectWizard.RepositoriesTab.ServerPaused.txt"), 0);
                                return;
                            }
                        }
                        catch (Exception e) {
                            Workspace.getDefaultLogger().error((Object)"", e);
                            return;
                        }
                        Class[] classArgs = new Class[]{Frame.class, IOMI.class, IServer.class, String.class};
                        Object[] objectArgs = new Object[]{Workspace.getWorkspace(), Workspace.getWorkspace().getCMRHandle(), Workspace.getWorkspace().getIServer(), Workspace.getWorkspace().getServerName()};
                        Constructor<?> newReposWizardConstructor = null;
                        WAWizardDialog wizard = null;
                        try {
                            newReposWizardConstructor = Class.forName("com.sas.workspace.mgmt.visuals.NewReposWizard").getConstructor(classArgs);
                            wizard = (WAWizardDialog)newReposWizardConstructor.newInstance(objectArgs);
                        }
                        catch (ClassNotFoundException cnfe) {
                            cnfe.printStackTrace();
                        }
                        catch (NoSuchMethodException nsme) {
                            nsme.printStackTrace();
                        }
                        catch (IllegalAccessException iae) {
                            iae.printStackTrace();
                        }
                        catch (InstantiationException ie) {
                            ie.printStackTrace();
                        }
                        catch (InvocationTargetException ite) {
                            ite.printStackTrace();
                        }
                        wizard.show();
                        wizard.dispose();
                        try {
                            RepositoriesTab.this.doDataExchange(false);
                        }
                        catch (MdException e) {
                            MessageUtil.displayMetadataExceptionMessage(e, "Reading");
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException(re);
                        }
                    }
                });
            }
        }

        @Override
        public void layoutWidgets() {
            WAPanel pnlSelection = new WAPanel();
            pnlSelection.setLayout(new GridBagLayout());
            pnlSelection.add((Component)this.m_btnAddRepository, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 16, 2, new Insets(6, 6, 0, 6), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_connectProjectCheckbox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_scrListPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(6, 22, 0, 6), 0, 0));
            if (WAConnectWizard.this.m_bAddRepositoryEnabled) {
                this.add((Component)pnlSelection, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 3, new Insets(6, 6, 0, 6), 0, 0));
            }
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                this.m_serverPaused = false;
                this.m_repositoriesModel.removeAllElements();
                this.m_vecRepositoryIDs = new Vector();
                if (WAConnectWizard.this.m_workspace.getMetadataServerStatus() == Workspace.SERVERSTATUS_PAUSED) {
                    this.m_serverPaused = true;
                } else {
                    try {
                        List repositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
                        Vector strIds = new Vector();
                        try {
                            strIds = WAConnectWizard.this.getMyProjectRepositories(WAConnectWizard.this.m_holdStrUser, repositories);
                        }
                        catch (Exception e) {
                            Workspace.getDefaultLogger().error((Object)"", e);
                        }
                        for (int i = 0; i < repositories.size(); ++i) {
                            CMetadata tmpMetadata = (CMetadata)repositories.get(i);
                            String repositoryId = tmpMetadata.getFQID();
                            String repositoryName = tmpMetadata.getName();
                            String strType = WsRepositoryUtil.getRepositoryType(Workspace.getMdFactory(), repositoryId);
                            if (strType.compareTo("PROJECT") != 0) continue;
                            boolean found = false;
                            for (int j = 0; j < strIds.size(); ++j) {
                                if (((String)strIds.elementAt(j)).indexOf(repositoryId) == -1) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            ImageIcon repositoryIcon = bundle.getImageIcon("Common.MetadataTypes.Project.image");
                            JLabel object = new JLabel(repositoryName, repositoryIcon, 0);
                            this.m_repositoriesModel.addElement(object);
                            this.m_vecRepositoryIDs.addElement(repositoryId);
                        }
                    }
                    catch (Exception ge) {
                        Workspace.getDefaultLogger().error((Object)"", ge);
                    }
                }
                if (this.m_repositoriesModel.size() > 0) {
                    this.m_lstRepositories.setSelectedIndex(0);
                }
                this.m_lstRepositories.requestFocus();
                this.m_strDefaultRep = WAConnectWizard.this.m_workspaceFile.getPropertyString("SelectedReps", "");
                int index = this.m_strDefaultRep.indexOf(",");
                if (index > -1) {
                    this.m_strDefaultRep = this.m_strDefaultRep.substring(0, index);
                }
                if (WAConnectWizard.this.m_bEdit) {
                    for (int i = 0; i < this.m_vecRepositoryIDs.size(); ++i) {
                        if (((String)this.m_vecRepositoryIDs.get(i)).compareTo(this.m_strDefaultRep) != 0) continue;
                        this.m_lstRepositories.setSelectedIndex(i);
                        this.m_connectProjectAction.setSelected(true);
                        break;
                    }
                }
                this.updateComponents();
            } else {
                String id;
                block21: {
                    id = null;
                    int index = this.m_lstRepositories.getSelectedIndex();
                    if (index < 0) {
                        try {
                            OMIServerRepository foundationRepository = (OMIServerRepository)WAConnectWizard.this.m_workspace.getConnectionManager().getMetadataServer().getFoundationRepository();
                            if (foundationRepository != null) {
                                id = foundationRepository.getDefaultRepositoryId();
                                WAConnectWizard.this.m_workspaceFile.setPropertyString("SelectedReps", id);
                                break block21;
                            }
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("SelectedReps", "");
                        }
                        catch (ServiceException e) {
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("SelectedReps", "");
                            MessageUtil.displayServiceExceptionMessage(e);
                        }
                        catch (RemoteException e) {
                            WAConnectWizard.this.m_workspaceFile.setPropertyString("SelectedReps", "");
                            MessageUtil.displayRemoteExceptionMessage(e);
                        }
                    } else {
                        id = (String)this.m_vecRepositoryIDs.get(index);
                        WAConnectWizard.this.m_workspaceFile.setPropertyString("SelectedReps", id);
                    }
                }
                String appServerId = WAConnectWizard.this.m_workspaceFile.getPropertyString("AppServer.Default");
                if (appServerId != null && appServerId.length() > 0 && id != null && id.indexOf("." + appServerId.substring(0, appServerId.indexOf("."))) == -1) {
                    WAConnectWizard.this.m_workspaceFile.setPropertyString("AppServer.Default", "");
                }
            }
            return true;
        }

        @Override
        public boolean validateData() {
            if (WAConnectWizard.this.m_bRepositoryRequired && this.m_lstRepositories.getSelectedIndex() == -1) {
                this.m_lstRepositories.requestFocus();
                MessageUtil.displayMessage(bundle.getString("ConnectWizard.RepositoriesTab.lstRepositories.Error.txt"), 0);
                return false;
            }
            return true;
        }

        public void updateComponents() {
            if (this.m_lstRepositories.getModel().getSize() <= 0) {
                this.m_lstRepositories.setBackground(UIManager.getColor("TextField.inactiveBackground"));
                this.m_lstRepositories.clearSelection();
                this.m_scrListPane.setEnabled(false);
                ImageIcon repositoryIcon = bundle.getImageIcon("Common.EmptyIcon.image");
                JLabel emptyLabel = new JLabel(this.m_serverPaused ? bundle.getString("ConnectWizard.RepositoriesTab.NoProjectsServerPaused.txt") : bundle.getString("ConnectWizard.RepositoriesTab.NoProjects.txt"), repositoryIcon, 0);
                emptyLabel.setAlignmentY(0.0f);
                this.m_repositoriesModel.addElement(emptyLabel);
                this.m_lstRepositories.setEnabled(false);
                this.m_connectProjectAction.setEnabled(false);
            } else {
                this.m_connectProjectAction.setEnabled(true);
            }
            if (this.m_connectProjectAction.isSelected()) {
                this.m_lstRepositories.setBackground(UIManager.getColor("List.background"));
                if (this.m_lstRepositories.getModel().getSize() > 0) {
                    this.m_lstRepositories.setSelectedIndex(0);
                }
                this.m_scrListPane.setEnabled(this.m_connectProjectAction.isSelected());
                this.m_lstRepositories.setEnabled(this.m_connectProjectAction.isSelected());
            } else {
                this.m_lstRepositories.setBackground(UIManager.getColor("TextField.inactiveBackground"));
                this.m_lstRepositories.clearSelection();
                this.m_scrListPane.setEnabled(this.m_connectProjectAction.isSelected());
                this.m_lstRepositories.setEnabled(this.m_connectProjectAction.isSelected());
            }
            if (this.m_serverPaused) {
                MessageUtil.displayMessage(bundle.getString("ConnectWizard.RepositoriesTab.NoProjectInformationServerPaused.txt"), bundle.getString("ConnectWizard.WelcomeTab.Title.txt"), 0);
            }
        }

        protected class ConnectProjectAction
        extends WsAbstractToggleAction {
            private static final long serialVersionUID = 1L;

            public ConnectProjectAction() {
                super(bundle, "ConnectWizard.RepositoriesTab.ConnectProject", 0);
                this.setSelected(false);
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                RepositoriesTab.this.updateComponents();
            }
        }

        protected class ConnectListBoxRenderer
        extends JLabel
        implements ListCellRenderer {
            private static final long serialVersionUID = 1L;

            public ConnectListBoxRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                ImageIcon icon = (ImageIcon)((JLabel)value).getIcon();
                this.setText(((JLabel)value).getText());
                this.setIcon(icon);
                return this;
            }
        }
    }

    class FinishTab
    extends WsDescriptionWizardTab {
        private static final long serialVersionUID = 1L;
        JScrollPane m_scrScrollPane;
        JTextPane m_tpText;
        DefaultStyledDocument m_doc;

        public FinishTab() {
            this.setHelpTopic("workwiz_5");
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        public void initialize() {
            this.setDescription(bundle.getString("ConnectWizard.FinishTab.Description.txt"));
            this.m_doc = new DefaultStyledDocument();
            this.m_tpText = new JTextPane(this.m_doc);
            this.m_scrScrollPane = new JScrollPane(this.m_tpText);
            this.m_tpText.setEditable(false);
            if (!WAWizardDialog.isUsingNewStyle()) {
                this.m_tpText.setBackground(SystemColor.control);
            }
            this.setWizardPageType(2);
        }

        @Override
        public void layoutWidgets() {
            WAPanel pnlMain = new WAPanel();
            pnlMain.setLayout(new GridBagLayout());
            if (!WAWizardDialog.isUsingNewStyle()) {
                pnlMain.setBorder(BorderFactory.createLoweredBevelBorder());
            }
            pnlMain.add((Component)this.m_scrScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)pnlMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
                myParent.runFinish();
                String initString = (String)myParent.getWizardData("FINISHINFO");
                try {
                    this.m_doc.insertString(0, initString, null);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                this.m_tpText.setCaretPosition(0);
            }
            return true;
        }

        @Override
        public boolean validateData() {
            return true;
        }

        @Override
        public void onBack() {
            ((WAWizardDialog)this.getTopLevelAncestor()).removeWizardData("FINISHINFO");
            try {
                this.m_doc.remove(0, this.m_doc.getLength());
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }
}

