/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASFileRef;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.AppServer;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.connection.ConnectionManager;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ServerSupport {
    public static final String CONNECT_CLSID = "028e4060-d545-11d5-880d-aa0004006d06";
    public static final String WORKSPACE_CLSID = "440196D4-90F0-11D0-9F41-00A024BB830C";
    public static final String GRID_CLSID = "D7E796B4-654C-4ab3-B690-657EE79309FB";
    private static final String WORKLOAD_PROPERTY_NAME = "Workload";
    private ServerContext m_server = null;
    private ServerContext m_defaultServer = null;
    private String m_hostName = null;
    private String m_hostAddress = null;
    private String m_hostPort = null;
    private String m_comamid = null;
    private String m_userid = null;
    private String m_signonOptions = "";
    private String m_password = null;
    private String m_scriptFile = null;
    private String m_fileRef = null;
    private boolean m_firstSignon = false;
    private static ArrayList m_alServerSupportCache = new ArrayList();
    private static WAdminResource bundle = WAdminResource.getBundle(ServerSupport.class);

    public ServerSupport(ServerContext iSCx) throws MdException, RemoteException {
        this.m_server = iSCx;
        AppServer app = new AppServer(iSCx.getObjectStore(), Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default"));
        this.m_defaultServer = app.getServerContext();
        this.setServerSpecs();
    }

    public ServerSupport(ServerContext iSCx, ServerContext iDefaultServer) throws MdException, RemoteException {
        this.m_server = iSCx;
        this.m_defaultServer = iDefaultServer;
        this.setServerSpecs();
    }

    public StringBuffer access() throws MdException, RemoteException {
        StringBuffer sRetStr = new StringBuffer();
        if (this.checkLocal()) {
            return sRetStr;
        }
        if (this.onSignonCache()) {
            return sRetStr;
        }
        this.setServerSpecs();
        if (this.m_hostName == null) {
            throw new MdException(bundle.formatString("ServerSupport.BadServerDefinition.txt", this.m_server.getName()));
        }
        boolean scripted = false;
        if (this.m_scriptFile != null) {
            scripted = true;
        }
        if (this.m_comamid != null && this.m_comamid != "") {
            sRetStr.append("options comamid=" + this.m_comamid + ";\n");
        }
        String source = "%let " + this.m_hostName + "=" + this.m_hostAddress;
        if (this.m_hostPort.length() > 0 && !scripted) {
            source = source + " " + this.m_hostPort;
        }
        source = source + ";\n";
        if (scripted) {
            source = source + this.m_scriptFile + ";\n";
        }
        source = source + "data _null_; \n";
        source = source + "   " + "signon " + this.m_hostName + " " + this.m_signonOptions;
        this.m_firstSignon = true;
        if (this.m_userid != null && !scripted) {
            String tmpPwString;
            try {
                tmpPwString = SasPasswordString.encode((String)"sas002", (String)this.m_password);
            }
            catch (SasPasswordEncodingException e) {
                tmpPwString = this.m_password;
            }
            source = source + " user=\"" + this.m_userid + "\" password=\"" + tmpPwString + "\"";
        }
        source = this.m_fileRef != null && this.m_fileRef.length() > 0 ? source + " script=" + this.m_fileRef.trim() : source + " noscript";
        source = source + ";\n";
        source = source + "run; \n";
        sRetStr.append(source);
        ServerSupport.addToSignonCache(this);
        return sRetStr;
    }

    public StringBuffer signoff() {
        return null;
    }

    public StringBuffer startSubmit() throws MdException, RemoteException {
        return this.startSubmit("");
    }

    public StringBuffer startSubmit(String additionalRsubmitOptions) throws MdException, RemoteException {
        StringBuffer sRetStr = new StringBuffer();
        if (this.checkLocal()) {
            return sRetStr;
        }
        this.setServerSpecs();
        sRetStr.append("rsubmit ").append(this.m_hostName);
        if (additionalRsubmitOptions != null && additionalRsubmitOptions.length() > 0) {
            sRetStr.append(" ").append(additionalRsubmitOptions);
        }
        sRetStr.append(" ; /* ").append(this.m_server.getName()).append(" */ \n");
        return sRetStr;
    }

    public StringBuffer doReturnCodeSetup() {
        StringBuffer sRetStr = new StringBuffer();
        if (this.m_firstSignon) {
            SASCodeGeneration codegen = new SASCodeGeneration();
            sRetStr.append(codegen.getReturnCodeSetup());
        }
        return sRetStr;
    }

    public StringBuffer endSubmit() throws MdException, RemoteException {
        StringBuffer sRetStr = new StringBuffer();
        if (this.checkLocal()) {
            return sRetStr;
        }
        sRetStr.append("endrsubmit; /* " + this.m_server.getName() + " */  \n\n");
        return sRetStr;
    }

    public boolean equals(ServerSupport iServerSupp) {
        try {
            if (this.m_server.getId().equals(iServerSupp.m_server.getId()) && this.m_defaultServer.getId().equals(iServerSupp.m_defaultServer.getId())) {
                return true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return false;
    }

    public int hashcode() {
        return super.hashCode();
    }

    public static boolean isEqual(String obj1, String obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public boolean checkLocal(ServerContext iServer) throws MdException, RemoteException {
        String sDefaultAppServer = iServer.getId();
        return this.m_server.getFQID().equals(sDefaultAppServer);
    }

    public boolean checkLocal() throws MdException, RemoteException {
        return this.checkLocal(this.m_defaultServer);
    }

    public ServerComponent getWorkspaceComponent() throws MdException, RemoteException {
        LogicalServer ls = null;
        ServerComponent sc = null;
        boolean foundLS = false;
        if (this.m_server != null && this.m_hostName != null) {
            AssociationList components = this.m_server.getUsingComponents();
            block0: for (int i = 0; i < components.size(); ++i) {
                ls = (LogicalServer)components.get(i);
                if (!ls.getClassIdentifier().equals(WORKSPACE_CLSID)) continue;
                for (int j = 0; j < ls.getUsingComponents().size(); ++j) {
                    sc = (ServerComponent)ls.getUsingComponents().get(j);
                    if (!sc.getClassIdentifier().equals(WORKSPACE_CLSID)) continue;
                    foundLS = true;
                    continue block0;
                }
            }
        }
        if (foundLS) {
            return sc;
        }
        return null;
    }

    public ServerComponent getGridServerComponent() throws MdException, RemoteException {
        LogicalServer ls = null;
        ServerComponent sc = null;
        boolean foundLS = false;
        if (this.m_server != null && this.m_hostName != null) {
            AssociationList components = this.m_server.getUsingComponents();
            block0: for (int i = 0; i < components.size(); ++i) {
                ls = (LogicalServer)components.get(i);
                if (!ls.getClassIdentifier().equals(GRID_CLSID)) continue;
                for (int j = 0; j < ls.getUsingComponents().size(); ++j) {
                    sc = (ServerComponent)ls.getUsingComponents().get(j);
                    if (!sc.getClassIdentifier().equals(GRID_CLSID)) continue;
                    foundLS = true;
                    continue block0;
                }
            }
        }
        if (foundLS) {
            return sc;
        }
        return null;
    }

    public List getGridWorkspaceList() throws MdException, RemoteException {
        ArrayList<String> lstWorkspace = new ArrayList<String>();
        ServerComponent sc = this.getGridServerComponent();
        if (sc != null) {
            for (int i = 0; i < sc.getProperties().size(); ++i) {
                Property prop = (Property)sc.getProperties().get(i);
                if (!prop.getPropertyName().equals(WORKLOAD_PROPERTY_NAME)) continue;
                lstWorkspace = new ArrayList();
                String[] workloads = prop.getDefaultValue().split(" ");
                for (int j = 0; j < workloads.length; ++j) {
                    lstWorkspace.add(workloads[j]);
                }
                break;
            }
        }
        return lstWorkspace;
    }

    private void setServerSpecs() throws MdException, RemoteException {
        Integer port;
        AssociationList lScripts;
        if (this.m_hostName != null) {
            return;
        }
        AssociationList components = this.m_server.getUsingComponents();
        LogicalServer ls = null;
        boolean foundLS = false;
        for (int i = 0; i < components.size(); ++i) {
            ls = (LogicalServer)components.get(i);
            if (!ls.getClassIdentifier().equals(CONNECT_CLSID)) continue;
            foundLS = true;
            break;
        }
        if (!foundLS || ls.getUsingComponents().isEmpty()) {
            return;
        }
        ServerComponent sc = (ServerComponent)ls.getUsingComponents().get(0);
        CMetadata iObj = null;
        boolean foundSCC = false;
        for (int i = 0; i < sc.getSourceConnections().size(); ++i) {
            iObj = (CMetadata)sc.getSourceConnections().get(i);
            if (!(iObj instanceof SASClientConnection)) continue;
            foundSCC = true;
            break;
        }
        if (!foundSCC) {
            throw new MdException(bundle.getString("ServerSupport.MissingConnection.txt"));
        }
        SASClientConnection iConn = (SASClientConnection)iObj;
        this.m_comamid = iConn.getCommunicationProtocol();
        this.m_signonOptions = ServerSupport.processProperties((List)iConn.getProperties());
        if (iConn.getScriptFiles().size() > 0 && (lScripts = iConn.getScriptFiles()).size() > 0) {
            File iScript = (File)lScripts.get(0);
            SASFileRef fileRef = null;
            String sAccessMethod = "";
            String sPath = "";
            String sOptions = "";
            if (iScript != null) {
                AssociationList fileRefs = iScript.getFileRefs();
                if (iScript.getFileName().length() > 0) {
                    sPath = "\"" + iScript.getFileName() + "\" ";
                }
                if (fileRefs.size() > 0) {
                    fileRef = (SASFileRef)fileRefs.get(0);
                    this.m_fileRef = fileRef.getFileref() + " ";
                    sAccessMethod = fileRef.getAccessMethod() + " ";
                    sOptions = ServerSupport.processProperties((List)fileRef.getProperties());
                } else {
                    this.m_fileRef = "RLINK ";
                }
            }
            this.m_scriptFile = "filename " + this.m_fileRef + sAccessMethod + sPath + sOptions;
        }
        this.m_hostName = iConn.getServerShortName();
        if (this.m_hostName == null || this.m_hostName.length() == 0) {
            this.m_hostName = iConn.getId();
            this.m_hostName = this.m_hostName.substring(this.m_hostName.indexOf(46) + 1);
        }
        this.m_hostAddress = iConn.getRemoteAddress();
        if (this.m_comamid != null && this.m_comamid.compareToIgnoreCase("TCP") != 0 && this.m_comamid.compareToIgnoreCase("TELNET") != 0) {
            this.m_hostName = "&" + this.m_hostName;
        }
        this.m_hostPort = iConn.getService() != null && iConn.getService().length() > 0 ? iConn.getService() : ((port = new Integer(iConn.getPort())).compareTo(new Integer(0)) > 0 ? port.toString() : "");
        AuthenticationDomain dom = iConn.getDomain();
        if (dom != null) {
            ConnectionManager connectionManager = Workspace.getWorkspace().getConnectionManager();
            PasswordAuthentication login = connectionManager.getLogin(dom.getName());
            if (login != null) {
                this.m_userid = login.getUserName();
                this.m_password = new String(login.getPassword());
            } else if (!Workspace.getWorkspace().isSingleSignOn()) {
                // empty if block
            }
        }
    }

    public String getHostName() {
        return this.m_hostName;
    }

    private boolean onSignonCache() {
        for (int i = 0; i < m_alServerSupportCache.size(); ++i) {
            ServerSupport iSS = (ServerSupport)m_alServerSupportCache.get(i);
            if (!this.equals(iSS)) continue;
            return true;
        }
        return false;
    }

    private static void addToSignonCache(ServerSupport iServSupp) {
        for (int i = 0; i < m_alServerSupportCache.size(); ++i) {
            if (!iServSupp.toString().equalsIgnoreCase(((ServerSupport)m_alServerSupportCache.get(i)).toString()) || !((ServerSupport)m_alServerSupportCache.get(i)).toString().equalsIgnoreCase(iServSupp.toString())) continue;
            return;
        }
        m_alServerSupportCache.add(iServSupp);
    }

    public static void clearSignonCache() {
        m_alServerSupportCache.clear();
    }

    public static ArrayList getSignonCache() {
        return m_alServerSupportCache;
    }

    public static void setSignonCache(ArrayList signonCache) {
        m_alServerSupportCache = signonCache;
    }

    public String toString() {
        try {
            return this.m_server.getName() + " w/ default of " + this.m_defaultServer.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "ServerSupport experienced an exception generating the string";
        }
    }

    protected static String processProperties(List lProps) throws RemoteException {
        String retStr = "";
        for (int i = 0; i < lProps.size(); ++i) {
            Property iProp = (Property)lProps.get(i);
            if (iProp.getPropertyName().equalsIgnoreCase("PROMPT") || iProp.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
            if (iProp.getUseValueOnly() != 0) {
                retStr = retStr + iProp.getDefaultValue() + " ";
                continue;
            }
            if (iProp.getDefaultValue() == null || iProp.getDefaultValue().length() == 0) continue;
            retStr = retStr + " " + iProp.getPropertyName() + iProp.getDelimiter() + iProp.getDefaultValue() + " ";
        }
        return retStr;
    }

    public LogicalServer getLogicalServer() throws MdException, RemoteException {
        if (this.m_server != null) {
            AssociationList lServers = this.m_server.getUsingComponents();
            for (int iServer = 0; iServer < lServers.size(); ++iServer) {
                LogicalServer ls = (LogicalServer)lServers.get(iServer);
                if (!ls.getClassIdentifier().equals(WORKSPACE_CLSID)) continue;
                return ls;
            }
        }
        return null;
    }
}

