/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.connection.ConnectionManager;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class SASCodeGeneration {
    private static final WAdminResource bundle = WAdminResource.getBundle(SASCodeGeneration.class);
    private StringBuffer m_GeneratedSource = new StringBuffer();
    private String m_indentString = "";
    protected int m_numIndents = 0;
    private boolean m_generateParallelMacroHeaderComments = false;
    private boolean m_bGenerateRCSetStatements = true;
    public static final String INDENT = "   ";
    public static final int LINE_LENGTH = 78;
    public static final String SYSLAST_PROPERTY_NAME = "SYSLAST";
    public static final String NOTE_LABEL = "NOTE:";
    public static final String WARNING_LABEL = "WARNING:";
    public static final String ERROR_LABEL = "ERROR:";
    public static final String ERROR_LABEL_QUOTE = "ERROR%QUOTE(:)";
    private static final String DIVIDER = "*";
    private static final String PROMPT_FOR_LINE_LENGTH = "SASCodeGeneration.PromptForLineLength";
    private static final String GRID_CLSID = "D7E796B4-654C-4ab3-B690-657EE79309FB";
    public static final int FQID_LENGTH = 17;
    public static final String ATTRIBUTE_OPTION_PREFIX = "OPTION.";
    public static String SYSRPUTSYNC_YES = "sysrputsync = yes";
    public static final int MAXIMUM_LINE_LENGTH = 255;

    public SASCodeGeneration addSourceCode(String sourceText) {
        if (sourceText != null) {
            if (this.m_indentString.length() > 0) {
                sourceText = sourceText.replaceAll("\n", "\n" + this.m_indentString);
            }
            this.m_GeneratedSource.append(sourceText);
        }
        return this;
    }

    public SASCodeGeneration addSourceCode(StringBuffer sourceText) {
        if (sourceText != null) {
            String source = sourceText.toString();
            this.addSourceCode(source);
        }
        return this;
    }

    public String getSource() {
        return this.m_GeneratedSource.toString();
    }

    public StringBuffer getSourceBuffer() {
        return this.m_GeneratedSource;
    }

    public void clearSourceBuffer() {
        this.m_GeneratedSource = new StringBuffer();
    }

    public SASCodeGeneration addCommentLine(String msg) {
        this.addSourceCode(this.makeComment(msg));
        return this;
    }

    public SASCodeGeneration indent() {
        return this.indent(1);
    }

    public SASCodeGeneration indent(int numIndents) {
        this.addSourceCode(INDENT);
        numIndents = this.m_numIndents + numIndents;
        this.setIndent(numIndents);
        return this;
    }

    public void setGenerateCommentsOnParallelMacros(boolean value) {
        this.m_generateParallelMacroHeaderComments = value;
    }

    public SASCodeGeneration setIndent(int numIndents) {
        this.m_numIndents = numIndents;
        StringBuffer indents = new StringBuffer();
        for (int i = 0; i < this.m_numIndents; ++i) {
            indents.append(INDENT);
        }
        this.m_indentString = indents.toString();
        return this;
    }

    public SASCodeGeneration unIndent() {
        return this.unIndent(1);
    }

    public SASCodeGeneration unIndent(int numIndents) {
        String temp;
        if ((numIndents = this.m_numIndents - numIndents) < 0) {
            numIndents = 0;
        }
        this.setIndent(numIndents);
        int length = this.m_GeneratedSource.length();
        if (length > INDENT.length() && (temp = this.m_GeneratedSource.substring(length - INDENT.length())).equals(INDENT)) {
            this.m_GeneratedSource.delete(length - INDENT.length(), length);
        }
        return this;
    }

    public String getReturnCodeSetup() {
        StringBuffer code = new StringBuffer();
        code.append(this.makeComment(bundle.getString("SASCodeGeneration.ReturnCodeSetup.msg.txt")));
        code.append("%global job_rc trans_rc sqlrc; \n").append("%let job_rc = 0;\n").append("%let trans_rc = 0;\n").append("%let sqlrc = 0;\n").append("%global syserr; \n").append("\n").append(this.getRCSetMacro());
        return code.toString();
    }

    public SASCodeGeneration genAddIfVersionMacro(String macName, String oper, String version, String sasCode) {
        this.addSourceCode(this.getAddIfVersionMacro(macName, oper, version, sasCode));
        return this;
    }

    public String getAddIfVersionMacro(String macName, String oper, String version, String sasCode) {
        StringBuffer code = new StringBuffer();
        code.append("%macro ").append(macName).append("; \n").append(INDENT).append("%if %sysevalf(&sysver ").append(oper).append(" ").append(version).append(",boolean) %then ").append(sasCode).append("; \n").append("%mend ").append(macName).append("; \n");
        return code.toString();
    }

    public StringBuffer getReturnCodeRemoteSetup(String remoteName) {
        StringBuffer code = new StringBuffer();
        code.append(this.makeComment(bundle.getString("SASCodeGeneration.ReturnCodeRemoteSetup.msg.txt")));
        code.append("data _null_;\n").append(INDENT).append("if &sysver ge 9 then rmtname = \"/ remote = " + remoteName + "\";\n").append(INDENT).append("else rmtname = \"\";\n").append(INDENT).append("call execute('%syslput job_rc = &job_rc '||rmtname||';');\n").append(INDENT).append("call execute('%syslput trans_rc = &trans_rc '||rmtname||';');\n").append(INDENT).append("call execute('%syslput sqlrc = &sqlrc '||rmtname||';');\n").append(INDENT).append("call execute('run;');\n").append("run;\n");
        return code;
    }

    public StringBuffer getReturnCodeRemoteEnding() {
        StringBuffer code = new StringBuffer();
        code.append(this.makeComment(bundle.getString("SASCodeGeneration.ReturnCodeRemoteEnding.msg.txt"))).append("%sysrput job_rc = &job_rc ;\n").append("%sysrput trans_rc = &trans_rc ;\n").append("%sysrput sqlrc = &sqlrc ;\n");
        return code;
    }

    public SASCodeGeneration genReturnCodeSetup() {
        this.addSourceCode(this.getReturnCodeSetup());
        return this;
    }

    public String getRCSetMacro() {
        return this.getRCSetMacros(true, true);
    }

    public String getRCSetMacros(boolean getMacroVersion, boolean getDSVersion) {
        StringBuffer code = new StringBuffer();
        if (getMacroVersion) {
            code.append("%macro rcSet(error); \n").append(INDENT).append("%if (&error gt &trans_rc) %then \n").append(INDENT).append(INDENT).append("%let trans_rc = &error;\n").append(INDENT).append("%if (&error gt &job_rc) %then \n").append(INDENT).append(INDENT).append("%let job_rc = &error;\n").append("%mend rcSet; \n");
        }
        if (getDSVersion) {
            if (getMacroVersion) {
                code.append("\n");
            }
            code.append("%macro rcSetDS(error); \n").append(INDENT).append("if &error gt input(symget('trans_rc'),12.) then \n").append(INDENT).append(INDENT).append("call symput('trans_rc',trim(left(put(&error,12.))));\n").append(INDENT).append("if &error gt input(symget('job_rc'),12.) then \n").append(INDENT).append(INDENT).append("call symput('job_rc',trim(left(put(&error,12.))));\n").append("%mend rcSetDS; \n");
        }
        return code.toString();
    }

    public SASCodeGeneration genRCSetMacro() {
        this.addSourceCode(this.getRCSetMacro());
        return this;
    }

    public String getRCSetCall(String errorVariable, boolean addBlankLine) {
        StringBuffer code = new StringBuffer();
        if (this.m_bGenerateRCSetStatements) {
            if (errorVariable.length() <= 0) {
                errorVariable = "&sysrc";
            }
            code.append("%rcSet(" + errorVariable + "); \n");
            if (addBlankLine) {
                code.append("\n");
            }
        }
        return code.toString();
    }

    public SASCodeGeneration genRCSetCall(String errorVariable, boolean addBlankLine) {
        this.addSourceCode(this.getRCSetCall(errorVariable, addBlankLine));
        return this;
    }

    public String getRCSetDSCall(String errorVariable, boolean addBlankLine) {
        StringBuffer code = new StringBuffer();
        if (this.m_bGenerateRCSetStatements) {
            if (errorVariable.length() <= 0) {
                errorVariable = "&sysrc";
            }
            code.append("%rcSetDS(" + errorVariable + "); \n");
            if (addBlankLine) {
                code.append("\n");
            }
        }
        return code.toString();
    }

    public StringBuffer getRemoteMacroVariablesSetup(List remoteVars, String remoteName) {
        return this.getRemoteMacroVariablesSetup(remoteVars, remoteName, false);
    }

    public StringBuffer getRemoteMacroVariablesSetup(List remoteVars, String remoteName, boolean blankLine) {
        int i;
        StringBuffer code = new StringBuffer();
        if (remoteVars == null) {
            return code;
        }
        ArrayList<String> valuesToRemote = new ArrayList<String>();
        for (i = 0; i < remoteVars.size(); ++i) {
            String value = remoteVars.get(i).toString();
            boolean found = false;
            for (int k = 0; k < valuesToRemote.size(); ++k) {
                if (!valuesToRemote.get(k).toString().equalsIgnoreCase(value)) continue;
                found = true;
                break;
            }
            if (found) continue;
            valuesToRemote.add(value);
        }
        if (valuesToRemote != null && !valuesToRemote.isEmpty()) {
            code.append(this.makeComment(bundle.getString("SASCodeGeneration.GenerateRemoteMacroVariablesSetup.txt")));
            for (i = 0; i < valuesToRemote.size(); ++i) {
                String macroName = valuesToRemote.get(i).toString();
                code.append("%syslput ").append(macroName).append(" = &").append(macroName).append(" / remote = ").append(remoteName).append("; \n");
            }
        }
        if (blankLine) {
            code.append("\n");
        }
        return code;
    }

    public StringBuffer getTSLevelMacro(String macroName, String featureName) {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_tsLevel");
            macro.addParameter("macroName");
            macro.addParameter("featureName");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_tsLevel(macroName=, featureName=); \n").append(INDENT).append("data _null_; \n").append(INDENT).append(INDENT).append("call symput(\"&macroName\",tslvl(\"&featureName\")); \n").append(INDENT).append("run; \n").append("%mend etls_tsLevel; \n\n");
        return code;
    }

    public SASCodeGeneration genTSLevelMacro(String macroName, String featureName) {
        return this.addSourceCode(this.getTSLevelMacro(macroName, featureName));
    }

    public StringBuffer getSignonMacro(ServerContext server) {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_signon");
            macro.addParameter("handleName").addParameter("cmacvar").addParameter("gridRC").addParameter("useGrid").addParameter("machineIdMacroVariable").addParameter("workloadMacroVariable").addParameter("log").addParameter("output").addParameter("additionalSignonOptions").addParameter("signonRetries");
            code.append(macro.getCommentHeader());
        }
        String serverName = null;
        try {
            serverName = server.getName();
            if (serverName == null || serverName.length() == 0) {
                serverName = Workspace.getMdFactory().getOMIUtil().getMetadataSimple(server.getCMetadataType(), server.getFQID(), "Name");
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage(exc, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        code.append("%macro etls_signon(handleName=etlsRemote, cmacvar=etls_signonStatus, \n").append(INDENT).append("gridRC=rc, useGrid=1, \n").append(INDENT).append("machineIdMacroVariable=etls_machineId, workloadMacroVariable=, \n").append(INDENT).append("log=, output=, additionalSignonOptions=, signonRetries=3); \n\n").append(INDENT).append("%let etls_gridInstalled =;\n").append(INDENT).append("%etls_tsLevel(macroName=etls_gridInstalled, featureName=uwugrdsv); \n\n").append(INDENT).append("%if (&useGrid = 1) %then \n").append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append("%if (\"&etls_gridInstalled\" ne \"\") %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (&gridRC eq ) %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%let gridRC = &handleName.RC ; \n\n").append(INDENT).append(INDENT).append(INDENT).append("%global &gridRC;\n").append(INDENT).append(INDENT).append(INDENT).append("%let workload = ; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (&workloadMacroVariable ne ) %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("data _null_;\n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("call symput('workload',';workload = '||symget(\"&workloadMacroVariable\"));\n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("run;\n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append(INDENT).append("%let &gridRC = %sysfunc(grdsvc_enable(\"&handleName\",\"resource = " + serverName + " &workload \")); \n").append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%else \n").append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.getString("SASCodeGeneration.GridServiceFunctionsNotInstalled.sasmacro.notrans"))).append(INDENT).append("%end; \n\n");
        code.append(INDENT).append("%local sleeptime sleepIncreaseAmount tryCount; \n").append(INDENT).append("%let sleepIncreaseAmount=5; \n").append(INDENT).append("%let sleeptime=5; \n").append(INDENT).append("%let tryCount=1; \n").append(INDENT).append("%let &cmacvar=1; \n\n").append(INDENT).append("%do %until((&&&cmacvar ne 1) or (&tryCount gt %eval(&signonRetries+1))); \n").append(INDENT).append(INDENT).append("data _null_; \n").append(INDENT).append(INDENT).append("signon &handleName cmacvar=&cmacvar \n").append(INDENT).append(INDENT).append(INDENT).append("%if (\"&log\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("log=&log; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (\"&output\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("output=&output; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (\"&additionalSignonOptions\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&additionalSignonOptions; \n").append(INDENT).append(INDENT).append(";run; \n\n");
        code.append(INDENT).append(INDENT).append("%if \"&&&cmacvar\" eq \"1\" %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("%if &tryCount lt %eval(&signonRetries+1) %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.formatString("SASCodeGeneration.SignonFailedWillRetry.note.sasmacro.notrans", "#&tryCount", "&sleeptime"), NOTE_LABEL, false)).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%let rc=%sysfunc(sleep(&sleeptime,1)); \n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append(INDENT).append("%else %if &signonRetries gt 0 %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.formatString("SASCodeGeneration.SignonFailedFinal.sasmacro.notrans", "#&tryCount"), ERROR_LABEL_QUOTE, false)).append("\n").append(INDENT).append(INDENT).append(INDENT).append("%let sleeptime=%sysevalf(&sleeptime+&sleepIncreaseAmount,int); /* increase sleeptime by factor */ \n").append(INDENT).append(INDENT).append(INDENT).append("%let tryCount=%eval(&tryCount+1); \n").append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append("%end; \n").append(INDENT).append(this.getRCSetCall("&syserr", true));
        code.append(INDENT).append("/* On successful signon, fetch and report machine name if grid was requested. */ \n").append(INDENT).append("%if (\"&machineIdMacroVariable\" ne \"\") %then %let &machineIdMacroVariable = ; \n").append(INDENT).append("%if (\"&&&cmacvar\" ne \"1\" and \"&machineIdMacroVariable\" ne \"\" and \n").append(INDENT).append(INDENT).append("  &useGrid = 1 and \"&etls_gridInstalled\" ne \"\") %then \n").append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append("%put; \n").append(INDENT).append(INDENT).append("%if (\"&&&gridRC\" eq \"0\") %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("%let &machineIdmacroVariable = %sysfunc(grdsvc_getname(&handleName)); \n").append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.getString("SASCodeGeneration.SignedOnToGridMachine.sasmacro.notrans"))).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%else \n").append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.getString("SASCodeGeneration.SignedOnToLocalMachine.sasmacro.notrans"))).append(INDENT).append(INDENT).append("%put; \n").append(INDENT).append("%end; \n\n");
        code.append("%mend etls_signon; \n\n");
        return code;
    }

    public SASCodeGeneration genSignonMacro(ServerContext server) {
        this.addSourceCode(this.getSignonMacro(server));
        return this;
    }

    public StringBuffer getSignoffMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_signoff");
            macro.addParameter("handleName");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_signoff(handleName=rmt); \n").append(INDENT).append("%local savemprint; \n").append(INDENT).append("%let savemprint=%sysfunc(getoption(mprint)); \n").append(INDENT).append(this.getPercentPutStatement(bundle.formatString("SASCodeGeneration.etls_signoff.note.sasmacro.notrans", "etls_serverConnected"))).append(INDENT).append("options nomprint; \n").append(INDENT).append("%local isConnected; \n").append(INDENT).append("%etls_serverConnected(serverId=&handleName); \n").append(INDENT).append("options &savemprint; \n").append(INDENT).append("%if &isConnected %then \n").append(INDENT).append(INDENT).append("signoff &handleName ;; \n").append("%mend etls_signoff; \n\n");
        return code;
    }

    public SASCodeGeneration genSignoffMacro() {
        this.addSourceCode(this.getSignoffMacro());
        return this;
    }

    public StringBuffer getParallelGetHandleMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_getHandle");
            macro.addParameter("statusTable").addParameter("handleVariable").addParameter("row");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_getHandle(statusTable=, handleVariable=, row=); \n").append(INDENT).append("%let etls_dsid = %sysfunc(open(&statusTable)); \n").append(INDENT).append("%if (&etls_dsid = 0) %then \n").append(INDENT).append(INDENT).append("%put %sysfunc(sysmsg()); \n").append(INDENT).append("%else \n").append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append("%let rc = %sysfunc(fetchobs(&etls_dsid, &row)); \n").append(INDENT).append(INDENT).append("%if (&rc ne 0) %then \n").append(INDENT).append(INDENT).append(INDENT).append("%put %sysfunc(sysmsg()); \n").append(INDENT).append(INDENT).append("%else \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("%let etls_varnum = %sysfunc(varnum(&etls_dsid,&handleVariable)); \n").append(INDENT).append(INDENT).append(INDENT).append("%if (&etls_varnum > 0) %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%sysfunc(getvarc(&etls_dsid,&etls_varnum)); \n").append(INDENT).append(INDENT).append(INDENT).append("%else \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%put %sysfunc(sysmsg()); \n").append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%let rc = %sysfunc(close(&etls_dsid)); \n").append(INDENT).append("%end; \n").append("%mend etls_getHandle; \n\n");
        return code;
    }

    public SASCodeGeneration genParallelGetHandleMacro() {
        this.addSourceCode(this.getParallelGetHandleMacro());
        return this;
    }

    public StringBuffer getParallelFreeHandleMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_freeHandle");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("handleVariable").addParameter("handleName").addParameter("statusSetting").addParameter("endTimeVariable").addParameter("startTimeVariable").addParameter("signoff").addParameter("returnCodeVariable").addParameter("returnCodeMacroVariable").addParameter("setMainJobRC").addParameter("statusUnknownReturnCode");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_freeHandle(statusTable=, statusVariable=, handleVariable=, \n").append(INDENT).append("handleName=, statusSetting=\"").append(bundle.getString("SASCodeGeneration.StatusSetting.Finish.default.txt")).append("\", \n").append(INDENT).append("endTimeVariable=endTime, startTimeVariable=startTime, signoff=1, \n").append(INDENT).append("returnCodeVariable=, returnCodeMacroVariable=, setMainJobRC=1, \n").append(INDENT).append("statusUnknownReturnCode=., startTimeMacroVariable=, endTimeMacroVariable= ); \n\n").append(INDENT).append("%if (\"&statusTable\" ne \"\") %then \n").append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append("%local etls_rcMacroVarExisted; \n").append(INDENT).append(INDENT).append("%let etls_rcMacroVarExisted = 0; \n").append(INDENT).append(INDENT).append("%if (\"&returnCodeMacroVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("proc sql noprint; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("select '1' into: etls_rcMacroVarExisted from dictionary.macros \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("where name=upcase(\"&returnCodeMacroVariable\"); \n").append(INDENT).append(INDENT).append(INDENT).append("quit; \n\n").append(INDENT).append(INDENT).append(INDENT).append(this.getRCSetCall("&sqlrc", false)).append(INDENT).append(INDENT).append(INDENT).append("%if (&etls_rcMacroVarExisted = 0) %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.getString("SASCodeGeneration.etls_freeHandle.returnCodeNotFound.sasmacro.notrans"), WARNING_LABEL, false)).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%let &returnCodeMacroVariable=&statusUnknownReturnCode; \n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (&setMainJobRC eq 1) %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%rcSet(&&&returnCodeMacroVariable); \n").append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%else \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("%let returnCodeMacroVariable=etls_rcmacvar; \n").append(INDENT).append(INDENT).append(INDENT).append("%let &returnCodeMacroVariable=&statusUnknownReturnCode; \n").append(INDENT).append(INDENT).append("%end; \n\n");
        code.append(INDENT).append(INDENT).append("%local etls_startTimeMacroVarExisted; \n").append(INDENT).append(INDENT).append("%let etls_startTimeMacroVarExisted = 0; \n").append(INDENT).append(INDENT).append("%if (\"&startTimeMacroVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("proc sql noprint; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("select '1' into: etls_startTimeMacroVarExisted from dictionary.macros \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("where name=upcase(\"&startTimeMacroVariable\"); \n").append(INDENT).append(INDENT).append(INDENT).append("quit; \n\n").append(INDENT).append(INDENT).append(INDENT).append(this.getRCSetCall("&sqlrc", false)).append(INDENT).append(INDENT).append(INDENT).append("%if (&etls_startTimeMacroVarExisted = 0) %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.getString("SASCodeGeneration.etls_freeHandle.startTimeNotFound.sasmacro.notrans"), WARNING_LABEL, false)).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%let &startTimeMacroVariable=; \n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%end; \n\n");
        code.append(INDENT).append(INDENT).append("%local etls_endTimeMacroVarExisted; \n").append(INDENT).append(INDENT).append("%let etls_endTimeMacroVarExisted = 0; \n").append(INDENT).append(INDENT).append("%if (\"&endTimeMacroVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("proc sql noprint; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("select '1' into: etls_endTimeMacroVarExisted from dictionary.macros \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("where name=upcase(\"&endTimeMacroVariable\"); \n").append(INDENT).append(INDENT).append(INDENT).append("quit; \n\n").append(INDENT).append(INDENT).append(INDENT).append(this.getRCSetCall("&sqlrc", false)).append(INDENT).append(INDENT).append(INDENT).append("%if (&etls_endTimeMacroVarExisted = 0) %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.getString("SASCodeGeneration.etls_freeHandle.endTimeNotFound.sasmacro.notrans"), WARNING_LABEL, false)).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%let &endTimeMacroVariable=%sysfunc(datetime()); \n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%end; \n\n");
        code.append(INDENT).append(INDENT).append("data &statusTable; \n").append(INDENT).append(INDENT).append(INDENT).append("modify &statusTable(where=(&handleVariable = &handleName)); \n").append(INDENT).append(INDENT).append(INDENT).append("%if (\"&startTimeMacroVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&startTimeVariable = input(symget(\"&startTimeMacroVariable\"),32.);; \n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (\"&endTimeVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%if (\"&endTimeMacroVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&endTimeVariable = input(symget(\"&endTimeMacroVariable\"),32.);; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("%else \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&endTimeVariable = datetime();; \n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (\"&returnCodeVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&returnCodeVariable = input(symget(\"&returnCodeMacroVariable\"),32.);; \n").append(INDENT).append(INDENT).append(INDENT).append("%if (\"&statusVariable\" ne \"\") %then \n").append(INDENT).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("if (symget(\"etls_rcMacroVarExisted\") eq \"0\") then \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&statusVariable = \"").append(bundle.getString("SASCodeGeneration.StatusSetting.UnknownStatus.default.txt")).append("\"; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("else\n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&statusVariable = &statusSetting;\n").append(INDENT).append(INDENT).append(INDENT).append("%end;\n");
        code.append(INDENT).append(INDENT).append(INDENT).append("call symput('handle',&handleVariable); \n").append(INDENT).append(INDENT).append(INDENT).append("replace; \n").append(INDENT).append(INDENT).append(INDENT).append("stop; \n").append(INDENT).append(INDENT).append("run; \n\n");
        code.append(INDENT).append(INDENT).append(this.getRCSetCall("&syserr", true)).append(INDENT).append(INDENT).append("%if (&signoff eq 1) %then \n").append(INDENT).append(INDENT).append(INDENT).append("%etls_signoff(handleName=&handle); \n").append(INDENT).append("%end; \n").append("%mend etls_freeHandle; \n\n");
        return code;
    }

    public SASCodeGeneration genParallelFreeHandleMacro() {
        this.addSourceCode(this.getParallelFreeHandleMacro());
        return this;
    }

    public StringBuffer getCommentLine(String label) {
        return this.getCommentLine(label, "", "");
    }

    public StringBuffer getCommentLine(String label, String name) {
        return this.getCommentLine(label, name, "");
    }

    public StringBuffer getCommentLine(String label, String name, String ID) {
        StringBuffer line = new StringBuffer();
        int labelAndID = label.length() + ID.length() + 1;
        int nameLength = 72 - labelAndID;
        List nameList = this.splitString(name, nameLength, true);
        String labelPad = this.repeat(" ", label.length());
        String IDPad = this.repeat(" ", ID.length());
        if (nameList.size() <= 0) {
            String pad = this.repeat(" ", 72 - label.length());
            line.append(" * ").append(label).append(pad).append(" * \n");
        }
        for (int i = 0; i < nameList.size(); ++i) {
            String blanks;
            int pad;
            String currentName = (String)nameList.get(i);
            String currentLabel = labelPad;
            String currentID = IDPad;
            if (i == 0) {
                currentLabel = label;
                currentID = ID;
            }
            line.append(" * ").append(currentLabel).append(currentName);
            if (currentID.length() > 0) {
                pad = 78 - (23 + currentLabel.length() + currentName.length());
                blanks = this.repeat(" ", pad);
                line.append(blanks).append(currentID).append(" *");
            } else {
                pad = 78 - (6 + currentLabel.length() + currentName.length());
                blanks = this.repeat(" ", pad);
                line.append(blanks).append(" *");
            }
            line.append(" \n");
        }
        return line;
    }

    public boolean isJobDateFormatNLS(AbstractTransformation mObject) throws MdException, RemoteException {
        Job job = null;
        boolean isNLSFormat = false;
        if (mObject != null) {
            TransformationActivity act;
            AssociationList jobs;
            TransformationStep step;
            AssociationList acts;
            ClassifierMap map;
            AssociationList steps;
            if (mObject instanceof Job) {
                job = (Job)mObject;
            } else if (mObject instanceof TransformationStep) {
                TransformationActivity act2;
                AssociationList jobs2;
                TransformationStep step2 = (TransformationStep)mObject;
                AssociationList acts2 = step2.getActivities();
                if (!acts2.isEmpty() && !(jobs2 = (act2 = (TransformationActivity)acts2.get(0)).getJobs()).isEmpty()) {
                    job = (Job)jobs2.get(0);
                }
            } else if (mObject instanceof ClassifierMap && !(steps = (map = (ClassifierMap)mObject).getSteps()).isEmpty() && !(acts = (step = (TransformationStep)steps.get(0)).getActivities()).isEmpty() && !(jobs = (act = (TransformationActivity)acts.get(0)).getJobs()).isEmpty()) {
                job = (Job)jobs.get(0);
            }
            if (job != null) {
                OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)job);
                isNLSFormat = OP.stringToBoolean(OP.getSpecificOptionValue("USENLSDATEFORMAT"), false);
            }
        }
        return isNLSFormat;
    }

    public StringBuffer getParallelCreateHandleMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_createHandle");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("handleVariable").addParameter("handlePrefix").addParameter("workloadMacroVariable").addParameter("row").addParameter("machineVariable").addParameter("statusSetting").addParameter("signon").addParameter("useGrid").addParameter("log").addParameter("output").addParameter("gridRC").addParameter("cmacvar").addParameter("additionalSignonOptions").addParameter("signonRetries");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_createHandle(statusTable=, statusVariable=, \n").append(INDENT).append("handleVariable=, handlePrefix=rmt, \n").append(INDENT).append("workloadMacroVariable=, row=, machineVariable=, \n").append(INDENT).append("statusSetting=\"").append(bundle.getString("SASCodeGeneration.StatusSetting.Running.default.txt")).append("\", startTimeVariable=startTime, \n").append(INDENT).append("signon=1, useGrid=1, log=, output=, gridRC=, cmacvar=etls_signonStatus, \n").append(INDENT).append("additionalSignonOptions=, signonRetries= ); \n\n").append(INDENT).append("%local remoteSessionId; \n").append(INDENT).append("%let remoteSessionId = &handlePrefix.&row; \n").append(INDENT).append("%let &cmacvar = 1; \n").append(INDENT).append("%local etls_machineId; \n");
        code.append(INDENT).append("%if (&signon eq 1) %then  \n").append(INDENT).append(INDENT).append("%etls_signon(handleName=&remoteSessionId, useGrid=&useGrid, \n").append(INDENT).append(INDENT).append(INDENT).append("machineIdMacroVariable=etls_machineId, workloadMacroVariable=&workloadMacroVariable, \n").append(INDENT).append(INDENT).append(INDENT).append("log=&log, output=&output, cmacvar=&cmacvar, gridRC=&gridRC, \n").append(INDENT).append(INDENT).append(INDENT).append("additionalSignonOptions=&additionalSignonOptions,signonRetries=&signonRetries); \n").append(INDENT).append("%else %let &cmacvar=0; \n\n");
        code.append(INDENT).append("data &statusTable; \n").append(INDENT).append(INDENT).append("retain ptr &row; \n").append(INDENT).append(INDENT).append("modify &statusTable point = ptr; \n").append(INDENT).append(INDENT).append("&handleVariable = \"&remoteSessionId\"; \n").append(INDENT).append(INDENT).append("%if (&signon eq 1) %then \n").append(INDENT).append(INDENT).append(INDENT).append("&machineVariable = \"&etls_machineId\";; \n").append(INDENT).append(INDENT).append("%if (&&&cmacvar ne 0) %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("&statusVariable = \"").append(bundle.getString("SASCodeGeneration.StatusSetting.FailedSignon.default.txt")).append("\"; \n").append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%else \n").append(INDENT).append(INDENT).append(INDENT).append("&statusVariable = &statusSetting;; \n").append(INDENT).append(INDENT).append("%if (&startTimeVariable ne ) %then \n").append(INDENT).append(INDENT).append(INDENT).append("&startTimeVariable = datetime();; \n").append(INDENT).append(INDENT).append("replace; \n").append(INDENT).append(INDENT).append("stop; \n").append(INDENT).append("run; \n\n").append(INDENT).append(this.getRCSetCall("&syserr", false)).append("%mend etls_createHandle; \n\n");
        return code;
    }

    public SASCodeGeneration genParallelCreateHandleMacro() {
        this.addSourceCode(this.getParallelCreateHandleMacro());
        return this;
    }

    public StringBuffer getParallelProcessesRunning() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_getProcessesRunning");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("processCountMacro").addParameter("statusSetting");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_getProcessesRunning(statusTable=, statusVariable=, processCountMacro=, \n").append(INDENT).append("statusSetting=\"").append(bundle.getString("SASCodeGeneration.StatusSetting.Running.default.txt")).append("\"); \n\n").append(INDENT).append("proc sql noprint; \n").append(INDENT).append(INDENT).append("select count(*) into: &processCountMacro \n").append(INDENT).append(INDENT).append(INDENT).append("from &statusTable where &statusVariable = &statusSetting; \n").append(INDENT).append("quit; \n\n").append(INDENT).append(this.getRCSetCall("&sqlrc", false)).append("%mend etls_getProcessesRunning; \n\n");
        return code;
    }

    public SASCodeGeneration genParallelProcessesRunning() {
        this.addSourceCode(this.getParallelProcessesRunning());
        return this;
    }

    public StringBuffer getParallelServerConnectedMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_serverConnected");
            macro.addParameter("serverId").addParameter("macvarname");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_serverConnected(serverId=,macvarname=isConnected); \n").append(INDENT).append("%let &macvarname=0; \n").append(INDENT).append("%local search_str none_str savenotes; \n\n").append(INDENT).append("/* setup information for listtask output */ \n").append(INDENT).append("/* listtask output on OS/390 differs */ \n").append(INDENT).append("%if %bquote(&sysscp) eq OS %then \n").append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append("%let search_str=Remote submit for; \n").append(INDENT).append(INDENT).append("%let token=5; \n").append(INDENT).append("%end; \n").append(INDENT).append("%else  \n").append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append("%let search_str=--------------; \n").append(INDENT).append(INDENT).append("%let token=1; \n").append(INDENT).append("%end; \n\n").append(INDENT).append("/* Issue listtask within PROC PRINTTO - send output to file */ \n").append(INDENT).append("filename __tmptxt TEMP; \n").append(INDENT).append("%let savenotes=%sysfunc(getoption(notes)); \n").append(INDENT).append("options nonotes; \n\n").append(INDENT).append("proc printto log=__tmptxt new; \n").append(INDENT).append("run; \n\n").append(INDENT).append("options notes; \n").append(INDENT).append("listtask; \n").append(INDENT).append("proc printto; \n").append(INDENT).append("run; \n\n").append(INDENT).append("options nonotes; \n\n").append(INDENT).append("/* read in the output from listtask */ \n").append(INDENT).append("%let dsname=_null_; \n").append(INDENT).append("data _null_(keep=Session); \n").append(INDENT).append(INDENT).append("length line $256 sessionId $60; \n").append(INDENT).append(INDENT).append("infile __tmptxt length=len; \n").append(INDENT).append(INDENT).append("input @1 line $varying. len; \n\n").append(INDENT).append(INDENT).append("if line=:'There are no' then \n").append(INDENT).append(INDENT).append(INDENT).append("stop; \n").append(INDENT).append(INDENT).append("/* look for the search string and scan for server name */ \n").append(INDENT).append(INDENT).append("if index(line,\"&search_str\") then  \n").append(INDENT).append(INDENT).append("do; \n").append(INDENT).append(INDENT).append(INDENT).append("sessionId=scan(line,&token,\" \"); \n").append(INDENT).append(INDENT).append(INDENT).append("sessionId=upcase(trim(left(tranwrd(sessionId,'\"',' ')))); \n").append(INDENT).append(INDENT).append(INDENT).append("if sessionId=upcase(symget(\"serverId\")) then \n").append(INDENT).append(INDENT).append(INDENT).append("do;  \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("call symput(\"&macvarname\",\"1\"); \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("stop; \n").append(INDENT).append(INDENT).append(INDENT).append("end; \n").append(INDENT).append(INDENT).append("end; \n").append(INDENT).append("run; \n").append(INDENT).append("filename __tmptxt clear; \n").append(INDENT).append("options &savenotes; \n").append("%mend etls_serverConnected; \n\n");
        return code;
    }

    public SASCodeGeneration genParallelServerConnectedMacro() {
        this.addSourceCode(this.getParallelServerConnectedMacro());
        return this;
    }

    public StringBuffer getParallelWaitForMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_waitfor");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("runningStatusSetting").addParameter("handleVariable").addParameter("completeStatusSetting").addParameter("endTimeVariable").addParameter("startTimeVariable").addParameter("waitType").addParameter("signoff").addParameter("returnCodeVariable").addParameter("returnCodeMacroVariable").addParameter("statusUnknownReturnCode");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_waitfor(statusTable=, statusVariable=, runningStatusSetting=\"").append(bundle.getString("SASCodeGeneration.StatusSetting.Running.default.txt")).append("\", handleVariable=, \n").append(INDENT).append("completeStatusSetting=\"").append(bundle.getString("SASCodeGeneration.StatusSetting.Finish.default.txt")).append("\", endTimeVariable=endTime, \n").append(INDENT).append("startTimeVariable=startTime, waitType=_ANY_, signoff=1, \n").append(INDENT).append("returnCodeVariable=, returnCodeMacroVariable=, statusUnknownReturnCode=.); \n\n").append(INDENT).append("proc sql noprint; \n").append(INDENT).append(INDENT).append("select count(*) into :etls_rows \n").append(INDENT).append(INDENT).append("   from &statusTable where &statusVariable = &runningStatusSetting; \n").append(INDENT).append(INDENT).append("%let etls_rows = &etls_rows; \n").append(INDENT).append(INDENT).append("%if (&etls_rows gt 0) %then \n").append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("select &handleVariable into :etlsHandles1 - :etlsHandles&etls_rows \n").append(INDENT).append(INDENT).append(INDENT).append("   from &statusTable where &statusVariable = &runningStatusSetting; \n").append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append("quit; \n\n").append(INDENT).append(this.getRCSetCall("&sqlrc", true)).append(INDENT).append("%if (&etls_rows gt 0) %then \n").append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append("waitfor &waitType \n").append(INDENT).append(INDENT).append(INDENT).append("%do i=1 %to &etls_rows; \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("&&etlsHandles&i \n").append(INDENT).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("; \n").append(INDENT).append("%end; \n\n").append(INDENT).append("%local useDefaultRCMacVar; \n").append(INDENT).append("%if (\"&returnCodeMacroVariable\" eq \"\") %then \n").append(INDENT).append(INDENT).append("%let useDefaultRCMacVar=Y; \n\n").append(INDENT).append("%do i=1 %to &etls_rows; \n\n").append(INDENT).append(INDENT).append("%if (\"&useDefaultRCMacVar\"=\"Y\") %then \n").append(INDENT).append(INDENT).append(INDENT).append("%let returnCodeMacroVariable=job_rc&&etlsHandles&i; \n\n").append(INDENT).append(INDENT).append("waitfor &&etlsHandles&i timeout=1; \n").append(INDENT).append(INDENT).append("%if (&SYSRC eq 0) or (&SYSRC eq -2) %then ").append(this.makeComment(bundle.getString("SASCodeGeneration.WaitFor.ProcessComplete.comment.txt"))).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("%etls_freeHandle(statusTable=&statusTable, statusVariable=&statusVariable,\n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("handleVariable=&handleVariable, handleName=\"&&etlsHandles&i\", \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("statusSetting=&completeStatusSetting, endTimeVariable=&endTimeVariable, \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("startTimeVariable=&startTimeVariable, signoff=&signoff, \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("returnCodeVariable=&returnCodeVariable, returnCodeMacroVariable=&returnCodeMacroVariable, \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("statusUnknownReturnCode=&statusUnknownReturnCode, \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("startTimeMacroVariable=etls_startTime_&&etlsHandles&i., \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("endTimeMacroVariable=etls_endTime_&&etlsHandles&i. ); \n").append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.formatString("SASCodeGeneration.WaitFor.ProcessComplete.note.sasmacro.notrans", "&&etlsHandles&i."), NOTE_LABEL, false)).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append(INDENT).append("%else %if (&SYSRC ne -1) %then ").append(this.makeComment(bundle.getString("SASCodeGeneration.WaitFor.UnknownStatus.comment.txt"))).append(INDENT).append(INDENT).append("%do; \n").append(INDENT).append(INDENT).append(INDENT).append("%etls_freeHandle(statusTable=&statusTable, statusVariable=&statusVariable,\n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("handleVariable=&handleVariable, handleName=\"&&etlsHandles&i\", \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("statusSetting=\"").append(bundle.getString("SASCodeGeneration.StatusSetting.UnknownStatus.default.txt")).append("\", endTimeVariable=&endTimeVariable, \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("startTimeVariable=&startTimeVariable, signoff=&signoff, \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("returnCodeVariable=&returnCodeVariable, returnCodeMacroVariable=&returnCodeMacroVariable, \n").append(INDENT).append(INDENT).append(INDENT).append(INDENT).append("statusUnknownReturnCode=&statusUnknownReturnCode, startTimeMacroVariable=etls_startTime_&&etlsHandles&i ); \n").append(INDENT).append(INDENT).append(INDENT).append(this.getPercentPutStatement(bundle.formatString("SASCodeGeneration.WaitFor.UnknownStatus.note.sasmacro.notrans", "&&etlsHandles&i."), NOTE_LABEL, false)).append(INDENT).append(INDENT).append("%end; \n").append(INDENT).append("%end; \n").append("%mend etls_waitfor; \n\n");
        return code;
    }

    public SASCodeGeneration genParallelWaitForMacro() {
        this.addSourceCode(this.getParallelWaitForMacro());
        return this;
    }

    public StringBuffer getSascmdOption() {
        StringBuffer code = new StringBuffer();
        code.append("%macro genSASCommand; \n").append(INDENT).append("%local noobjserver; \n").append(INDENT).append("%if \"&sysscp\"=\"OS\" %then %let noobjserver=; \n").append(INDENT).append("%else %if \"&sysscp\"=\"VMS_AXP\" %then %let noobjserver=%quote(/noobjectserver); \n").append(INDENT).append("%else %let noobjserver=%quote(-noobjectserver); \n").append(INDENT).append("options sascmd = \"!sascmd &noobjserver\"; \n").append("%mend genSASCommand; \n").append("%genSASCommand; \n\n");
        return code;
    }

    public SASCodeGeneration genSascmdOption() {
        this.addSourceCode(this.getSascmdOption());
        return this;
    }

    public StringBuffer getParallelMacros(ServerContext server) {
        StringBuffer code = new StringBuffer();
        code.append(this.getSascmdOption()).append(this.getTSLevelMacro("etls_gridInstalled", "uwugrdsv")).append(this.getSignonMacro(server)).append(this.getParallelServerConnectedMacro()).append(this.getSignoffMacro()).append(this.getParallelGetHandleMacro()).append(this.getParallelFreeHandleMacro()).append(this.getParallelCreateHandleMacro()).append(this.getParallelWaitForMacro()).append(this.getParallelProcessesRunning());
        return code;
    }

    public SASCodeGeneration genParallelMacros(ServerContext server) {
        return this.addSourceCode(this.getParallelMacros(server));
    }

    public StringBuffer getSubmitToGridPrefix(CMetadata metaObject, ServerContext server, String sServerComponentId) throws MdException, RemoteException {
        if (sServerComponentId == null || !sServerComponentId.equalsIgnoreCase(GRID_CLSID)) {
            return null;
        }
        WorkspaceFile adFile = Workspace.getWorkspace().getAppDefaultsFile();
        int signonRetries = adFile.getPropertyInt("SubmitToGrid.SignonRetries", 0);
        String gridSubmitWorkload = adFile.getPropertyString("SubmitToGrid.Workload", "");
        String additionalSignonOptions = adFile.getPropertyString("SubmitToGrid.SignonOptions", "");
        String gridSubmitHandleName = "etlsRmt";
        StringBuffer prefixCode = new StringBuffer();
        prefixCode.append(this.getReturnCodeSetup()).append(this.getTSLevelMacro("etls_gridInstalled", "uwugrdsv")).append(this.getSignonMacro(server)).append(this.getParallelServerConnectedMacro()).append(this.getSignoffMacro());
        prefixCode.append("%global etls_signonStatus; \n").append("%let etls_workload = ").append(gridSubmitWorkload).append(";\n").append("%let etls_additionalSignonOptions = ").append(additionalSignonOptions).append(";\n").append("%let etls_handleName = ").append(gridSubmitHandleName).append(";\n").append("%let etls_startTime_&etls_handleName = %sysfunc(datetime()); \n").append("%let etls_endTime_&etls_handleName = &&&etls_startTime_&etls_handleName; \n\n");
        prefixCode.append("%etls_signon(handleName=&etls_handleName, cmacvar=etls_signonStatus, \n").append(INDENT).append("machineIdMacroVariable=etls_machineId,");
        if (gridSubmitWorkload.length() > 0) {
            prefixCode.append("workloadMacroVariable=etls_workload, \n");
        }
        prefixCode.append("\n").append(INDENT).append("additionalSignonOptions=&etls_additionalSignonOptions,signonRetries=").append(signonRetries).append("); \n\n");
        prefixCode.append("%syslput etls_handleName = &etls_handleName / remote = &etls_handleName; \n\n").append("rsubmit &etls_handlename wait = no sysrputsync = yes persist = yes");
        prefixCode.append("; \n\n").append("%let job_rc = 0;\n").append("%sysrput etls_startTime_&etls_handleName = %sysfunc(datetime()); \n\n");
        return prefixCode;
    }

    public StringBuffer getSubmitToGridSuffix(ServerContext server, String sServerComponentId) {
        if (sServerComponentId == null || !sServerComponentId.equalsIgnoreCase(GRID_CLSID)) {
            return null;
        }
        StringBuffer suffixCode = new StringBuffer();
        suffixCode.append("%sysrput etls_endTime_&etls_handleName = %sysfunc(datetime()); \n").append("%sysrput job_rc&etls_handleName = &job_rc;\n").append("endrsubmit;\n\n").append("%etls_signoff(handleName=&etls_handleName); \n\n").append("%put NOTE: Total runtime was %sysfunc(round(%sysevalf((&&&etls_endTime_&etls_handleName - &&&etls_startTime_&etls_handleName)/60),.0001)) (minutes).; \n").append("%put NOTE: Return code was &&job_rc&etls_handleName...; \n");
        return suffixCode;
    }

    public SASCodeGeneration genPercentPutStatement(String msg, String label) {
        return this.addSourceCode(this.getPercentPutStatement(msg, label));
    }

    public SASCodeGeneration genPutStatement(String msg) {
        return this.addSourceCode(this.getPutStatement(msg, NOTE_LABEL));
    }

    public SASCodeGeneration genPutStatement(String msg, String label) {
        return this.addSourceCode(this.getPutStatement(msg, label));
    }

    public SASCodeGeneration genPutStatement(String msg, String label, boolean splitLabel) {
        return this.addSourceCode(this.getPutStatement(msg, label, splitLabel));
    }

    public SASCodeGeneration genPercentPutStatement(String msg) {
        return this.addSourceCode(this.getPercentPutStatement(msg, NOTE_LABEL));
    }

    public StringBuffer getPutStatement(String msg) {
        return this.getPutStatement(msg, NOTE_LABEL);
    }

    public StringBuffer getPutStatement(String msg, String label) {
        return this.getPutStatement(msg, label, false);
    }

    public StringBuffer getPutStatement(String msg, String label, boolean splitLabel) {
        return this.getPutStatement(msg, label, "", false);
    }

    public StringBuffer getPutStatement(String msg, String label, String sasvar, boolean splitLabel) {
        StringBuffer message = new StringBuffer("put ");
        boolean isSasVarSet = sasvar.length() > 0;
        String newLabel = label;
        if (splitLabel) {
            message.append("\"" + newLabel.replaceAll(":", "\" "));
            newLabel = ":";
        }
        StringBuffer msgBuff = new StringBuffer(msg);
        if (isSasVarSet) {
            msgBuff.append(" ");
        }
        message.append(this.splitString(newLabel + " " + msgBuff.toString(), 68, false, "     ", true));
        if (!isSasVarSet) {
            message.append(";\n");
        } else {
            message.append(" ").append(sasvar).append(";\n");
        }
        return message;
    }

    public StringBuffer getPercentPutStatement(String msg) {
        return this.getPercentPutStatement(msg, NOTE_LABEL);
    }

    public StringBuffer getPercentPutStatement(String msg, String label) {
        return this.getPercentPutStatement(msg, label, true);
    }

    public StringBuffer getPercentPutStatement(String msg, String label, boolean usePercentStr) {
        StringBuffer message = new StringBuffer("%put ");
        if (usePercentStr) {
            message.append("%str(");
            msg = this.escapeMacroValue(msg);
        }
        message.append(label).append(" ").append(this.splitString(msg, 68, false, "     ", false));
        if (usePercentStr) {
            message.append(")");
        }
        message.append(";\n");
        return message;
    }

    public StringBuffer getMetadataMacrosAndOptions(CMetadata metaObject, ServerContext appServer, boolean makeMetauser) throws MdException, RemoteException {
        return this.getMetadataMacrosAndOptions(metaObject, appServer, makeMetauser, null, null);
    }

    public StringBuffer getMetadataMacrosAndOptions(CMetadata metaObject, ServerContext appServer, boolean makeMetauser, String metauser, String metapass) throws MdException, RemoteException {
        StringBuffer code = new StringBuffer();
        String reposID = metaObject.getRepositoryID();
        String reposName = this.escapeMacroValue(Workspace.getRepositoryName(reposID));
        code.append("/* ").append(bundle.getString("SASCodeGeneration.MacroVars.msg.txt")).append(" */\n");
        String serverName = appServer.getName();
        if (serverName == null || serverName.length() == 0) {
            try {
                serverName = Workspace.getMdFactory().getOMIUtil().getMetadataSimple(appServer.getCMetadataType(), appServer.getFQID(), "Name");
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage(exc, "Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
        Workspace ws = Workspace.getWorkspace();
        ConnectionManager connectionManager = ws.getConnectionManager();
        UserContextInterface userContext = ws.getUserContext();
        String appServerName = this.escapeMacroValue(serverName);
        code.append("%let IOMServer      = %nrquote(").append(appServerName).append(");\n");
        if (makeMetauser) {
            PasswordAuthentication pw = connectionManager.getAuthenticatedLogin();
            if (pw != null) {
                String SASPassword2;
                if (metapass == null) {
                    metapass = new String(pw.getPassword());
                }
                try {
                    SASPassword2 = SasPasswordString.encode((String)"sas002", (String)metapass);
                }
                catch (SasPasswordEncodingException spee) {
                    SASPassword2 = metapass;
                }
                code.append("%let metaUser       = %nrquote(");
                if (metauser == null) {
                    code.append(pw.getUserName());
                } else {
                    code.append(metauser);
                }
                code.append(");\n");
                code.append("%let metaPass       = %nrquote(").append(SASPassword2).append(");\n");
            } else {
                makeMetauser = false;
            }
        }
        try {
            ServerInterface serverInterface = userContext.getAuthServer();
            code.append("%let metaPort       = %nrquote(").append(serverInterface.getPort()).append(");\n");
            code.append("%let metaServer     = %nrquote(").append(serverInterface.getHost()).append(");\n");
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        code.append("%let metaRepository = %nrquote(").append(reposName).append(");\n");
        code.append("\n");
        code.append("/* ").append(bundle.getString("SASCodeGeneration.SetOptions.msg.txt")).append(" */\n");
        code.append("options metaport       = &metaPort \n");
        if (makeMetauser) {
            code.append("        metauser       = \"&metaUser\" \n");
            code.append("        metapass       = \"&metaPass\" \n");
        }
        code.append("        metaserver     = \"&metaServer\" \n");
        code.append("        metarepository = \"&metaRepository\";\n\n");
        return code;
    }

    public SASCodeGeneration genMetadataMacrosAndOptions(CMetadata metaObject, ServerContext appServer, boolean makeMetauser) throws MdException, RemoteException {
        this.addSourceCode(this.getMetadataMacrosAndOptions(metaObject, appServer, makeMetauser));
        return this;
    }

    public SASCodeGeneration genMetadataMacrosAndOptions(CMetadata metaObject, ServerContext appServer, boolean makeMetauser, String metauser, String metapass) throws MdException, RemoteException {
        this.addSourceCode(this.getMetadataMacrosAndOptions(metaObject, appServer, makeMetauser, metauser, metapass));
        return this;
    }

    public String getAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needQuotes) throws MdException, RemoteException {
        return this.getAttrib(column, isDataStep, passthru, needLabel, needFormats, needFormats, needQuotes);
    }

    public String getAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needInformats, boolean needQuotes) throws MdException, RemoteException {
        String columnDesc;
        String columnInformat;
        String columnFormat;
        StringBuffer attrib = new StringBuffer("");
        String columnName = column.getSASColumnName();
        if (columnName == null || columnName.length() == 0) {
            return "";
        }
        if (needQuotes) {
            columnName = DBMSNamesUtil.getQuotedString(columnName, passthru);
        }
        attrib.append(columnName).append(" length = ");
        String columnType = column.getSASColumnType();
        int columnLength = column.getSASColumnLength();
        if (columnType.equalsIgnoreCase("C") && isDataStep) {
            attrib.append("$");
        }
        attrib.append(columnLength);
        if (needFormats && (columnFormat = this.makeFormatName(column.getSASFormat(), true, columnType)) != null && columnFormat.length() > 0) {
            attrib.append(" format = " + columnFormat);
        }
        if (needInformats && (columnInformat = this.makeFormatName(column.getSASInformat(), false, columnType)) != null && columnInformat.length() > 0) {
            attrib.append(" informat = " + columnInformat);
        }
        if ((columnDesc = column.getDesc()) != null && columnDesc.length() > 0 && needLabel) {
            columnDesc = columnDesc.replaceAll("'", "''");
            attrib.append("\nlabel = '").append(columnDesc).append("'");
        }
        String stmt = attrib.toString();
        stmt = isDataStep ? "attrib " + stmt.replaceAll("\n", "\n          ") + "; \n" : stmt.replaceAll("\n", "\n          ");
        return stmt;
    }

    public SASCodeGeneration genAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needQuotes) throws MdException, RemoteException {
        this.addSourceCode(this.getAttrib(column, isDataStep, passthru, needLabel, needFormats, needQuotes));
        return this;
    }

    public SASCodeGeneration genAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needInformats, boolean needQuotes) throws MdException, RemoteException {
        this.addSourceCode(this.getAttrib(column, isDataStep, passthru, needLabel, needFormats, needInformats, needQuotes));
        return this;
    }

    public String getQuotedColumnName(Column column, boolean quoted) throws MdException, RemoteException {
        String columnName = column.getSASColumnName();
        DataTable table = column.getTable();
        if (table != null) {
            columnName = DBMSNamesUtil.getQuotedColumnName(column, table, quoted, false);
        }
        return columnName;
    }

    public StringBuffer getNoSyntaxCheck() {
        return this.getNoSyntaxCheck("");
    }

    public StringBuffer getNoSyntaxCheck(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append("%local etls_syntaxcheck; \n").append(indent).append("%let etls_syntaxcheck = %sysfunc(getoption(syntaxcheck)); \n").append(indent).append(this.makeComment(bundle.getString("SASCodeGeneration.SyntaxCheck.Note.txt"))).append(indent).append("options nosyntaxcheck;\n");
        return synCode;
    }

    public StringBuffer getObsMaxSet() {
        return this.getObsMaxSet("");
    }

    public StringBuffer getObsMaxSet(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append("%local etls_obs; \n").append(indent).append("%let etls_obs = %sysfunc(getoption(obs)); \n").append(indent).append(this.makeComment(bundle.getString("SASCodeGeneration.ObsMax.Note.txt"))).append(indent).append("options obs = max;\n");
        return synCode;
    }

    public StringBuffer getResetObs() {
        return this.getResetObs("");
    }

    public StringBuffer getResetObs(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append(this.makeComment(bundle.getString("SASCodeGeneration.ResetObs.Note.txt"))).append(indent).append("options obs = &etls_obs; \n");
        return synCode;
    }

    public StringBuffer getResetSyntaxCheck() {
        return this.getResetSyntaxCheck("");
    }

    public StringBuffer getResetSyntaxCheck(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append(this.makeComment(bundle.getString("SASCodeGeneration.ResetSyntaxCheck.Note.txt"))).append(indent).append("options &etls_syntaxcheck; \n");
        return synCode;
    }

    public String makeColumnList(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean needQuotes, String indent) throws MdException, RemoteException {
        return this.makeColumnList(columnList, oneColumnPerLine, spacesToIndentNextLines, passthru, delimiter, tableAlias, needQuotes, indent, false, false);
    }

    public String makeColumnList(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean needQuotes, String indent, boolean groupBy, boolean orderBy) throws MdException, RemoteException {
        return this.makeColumnList(columnList, oneColumnPerLine, spacesToIndentNextLines, passthru, delimiter, tableAlias, needQuotes, indent, groupBy, orderBy, false);
    }

    public String makeColumnList(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean needQuotes, String indent, boolean groupBy, boolean orderBy, boolean useTableNameAsAlias) throws MdException, RemoteException {
        if (columnList == null || columnList.size() == 0) {
            return "";
        }
        if (indent == null) {
            indent = this.m_indentString;
        }
        if (!delimiter.equals(" ")) {
            delimiter = delimiter + " ";
        }
        if ((tableAlias = tableAlias.trim()).length() > 0) {
            tableAlias = tableAlias.concat(".");
        }
        StringBuffer columnString = new StringBuffer();
        int currentLineLength = spacesToIndentNextLines.length() + indent.length();
        for (int i = 0; i < columnList.size(); ++i) {
            String columnName;
            Object obj = columnList.get(i);
            if (obj instanceof String) {
                columnName = needQuotes ? DBMSNamesUtil.getQuotedString((String)obj, passthru) : (String)obj;
            } else {
                if (!(obj instanceof Column)) continue;
                Column column = (Column)obj;
                boolean useColumnInt = false;
                if (groupBy) {
                    AssociationList targetFMs = column.getTargetFeatureMaps();
                    for (int j = 0; j < targetFMs.size(); ++j) {
                        CMetadata fm = (CMetadata)targetFMs.get(j);
                        if (!(fm instanceof FeatureMap) || !((FeatureMap)fm).getTransformRole().equals("SQLGROUPBYINTEGER")) continue;
                        useColumnInt = true;
                    }
                }
                if (!useColumnInt) {
                    String prefix = "";
                    if (useTableNameAsAlias && (tableAlias == null || tableAlias.length() == 0) && column.getTable() instanceof PhysicalTable) {
                        PhysicalTable table = (PhysicalTable)column.getTable();
                        prefix = table.getSASTableName().concat(".");
                    }
                    columnName = needQuotes ? prefix.concat(DBMSNamesUtil.getQuotedColumnName(column, needQuotes, passthru)) : prefix.concat(column.getSASColumnName());
                    if (orderBy && column.getSortOrder().equals("Descending")) {
                        columnName = prefix.concat(columnName) + " desc";
                    }
                } else {
                    columnName = Integer.toString(column.getTable().getColumns().indexOf((Object)column) + 1);
                }
            }
            if (oneColumnPerLine) {
                if (i > 0) {
                    columnString.append(delimiter).append("\n").append(spacesToIndentNextLines);
                }
            } else {
                if (currentLineLength + columnName.length() + tableAlias.length() > 78) {
                    columnString.append(delimiter).append("\n").append(spacesToIndentNextLines);
                    currentLineLength = spacesToIndentNextLines.length() + indent.length();
                } else if (i > 0) {
                    columnString.append(delimiter);
                }
                currentLineLength = currentLineLength + columnName.length() + tableAlias.length() + delimiter.length();
            }
            if (tableAlias.length() > 0) {
                columnString.append(tableAlias);
            }
            columnString.append(columnName);
        }
        return columnString.toString();
    }

    public String makeColumnList(DataTable table, String spacesToIndentNextLines, boolean needQuotes, String indent) throws MdException, RemoteException {
        if (table == null) {
            return null;
        }
        AssociationList columnList = table.getColumns();
        return this.makeColumnList((List)columnList, false, spacesToIndentNextLines, false, " ", "", needQuotes, indent);
    }

    public String makeColumnList(DataTable table, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean needQuotes, String indent) throws MdException, RemoteException {
        if (table == null) {
            return null;
        }
        AssociationList columnList = table.getColumns();
        return this.makeColumnList((List)columnList, oneColumnPerLine, spacesToIndentNextLines, passthru, delimiter, tableAlias, needQuotes, indent);
    }

    public String makeColumnList(List columnList, String spacesToIndentNextLines, boolean needQuotes) throws MdException, RemoteException {
        return this.makeColumnList(columnList, false, spacesToIndentNextLines, false, " ", "", needQuotes, null);
    }

    public String makeFormatName(String fmtName, String type) {
        return WsColumnMetadataUtil.makeValidFmtName(fmtName, false, type);
    }

    public String makeFormatName(String fmtName, boolean isFormat, String type) {
        return WsColumnMetadataUtil.makeValidFmtName(fmtName, isFormat, type);
    }

    public String makeComment(String msg) {
        int lineLength = 72;
        List lineList = this.splitString(msg, lineLength, true);
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < lineList.size(); ++i) {
            String line = (String)lineList.get(i);
            code.append("/* ").append(line).append(" */ \n");
        }
        return code.toString();
    }

    public List splitString(String string, int lineLength, boolean pad) {
        return this.splitString(string, lineLength, pad, false);
    }

    public List splitString(String string, int lineLength, boolean pad, boolean bPutStatement) {
        List<String> lineList = new ArrayList<String>();
        string = string.replaceAll("\n", "").replaceAll("\r", "");
        while (string.length() > 0) {
            if (string.length() <= lineLength) {
                lineList.add(string);
                break;
            }
            String blank = "X";
            int index = lineLength + 1;
            while (!blank.equals(" ") && index > 0) {
                blank = string.substring(--index, index + 1);
            }
            if (index <= 0) {
                index = lineLength - 1;
            }
            String line = bPutStatement ? string.substring(0, index) : string.substring(0, index).trim();
            lineList.add(line);
            string = string.substring(index);
        }
        if (pad) {
            lineList = this.padStrings(lineList);
        }
        return lineList;
    }

    public String splitString(String string, int lineLength, boolean pad, String spacesToIndentNextLines, boolean quoteEachLine) {
        List lineList = this.splitString(string, lineLength, pad, true);
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < lineList.size(); ++i) {
            if (i > 0) {
                text.append("\n").append(spacesToIndentNextLines);
            }
            String line = (String)lineList.get(i);
            if (quoteEachLine) {
                line = "\"" + line.replaceAll("\"", "\"\"") + "\"";
            }
            text.append(line);
        }
        return text.toString();
    }

    public List padStrings(List list) {
        String text;
        int i;
        int maxLength = 0;
        for (i = 0; i < list.size(); ++i) {
            text = (String)list.get(i);
            maxLength = Math.max(maxLength, text.length());
        }
        ++maxLength;
        for (i = 0; i < list.size(); ++i) {
            text = (String)list.get(i);
            text = text + this.repeat(" ", maxLength - text.length());
            list.set(i, text);
        }
        return list;
    }

    public String repeat(String repeatString, int numRepeats) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < numRepeats; ++i) {
            newString.append(repeatString);
        }
        return newString.toString();
    }

    public String escapeMacroValue(String string) {
        if (!string.startsWith("%str(")) {
            string = string.replaceAll("%", "%%").replaceAll("'", "%'").replaceAll("\"", "%\"").replaceAll("[(]", "%(").replaceAll("[)]", "%)");
        }
        return string;
    }

    public StringBuffer getParameterStatements(List attrDescriptors) {
        return this.getParameterStatements(attrDescriptors, true);
    }

    public StringBuffer getParameterStatements(List attrDescriptors, boolean generateBlankDefaults) {
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < attrDescriptors.size(); ++i) {
            String defaultValue;
            AttributeDescriptorInterface attr = (AttributeDescriptorInterface)attrDescriptors.get(i);
            String string = defaultValue = attr.getDefault() != null ? attr.getDefault().toString() : "";
            if (!generateBlankDefaults && defaultValue.length() <= 0) continue;
            code.append("%let ").append(SASCodeGeneration.getRealOptionName(attr)).append(" = ").append(defaultValue).append(";\n");
        }
        return code;
    }

    public boolean getGenerateRCSetCalls() {
        return this.m_bGenerateRCSetStatements;
    }

    public void setGenerateRCSetCalls(boolean gen) {
        this.m_bGenerateRCSetStatements = gen;
    }

    public StringBuffer getLabelStatement(String desc) {
        StringBuffer labelStatement = new StringBuffer();
        String desc2 = desc;
        if (desc2 != null && desc2.length() > 0) {
            desc2 = desc2.replaceAll("'", "''");
            labelStatement.append("label = '").append(desc2).append("'");
        }
        return labelStatement;
    }

    public StringBuffer getLabelStatement(Column col) throws RemoteException {
        return this.getLabelStatement(col.getDesc());
    }

    public static String getRealOptionName(String attributeName) {
        String attrName = null;
        if (attributeName != null && attributeName.length() > ATTRIBUTE_OPTION_PREFIX.length()) {
            attrName = attributeName.substring(ATTRIBUTE_OPTION_PREFIX.length());
        }
        return attrName;
    }

    public static String getRealOptionName(AttributeDescriptorInterface attribute) {
        return SASCodeGeneration.getRealOptionName(attribute.getName());
    }

    public static int displayLineLengthMessage(String line, int lineNumber) {
        return SASCodeGeneration.displayLineLengthMessage(line, lineNumber, null);
    }

    public static int displayLineLengthMessage(String line, int lineNumber, String namedText) {
        if (SASCodeGeneration.isUserPreferenceToPromptForLineLength()) {
            String sTitle = bundle.getString("SASCodeGeneration.MaximumLineLengthWarning.title.txt");
            String sMessage = namedText == null || namedText.length() == 0 ? bundle.formatString("SASCodeGeneration.MaximumLineLengthWarning.txt", Integer.toString(lineNumber), Integer.toString(255)) : bundle.formatString("SASCodeGeneration.MaximumLineLengthWarning.NamedText.txt", Integer.toString(lineNumber), namedText, Integer.toString(255));
            JCheckBox ckbDoNotShow = WsUIUtilities.createCheckBox(bundle, "SASCodeGeneration.MaximumLineLengthWarning.DoNotShowMessageAgain", 1);
            Object[] aMessages = new Object[]{sMessage, ckbDoNotShow};
            int eAnswer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), aMessages, sTitle, 0, 2);
            SASCodeGeneration.setUserPreferenceToPromptForLineLength(!ckbDoNotShow.isSelected());
            return eAnswer;
        }
        return 0;
    }

    public static void setUserPreferenceToPromptForLineLength(boolean bPrompt) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(PROMPT_FOR_LINE_LENGTH, bPrompt);
    }

    public static boolean isUserPreferenceToPromptForLineLength() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(PROMPT_FOR_LINE_LENGTH, true);
    }

    public class SASMacro {
        private String m_name;
        private String m_description;
        private List m_parameters = new ArrayList();

        public SASMacro(String name) {
            this.m_name = name;
            this.m_description = bundle.getString("SASCodeGeneration." + name + ".desc.txt");
        }

        public SASMacro addParameter(String name) {
            this.m_parameters.add(new Parameter(name, this.m_name));
            return this;
        }

        public StringBuffer getCommentHeader() {
            StringBuffer comment = new StringBuffer();
            String divider = SASCodeGeneration.this.repeat(SASCodeGeneration.DIVIDER, 75);
            comment.append("/*").append(divider).append(" \n").append(SASCodeGeneration.this.getCommentLine(bundle.getString("SASCodeGeneration.Macro.txt"))).append(SASCodeGeneration.this.getCommentLine(SASCodeGeneration.INDENT + this.m_name, " - " + this.m_description));
            if (!this.m_parameters.isEmpty()) {
                comment.append(SASCodeGeneration.this.getCommentLine(""));
                comment.append(SASCodeGeneration.this.getCommentLine(SASCodeGeneration.INDENT + bundle.getString("SASCodeGeneration.Parameters.txt")));
            }
            for (int i = 0; i < this.m_parameters.size(); ++i) {
                Parameter parm = (Parameter)this.m_parameters.get(i);
                comment.append(SASCodeGeneration.this.getCommentLine("      " + parm.getName(), " - " + parm.getDescription()));
            }
            comment.append(" *").append(divider).append("/ \n");
            return comment;
        }

        private class Parameter {
            private String m_parameterName;
            private String m_parameterDescription;

            public Parameter(String name, String macroName) {
                this.m_parameterName = name;
                this.m_parameterDescription = bundle.getString("SASCodeGeneration." + macroName + "." + name + ".desc.txt");
            }

            public String getName() {
                return this.m_parameterName;
            }

            public String getDescription() {
                return this.m_parameterDescription;
            }
        }
    }
}

