/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsAbstractProgressDialog;
import com.sas.workspace.WsMessageDisplayer;
import com.sas.workspace.WsStatusBar;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class OpRequestUI
implements WsMessageDisplayer {
    private static WAdminResource bundle = WAdminResource.getBundle(OpRequestUI.class);
    protected Frame m_frmParent;
    protected String m_sMessage;
    private String m_sPrototype;
    protected String m_sTitle;
    protected Timer m_timerDelay;
    protected Timer m_timerUpdate;
    protected int m_msDelay = 0;
    protected int m_msUpdate = 250;
    protected boolean m_bProgressShownOnStatusBar = true;
    protected Thread m_threadOperation;
    protected WsAbstractProgressDialog m_dlgProgress;
    protected Dimension m_dimMessage;

    public OpRequestUI() {
    }

    public OpRequestUI(String sMessage) {
        this.m_sMessage = sMessage;
    }

    public OpRequestUI(Component cmpParent) {
        this.m_frmParent = WorkspaceUtil.getParentFrame(cmpParent);
    }

    public OpRequestUI(Component cmpParent, String sMessage) {
        this.m_sMessage = sMessage;
        this.m_frmParent = WorkspaceUtil.getParentFrame(cmpParent);
    }

    public OpRequestUI(Component cmpParent, String sMessage, String sTitle) {
        this.m_sMessage = sMessage;
        this.m_sTitle = sTitle;
        this.m_frmParent = WorkspaceUtil.getParentFrame(cmpParent);
    }

    public OpRequestUI(JDialog dlgParent) {
        this.m_frmParent = WorkspaceUtil.getParentFrame(dlgParent);
    }

    public OpRequestUI(JDialog dlgParent, String sMessage) {
        this.m_sMessage = sMessage;
        this.m_frmParent = WorkspaceUtil.getParentFrame(dlgParent);
    }

    public OpRequestUI(JDialog dlgParent, String sMessage, String sTitle) {
        this.m_sMessage = sMessage;
        this.m_sTitle = sTitle;
        this.m_frmParent = WorkspaceUtil.getParentFrame(dlgParent);
    }

    public OpRequestUI(Frame frmParent) {
        this.m_frmParent = frmParent;
    }

    public OpRequestUI(Frame frmParent, String sMessage) {
        this.m_sMessage = sMessage;
        this.m_frmParent = frmParent;
    }

    public OpRequestUI(Frame frmParent, String sMessage, String sTitle) {
        this.m_sMessage = sMessage;
        this.m_sTitle = sTitle;
        this.m_frmParent = frmParent;
    }

    public OpRequestUI(Frame frmParent, String sMessage, String sTitle, String sCancelMessage) {
        this.m_sMessage = sMessage;
        this.m_sTitle = sTitle;
        this.m_frmParent = frmParent;
    }

    public int getDelayBeforeProgressCancelDialog() {
        return this.m_msDelay;
    }

    public void setDelayBeforeProgressCancelDialog(int msDelay) {
        this.m_msDelay = msDelay < 0 ? 1500 : msDelay;
    }

    public int getUpdateDelay() {
        return this.m_msUpdate;
    }

    public void setUpdateDelay(int msUpdate) {
        this.m_msUpdate = msUpdate < 0 ? 250 : msUpdate;
    }

    public void setProgressShownOnStatusBar(boolean bProgressShownOnStatusBar) {
        this.m_bProgressShownOnStatusBar = bProgressShownOnStatusBar;
    }

    public boolean isProgressShownOnStatusBar() {
        return this.m_bProgressShownOnStatusBar;
    }

    protected boolean isOperationStillRunning() {
        return this.m_threadOperation != null && this.m_threadOperation.isAlive();
    }

    public String getMessage() {
        if (this.m_sMessage == null) {
            this.m_sMessage = bundle.getString("OpRequestUI.RetrievingData");
        }
        return this.m_sMessage;
    }

    @Override
    public void displayMessage(String sMessage) {
        this.setMessage(sMessage);
    }

    public void setMessage(String sMessage) {
        if (this.m_sPrototype == null) {
            this.m_sPrototype = this.m_sMessage;
        }
        this.m_sMessage = sMessage;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WsAbstractProgressDialog dlg = OpRequestUI.this.m_dlgProgress;
                if (dlg != null) {
                    dlg.setText(OpRequestUI.this.m_sMessage);
                }
                Workspace.getWorkspace().setStatusText(OpRequestUI.this.m_sMessage);
            }
        });
    }

    public void setMessagePreferredSize(Dimension dimMessageLabel) {
        this.m_dimMessage = dimMessageLabel;
    }

    public Dimension getMessagePreferredSize() {
        return this.m_dimMessage;
    }

    public String getTitle() {
        if (this.m_sTitle == null) {
            this.m_sTitle = bundle.getString("OpRequestUI.Title.Accessing");
        }
        return this.m_sTitle;
    }

    public void setTitle(String sTitle) {
        this.m_sTitle = sTitle;
    }

    public Object exec(Object oTarget, String sMethod, Object[] oArgs, String sCancelMethod, String sCleanupMethod, Object oRequestInfo) {
        if (oArgs == null && oRequestInfo != null) {
            oArgs = new Object[]{oRequestInfo};
        }
        cRunnableMethod runMethod = new cRunnableMethod();
        runMethod.init(oTarget, sMethod, oArgs);
        this.execute(runMethod);
        return runMethod.getReturnValue();
    }

    public Object exec(Object oTarget, String sMethod, String sCancelMethod, String sCleanupMethod, Object oRequestInfo) {
        return this.exec(oTarget, sMethod, null, sCancelMethod, sCleanupMethod, oRequestInfo);
    }

    public Object exec(Object oTarget, String sMethod, Object oRequestInfo) {
        return this.exec(oTarget, sMethod, null, null, null, oRequestInfo);
    }

    public Object exec(Object oTarget, String sMethod, Object[] oArgs) {
        return this.exec(oTarget, sMethod, oArgs, null, null, null);
    }

    public Object exec(Object oTarget, String sMethod) {
        return this.exec(oTarget, sMethod, null, null, null, null);
    }

    public void execute(Runnable runOperation) {
        this.execute(runOperation, null);
    }

    public void execute(Runnable runOperation, Runnable runCompletionNotification) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        Workspace.getWorkspace().setStatusText(this.getMessage());
        try {
            this.m_threadOperation = this.createOperationThread(runOperation, runCompletionNotification);
            if (this.m_msDelay <= 0) {
                this.m_dlgProgress = this.createProgressDialog();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OpRequestUI.this.m_threadOperation.start();
                    }
                });
                this.m_dlgProgress.show();
                this.m_dlgProgress = null;
            } else {
                this.m_threadOperation.start();
                this.startDelayTimerSync();
            }
        }
        finally {
            Workspace.getWorkspace().clearStatusText();
            Workspace.getWorkspace().setCursor(null);
        }
    }

    protected void startDelayTimerSync() {
        WsStatusBar barStatus = Workspace.getWorkspace().getStatusBar();
        for (long howLongHaveWeBeenWaiting = 0L; howLongHaveWeBeenWaiting < (long)this.m_msDelay; howLongHaveWeBeenWaiting += 250L) {
            WorkspaceUtil.sleep(250);
            if (this.isOperationStillRunning()) continue;
            barStatus.clear();
            return;
        }
        if (barStatus.isProgressShown() && this.m_bProgressShownOnStatusBar) {
            barStatus.incrementProgress();
            this.startUpdateTimer();
        } else {
            barStatus.clear();
            this.m_dlgProgress = this.createProgressDialog();
            this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(3));
            this.m_dlgProgress.show();
            this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(0));
            this.m_dlgProgress = null;
        }
    }

    public void executeWithCancel(Runnable runOperation) throws InterruptedException {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        Workspace.getWorkspace().setStatusText(this.getMessage());
        try {
            this.m_threadOperation = this.createOperationThread(runOperation, null);
            this.m_threadOperation.start();
            if (this.m_msDelay > 0 && !this.delay()) {
                return;
            }
            this.m_dlgProgress = this.createProgressDialog();
            this.m_dlgProgress.setCancelEnabled(true);
            this.m_dlgProgress.show();
            if (!this.m_dlgProgress.isComplete()) {
                throw new InterruptedException("Operation cancelled");
            }
        }
        finally {
            this.m_dlgProgress = null;
            Workspace.getWorkspace().clearStatusText();
            Workspace.getWorkspace().setCursor(null);
        }
    }

    public int executeWithCancel(OpRequestUICancellableRunnable runOperation) {
        int result;
        block3: {
            result = 0;
            try {
                this.executeWithCancel((Runnable)runOperation);
            }
            catch (InterruptedException ex) {
                result = 1;
                runOperation.cancel();
                if (!runOperation.blockEventThreadUntilComplete()) break block3;
                while (this.isOperationStillRunning()) {
                    WorkspaceUtil.sleep(500);
                }
            }
        }
        return result;
    }

    private boolean delay() {
        for (long howLongHaveWeBeenWaiting = 0L; howLongHaveWeBeenWaiting < (long)this.m_msDelay; howLongHaveWeBeenWaiting += 200L) {
            WorkspaceUtil.sleep(200);
            if (this.isOperationStillRunning()) continue;
            return false;
        }
        return true;
    }

    protected void startDelayTimer() {
        this.m_timerDelay = new Timer(this.m_msDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WsStatusBar barStatus = Workspace.getWorkspace().getStatusBar();
                OpRequestUI.this.m_timerDelay.stop();
                if (OpRequestUI.this.isOperationStillRunning()) {
                    if (barStatus.isProgressShown() && OpRequestUI.this.m_bProgressShownOnStatusBar) {
                        barStatus.incrementProgress();
                        OpRequestUI.this.startUpdateTimer();
                    } else {
                        barStatus.clear();
                        OpRequestUI.this.m_dlgProgress = OpRequestUI.this.createProgressDialog();
                        OpRequestUI.this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(3));
                        OpRequestUI.this.m_dlgProgress.show();
                        OpRequestUI.this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(0));
                        OpRequestUI.this.m_dlgProgress = null;
                    }
                } else {
                    barStatus.clear();
                }
            }
        });
        this.m_timerDelay.start();
    }

    protected void startUpdateTimer() {
        this.m_timerUpdate = new Timer(this.m_msUpdate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OpRequestUI.this.isOperationStillRunning()) {
                    Workspace.getWorkspace().getStatusBar().incrementProgress();
                } else {
                    OpRequestUI.this.m_timerUpdate.stop();
                    Workspace.getWorkspace().clearStatusText();
                }
            }
        });
        this.m_timerUpdate.start();
    }

    protected WsAbstractProgressDialog createProgressDialog() {
        String sMessage = this.m_sPrototype != null ? this.m_sPrototype : this.m_sMessage;
        Frame frmParent = this.m_frmParent != null ? this.m_frmParent : Workspace.getWorkspace();
        cProgressDialog dlgProgress = new cProgressDialog(frmParent, this.m_sTitle, sMessage);
        if (this.m_dimMessage != null) {
            dlgProgress.setTextPreferredSize(this.m_dimMessage);
        }
        dlgProgress.setText(this.m_sMessage);
        return dlgProgress;
    }

    protected Thread createOperationThread(Runnable runOperation, Runnable runCompletionNotification) {
        return new cOperationThread(runOperation, runCompletionNotification);
    }

    protected class cRunnableMethod
    implements Runnable {
        protected Object m_oTarget;
        protected Object[] m_oaArgs;
        protected Method m_method;
        protected Object m_oReturnValue;

        protected cRunnableMethod() {
        }

        public void init(Object oTarget, String sMethod, Object[] oaArgs) {
            if (oTarget == null || sMethod == null) {
                return;
            }
            this.m_oTarget = oTarget;
            this.m_oaArgs = oaArgs;
            try {
                if (oaArgs == null) {
                    this.m_method = this.m_oTarget.getClass().getMethod(sMethod, null);
                } else {
                    Class[] caArgs = new Class[oaArgs.length];
                    int nArgs = oaArgs.length;
                    for (int iArg = 0; iArg < nArgs; ++iArg) {
                        caArgs[iArg] = oaArgs[iArg].getClass();
                    }
                    this.m_method = this.m_oTarget.getClass().getMethod(sMethod, caArgs);
                }
            }
            catch (NoSuchMethodException e) {
                String sMessage = "OpRequestUI: No such method exception: \"" + sMethod + "\" on class " + this.m_oTarget.getClass();
                System.out.println(sMessage);
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                this.m_oReturnValue = this.m_method.invoke(this.m_oTarget, this.m_oaArgs);
            }
            catch (InvocationTargetException e) {
                String sMessage = "OpRequestUI: Exception in callback method \"" + this.m_method.getName() + "\" on object " + this.m_oTarget;
                System.out.println(sMessage);
                e.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object getReturnValue() {
            return this.m_oReturnValue;
        }
    }

    protected class cProgressDialog
    extends WsAbstractProgressDialog {
        private static final long serialVersionUID = 1L;

        public cProgressDialog(Frame frmParent, String sTitle, String sText) {
            super(frmParent, sTitle, sText);
        }

        @Override
        protected boolean isComplete() {
            return !OpRequestUI.this.isOperationStillRunning();
        }
    }

    protected class cOperationThread
    extends Thread {
        protected Runnable m_runOperation;
        protected Runnable m_runCompletionNotification;

        public cOperationThread(Runnable runOperation, Runnable runCompletionNotification) {
            super("BackgroundOperation");
            this.m_runOperation = runOperation;
            this.m_runCompletionNotification = runCompletionNotification;
            this.setPriority(5);
        }

        @Override
        public void run() {
            this.m_runOperation.run();
            if (this.m_runCompletionNotification != null) {
                SwingUtilities.invokeLater(this.m_runCompletionNotification);
            }
        }
    }
}

