/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATableModel;
import com.sas.workspace.Workspace;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class JDBCTableModel
extends WATableModel {
    private static final long serialVersionUID = 1L;
    private EventListenerList m_listenerList;
    private ResultSet m_resultSet;
    private ResultSetMetaData m_metadata;
    private boolean m_useColumnNames;
    private Vector _rows;
    private boolean _more;
    private int _rowCount;
    private ModelReadThread m_readThread;
    public static final int InitialRowRead = 25;
    protected boolean bUseColumnClass = true;
    protected boolean doneWithRead = false;
    protected boolean m_bErrorOnRead = false;
    protected int max_read_rows = 5000;

    public JDBCTableModel(ResultSet resultSet) {
        this.m_resultSet = resultSet;
        this.m_metadata = this.getMetaData();
        this.m_useColumnNames = false;
        this._rows = new Vector();
        this._rowCount = -1;
        this._more = true;
        this.m_readThread = new ModelReadThread(this, this._rows);
        this.m_readThread.start();
        this.ensureRowIndex(25);
    }

    public JDBCTableModel(ResultSet resultSet, int maxRowsToRead) {
        this.max_read_rows = maxRowsToRead;
        this.m_resultSet = resultSet;
        this.m_metadata = this.getMetaData();
        this.m_useColumnNames = false;
        this._rows = new Vector();
        this._rowCount = -1;
        this._more = true;
        this.m_readThread = new ModelReadThread(this, this._rows);
        this.m_readThread.start();
        this.ensureRowIndex(25);
    }

    public JDBCTableModel(ResultSet resultSet, boolean useColumnClass) {
        this.bUseColumnClass = useColumnClass;
        this.m_resultSet = resultSet;
        this.m_metadata = this.getMetaData();
        this.m_useColumnNames = false;
        this._rows = new Vector();
        this._rowCount = -1;
        this._more = true;
        this.m_readThread = new ModelReadThread(this, this._rows);
        this.m_readThread.start();
        this.ensureRowIndex(25);
    }

    public JDBCTableModel(ResultSet resultSet, boolean useColumnClass, int maxRowsToRead) {
        this.max_read_rows = maxRowsToRead;
        this.bUseColumnClass = useColumnClass;
        this.m_resultSet = resultSet;
        this.m_metadata = this.getMetaData();
        this.m_useColumnNames = false;
        this._rows = new Vector();
        this._rowCount = -1;
        this._more = true;
        this.m_readThread = new ModelReadThread(this, this._rows);
        this.m_readThread.start();
        this.ensureRowIndex(25);
    }

    public void setUseColumnClass(boolean useColumnClass) {
        this.bUseColumnClass = useColumnClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDoneWithRead() {
        JDBCTableModel jDBCTableModel = this;
        synchronized (jDBCTableModel) {
            if (!this._more) {
                this.doneWithRead = true;
            }
        }
        return this.doneWithRead;
    }

    public final void setUseColumnNames(boolean useColumnNames) {
        if (this.m_useColumnNames != useColumnNames) {
            this.m_useColumnNames = useColumnNames;
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    public int getMaxRowsToRead() {
        return this.max_read_rows;
    }

    public void setMaxRowsToRead(int maxRowsToRead) {
        this.max_read_rows = maxRowsToRead;
    }

    public final boolean isUseColumnNames() {
        return this.m_useColumnNames;
    }

    public Object getObjectAt(int rowIndex, int columnIndex) {
        this.ensureRowIndex(rowIndex - 1);
        Object returnObject = null;
        try {
            returnObject = ((Object[])this._rows.elementAt(rowIndex - 1))[columnIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException exp) {
            exp.printStackTrace();
        }
        return returnObject;
    }

    public Object getObjectAt(int rowIndex, String columnName) {
        this.ensureRowIndex(rowIndex - 1);
        return ((Object[])this._rows.elementAt(rowIndex - 1))[this.findColumn(columnName) - 1];
    }

    public Object[] getRow(int rowIndex) {
        this.ensureRowIndex(rowIndex - 1);
        return (Object[])this._rows.elementAt(rowIndex - 1);
    }

    public Object getRowValue(int rowIndex) {
        Integer row = new Integer(rowIndex + 1);
        return row.toString();
    }

    public Enumeration elements() {
        return new Enumeration(){
            int _i = 1;
            Object _row;

            @Override
            public boolean hasMoreElements() {
                JDBCTableModel.this.ensureRowIndex(this._i - 1);
                try {
                    this._row = JDBCTableModel.this._rows.elementAt(this._i);
                }
                catch (Exception e) {
                    this._row = null;
                }
                return this._row != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                ++this._i;
                return this._row;
            }
        };
    }

    protected synchronized void ensureRowIndex(int rowIndex) {
        if (this.isErrorOnRead()) {
            return;
        }
        if (rowIndex > -1 && rowIndex < this._rows.size()) {
            return;
        }
        this.m_readThread.waitForMore(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getNextRow() {
        if (this.m_resultSet == null) {
            this.doneWithRead = true;
            return null;
        }
        if (!this._more) {
            this.doneWithRead = true;
            return null;
        }
        Object[] row = null;
        ResultSet resultSet = this.m_resultSet;
        synchronized (resultSet) {
            if (this.m_resultSet == null) {
                this.doneWithRead = true;
                return null;
            }
            if (!this._more) {
                this.doneWithRead = true;
                return null;
            }
            try {
                int columnCount = this.getColumnCount();
                if (columnCount > 0) {
                    this._more = this.m_resultSet.next();
                    if (this._more) {
                        row = new Object[columnCount];
                        for (int i = 0; i < columnCount; ++i) {
                            row[i] = this.m_resultSet.getObject(i + 1);
                        }
                    }
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                this.doneWithRead = true;
                this.setErrorOnRead(true);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return row;
    }

    public boolean close() {
        try {
            this.m_resultSet.close();
            this.m_resultSet = null;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isClosed() {
        return this.m_resultSet == null;
    }

    public final ResultSetMetaData getMetaData() {
        if (this.m_metadata == null && this.m_resultSet != null) {
            try {
                this.m_metadata = this.m_resultSet.getMetaData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_metadata;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.getEventListenerList().add(TableModelListener.class, l);
        l.tableChanged(new TableModelEvent(this));
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        Class<Object> c = Object.class;
        int columnType = 1111;
        try {
            columnType = this.m_metadata.getColumnType(columnIndex + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.bUseColumnClass) {
            c = String.class;
        } else {
            switch (columnType) {
                case 91: {
                    c = Date.class;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    c = Double.class;
                    break;
                }
                case 4: {
                    c = Integer.class;
                    break;
                }
                case 92: {
                    c = Time.class;
                    break;
                }
                case 93: {
                    c = Timestamp.class;
                    break;
                }
                case 12: {
                    c = String.class;
                    break;
                }
                case 1: {
                    c = Character.class;
                    break;
                }
            }
        }
        return c;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = null;
        try {
            name = this.isUseColumnNames() ? ((name = this.m_metadata.getColumnName(columnIndex + 1)) == null || name.trim().length() == 0 ? this.m_metadata.getColumnLabel(columnIndex + 1) : name) : ((name = this.m_metadata.getColumnLabel(columnIndex + 1)) == null || name.trim().length() == 0 ? this.m_metadata.getColumnName(columnIndex + 1) : name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name == null ? "" : name;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.getMetaData().getColumnCount();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int findColumn(String columnName) {
        int columnIndex = -1;
        ResultSetMetaData metadata = this.getMetaData();
        try {
            int columnCount = metadata.getColumnCount();
            for (int i = 0; columnIndex == -1 && i < columnCount; ++i) {
                columnIndex = columnName.equalsIgnoreCase(metadata.getColumnName(i + 1)) ? i + 1 : -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columnIndex;
    }

    @Override
    public int getRowCount() {
        int rowCount = this._rowCount;
        if (rowCount != -1) {
            return rowCount;
        }
        this.ensureRowIndex(-1);
        return this._rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getObjectAt(rowIndex + 1, columnIndex + 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.getEventListenerList().remove(TableModelListener.class, l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    protected EventListenerList getEventListenerList() {
        if (this.m_listenerList != null) {
            return this.m_listenerList;
        }
        this.m_listenerList = new EventListenerList();
        return this.m_listenerList;
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(event);
        }
    }

    public void setErrorOnRead(boolean b) {
        this.m_bErrorOnRead = b;
    }

    public boolean isErrorOnRead() {
        return this.m_bErrorOnRead;
    }

    public class ModelReadThread
    extends Thread {
        JDBCTableModel m_TableModel;
        Vector m_Rows;

        public ModelReadThread(JDBCTableModel tblModel, Vector rows) {
            this.m_TableModel = tblModel;
            this.m_Rows = rows;
        }

        @Override
        public void run() {
            Object[] row;
            int actualCount = 0;
            int firstNewRow = 1;
            int rowIncrement = 25;
            this.setPriority(this.getPriority() - 1);
            while ((row = this.m_TableModel.getNextRow()) != null && actualCount < JDBCTableModel.this.max_read_rows) {
                this.m_Rows.addElement(row);
                actualCount = this.m_Rows.size();
                Thread.yield();
                if (actualCount - firstNewRow < rowIncrement) continue;
                this.m_TableModel._rowCount = actualCount;
                this.m_TableModel.fireTableChanged(new TableModelEvent(this.m_TableModel, firstNewRow, actualCount - 1, -1, 1));
                this.moreAdded();
                firstNewRow = actualCount;
                rowIncrement = 25;
            }
            if (JDBCTableModel.this.isErrorOnRead()) {
                this.moreAdded();
            } else if (actualCount - firstNewRow > 0 || actualCount == 1 && firstNewRow == 1) {
                this.m_TableModel._rowCount = actualCount;
                this.m_TableModel.fireTableChanged(new TableModelEvent(this.m_TableModel, firstNewRow, actualCount - 1, -1, 1));
                this.moreAdded();
            }
            Workspace.getDefaultLogger().debug("Done reading JDBC ResultSet...");
            JDBCTableModel.this.doneWithRead = true;
        }

        public synchronized void waitForMore(int rowIndex) {
            try {
                while (this.m_TableModel._more && rowIndex > this.m_Rows.size() && !JDBCTableModel.this.isErrorOnRead()) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                System.err.println("ensureRowIndex:  Interrupted Wait Exception");
            }
        }

        public synchronized void moreAdded() {
            this.notifyAll();
        }
    }
}

