/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.Repository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class HelpClassLoader
extends URLClassLoader {
    private static URL[] VJRURLs = null;
    private static Hashtable classLoaders = new Hashtable();

    private HelpClassLoader(Class callingClass) {
        super(HelpClassLoader.getAllURLs(), callingClass.getClassLoader());
    }

    public static HelpClassLoader getInstance(Class callingClass) {
        HelpClassLoader result = (HelpClassLoader)classLoaders.get(callingClass.getClassLoader());
        if (result == null) {
            result = new HelpClassLoader(callingClass);
            classLoaders.put(callingClass.getClassLoader(), result);
        }
        return result;
    }

    private static URL[] getAllURLs() {
        return HelpClassLoader.combineURLs(HelpClassLoader.getJarURLs(), HelpClassLoader.getVJRURLs());
    }

    private static URL[] getJarURLs() {
        File dir = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "help");
        ArrayList<URL> urls = new ArrayList<URL>();
        if (dir.exists() && dir.isDirectory()) {
            File classesDir = new File(dir, "classes");
            if (classesDir.exists() && classesDir.isDirectory()) {
                try {
                    urls.add(classesDir.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            String[] names = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase(Locale.US).endsWith(".jar");
                }
            });
            for (int i = 0; i < names.length; ++i) {
                try {
                    File urlFile = new File(dir.getPath() + File.separatorChar + names[i]);
                    urls.add(urlFile.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        URL[] urlArray = new URL[urls.size()];
        return urls.toArray(urlArray);
    }

    private static URL[] getVJRURLs() {
        if (VJRURLs != null) {
            return VJRURLs;
        }
        VJRURLs = new URL[0];
        File helpPicklistDir = new File("help");
        File helpPicklist = new File(helpPicklistDir, "secondary.picklist");
        if (!helpPicklistDir.exists() || !helpPicklist.exists()) {
            return VJRURLs;
        }
        Plugin[] vjrPlugins = HelpClassLoader.getVJRPlugins(helpPicklist);
        for (int i = vjrPlugins.length - 1; i >= 0; --i) {
            VJRURLs = HelpClassLoader.combineURLs(VJRURLs, vjrPlugins[i].getBundleClasspath());
        }
        return VJRURLs;
    }

    private static URL[] combineURLs(URL[] urls1, URL[] urls2) {
        URL[] result = new URL[urls1.length + urls2.length];
        System.arraycopy(urls1, 0, result, 0, urls1.length);
        System.arraycopy(urls2, 0, result, urls1.length, urls2.length);
        return result;
    }

    private static Plugin[] getVJRPlugins(File helpPicklist) {
        Plugin[] plugins = new Plugin[]{};
        if (helpPicklist.exists()) {
            try {
                FileInputStream input = new FileInputStream(helpPicklist);
                PickList pickList = new PickList((InputStream)input);
                plugins = Repository.getDefaultRepository().find(pickList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return plugins;
    }
}

