/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Variable;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.Token;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionParser {
    private static WAdminResource bundle = WAdminResource.getBundle(ExpressionParser.class);
    private static ServerContext s_Server = null;
    private static final int NONE = 0;
    private static final int TEXT = 1;
    private static final int QUOTE1 = 2;
    private static final int QUOTE2 = 3;
    private static final int VARIABLE = 4;

    private ExpressionParser() {
    }

    public static String tokenizeString(String source, List objects, AbstractTransformation transform, boolean useQuotesInName, boolean caseSensitiveCompare) throws MdException, RemoteException {
        return ExpressionParser.tokenizeString(source, objects, transform, useQuotesInName, caseSensitiveCompare, false);
    }

    public static String tokenizeString(String source, List objects, AbstractTransformation transform, boolean useQuotesInName, boolean caseSensitiveCompare, boolean useNLiteralDoubleQuotes) throws MdException, RemoteException {
        if (objects == null) {
            return source;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Root> newObjects = new ArrayList<Root>();
        ListIterator objIter = objects.listIterator();
        while (objIter.hasNext()) {
            Root object = (Root)objIter.next();
            String fullName = ExpressionParser.getObjectName(object, useQuotesInName, true, useNLiteralDoubleQuotes);
            newObjects.add(object);
            names.add(fullName);
            String shortName = ExpressionParser.getObjectName(object, useQuotesInName, false, useNLiteralDoubleQuotes);
            if (fullName.equals(shortName)) continue;
            newObjects.add(object);
            names.add(shortName);
        }
        return ExpressionParser.tokenizeString(source, newObjects, names, transform, caseSensitiveCompare, useNLiteralDoubleQuotes);
    }

    public static String tokenizeString(String source, List objects, List usedObjects, boolean useQuotesInName, boolean caseSensitiveCompare) throws MdException, RemoteException {
        return ExpressionParser.tokenizeString(source, objects, usedObjects, useQuotesInName, caseSensitiveCompare, false);
    }

    public static String tokenizeString(String source, List objects, List usedObjects, boolean useQuotesInName, boolean caseSensitiveCompare, boolean useNLiteralDoubleQuotes) throws MdException, RemoteException {
        return ExpressionParser.tokenizeString(source, objects, usedObjects, useQuotesInName, caseSensitiveCompare, useNLiteralDoubleQuotes, false);
    }

    public static String tokenizeString(String source, List objects, List usedObjects, boolean useQuotesInName, boolean caseSensitiveCompare, boolean useNLiteralDoubleQuotes, boolean updateObjectList) throws MdException, RemoteException {
        if (objects == null) {
            return source;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Root> newObjects = new ArrayList<Root>();
        ListIterator objIter = objects.listIterator();
        while (objIter.hasNext()) {
            Root object = (Root)objIter.next();
            String fullName = ExpressionParser.getObjectName(object, useQuotesInName, true, useNLiteralDoubleQuotes);
            newObjects.add(object);
            names.add(fullName);
            String shortName = ExpressionParser.getObjectName(object, useQuotesInName, false, useNLiteralDoubleQuotes);
            if (fullName.equals(shortName)) continue;
            newObjects.add(object);
            names.add(shortName);
        }
        if (updateObjectList) {
            objects.clear();
            objects.addAll(newObjects);
        }
        return ExpressionParser.tokenizeString(source, newObjects, names, usedObjects, caseSensitiveCompare, useNLiteralDoubleQuotes);
    }

    public static String tokenizeString(String source, List objects, List text, AbstractTransformation transform, boolean caseSensitiveCompare) throws MdException, RemoteException {
        return ExpressionParser.tokenizeString(source, objects, text, transform, false);
    }

    public static String tokenizeString(String source, List objects, List text, AbstractTransformation transform, boolean caseSensitiveCompare, boolean useNLiteralDoubleQuotes) throws MdException, RemoteException {
        int i;
        if (objects == null || text == null || transform == null) {
            return source;
        }
        String retValue = "";
        ArrayList<Boolean> usedList = new ArrayList<Boolean>();
        int count = Math.min(objects.size(), text.size());
        for (i = 0; i < count; ++i) {
            usedList.add(false);
        }
        retValue = ExpressionParser.tokenizeString(source, text, usedList, caseSensitiveCompare, useNLiteralDoubleQuotes ? (char)'\"' : '\'');
        if (transform.getSubstitutionVariables().size() > 0) {
            MdObjectStore store = (MdObjectStore)transform.getObjectStore();
            store.removeObjectsFromStore((List)transform.getSubstitutionVariables());
        }
        for (i = 0; i < count; ++i) {
            if (!((Boolean)usedList.get(i)).booleanValue()) continue;
            Variable var = (Variable)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)transform.getObjectStore(), null, "var", "Variable", transform.getRepositoryID(), null);
            var.getAssociatedObjects().add(objects.get(i));
            var.setName("[" + i + "] - " + objects.get(i).toString());
            var.setMarker("[" + i + "]");
            if (i > 0 && objects.get(i) == objects.get(i - 1)) {
                var.setValueType("short name");
            } else {
                var.setValueType("long name");
            }
            var.getOwningTransformations().add((Object)transform);
        }
        return retValue;
    }

    public static String tokenizeString(String source, List objects, List text, List usedObjects, boolean caseSensitiveCompare, boolean useNLiteralDoubleQuotes) throws MdException, RemoteException {
        int i;
        if (objects == null || text == null) {
            return source;
        }
        String retValue = "";
        ArrayList<Boolean> usedList = new ArrayList<Boolean>();
        int count = Math.min(objects.size(), text.size());
        for (i = 0; i < count; ++i) {
            usedList.add(false);
        }
        retValue = ExpressionParser.tokenizeString(source, text, usedList, caseSensitiveCompare, useNLiteralDoubleQuotes ? (char)'\"' : '\'');
        for (i = 0; i < count; ++i) {
            if (!((Boolean)usedList.get(i)).booleanValue()) continue;
            usedObjects.add(objects.get(i));
        }
        return retValue;
    }

    public static String tokenizeString(String source, List text, List used, boolean caseSensitiveCompare) throws MdException, RemoteException {
        return ExpressionParser.tokenizeString(source, text, used, caseSensitiveCompare, '\'');
    }

    public static String tokenizeString(String source, List text, List used, boolean caseSensitiveCompare, char nLiteralQuote) throws MdException, RemoteException {
        return ExpressionParser.tokenizeString(source, text, used, caseSensitiveCompare, nLiteralQuote, true);
    }

    public static String tokenizeString(String source, List text, List used, boolean caseSensitiveCompare, char nLiteralQuote, boolean useNLiteral) throws MdException, RemoteException {
        int j;
        if (source == null) {
            return null;
        }
        if (text == null || used == null) {
            return source;
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        int end = 0;
        int state = 0;
        block5: while (end < source.length()) {
            char currchar = source.charAt(end);
            ++end;
            switch (state) {
                case 1: {
                    if (currchar == '\'') {
                        tokens.add(new Token(true, source.substring(start, end - 1)));
                        start = end - 1;
                        state = 2;
                        continue block5;
                    }
                    if (currchar != '\"') continue block5;
                    tokens.add(new Token(true, source.substring(start, end - 1)));
                    start = end - 1;
                    state = 3;
                    continue block5;
                }
                case 2: {
                    if (currchar != '\'') continue block5;
                    if (nLiteralQuote == currchar && (source.length() > end && source.charAt(end) == 'n' || !useNLiteral)) {
                        if (useNLiteral) {
                            ++end;
                        }
                        tokens.add(new Token(true, source.substring(start, end)));
                    } else {
                        tokens.add(new Token(false, source.substring(start, end)));
                    }
                    start = end;
                    state = 0;
                    continue block5;
                }
                case 3: {
                    if (currchar != '\"') continue block5;
                    if (nLiteralQuote == currchar && (source.length() > end && source.charAt(end) == 'n' || !useNLiteral)) {
                        if (useNLiteral) {
                            ++end;
                        }
                        tokens.add(new Token(true, source.substring(start, end)));
                    } else {
                        tokens.add(new Token(false, source.substring(start, end)));
                    }
                    start = end;
                    state = 0;
                    continue block5;
                }
            }
            if (currchar == '\'') {
                state = 2;
                continue;
            }
            if (currchar == '\"') {
                state = 3;
                continue;
            }
            state = 1;
        }
        if (state != 0) {
            tokens.add(new Token(true, source.substring(start, end)));
        }
        for (j = 0; j < tokens.size() - 1; ++j) {
            Token tok1 = (Token)tokens.get(j);
            Token tok2 = (Token)tokens.get(j + 1);
            if (!tok1.canSubstitute() || !tok2.canSubstitute()) continue;
            tok1.addString(tok2.getText());
            tokens.remove(j + 1);
            --j;
        }
        for (j = 0; j < tokens.size(); ++j) {
            String tokText;
            Token tok = (Token)tokens.get(j);
            if (!tok.canSubstitute()) continue;
            String lowName = "";
            String tokTextCompare = tokText = tok.getText();
            boolean matchFound = true;
            int count = Math.min(text.size(), used.size());
            while (matchFound) {
                matchFound = false;
                int lowIndex = tokText.length();
                tokTextCompare = !caseSensitiveCompare ? tokText.toLowerCase() : tokText;
                int lowObject = 0;
                for (int k = 0; k < count; ++k) {
                    int nextChar;
                    Pattern p;
                    Matcher m;
                    int index;
                    String name = (String)text.get(k);
                    if (!caseSensitiveCompare) {
                        name = name.toLowerCase();
                    }
                    if ((index = tokTextCompare.indexOf(name)) < 0 || name.length() <= 0 || (m = (p = Pattern.compile("(['\"]).*?" + name + ".*?\\1")).matcher(tokTextCompare)).find()) continue;
                    int prevChar = index - 1;
                    if (index > 0 && (Character.isJavaIdentifierPart(tokText.charAt(prevChar)) || tokText.charAt(prevChar) == '&' || tokText.charAt(prevChar) == '\"' || tokText.charAt(prevChar) == '\'')) {
                        index = lowIndex + 1;
                    }
                    if ((nextChar = index + name.length()) < tokText.length() && (Character.isJavaIdentifierPart(tokText.charAt(nextChar)) || ExpressionParser.getNextNonBlankChar(tokText, nextChar) == '(' || ExpressionParser.getNextNonBlankChar(tokText, nextChar) == '.')) {
                        index = lowIndex + 1;
                    }
                    if (index >= lowIndex && (index != lowIndex || name.length() <= lowName.length())) continue;
                    lowIndex = index;
                    lowName = name;
                    lowObject = k;
                    matchFound = true;
                }
                if (!matchFound) continue;
                Boolean temp = (Boolean)used.get(lowObject);
                if (!temp.booleanValue()) {
                    used.set(lowObject, true);
                }
                tokText = tokText.substring(0, lowIndex) + "[" + lowObject + "]" + tokText.substring(lowIndex + lowName.length());
            }
            tok.foundMatch(tokText);
        }
        String retValue = "";
        for (int i = 0; i < tokens.size(); ++i) {
            retValue = retValue + ((Token)tokens.get(i)).getText();
        }
        return retValue;
    }

    private static char getNextNonBlankChar(String text, int start) {
        char nextChar = ' ';
        while (start < text.length() - 1) {
            char c = text.charAt(start);
            if (c != ' ') {
                return c;
            }
            ++start;
        }
        return nextChar;
    }

    public static String detokenizeString(String source, AbstractTransformation transform, boolean useQuotesInName) throws MdException, RemoteException {
        return ExpressionParser.detokenizeString(source, transform, useQuotesInName, false);
    }

    public static String detokenizeString(String source, AbstractTransformation transform, boolean useQuotesInName, boolean useNLiteralDoubleQuotes) throws MdException, RemoteException {
        if (transform == null) {
            return source;
        }
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<String> tokenids = new ArrayList<String>();
        AssociationList list = transform.getSubstitutionVariables();
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            Root obj = var.getAssociatedObject();
            if (obj == null) continue;
            String type = var.getValueType();
            if (type.equals("short name")) {
                text.add(ExpressionParser.getObjectName(obj, useQuotesInName, false, useNLiteralDoubleQuotes));
            } else {
                text.add(ExpressionParser.getObjectName(obj, useQuotesInName, true, useNLiteralDoubleQuotes));
            }
            tokenids.add(var.getMarker());
        }
        return ExpressionParser.detokenizeString(source, tokenids, text);
    }

    public static String detokenizeString(String source, List tokenids, List text) throws MdException, RemoteException {
        int i;
        if (tokenids == null || text == null) {
            return source;
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        int end = 0;
        int state = 0;
        block5: while (end < source.length()) {
            char currchar = source.charAt(end);
            ++end;
            switch (state) {
                case 1: {
                    if (currchar == '\"') {
                        state = 3;
                        continue block5;
                    }
                    if (currchar != '[') continue block5;
                    tokens.add(new Token(false, source.substring(start, --end)));
                    start = end;
                    state = 4;
                    continue block5;
                }
                case 4: {
                    if (currchar != ']') continue block5;
                    tokens.add(new Token(true, source.substring(start, end)));
                    start = end;
                    state = 0;
                    continue block5;
                }
                case 3: {
                    if (currchar != '\"') continue block5;
                    tokens.add(new Token(false, source.substring(start, end)));
                    start = end;
                    state = 0;
                    continue block5;
                }
            }
            if (currchar == '[') {
                state = 4;
                continue;
            }
            if (currchar == '\"') {
                state = 3;
                continue;
            }
            state = 1;
        }
        if (state != 0) {
            tokens.add(new Token(true, source.substring(start, end)));
        }
        ListIterator nameIter = text.listIterator();
        ListIterator idIter = tokenids.listIterator();
        while (nameIter.hasNext() && idIter.hasNext()) {
            String name = (String)nameIter.next();
            String id = (String)idIter.next();
            for (i = 0; i < tokens.size(); ++i) {
                Token tok = (Token)tokens.get(i);
                if (!tok.canSubstitute() || !tok.getText().equals(id)) continue;
                tok.foundMatch(name);
            }
        }
        for (i = 0; i < tokens.size() - 1; ++i) {
            Token tok = (Token)tokens.get(i);
            if (!tok.canSubstitute()) continue;
            tok.foundMatch(bundle.getString("ExpressionParser.MissingToken"));
        }
        String retValue = "";
        for (i = 0; i < tokens.size(); ++i) {
            retValue = retValue + ((Token)tokens.get(i)).getText();
        }
        return retValue;
    }

    private static String getObjectName(Root object, boolean useQuotesInName, boolean longName, boolean useNLiteralDoubleQuotes) throws MdException, RemoteException {
        String retValue = "";
        String quote = "'";
        if (useNLiteralDoubleQuotes) {
            quote = "\"";
        }
        if (object instanceof PhysicalTable) {
            PhysicalTable table = (PhysicalTable)object;
            if (longName) {
                RelationalSchema library = table.getTablePackage();
                if (library instanceof SASLibrary) {
                    SASLibrary tempLib = LibraryUtil.getClientLibrary((SASLibrary)library, s_Server);
                    retValue = tempLib.getLibref() + ".";
                }
                if (library instanceof DatabaseSchema) {
                    AssociationList list = ((DatabaseSchema)library).getUsedByPackages();
                    if (list.size() > 0) {
                        SASLibrary slib = (SASLibrary)list.get(0);
                        retValue = useQuotesInName ? quote + slib.getLibref() + quote + "n." : slib.getLibref() + ".";
                    }
                } else if (library == null) {
                    retValue = "WORK.";
                }
            }
            retValue = useQuotesInName ? retValue + quote + table.getSASTableName() + quote + "n" : retValue + table.getSASTableName();
        } else if (object instanceof ExternalTable) {
            retValue = "WORK.";
            retValue = useQuotesInName ? retValue + quote + object.getName() + quote + "n" : retValue + object.getName();
        } else if (object instanceof Column) {
            Column col = (Column)object;
            if (longName && col.getTable() instanceof PhysicalTable) {
                retValue = useQuotesInName ? quote + ((PhysicalTable)col.getTable()).getSASTableName() + quote + "n." : ((PhysicalTable)col.getTable()).getSASTableName() + ".";
            } else if (longName && col.getTable() instanceof ExternalTable) {
                retValue = useQuotesInName ? quote + col.getTable().getName() + quote + "n." : col.getTable().getName() + ".";
            }
            retValue = useQuotesInName ? retValue + quote + col.getSASColumnName() + quote + "n" : retValue + col.getSASColumnName();
        } else if (object != null) {
            retValue = object.getName();
        }
        return retValue;
    }

    public static void setServer(ServerContext iServer) {
        s_Server = iServer;
    }
}

