/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.util.RB;
import com.sas.text.Message;
import com.sas.workspace.DesktopUtil;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class EnableHelpUtil {
    public static final String RB_KEY = "SASJavaHelp.";

    public static void enableHelpKey(Component comp, final String docsetId, final String docsetTarget, final String docsetVersion) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"componentNull.fmt.txt"), (Object)"enableHelpKey"));
        }
        if (docsetId != null) {
            final ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesktopUtil.openHelpDoc(docsetId, docsetTarget, docsetVersion, null);
                }
            };
            KeyListener key = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    int code = e.getKeyCode();
                    if (code == 112 || code == 156) {
                        ActionListener al = action;
                        al.actionPerformed(new ActionEvent(e.getComponent(), 1001, null));
                    }
                }
            };
            if (comp instanceof JComponent) {
                JComponent root = (JComponent)comp;
                root.registerKeyboardAction(action, KeyStroke.getKeyStroke(156, 0), 1);
                root.registerKeyboardAction(action, KeyStroke.getKeyStroke(112, 0), 1);
            } else {
                comp.addKeyListener(key);
            }
        } else {
            Workspace.getDefaultLogger().warn(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"helpSetFailed.fmt.txt"), (Object)"enableHelpKey"));
        }
    }

    public static void enableHelpOnClick(Component comp, final String docsetId, final String docsetTarget, final String docsetVersion) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"componentNull.fmt.txt"), (Object)"enableHelpOnClick"));
        }
        if (!(comp instanceof JButton) && !(comp instanceof JMenuItem)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"wrongComponentType.fmt.txt"), (Object)"JButton", (Object)"JMenuItem"));
        }
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopUtil.openHelpDoc(docsetId, docsetTarget, docsetVersion, null);
            }
        };
        if (comp instanceof JButton) {
            ((JButton)comp).addActionListener(l);
        } else if (comp instanceof JMenuItem) {
            ((JMenuItem)comp).addActionListener(l);
        }
    }
}

