/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;

public class DesktopUtil {
    public static void openHelpDoc(String docsetId, String docsetTarget, String docsetVersion, String displayMes) {
        block12: {
            String myOS = System.getProperty("os.name").toLowerCase();
            Locale locale = null != Locale.getDefault() ? Locale.getDefault() : new Locale("en");
            String helpVersion = "version";
            String Url = "https://documentation.sas.com?docsetId=" + docsetId + "&docsetVersion=" + helpVersion + "&locale=" + locale + "&requestor=inapp";
            if (docsetTarget != null && docsetTarget.trim().length() > 0) {
                Url = "https://documentation.sas.com?docsetId=" + docsetId + "&docsetVersion=" + helpVersion + "&docsetTarget=" + docsetTarget + "&locale=" + locale + "&requestor=inapp";
            }
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URL(Url).toURI());
                } else if (myOS.contains("mac")) {
                    DesktopUtil.execCommand("open " + Url);
                } else if (myOS.contains("nix") || myOS.contains("nux") || myOS.contains("aix") || myOS.contains("solaris") || myOS.contains("sunos")) {
                    if (!DesktopUtil.execCommand("kde-open " + Url) && !DesktopUtil.execCommand("gnome-open " + Url)) {
                        DesktopUtil.execCommand("xdg-open " + Url);
                    }
                } else if (myOS.contains("win")) {
                    DesktopUtil.execCommand("rundll32 url.dll,FileProtocolHandler " + Url);
                } else {
                    MessageUtil.displayMessage(displayMes);
                }
            }
            catch (IOException | URISyntaxException e) {
                Workspace.getDefaultLogger().error("Failed to display the help document for docsetId: " + docsetId + " : " + e.getMessage());
                if (displayMes == null) break block12;
                MessageUtil.displayMessage(displayMes, 0);
            }
        }
    }

    private static boolean execCommand(String command) {
        try {
            Process p = Runtime.getRuntime().exec(command);
            if (p == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    return false;
                }
                return false;
            }
            catch (IllegalThreadStateException itse) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

