/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;

public class ConnectPropertyDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    protected WAPanel m_centerPanel = new WAPanel();
    protected String m_strName;
    protected String m_strPassword;
    protected String m_strMachine;
    protected int m_iPort;
    protected boolean m_saveToFile;
    protected WATextField m_nameText;
    protected WAPasswordField m_passwordText;
    protected WAIntTextField m_portText;
    protected WATextField m_machineText;
    protected JLabel m_namelabel;
    protected JLabel m_passwordlabel;
    protected JLabel m_portlabel;
    protected JLabel m_machinelabel;
    protected String m_nameTextInitialValue;
    protected String m_passwordTextInitialValue;
    protected String m_portTextInitialValue;
    protected String m_machineTextInitialValue;
    protected WorkspaceFile m_workspacefile;
    private static WAdminResource bundle = WAdminResource.getBundle(ConnectPropertyDialog.class);

    public ConnectPropertyDialog(Frame owner) {
        this(owner, true);
    }

    public ConnectPropertyDialog(Frame owner, boolean saveToFile) {
        super(owner, bundle.getString("ConnectProperty.Title.txt"), true);
        this.m_saveToFile = saveToFile;
        try {
            this._initialize();
            if (this.m_saveToFile) {
                this.m_workspacefile = Workspace.getWorkspace().getWorkspaceFile();
                this._initializeFromFile();
            }
            this._layoutWidgets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onOK() {
        super.onOK();
        if (!this.m_saveToFile) {
            this.dispose();
            return false;
        }
        String tmp = this.m_nameText.getText();
        if (!(tmp = tmp.trim()).equals(this.m_nameTextInitialValue)) {
            this.m_workspacefile.setPropertyString("userid", tmp);
        }
        String strPass = this.m_passwordTextInitialValue;
        boolean passwordChanged = false;
        char[] pass = this.m_passwordText.getPassword();
        if (pass.length != this.m_passwordTextInitialValue.length()) {
            strPass = String.valueOf(pass);
            passwordChanged = true;
        } else {
            for (int ii = 0; ii < pass.length; ++ii) {
                if (pass[ii] == this.m_passwordTextInitialValue.charAt(ii)) continue;
                strPass = String.valueOf(pass);
                passwordChanged = true;
                break;
            }
        }
        if (passwordChanged) {
            strPass = strPass.trim();
            try {
                String strPassEncrypt = Workspace.getMdFactory().getUtil().safeEncrypt(strPass);
                this.m_workspacefile.setPropertyString("password", strPassEncrypt);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        tmp = this.m_machineText.getText();
        if (!(tmp = tmp.trim()).equals(this.m_machineTextInitialValue)) {
            this.m_workspacefile.setPropertyString("host", tmp);
        }
        tmp = this.m_portText.getText();
        if (!(tmp = tmp.trim()).equals(this.m_portTextInitialValue)) {
            this.m_workspacefile.setPropertyString("port", tmp);
        }
        this.m_workspacefile.saveExisting();
        return true;
    }

    public String getUserid() {
        String userid = this.m_nameText.getText();
        userid = userid.trim();
        return userid;
    }

    public String getPassword() {
        char[] p = this.m_passwordText.getPassword();
        String password = String.valueOf(p);
        password = password.trim();
        return password;
    }

    public String getHost() {
        String host = this.m_machineText.getText();
        host = host.trim();
        return host;
    }

    public String getPort() {
        String port = this.m_portText.getText();
        port = port.trim();
        return port;
    }

    public void setHostEnabled(boolean canEdit) {
        this.m_machineText.setEnabled(canEdit);
        this.m_machinelabel.setEnabled(canEdit);
        this.m_portText.setEnabled(canEdit);
        this.m_portlabel.setEnabled(canEdit);
    }

    public void setHost(String hostName) {
        this.m_machineText.setText(hostName);
        this.m_machineTextInitialValue = hostName;
    }

    public void setPort(String port) {
        this.m_portText.setText(port);
        this.m_portTextInitialValue = port;
    }

    public void setUserid(String userid) {
        this.m_nameText.setText(userid);
        this.m_nameTextInitialValue = userid;
    }

    private void _initialize() throws Exception {
        this.m_nameText = new WATextField();
        this.m_nameText.setColumns(20);
        this.m_passwordText = new WAPasswordField();
        this.m_passwordText.setColumns(12);
        this.m_portText = new WAIntTextField();
        this.m_portText.setColumns(6);
        this.m_portText.setHorizontalAlignment(2);
        this.m_machineText = new WATextField();
        this.m_machineText.setColumns(20);
        this.m_namelabel = new JLabel(bundle.getString("ConnectProperty.Label.Name.txt"));
        this.m_namelabel.setDisplayedMnemonic(bundle.getString("ConnectProperty.Label.Name.mnem").charAt(0));
        this.m_namelabel.setLabelFor(this.m_nameText);
        this.m_passwordlabel = new JLabel(bundle.getString("ConnectProperty.Label.Password.txt"));
        this.m_passwordlabel.setDisplayedMnemonic(bundle.getString("ConnectProperty.Label.Password.mnem").charAt(0));
        this.m_passwordlabel.setLabelFor(this.m_passwordText);
        this.m_portlabel = new JLabel(bundle.getString("ConnectProperty.Label.Port.txt"));
        this.m_portlabel.setDisplayedMnemonic(bundle.getString("ConnectProperty.Label.Port.mnem").charAt(0));
        this.m_portlabel.setLabelFor(this.m_portText);
        this.m_machinelabel = new JLabel(bundle.getString("ConnectProperty.Label.Machine.txt"));
        this.m_machinelabel.setDisplayedMnemonic(bundle.getString("ConnectProperty.Label.Machine.mnem").charAt(0));
        this.m_machinelabel.setLabelFor(this.m_machineText);
    }

    private void _initializeFromFile() throws RemoteException {
        if (this.m_workspacefile.isOpen()) {
            String str = this.m_workspacefile.getPropertyString("userid");
            this.m_nameText.setText(str);
            this.m_nameTextInitialValue = str;
            str = this.m_workspacefile.getPropertyString("password");
            String unencryptedPass = Workspace.getMdFactory().getUtil().safeDecrypt(str);
            this.m_passwordText.setText(unencryptedPass);
            this.m_passwordTextInitialValue = unencryptedPass;
            str = this.m_workspacefile.getPropertyString("port");
            this.m_portText.setText(str);
            this.m_portTextInitialValue = str;
            str = this.m_workspacefile.getPropertyString("host");
            this.m_machineText.setText(str);
            this.m_machineTextInitialValue = str;
        } else {
            this.m_nameTextInitialValue = "";
            this.m_passwordTextInitialValue = "";
            this.m_portTextInitialValue = "";
            this.m_machineTextInitialValue = "";
        }
    }

    private void _layoutWidgets() throws Exception {
        GridBagLayout panelLayout = new GridBagLayout();
        this.m_centerPanel.setLayout(panelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(14, 12, 0, 0);
        panelLayout.setConstraints(this.m_namelabel, gbc);
        this.m_centerPanel.add(this.m_namelabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        panelLayout.setConstraints(this.m_nameText, gbc);
        this.m_centerPanel.add(this.m_nameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.insets = new Insets(14, 12, 0, 0);
        panelLayout.setConstraints(this.m_passwordlabel, gbc);
        this.m_centerPanel.add(this.m_passwordlabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        panelLayout.setConstraints(this.m_passwordText, gbc);
        this.m_centerPanel.add(this.m_passwordText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(14, 12, 0, 0);
        panelLayout.setConstraints(this.m_machinelabel, gbc);
        this.m_centerPanel.add(this.m_machinelabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        panelLayout.setConstraints(this.m_machineText, gbc);
        this.m_centerPanel.add(this.m_machineText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 18;
        gbc.insets = new Insets(14, 12, 8, 0);
        panelLayout.setConstraints(this.m_portlabel, gbc);
        this.m_centerPanel.add(this.m_portlabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 8, 12);
        panelLayout.setConstraints(this.m_portText, gbc);
        this.m_centerPanel.add(this.m_portText);
        Container contPane = this.getContentPane();
        contPane.add((Component)this.m_centerPanel, "Center");
    }
}

