/*
 * Decompiled with CFR 0.152.
 */
package com.sas.plugins;

import com.sas.app.NonAPI;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.Repository;
import com.sas.app.VersionSpec;
import com.sas.plugins.InvalidPluginDirectoryException;
import com.sas.plugins.PluginInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.PluginClassLoader;
import com.sas.workspace.ILogger;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PluginLoader {
    private HashMap m_pluginLoaders = new HashMap();
    protected ArrayList m_plugins = new ArrayList();
    protected ArrayList m_pluginDirs = new ArrayList();
    protected HashMap m_foundation = new HashMap();
    protected HashMap m_pluginCache = new HashMap();
    private ILogger m_logger = null;
    protected List loadProblemPlugins = new ArrayList();
    protected StringBuffer loadProblemDetails = new StringBuffer();
    protected static WAdminResource bundle = new WAdminResource(PluginLoader.class);
    private static URLClassLoader m_classLoader = null;
    private Class[] m_paramTypes = null;
    private Object[] m_paramData = null;

    private void debug(String msg) {
        if (this.m_logger == null) {
            ILogger logger;
            String loggerContext = Workspace.getMainLoggingContext() + ".plugins";
            boolean debug = Workspace.isDebug();
            if (debug) {
                ArrayList<String> loggingContexts = new ArrayList<String>();
                loggingContexts.add(loggerContext);
                Workspace.setLoggingPriorities(loggingContexts, ILogger.DEBUG);
            }
            if ((logger = Workspace.getLogger(loggerContext)) != null) {
                this.m_logger = logger;
            }
        }
        if (this.m_logger != null && this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("PluginLoader: " + msg);
        }
    }

    public PluginLoader(String pluginDirectory) throws InvalidPluginDirectoryException {
        File PluginFile = new File(pluginDirectory);
        if (!PluginFile.isDirectory()) {
            throw new InvalidPluginDirectoryException();
        }
        this.m_pluginDirs.add(PluginFile);
    }

    public PluginLoader(ArrayList ArrayPluginDirs) throws InvalidPluginDirectoryException {
        for (String m_PluginDir : ArrayPluginDirs) {
            File m_PluginFile = new File(m_PluginDir);
            if (!m_PluginFile.isDirectory()) {
                throw new InvalidPluginDirectoryException();
            }
            this.m_pluginDirs.add(m_PluginFile);
        }
    }

    public PluginLoader(String pluginDirectory, Class[] paramTypes, Object[] paramData) throws InvalidPluginDirectoryException {
        this(pluginDirectory);
        this.m_paramTypes = paramTypes;
        this.m_paramData = paramData;
    }

    public PluginLoader(ArrayList ArrayPluginDirs, Class[] paramTypes, Object[] paramData) throws InvalidPluginDirectoryException {
        this(ArrayPluginDirs);
        this.m_paramTypes = paramTypes;
        this.m_paramData = paramData;
    }

    public PluginLoader() {
    }

    public List getLoadingProblemPlugins() {
        return this.loadProblemPlugins;
    }

    public String getLoadingProblemDetails() {
        return this.loadProblemDetails.toString();
    }

    public void initializePlugins() {
        m_classLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        for (File dir : this.m_pluginDirs) {
            File[] dirs = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            for (int i = 0; i < dirs.length; ++i) {
                this.initializePluginDir(dirs[i], m_classLoader);
            }
        }
    }

    private URL[] combineURLs(URL[] urls1, URL[] urls2) {
        URL[] result = new URL[urls1.length + urls2.length];
        System.arraycopy(urls1, 0, result, 0, urls1.length);
        System.arraycopy(urls2, 0, result, urls1.length, urls2.length);
        return result;
    }

    private void initializePluginDir(File dir, URLClassLoader parent) {
        URL[] urls = this.getJars(dir);
        Plugin[] vjrPlugins = this.getVJRPlugins(dir);
        Map pluginVersions = NonAPI.smcGetLoadedPluginVersions((ClassLoader)this.getClass().getClassLoader());
        boolean loadProblem = false;
        StringBuffer details = new StringBuffer();
        for (int i = 0; i < vjrPlugins.length; ++i) {
            boolean combine = true;
            Object object = pluginVersions.get(vjrPlugins[i].getName());
            if (object != null && object instanceof VersionSpec) {
                combine = false;
                VersionSpec loadedVersion = (VersionSpec)object;
                if (!loadedVersion.includes(vjrPlugins[i].getVersion())) {
                    if (loadedVersion.compareTo(vjrPlugins[i].getVersion()) < 0) {
                        loadProblem = true;
                        details.append(bundle.formatString("PluginLoader.VersionIssue.DetailsMember.txt", new Object[]{dir.getName(), vjrPlugins[i].getName(), vjrPlugins[i].getVersion().toString(), loadedVersion.toString()}));
                        this.debug(bundle.formatString("PluginLoader.VersionIssue.DetailsMember.txt", new Object[]{dir.getName(), vjrPlugins[i].getName(), vjrPlugins[i].getVersion().toString(), loadedVersion.toString()}));
                    } else {
                        this.debug(bundle.formatString("PluginLoader.VersionIssue.DetailsMember.txt", new Object[]{dir.getName(), vjrPlugins[i].getName(), vjrPlugins[i].getVersion().toString(), loadedVersion.toString()}));
                    }
                }
            }
            if (!combine) continue;
            urls = this.combineURLs(urls, vjrPlugins[i].getBundleClasspath());
        }
        if (loadProblem) {
            this.loadProblemPlugins.add(dir.getName());
            this.loadProblemDetails.append(details);
        }
        URLClassLoader defaultPluginLoader = null;
        for (int i = 0; i < urls.length; ++i) {
            try {
                String filename = URLDecoder.decode(urls[i].getFile(), "UTF-8");
                this.debug("loading " + filename);
                if (new File(filename).isDirectory()) continue;
                JarFile jf = new JarFile(filename);
                Manifest mf = jf.getManifest();
                if (null == mf) {
                    this.debug("there is no manifest defined in " + filename);
                    continue;
                }
                Attributes attr = mf.getMainAttributes();
                String manifestEntry = attr.getValue("Plugin-Init");
                if (null == manifestEntry) {
                    this.debug("there is no Plugin-Init in the " + filename + "'s manifest file");
                    continue;
                }
                String typesPlugin = attr.getValue("Depends-On-Types-Plugin");
                ClassLoader pluginLoader = null;
                if (typesPlugin != null && typesPlugin.length() > 0) {
                    pluginLoader = this.makeNestedPluginClassLoader(typesPlugin, this.getJars(dir), Arrays.asList(vjrPlugins));
                }
                if (pluginLoader == null) {
                    if (defaultPluginLoader == null) {
                        defaultPluginLoader = new URLClassLoader(urls, (ClassLoader)m_classLoader);
                    }
                    pluginLoader = defaultPluginLoader;
                }
                ArrayList pluginNameArray = this.getPluginClassnames(manifestEntry);
                for (String pluginName : pluginNameArray) {
                    this.m_plugins.add(pluginName);
                    Class<?> pluginClass = null;
                    try {
                        pluginClass = pluginLoader.loadClass(pluginName);
                        this.m_pluginLoaders.put(pluginName, pluginLoader);
                    }
                    catch (NoClassDefFoundError e) {
                        continue;
                    }
                    HashSet foundation = new HashSet();
                    PluginLoader.getFoundation(foundation, pluginClass);
                    for (String interfaceName : foundation) {
                        this.debug("adding " + pluginName + " to " + interfaceName + " hashmap");
                        ArrayList<String> pluginList = (ArrayList<String>)this.m_foundation.get(interfaceName);
                        if (null == pluginList) {
                            pluginList = new ArrayList<String>();
                            this.m_foundation.put(interfaceName, pluginList);
                        }
                        pluginList.add(pluginName);
                    }
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                Workspace.getDefaultLogger().debug("DEBUG NOTE ONLY:  Class not found moving on");
            }
        }
    }

    private Plugin[] getVJRPlugins(File dir) {
        Plugin[] plugins = new Plugin[]{};
        if (new File(dir.getPath() + File.separatorChar + "picklist").exists()) {
            try {
                File pickListFile = new File(dir.getPath() + File.separatorChar + "picklist");
                FileInputStream input = new FileInputStream(pickListFile);
                PickList pickList = new PickList((InputStream)input);
                plugins = Repository.getDefaultRepository().find(pickList);
                if (new File(dir.getPath() + File.separatorChar + "help" + File.separatorChar + "primary.picklist").exists()) {
                    File helpPickListFile = new File(dir.getPath() + File.separatorChar + "help" + File.separatorChar + "primary.picklist");
                    FileInputStream helpPickListInput = new FileInputStream(helpPickListFile);
                    PickList helpPickList = new PickList((InputStream)helpPickListInput);
                    Plugin[] helpPlugins = Repository.getDefaultRepository().find(helpPickList);
                    Plugin[] result = new Plugin[plugins.length + helpPlugins.length];
                    System.arraycopy(plugins, 0, result, 0, plugins.length);
                    System.arraycopy(helpPlugins, 0, result, plugins.length, helpPlugins.length);
                    plugins = result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return plugins;
    }

    private ClassLoader makeNestedPluginClassLoader(String typesPlugin, URL[] urls, List plugins) {
        try {
            this.debug("creating dependent classloader for types plugin " + typesPlugin);
            PluginClassLoader typesPluginClassLoader = com.sas.services.information.PluginLoader.getInstance((String)"sas.services.information.types").getPluginClassLoader(typesPlugin);
            if (typesPluginClassLoader != null) {
                return typesPluginClassLoader.getChildLoader(urls, plugins);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void displayPluginMessage(String helpSet, String helpContext, String docsetVersion) {
        List problemPlugins = this.getLoadingProblemPlugins();
        if (problemPlugins.size() > 0 && System.getProperty("hidePluginVersionMessage") == null) {
            String brokenList = bundle.getString("PluginLoader.VersionIssue.Message.txt");
            for (int i = 0; i < problemPlugins.size(); ++i) {
                brokenList = brokenList + bundle.formatString("PluginLoader.VersionIssue.ListMember.txt", problemPlugins.get(i));
            }
            String details = this.getLoadingProblemDetails();
            JTextArea textArea = new JTextArea(details);
            textArea.setRows(15);
            textArea.setColumns(40);
            textArea.setEditable(false);
            MessageUtil.displayDetailsMessage(brokenList, bundle.getString("PluginLoader.VersionIssue.Title.txt"), 2, -1, new JScrollPane(textArea), helpSet, helpContext, docsetVersion);
        }
    }

    private URL[] getJars(File dir) {
        ArrayList<URL> urls = new ArrayList<URL>();
        File classesDir = new File(dir, "classes");
        if (classesDir.exists() && classesDir.isDirectory()) {
            try {
                urls.add(classesDir.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        String[] names = dir.list(new FileExtension(".jar"));
        for (int i = 0; i < names.length; ++i) {
            try {
                File urlFile = new File(dir.getPath() + File.separatorChar + names[i]);
                urls.add(urlFile.toURI().toURL());
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        File helpDir = new File(dir, "help");
        if (helpDir.exists() && helpDir.isDirectory()) {
            URL[] aryHelpURL = this.getJars(helpDir);
            for (int urlIndex = 0; urlIndex < aryHelpURL.length; ++urlIndex) {
                urls.add(aryHelpURL[urlIndex]);
            }
        }
        URL[] urlArray = new URL[urls.size()];
        return urls.toArray(urlArray);
    }

    private ArrayList getPluginClassnames(String manifestEntry) {
        ArrayList<String> pluginNameArray = new ArrayList<String>();
        int fromIndex = 0;
        while (-1 != fromIndex) {
            String pluginName;
            int location = manifestEntry.indexOf(59, fromIndex);
            if (-1 == location) {
                pluginName = manifestEntry.substring(fromIndex);
                fromIndex = location;
            } else {
                pluginName = manifestEntry.substring(fromIndex, location);
                fromIndex = location + 1;
            }
            if (pluginName.toLowerCase().endsWith(".class")) {
                pluginName = pluginName.substring(0, pluginName.length() - 6);
            }
            pluginName = pluginName.replace('/', '.');
            if (0 == (pluginName = pluginName.trim()).length()) continue;
            pluginNameArray.add(pluginName);
        }
        return pluginNameArray;
    }

    public ArrayList getPluginsDetailed(String interfaceType) {
        return this.getPluginsDetailed(interfaceType, false);
    }

    public ArrayList getPluginsDetailed(String interfaceType, boolean bUsePluginCache) {
        ArrayList<PluginDetails> pluginObjects = new ArrayList<PluginDetails>();
        ArrayList plugins = (ArrayList)this.m_foundation.get(interfaceType);
        if (null == plugins) {
            this.debug("there are no plugins of type " + interfaceType);
            return new ArrayList();
        }
        for (int i = 0; i < plugins.size(); ++i) {
            PluginDetails details = new PluginDetails((String)plugins.get(i));
            pluginObjects.add(details);
            PluginInterface obj = null;
            try {
                obj = this.createPlugin((String)plugins.get(i), bUsePluginCache);
                details.setObject(obj);
                continue;
            }
            catch (Throwable e) {
                details.setException(e);
                details.setObject(obj);
            }
        }
        return pluginObjects;
    }

    public ArrayList getValidPlugins(ArrayList details) {
        Iterator it = details.iterator();
        ArrayList<PluginInterface> validPlugins = new ArrayList<PluginInterface>();
        while (it.hasNext()) {
            PluginDetails detail = (PluginDetails)it.next();
            if (!detail.isValid()) continue;
            validPlugins.add(detail.getObject());
        }
        return validPlugins;
    }

    public ArrayList getInvalidPlugins(ArrayList details) {
        Iterator it = details.iterator();
        ArrayList<PluginDetails> invalidPlugins = new ArrayList<PluginDetails>();
        while (it.hasNext()) {
            PluginDetails detail = (PluginDetails)it.next();
            if (detail.isValid()) continue;
            invalidPlugins.add(detail);
        }
        return invalidPlugins;
    }

    public List getPlugins(Class clsInterface) {
        return this.getPlugins(clsInterface.getName(), false);
    }

    public ArrayList getPlugins(String interfaceType) {
        return this.getPlugins(interfaceType, false);
    }

    public ArrayList getPlugins(String interfaceType, boolean bUseCachedPlugins) {
        ArrayList<PluginInterface> pluginObjects = new ArrayList<PluginInterface>();
        ArrayList plugins = (ArrayList)this.m_foundation.get(interfaceType);
        if (null == plugins) {
            this.debug("there are no plugins of type " + interfaceType);
            return new ArrayList();
        }
        for (int i = 0; i < plugins.size(); ++i) {
            try {
                PluginInterface obj = this.createPlugin((String)plugins.get(i), bUseCachedPlugins);
                pluginObjects.add(obj);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return pluginObjects;
    }

    private PluginInterface createPlugin(String name, boolean bUsePluginCache) throws IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        PluginInterface ret = null;
        if (bUsePluginCache) {
            ret = (PluginInterface)this.m_pluginCache.get(name);
        }
        if (null == ret) {
            if (null != this.m_paramTypes) {
                Class<?> newPlugin = ((URLClassLoader)this.m_pluginLoaders.get(name)).loadClass(name);
                Constructor<?> con = newPlugin.getConstructor(this.m_paramTypes);
                ret = (PluginInterface)con.newInstance(this.m_paramData);
            } else {
                Class<?> newPlugin = ((URLClassLoader)this.m_pluginLoaders.get(name)).loadClass(name);
                ret = (PluginInterface)newPlugin.newInstance();
            }
            ret.initPlugin();
            if (bUsePluginCache) {
                this.m_pluginCache.put(name, ret);
            }
        }
        return ret;
    }

    public void setParamTypes(Class[] paramTypes) {
        this.m_paramTypes = paramTypes;
    }

    public ArrayList getPlugins() {
        ArrayList<PluginInterface> pluginObjects = new ArrayList<PluginInterface>(this.m_plugins.size());
        Iterator it = this.m_plugins.iterator();
        while (it.hasNext()) {
            try {
                String pluginName = (String)it.next();
                pluginObjects.add(this.createPlugin(pluginName, true));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return pluginObjects;
    }

    public ClassLoader getClassLoader(String name) {
        return (ClassLoader)this.m_pluginLoaders.get(name);
    }

    public static ClassLoader getClassLoader() {
        if (null == m_classLoader) {
            return ClassLoader.getSystemClassLoader();
        }
        return m_classLoader;
    }

    private static void getFoundation(Set foundation, Class aClass) {
        if (foundation != null && aClass != null) {
            foundation.add(aClass.getName());
            Class<?>[] classIfs = aClass.getInterfaces();
            int numIfs = classIfs.length;
            for (int i = 0; i < numIfs; ++i) {
                PluginLoader.getFoundation(foundation, classIfs[i]);
            }
            Class superClass = aClass.getSuperclass();
            if (superClass != null) {
                PluginLoader.getFoundation(foundation, superClass);
            }
        }
    }

    private class FileExtension
    implements FilenameFilter {
        private String m_extension;

        public FileExtension(String ext) {
            this.m_extension = ext.toLowerCase(Locale.US);
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.US).endsWith(this.m_extension);
        }
    }

    public class PluginDetails {
        protected String m_pluginName = null;
        protected PluginInterface m_obj = null;
        protected Throwable m_exception = null;

        public PluginDetails(String name) {
            this.m_pluginName = name;
        }

        public String getPluginName() {
            return this.m_pluginName;
        }

        public void setPluginName(String name) {
            this.m_pluginName = name;
        }

        public PluginInterface getObject() {
            return this.m_obj;
        }

        public void setObject(PluginInterface obj) {
            this.m_obj = obj;
        }

        public boolean isValid() {
            return null != this.m_obj;
        }

        public Throwable getException() {
            return this.m_exception;
        }

        public void setException(Throwable e) {
            this.m_exception = e;
        }
    }
}

