/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.httpinvoker.stateful.ObjectDoesntExistException;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceIdHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.scope.ScopedObject;

public class StatefulServiceProxyInterceptor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        if (StatefulServiceHolderInterface.class.isAssignableFrom(method.getDeclaringClass())) {
            if (method.getName().equals("removeStatefulServiceFromScope")) {
                Object holder = mi.getThis();
                Set<StatefulServiceHolderInterface.ServicePair> childSet = null;
                StatefulServiceHolderInterface.ServicePair rootPair = null;
                String thisId = null;
                if (holder instanceof StatefulServiceHolderInterface) {
                    try {
                        StatefulServiceHolderInterface ssh = (StatefulServiceHolderInterface)holder;
                        childSet = ssh.getChildren();
                        rootPair = ssh.getRoot();
                        thisId = StatefulServiceIdHolder.getId();
                        if (thisId != null && thisId.startsWith("Delete")) {
                            thisId = thisId.substring("Delete".length());
                        }
                    }
                    catch (ObjectDoesntExistException odee) {
                        return null;
                    }
                }
                if (holder instanceof ScopedObject) {
                    ((ScopedObject)holder).removeFromScope();
                }
                if (childSet != null && !childSet.isEmpty()) {
                    for (StatefulServiceHolderInterface.ServicePair childPair : childSet) {
                        StatefulServiceHolderInterface child = childPair.getService();
                        String childId = "Delete" + childPair.getId();
                        StatefulServiceIdHolder.setId(childId);
                        try {
                            child.clearRoot();
                            child.removeStatefulServiceFromScope();
                        }
                        catch (ObjectDoesntExistException objectDoesntExistException) {}
                        continue;
                        finally {
                            StatefulServiceIdHolder.clear();
                        }
                    }
                } else if (rootPair != null && thisId != null) {
                    StatefulServiceHolderInterface root = rootPair.getService();
                    String rootId = rootPair.getId();
                    StatefulServiceIdHolder.setId(rootId);
                    try {
                        root.removeChild(thisId);
                    }
                    catch (ObjectDoesntExistException objectDoesntExistException) {
                    }
                    finally {
                        StatefulServiceIdHolder.clear();
                    }
                }
                return null;
            }
            Object result = mi.proceed();
            return result;
        }
        Object holder = mi.getThis();
        Object target = ((StatefulServiceHolderInterface)holder).getStatefulService();
        Object[] args = mi.getArguments();
        try {
            Object result = method.invoke(target, args);
            return result;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            throw t;
        }
    }
}

