/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.httpinvoker.stateful.StatefulInvocationInterceptor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import org.aopalliance.aop.Advice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.framework.ProxyFactory;

public final class StatefulProxyFactory {
    private static final Logger LOGGER = LogManager.getLogger(StatefulProxyFactory.class);

    private StatefulProxyFactory() {
    }

    public static Object getProxy(Object obj, Class<?> clazz) {
        return StatefulProxyFactory.getProxy(obj, clazz, true);
    }

    public static Object getProxy(Object obj, Class<?> clazz, boolean useInterfaceClassloader) {
        String id = StatefulServiceResultIdHolder.getId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Got ID: " + id);
        }
        ProxyFactory factory = new ProxyFactory(obj);
        factory.addInterface(clazz);
        factory.addAdvice((Advice)new StatefulInvocationInterceptor(id));
        if (useInterfaceClassloader) {
            return factory.getProxy(clazz.getClassLoader());
        }
        return factory.getProxy();
    }
}

