/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceIdHolder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class StatefulInvocationInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LogManager.getLogger(StatefulInvocationInterceptor.class);
    private final String id;

    public StatefulInvocationInterceptor(String id) {
        this.id = id;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            StatefulServiceIdHolder.setId(this.id);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Set ID: " + this.id);
            }
            Object object = mi.proceed();
            return object;
        }
        finally {
            StatefulServiceIdHolder.clear();
        }
    }
}

