/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.MutableRemoteInvocationAttributeResult;
import com.sas.svcs.remoting.RemoteInvocationResultProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class ServerRemoteInvocationStatefulServiceResultIdProcessor
implements RemoteInvocationResultProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ServerRemoteInvocationStatefulServiceResultIdProcessor.class);
    private Set<String> returnsStatefulMethodNamesSet = new HashSet<String>(1);

    @Override
    public void process(RemoteInvocationResult rir) {
        if (rir instanceof MutableRemoteInvocationAttributeResult && this.returnsStatefulMethodNamesSet != null && !rir.hasException()) {
            String methodName;
            MutableRemoteInvocationAttributeResult riar = (MutableRemoteInvocationAttributeResult)rir;
            RemoteInvocation ri = riar.getRemoteInvocation();
            String string = methodName = ri != null ? ri.getMethodName() : null;
            if (this.returnsStatefulMethodNamesSet.contains(methodName)) {
                String id = StatefulServiceResultIdHolder.getId();
                StatefulServiceResultIdHolder.clear();
                riar.addAttribute("sasStatefulServiceResultId", (Serializable)((Object)id));
                riar.setValue(null);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("set result id: " + id);
                    LOGGER.debug("returning null for method: " + methodName);
                }
            }
        }
    }

    public void setReturnsStatefulMethodName(String returnsStatefulMethodName) {
        this.returnsStatefulMethodNamesSet.add(returnsStatefulMethodName);
    }

    public void setReturnsStatefulMethodNames(Set<String> returnsStatefulMethodNamesSet) {
        this.returnsStatefulMethodNamesSet = returnsStatefulMethodNamesSet;
    }
}

