/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.client;

import com.sas.svcs.remoting.client.CreateSocketsFactory;
import com.sas.svcs.remoting.client.SocketFactoryHelper;
import com.sas.svcs.remoting.client.SubjectName;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SSLSocketFactory
extends SSLConnectionSocketFactory
implements CreateSocketsFactory {
    private static final Logger LOGGER = LogManager.getLogger(SSLConnectionSocketFactory.class);
    public static final SSLSocketFactory INSTANCE = new SSLSocketFactory(SSLContexts.createDefault());
    private final HostnameVerifier hostnameVerifier = SSLSocketFactory.getDefaultHostnameVerifier();

    private SSLSocketFactory(SSLContext sslContext) {
        super(sslContext);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return SocketFactoryHelper.decorate(javax.net.ssl.SSLSocketFactory.getDefault().createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return SocketFactoryHelper.decorate(javax.net.ssl.SSLSocketFactory.getDefault().createSocket(host, port, clientHost, clientPort));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, int connectTimeout) throws IOException, UnknownHostException {
        InetSocketAddress localSocketAddress = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteSocketAddress = new InetSocketAddress(host, port);
        Socket sock = javax.net.ssl.SSLSocketFactory.getDefault().createSocket();
        if (localAddress != null) {
            sock.bind(localSocketAddress);
        }
        try {
            if (connectTimeout > 0 && sock.getSoTimeout() == 0) {
                sock.setSoTimeout(connectTimeout);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connecting socket to " + host + " with timeout " + connectTimeout);
            }
            sock.connect(remoteSocketAddress, connectTimeout);
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            SSLSocket sslsock = (SSLSocket)sock;
            LOGGER.debug("Starting handshake");
            sslsock.startHandshake();
            this.verifyHostname(sslsock, host);
            return sock;
        }
        HttpCoreContext httpCoreContext = new HttpCoreContext();
        HttpHost httpHost = new HttpHost(host, port);
        httpCoreContext.setTargetHost(httpHost);
        return super.createLayeredSocket(sock, host, port, (HttpContext)httpCoreContext);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return SocketFactoryHelper.decorate(((javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault()).createSocket(socket, host, port, autoClose));
    }

    private void verifyHostname(SSLSocket sslsock, String hostname) throws IOException {
        try {
            X509Certificate x509;
            Certificate[] certs;
            SSLSession session = sslsock.getSession();
            if (session == null) {
                InputStream in = sslsock.getInputStream();
                in.available();
                session = sslsock.getSession();
                if (session == null) {
                    sslsock.startHandshake();
                    session = sslsock.getSession();
                }
            }
            if (session == null) {
                throw new SSLHandshakeException("SSL session not available");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Secure session established");
                LOGGER.debug(" negotiated protocol: " + session.getProtocol());
                LOGGER.debug(" negotiated cipher suite: " + session.getCipherSuite());
                try {
                    certs = session.getPeerCertificates();
                    x509 = (X509Certificate)certs[0];
                    X500Principal peer = x509.getSubjectX500Principal();
                    LOGGER.debug(" peer principal: " + peer.toString());
                    Collection<List<?>> altNames1 = x509.getSubjectAlternativeNames();
                    if (altNames1 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames1) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        LOGGER.debug(" peer alternative names: " + altNames);
                    }
                    X500Principal issuer = x509.getIssuerX500Principal();
                    LOGGER.debug(" issuer principal: " + issuer.toString());
                    Collection<List<?>> altNames2 = x509.getIssuerAlternativeNames();
                    if (altNames2 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames2) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        LOGGER.debug(" issuer alternative names: " + altNames);
                    }
                }
                catch (Exception certs2) {
                    // empty catch block
                }
            }
            if (!this.hostnameVerifier.verify(hostname, session)) {
                certs = session.getPeerCertificates();
                x509 = (X509Certificate)certs[0];
                List<SubjectName> subjectAlts = this.getSubjectAltNames(x509);
                throw new SSLPeerUnverifiedException("Certificate for <" + hostname + "> doesn't match any of the subject alternative names: " + subjectAlts);
            }
        }
        catch (IOException iox) {
            try {
                sslsock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iox;
        }
    }

    private List<SubjectName> getSubjectAltNames(X509Certificate cert) {
        try {
            Collection<List<?>> entries = cert.getSubjectAlternativeNames();
            if (entries == null) {
                return Collections.emptyList();
            }
            ArrayList<SubjectName> result = new ArrayList<SubjectName>();
            for (List<?> entry : entries) {
                Integer type = entry.size() >= 2 ? (Integer)entry.get(0) : null;
                if (type == null) continue;
                String s = (String)entry.get(1);
                result.add(new SubjectName(s, type));
            }
            return result;
        }
        catch (CertificateParsingException ignore) {
            return Collections.emptyList();
        }
    }
}

