/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.client;

import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import java.io.IOException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.web.util.UriComponentsBuilder;

public class SASClientTicketingProxy
extends HttpInvokerProxyFactoryBean {
    private static final Logger LOGGER = LogManager.getLogger(SASClientTicketingProxy.class);
    private String tgt;
    private volatile boolean isFirstCallMade = false;
    private final Object firstCallLock = new Object();
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final String RETRIES_PROP_NAME = "sas.svcs.remoting.sctp.maxRetries";
    private int maxRetries = Integer.getInteger("sas.svcs.remoting.sctp.maxRetries", 3);

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    protected String getTransformedServiceUrl(MethodInvocation mi) {
        String serviceUrl = this.getServiceUrl();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current service url is '" + serviceUrl + "' for method invocation: " + mi.toString());
        }
        if (serviceUrl.contains(":80/")) {
            serviceUrl = serviceUrl.replace(":80/", "/");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Removed :80/ from service url, new url is '" + serviceUrl + "' for method invocation: " + mi.toString());
            }
        } else if (serviceUrl.contains(":443/")) {
            serviceUrl = serviceUrl.replace(":443/", "/");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Removed :443/ from service url, new url is '" + serviceUrl + "' for method invocation: " + mi.toString());
            }
        }
        serviceUrl = UriComponentsBuilder.fromHttpUrl((String)serviceUrl).replaceQueryParam("ticket", new Object[0]).build().toUriString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Service url is '" + serviceUrl + "' after removing ticket query parameter (if present) for method invocation: " + mi.toString());
        }
        return serviceUrl;
    }

    protected synchronized void initialize(MethodInvocation mi) {
        AuthenticationClient authClient = AuthenticationClientHolder.get();
        if (null == authClient) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No auth client set for method invocation: " + mi.toString());
            }
            if (null != this.tgt) {
                this.setServiceUrl(this.getTransformedServiceUrl(mi));
                this.tgt = null;
            }
            return;
        }
        String clientTgt = authClient.getTicketGrantingTicket();
        if (null == clientTgt) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No ticket-granting ticket found for method invocation: " + mi.toString());
            }
            if (null != this.tgt) {
                this.setServiceUrl(this.getTransformedServiceUrl(mi));
                this.tgt = null;
            }
            return;
        }
        this.tgt = clientTgt;
        String serviceUrl = this.getTransformedServiceUrl(mi);
        String ticket = authClient.acquireTicket(serviceUrl);
        this.isFirstCallMade = false;
        serviceUrl = serviceUrl + "?ticket=" + ticket;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Acquired service ticket, service url now '" + serviceUrl + "' for method invocation: " + mi.toString());
        }
        this.setServiceUrl(serviceUrl);
    }

    protected boolean needsInitialization() {
        if (null == this.tgt) {
            return true;
        }
        AuthenticationClient authClient = AuthenticationClientHolder.get();
        if (null == authClient) {
            return true;
        }
        return !this.tgt.equals(authClient.getTicketGrantingTicket());
    }

    private synchronized void initIfNeeded(MethodInvocation mi) {
        if (this.needsInitialization()) {
            this.initialize(mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeInternal(MethodInvocation mi, int remainingRetries) throws Throwable {
        try {
            this.initIfNeeded(mi);
            if (!this.isFirstCallMade) {
                Object object = this.firstCallLock;
                synchronized (object) {
                    if (!this.isFirstCallMade) {
                        Object ret = super.invoke(mi);
                        this.isFirstCallMade = true;
                        return ret;
                    }
                }
            }
            return super.invoke(mi);
        }
        catch (RemoteAccessException e) {
            Throwable cause;
            if (remainingRetries > 0 && (cause = e.getCause()) instanceof IOException) {
                LOGGER.warn("IOException in remote method invocation: '" + mi.toString() + "'. Trying to reinitialize and retry call (maximum " + remainingRetries + " more times).");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Reinitializing for underlying cause:", cause);
                }
                this.initialize(mi);
                return this.invokeInternal(mi, remainingRetries - 1);
            }
            throw e;
        }
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        return this.invokeInternal(mi, this.maxRetries);
    }
}

