/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.client;

import com.sas.svcs.remoting.client.HostConfigProxyResolver;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;

public class CommonsClientHttpRequestFactory
implements InitializingBean,
ClientHttpRequestFactory,
DisposableBean {
    private static final Logger LOGGER = LogManager.getLogger(CommonsClientHttpRequestFactory.class);
    private HostConfigProxyResolver resolver = new HostConfigProxyResolver();
    private HttpClient httpClient = HttpClients.createSystem();
    @Nullable
    private RequestConfig requestConfig;
    private int connectTimeout = -1;
    private int connectionRequestTimeout = -1;
    private boolean bufferRequestBody = true;
    @Nullable
    private BiFunction<HttpMethod, URI, HttpContext> httpContextFactory;

    public void setResolver(HostConfigProxyResolver resolver) {
        this.resolver = resolver;
    }

    protected void initializeHttpClient() {
        String proxyUser = System.getProperty("http.proxyUser");
        String proxyPass = System.getProperty("http.proxyPassword");
        if (proxyUser == null && null != (proxyUser = System.getProperty("https.proxyUser"))) {
            proxyPass = System.getProperty("https.proxyPassword");
        }
        String proxyRealm = System.getProperty("http.proxyRealm");
        String proxyScheme = System.getProperty("http.proxyScheme");
        if (null != proxyUser) {
            AuthScope authscope = new AuthScope(null, -1, proxyRealm, proxyScheme);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPass);
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(authscope, (Credentials)credentials);
            this.setHttpClient((HttpClient)HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build());
        }
    }

    @Autowired(required=false)
    public void setHttpClient(@Qualifier(value="com.sas.svcs.httpClient") HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpHost httpHost = this.resolver.getHttpHostForUri(uri);
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)this.createRequestConfig(this.httpClient));
        CloseableHttpClient httpClient = null;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().useSystemProperties();
        if (null == httpHost) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No http host found for " + uri.getPath());
            }
            httpClient = httpClientBuilder.build();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using http host " + httpHost.toString() + " to execute request for " + uri.getPath());
            }
            httpClient = httpClientBuilder.setProxy(httpHost).build();
        }
        HttpUriRequest httpUriRequest = this.createHttpUriRequest(httpMethod, uri);
        return new CommonsClientHttpRequest(this.httpClient, httpUriRequest);
    }

    public void afterPropertiesSet() throws Exception {
        this.initializeHttpClient();
    }

    @Nullable
    private RequestConfig createRequestConfig(Object client) {
        if (client instanceof Configurable) {
            RequestConfig clientRequestConfig = ((Configurable)client).getConfig();
            return this.mergeRequestConfig(clientRequestConfig);
        }
        return this.requestConfig;
    }

    private RequestConfig mergeRequestConfig(RequestConfig clientConfig) {
        int socketTimeout;
        if (this.requestConfig == null) {
            return clientConfig;
        }
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)clientConfig);
        this.connectTimeout = this.requestConfig.getConnectTimeout();
        if (this.connectTimeout >= 0) {
            builder.setConnectTimeout(this.connectTimeout);
        }
        this.connectionRequestTimeout = this.requestConfig.getConnectionRequestTimeout();
        if (this.connectionRequestTimeout >= 0) {
            builder.setConnectionRequestTimeout(this.connectionRequestTimeout);
        }
        if ((socketTimeout = this.requestConfig.getSocketTimeout()) >= 0) {
            builder.setSocketTimeout(socketTimeout);
        }
        return builder.build();
    }

    private HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            return new HttpGet(uri);
        }
        if (HttpMethod.HEAD.equals((Object)httpMethod)) {
            return new HttpHead(uri);
        }
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            return new HttpPost(uri);
        }
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            return new HttpPut(uri);
        }
        if (HttpMethod.PATCH.equals((Object)httpMethod)) {
            return new HttpPatch(uri);
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            return new HttpDelete(uri);
        }
        if (HttpMethod.OPTIONS.equals((Object)httpMethod)) {
            return new HttpOptions(uri);
        }
        if (HttpMethod.TRACE.equals((Object)httpMethod)) {
            return new HttpTrace(uri);
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + httpMethod);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    private RequestConfig.Builder requestConfigBuilder() {
        return this.requestConfig != null ? RequestConfig.copy((RequestConfig)this.requestConfig) : RequestConfig.custom();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.requestConfig = this.requestConfigBuilder().setConnectTimeout(connectTimeout).build();
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.requestConfig = this.requestConfigBuilder().setConnectionRequestTimeout(connectionRequestTimeout).build();
    }

    public void setBufferRequestBody(boolean bufferRequestBody) {
        this.bufferRequestBody = bufferRequestBody;
    }

    public void setHttpContextFactory(BiFunction<HttpMethod, URI, HttpContext> httpContextFactory) {
        this.httpContextFactory = httpContextFactory;
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
    }

    @Nullable
    protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
        return this.httpContextFactory != null ? this.httpContextFactory.apply(httpMethod, uri) : null;
    }

    public void destroy() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient instanceof Closeable) {
            ((Closeable)httpClient).close();
        }
    }

    private static class CommonsClientHttpRequest
    extends AbstractClientHttpRequest {
        private final HttpClient httpClient;
        private final HttpUriRequest httpUriRequest;
        private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream();

        protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
            return this.bufferedOutput;
        }

        protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
            byte[] bytes = this.bufferedOutput.toByteArray();
            headers.remove((Object)"Content-Length");
            ClientHttpResponse result = this.executeInternal(headers, bytes);
            this.bufferedOutput = null;
            return result;
        }

        CommonsClientHttpRequest(HttpClient httpClient, HttpUriRequest httpUriRequest) {
            this.httpClient = httpClient;
            this.httpUriRequest = httpUriRequest;
        }

        public HttpMethod getMethod() {
            return HttpMethod.valueOf((String)this.httpUriRequest.getMethod());
        }

        public URI getURI() {
            return this.httpUriRequest.getURI();
        }

        public ClientHttpResponse executeInternal(HttpHeaders headers, byte[] output) throws IOException {
            for (Map.Entry entry : headers.entrySet()) {
                String headerName = (String)entry.getKey();
                for (String headerValue : (List)entry.getValue()) {
                    this.httpUriRequest.addHeader(headerName, headerValue);
                }
            }
            if (this.httpUriRequest instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest httpEntityRequest = (HttpEntityEnclosingRequest)this.httpUriRequest;
                ByteArrayEntity httpEntity = new ByteArrayEntity(output);
                httpEntityRequest.setEntity((HttpEntity)httpEntity);
                MediaType mediaType = headers.getContentType();
                if (null != mediaType) {
                    httpEntity.setContentType(mediaType.toString());
                }
            }
            HttpResponse httpResponse = this.httpClient.execute(this.httpUriRequest);
            return new CommonsClientHttpResponse(httpResponse);
        }

        public String getMethodValue() {
            return this.httpUriRequest.getMethod();
        }
    }

    private static class CommonsClientHttpResponse
    implements ClientHttpResponse {
        private static final Logger LOGGER = LogManager.getLogger(CommonsClientHttpResponse.class);
        private final HttpResponse httpResponse;
        private HttpHeaders headers;

        CommonsClientHttpResponse(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
        }

        public int getRawStatusCode() {
            return this.httpResponse.getStatusLine().getStatusCode();
        }

        public HttpStatus getStatusCode() {
            return HttpStatus.valueOf((int)this.httpResponse.getStatusLine().getStatusCode());
        }

        public String getStatusText() {
            return this.httpResponse.getStatusLine().getReasonPhrase();
        }

        public HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
                for (Header header : this.httpResponse.getAllHeaders()) {
                    this.headers.add(header.getName(), header.getValue());
                }
            }
            return this.headers;
        }

        public InputStream getBody() throws IOException {
            HttpEntity entity = this.httpResponse.getEntity();
            InputStream inputStream = null;
            if (entity != null) {
                inputStream = entity.getContent();
            }
            return inputStream;
        }

        public void close() {
            if (this.httpResponse instanceof CloseableHttpResponse) {
                CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)this.httpResponse;
                try {
                    closeableHttpResponse.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getStackTrace());
                }
            }
        }
    }
}

