/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.aspects;

import com.sas.svcs.remoting.RemoteInvocationAttributeResult;
import com.sas.svcs.remoting.RemoteInvocationProcessor;
import com.sas.svcs.remoting.RemoteInvocationResultProcessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public abstract class AbstractAspectJRemoteInvocationInterceptor {
    private static final Logger LOGGER = LogManager.getLogger(AbstractAspectJRemoteInvocationInterceptor.class);
    private List<RemoteInvocationProcessor> preProcessors = new ArrayList<RemoteInvocationProcessor>();
    private List<RemoteInvocationResultProcessor> postProcessors = new ArrayList<RemoteInvocationResultProcessor>();

    public void setPreProcessors(List<RemoteInvocationProcessor> v) {
        this.preProcessors = v;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("RemoteInvocationIntercepter has preProcessors: " + this.preProcessors);
        }
    }

    public void setPostProcessors(List<RemoteInvocationResultProcessor> v) {
        this.postProcessors = v;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("RemoteInvocationIntercepter has postProcessors: " + this.postProcessors);
        }
    }

    public abstract void pointcut();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object invoke(ProceedingJoinPoint jp) throws Throwable {
        RemoteInvocation ri = null;
        Object[] args = jp.getArgs();
        if (null == args) {
            return jp.proceed();
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof RemoteInvocation)) continue;
            ri = (RemoteInvocation)args[i];
            break;
        }
        Boolean[] processorRan = new Boolean[this.preProcessors.size()];
        try {
            this.preProcess(ri, processorRan);
            Object value = jp.proceed();
            Object object = value = this.postProcessResult(value);
            return object;
        }
        finally {
            this.postProcessInvocation(ri, processorRan);
        }
    }

    private void postProcessInvocation(RemoteInvocation ri, Boolean[] processorRan) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Pre-processing remote invocation.");
        }
        if (null == ri) {
            return;
        }
        if (this.preProcessors.isEmpty()) {
            return;
        }
        for (int index = 0; index < this.preProcessors.size(); ++index) {
            RemoteInvocationProcessor riv = this.preProcessors.get(index);
            if (null == processorRan[index] || !processorRan[index].booleanValue()) break;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processing " + riv.getClass().getName());
                }
                riv.finish(ri);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Processed " + riv.getClass().getName());
                continue;
            }
            catch (Throwable t) {
                LOGGER.error("Error running post processing stage of processor " + riv.getClass().getName(), t);
            }
        }
    }

    private void preProcess(RemoteInvocation ri, Boolean[] processorRan) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Pre-processing remote invocation.");
        }
        if (null == ri) {
            return;
        }
        if (this.preProcessors.isEmpty()) {
            return;
        }
        for (int index = 0; index < this.preProcessors.size(); ++index) {
            RemoteInvocationProcessor riv = this.preProcessors.get(index);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing " + riv.getClass().getName());
            }
            riv.process(ri);
            processorRan[index] = Boolean.TRUE;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Processed " + riv.getClass().getName());
        }
    }

    private Object postProcessResult(Object o) {
        RemoteInvocationAttributeResult riar;
        if (o != null && !(o instanceof RemoteInvocationResult)) {
            return o;
        }
        if (this.postProcessors.isEmpty()) {
            return o;
        }
        if (!(o instanceof RemoteInvocationAttributeResult)) {
            RemoteInvocationResult rir = (RemoteInvocationResult)o;
            riar = new RemoteInvocationAttributeResult(rir);
        } else {
            riar = (RemoteInvocationAttributeResult)o;
        }
        for (RemoteInvocationResultProcessor rirv : this.postProcessors) {
            rirv.process(riar);
        }
        return riar;
    }
}

